/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.json5.codeinsight;

import com.intellij.json.JsonDialectUtil;
import com.intellij.json.codeinsight.JsonLiteralChecker;
import com.intellij.json.codeinsight.StandardJsonLiteralChecker;
import com.intellij.json.json5.Json5Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class Json5JsonLiteralChecker
implements JsonLiteralChecker {
    private static final Pattern VALID_HEX_ESCAPE = Pattern.compile("\\\\(x[0-9a-fA-F]{2})");
    private static final Pattern INVALID_NUMERIC_ESCAPE = Pattern.compile("\\\\[1-9]");

    @Override
    @Nullable
    public String getErrorForNumericLiteral(String literalText) {
        return null;
    }

    @Override
    @Nullable
    public String getErrorForStringFragment(String fragmentText) {
        if (fragmentText.startsWith("\\") && fragmentText.length() > 1 && fragmentText.endsWith("\n") && StringUtil.isEmptyOrSpaces((String)fragmentText.substring(1, fragmentText.length() - 1))) {
            return null;
        }
        if (fragmentText.startsWith("\\x") && VALID_HEX_ESCAPE.matcher(fragmentText).matches()) {
            return null;
        }
        if (!StandardJsonLiteralChecker.VALID_ESCAPE.matcher(fragmentText).matches() && !INVALID_NUMERIC_ESCAPE.matcher(fragmentText).matches()) {
            return null;
        }
        return StandardJsonLiteralChecker.getStringError(fragmentText);
    }

    @Override
    public boolean isApplicable(PsiElement element) {
        return JsonDialectUtil.getLanguage(element) == Json5Language.INSTANCE;
    }
}

