/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.NameMapperKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import gnu.trove.THashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.rpc.CommandProcessorKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000 \"2\u00020\u0001:\u0001\"B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000eJ\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020!H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R@\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/javascript/debugger/NameMapper;", "", "document", "Lcom/intellij/openapi/editor/Document;", "transpiledDocument", "sourceMappings", "Lorg/jetbrains/debugger/sourcemap/Mappings;", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "transpiledFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/editor/Document;Lorg/jetbrains/debugger/sourcemap/Mappings;Lorg/jetbrains/debugger/sourcemap/SourceMap;Lcom/intellij/openapi/vfs/VirtualFile;)V", "<set-?>", "", "", "rawNameToSource", "getRawNameToSource", "()Ljava/util/Map;", "setRawNameToSource", "(Ljava/util/Map;)V", "getSourceMap", "()Lorg/jetbrains/debugger/sourcemap/SourceMap;", "addMapping", "", "generatedName", "sourceName", "extractName", "rawGeneratedName", "", "map", "identifierOrNamedElement", "Lcom/intellij/psi/PsiElement;", "forceMapBySourceCode", "", "Companion", "intellij.platform.scriptDebugger.ui"})
public class NameMapper {
    @Nullable
    private Map<String, String> rawNameToSource;
    private final Document document;
    private final Document transpiledDocument;
    private final Mappings sourceMappings;
    @NotNull
    private final SourceMap sourceMap;
    private final VirtualFile transpiledFile;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Map<String, String> getRawNameToSource() {
        return this.rawNameToSource;
    }

    private final void setRawNameToSource(Map<String, String> map) {
        this.rawNameToSource = map;
    }

    @JvmOverloads
    @Nullable
    public String map(@NotNull PsiElement identifierOrNamedElement, boolean forceMapBySourceCode) {
        String generatedName;
        Intrinsics.checkParameterIsNotNull((Object)identifierOrNamedElement, (String)"identifierOrNamedElement");
        int offset = identifierOrNamedElement.getTextOffset();
        int line = this.document.getLineNumber(offset);
        int sourceEntryIndex = this.sourceMappings.indexOf(line, offset - this.document.getLineStartOffset(line));
        if (sourceEntryIndex == -1) {
            return null;
        }
        MappingEntry sourceEntry = this.sourceMappings.getByIndex(sourceEntryIndex);
        MappingEntry next = this.sourceMappings.getNextOnTheSameLine(sourceEntryIndex, false);
        if (next != null && this.sourceMappings.getColumn(next) == this.sourceMappings.getColumn(sourceEntry)) {
            NameMapperKt.warnSeveralMapping(identifierOrNamedElement);
            return null;
        }
        try {
            generatedName = this.extractName(NameMapperKt.access$getGeneratedName(this.transpiledDocument, this.sourceMap, sourceEntry));
        }
        catch (IndexOutOfBoundsException e) {
            VirtualFile virtualFile = this.transpiledFile;
            CommandProcessorKt.getLOG().warn("Cannot get generated name: source entry (" + sourceEntry.getGeneratedLine() + ",  " + sourceEntry.getGeneratedColumn() + "). Transpiled File: " + (virtualFile != null ? virtualFile.getPath() : null));
            return null;
        }
        if (generatedName == null || (e = (CharSequence)generatedName).length() == 0) {
            return null;
        }
        String sourceName = sourceEntry.getName();
        if (sourceName == null || forceMapBySourceCode || Registry.is((String)"js.debugger.name.mappings.by.source.code", (boolean)false)) {
            Object object;
            Object object2;
            PsiElement psiElement = identifierOrNamedElement;
            if (!(psiElement instanceof PsiNamedElement)) {
                psiElement = null;
            }
            if ((object2 = (PsiNamedElement)psiElement) == null || (object2 = object2.getName()) == null) {
                object2 = object = identifierOrNamedElement.getText();
            }
            if (object2 == null) {
                object = sourceName;
            }
            if (object == null) {
                return null;
            }
            sourceName = object;
        }
        this.addMapping(generatedName, sourceName);
        return generatedName;
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ String map$default(NameMapper nameMapper, PsiElement psiElement, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: map");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return nameMapper.map(psiElement, bl);
    }

    @JvmOverloads
    @Nullable
    public String map(@NotNull PsiElement identifierOrNamedElement) {
        return NameMapper.map$default(this, identifierOrNamedElement, false, 2, null);
    }

    public final void addMapping(@NotNull String generatedName, @NotNull String sourceName) {
        Intrinsics.checkParameterIsNotNull((Object)generatedName, (String)"generatedName");
        Intrinsics.checkParameterIsNotNull((Object)sourceName, (String)"sourceName");
        if (this.rawNameToSource == null) {
            this.rawNameToSource = (Map)new THashMap();
        }
        Map<String, String> map = this.rawNameToSource;
        if (map == null) {
            Intrinsics.throwNpe();
        }
        map.put(generatedName, sourceName);
    }

    @Nullable
    protected String extractName(@NotNull CharSequence rawGeneratedName) {
        Intrinsics.checkParameterIsNotNull((Object)rawGeneratedName, (String)"rawGeneratedName");
        return NameMapperKt.getNAME_TRIMMER().trimFrom(rawGeneratedName);
    }

    @NotNull
    protected final SourceMap getSourceMap() {
        return this.sourceMap;
    }

    public NameMapper(@NotNull Document document, @NotNull Document transpiledDocument, @NotNull Mappings sourceMappings, @NotNull SourceMap sourceMap, @Nullable VirtualFile transpiledFile) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)transpiledDocument, (String)"transpiledDocument");
        Intrinsics.checkParameterIsNotNull((Object)sourceMappings, (String)"sourceMappings");
        Intrinsics.checkParameterIsNotNull((Object)sourceMap, (String)"sourceMap");
        this.document = document;
        this.transpiledDocument = transpiledDocument;
        this.sourceMappings = sourceMappings;
        this.sourceMap = sourceMap;
        this.transpiledFile = transpiledFile;
    }

    public /* synthetic */ NameMapper(Document document, Document document2, Mappings mappings, SourceMap sourceMap, VirtualFile virtualFile, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            virtualFile = null;
        }
        this(document, document2, mappings, sourceMap, virtualFile);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/debugger/NameMapper$Companion;", "", "()V", "trimName", "", "rawGeneratedName", "", "isLastToken", "", "intellij.platform.scriptDebugger.ui"})
    public static final class Companion {
        @Nullable
        public final String trimName(@NotNull CharSequence rawGeneratedName, boolean isLastToken) {
            Intrinsics.checkParameterIsNotNull((Object)rawGeneratedName, (String)"rawGeneratedName");
            return (isLastToken ? NameMapperKt.getNAME_TRIMMER() : NameMapperKt.access$getOPERATOR_TRIMMER$p()).trimFrom(rawGeneratedName);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

