/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.LogEventAction;
import com.intellij.internal.statistic.eventLog.LogEventBaseAction;
import com.intellij.internal.statistic.eventLog.LogEventsKt;
import com.intellij.internal.statistic.eventLog.LogStateEventAction;
import com.intellij.util.containers.hash.HashMap;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventJsonDeserializer;", "Lcom/google/gson/JsonDeserializer;", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "()V", "createAction", "Lcom/intellij/internal/statistic/eventLog/LogEventBaseAction;", "obj", "Lcom/google/gson/JsonObject;", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "intellij.platform.ide.impl"})
public final class LogEventJsonDeserializer
implements JsonDeserializer<LogEvent> {
    @NotNull
    public LogEvent deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
        JsonObject actionObj;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsonObject obj = json.getAsJsonObject();
        JsonElement jsonElement = obj.get("session");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"obj[\"session\"]");
        String session2 = jsonElement.getAsString();
        JsonElement jsonElement2 = obj.get("build");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"obj[\"build\"]");
        String build2 = jsonElement2.getAsString();
        JsonElement jsonElement3 = obj.get("bucket");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"obj[\"bucket\"]");
        String bucket = jsonElement3.getAsString();
        JsonElement jsonElement4 = obj.get("time");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement4, (String)"obj[\"time\"]");
        long time = jsonElement4.getAsLong();
        JsonElement jsonElement5 = obj.get("group");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement5, (String)"obj[\"group\"]");
        JsonObject group = jsonElement5.getAsJsonObject();
        JsonElement jsonElement6 = group.get("id");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement6, (String)"group[\"id\"]");
        String groupId = jsonElement6.getAsString();
        JsonElement jsonElement7 = group.get("version");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement7, (String)"group[\"version\"]");
        String groupVersion = jsonElement7.getAsString();
        JsonElement jsonElement8 = obj.get("event");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement8, (String)"obj[\"event\"]");
        JsonObject jsonObject = actionObj = jsonElement8.getAsJsonObject();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"actionObj");
        LogEventBaseAction action = this.createAction(jsonObject);
        if (actionObj.has("data")) {
            JsonObject dataObj = actionObj.getAsJsonObject("data");
            Object object = context.deserialize((JsonElement)dataObj, new TypeToken<HashMap<String, Object>>(){}.getType());
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"context.deserialize<Hash\u2026<String, Any>>() {}.type)");
            Map map = (Map)object;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                String key = (String)entry2.getKey();
                entry2 = entry;
                Object value = entry2.getValue();
                if (value instanceof Double && ((Number)value).doubleValue() % 1.0 == 0.0) {
                    int intValue = (int)Math.round(((Number)value).doubleValue());
                    String string = key;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
                    action.addData(string, intValue);
                    continue;
                }
                String string = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
                Object v = value;
                Intrinsics.checkExpressionValueIsNotNull(v, (String)"value");
                action.addData(string, v);
            }
        }
        String string = session2;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"session");
        String string2 = build2;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"build");
        String string3 = bucket;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"bucket");
        String string4 = groupId;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"groupId");
        String string5 = groupVersion;
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"groupVersion");
        return LogEventsKt.newLogEvent(string, string2, string3, time, string4, string5, action);
    }

    @NotNull
    public final LogEventBaseAction createAction(@NotNull JsonObject obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        JsonElement jsonElement = obj.get("id");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"obj.get(\"id\")");
        String id = jsonElement.getAsString();
        if (obj.has("count")) {
            JsonPrimitive count;
            JsonElement jsonElement2 = obj.get("count");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"obj.get(\"count\")");
            JsonPrimitive jsonPrimitive = count = jsonElement2.getAsJsonPrimitive();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonPrimitive, (String)"count");
            if (jsonPrimitive.isNumber()) {
                String string = id;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
                return new LogEventAction(string, count.getAsInt());
            }
        }
        String string = id;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
        return new LogStateEventAction(string);
    }
}

