/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.eventLog.FeatureUsageUiEvents;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J$\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u001c\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u001c\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u001c\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J$\u0010\u001a\u001a\u00020\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0002R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00060\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00060\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00060\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00060\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/internal/statistic/eventLog/FeatureUsageUiEventsImpl;", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageUiEvents;", "()V", "APPLY_CONFIGURABLE_DATA", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "CLOSE_CANCEL_DIALOG_DATA", "kotlin.jvm.PlatformType", "CLOSE_CUSTOM_DIALOG_DATA", "CLOSE_OK_DIALOG_DATA", "RESET_CONFIGURABLE_DATA", "SELECT_CONFIGURABLE_DATA", "SHOW_DIALOG_DATA", "logApplyConfigurable", "", "name", "context", "Ljava/lang/Class;", "logCloseDialog", "exitCode", "", "logResetConfigurable", "logSelectConfigurable", "logShowDialog", "toReport", "defaultValue", "intellij.platform.ide.impl"})
public final class FeatureUsageUiEventsImpl
implements FeatureUsageUiEvents {
    private final HashMap<String, Object> SELECT_CONFIGURABLE_DATA = new HashMap();
    private final HashMap<String, Object> APPLY_CONFIGURABLE_DATA = new HashMap();
    private final HashMap<String, Object> RESET_CONFIGURABLE_DATA = new HashMap();
    private final HashMap<String, Object> SHOW_DIALOG_DATA;
    private final HashMap<String, Object> CLOSE_OK_DIALOG_DATA;
    private final HashMap<String, Object> CLOSE_CANCEL_DIALOG_DATA;
    private final HashMap<String, Object> CLOSE_CUSTOM_DIALOG_DATA;

    public void logSelectConfigurable(@NotNull String name, @NotNull Class<?> context) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        if (FeatureUsageLogger.INSTANCE.isEnabled()) {
            String report = this.toReport(context, name, "ide.settings.third.party.plugin");
            FeatureUsageLogger.INSTANCE.log("ui.settings", report, (Map)this.SELECT_CONFIGURABLE_DATA);
        }
    }

    public void logApplyConfigurable(@NotNull String name, @NotNull Class<?> context) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        if (FeatureUsageLogger.INSTANCE.isEnabled()) {
            String report = this.toReport(context, name, "ide.settings.third.party.plugin");
            FeatureUsageLogger.INSTANCE.log("ui.settings", report, (Map)this.APPLY_CONFIGURABLE_DATA);
        }
    }

    public void logResetConfigurable(@NotNull String name, @NotNull Class<?> context) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        if (FeatureUsageLogger.INSTANCE.isEnabled()) {
            String report = this.toReport(context, name, "ide.settings.third.party.plugin");
            FeatureUsageLogger.INSTANCE.log("ui.settings", report, (Map)this.RESET_CONFIGURABLE_DATA);
        }
    }

    public void logShowDialog(@NotNull String name, @NotNull Class<?> context) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        if (FeatureUsageLogger.INSTANCE.isEnabled()) {
            String report = this.toReport(context, name, "dialog.third.party.plugin");
            FeatureUsageLogger.INSTANCE.log("ui.dialogs", report, (Map)this.SHOW_DIALOG_DATA);
        }
    }

    public void logCloseDialog(@NotNull String name, int exitCode, @NotNull Class<?> context) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        if (FeatureUsageLogger.INSTANCE.isEnabled()) {
            String report = this.toReport(context, name, "dialog.third.party.plugin");
            if (exitCode == 0) {
                FeatureUsageLogger.INSTANCE.log("ui.dialogs", report, (Map)this.CLOSE_OK_DIALOG_DATA);
            } else if (exitCode == 1) {
                FeatureUsageLogger.INSTANCE.log("ui.dialogs", report, (Map)this.CLOSE_CANCEL_DIALOG_DATA);
            } else {
                FeatureUsageLogger.INSTANCE.log("ui.dialogs", report, (Map)this.CLOSE_CUSTOM_DIALOG_DATA);
            }
        }
    }

    private final String toReport(Class<?> context, String name, String defaultValue) {
        PluginId pluginId = PluginManagerCore.getPluginByClassName(context.getName());
        return StatisticsUtilKt.isDevelopedByJetBrains(pluginId) ? name : defaultValue;
    }

    public FeatureUsageUiEventsImpl() {
        HashMap hashMap = ContainerUtil.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"ContainerUtil.newHashMap<String, Any>()");
        this.SHOW_DIALOG_DATA = hashMap;
        HashMap hashMap2 = ContainerUtil.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap2, (String)"ContainerUtil.newHashMap<String, Any>()");
        this.CLOSE_OK_DIALOG_DATA = hashMap2;
        HashMap hashMap3 = ContainerUtil.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap3, (String)"ContainerUtil.newHashMap<String, Any>()");
        this.CLOSE_CANCEL_DIALOG_DATA = hashMap3;
        HashMap hashMap4 = ContainerUtil.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap4, (String)"ContainerUtil.newHashMap<String, Any>()");
        this.CLOSE_CUSTOM_DIALOG_DATA = hashMap4;
        Map map = this.SELECT_CONFIGURABLE_DATA;
        String string = "type";
        Object object = "select";
        map.put(string, object);
        map = this.APPLY_CONFIGURABLE_DATA;
        string = "type";
        object = "apply";
        map.put(string, object);
        map = this.RESET_CONFIGURABLE_DATA;
        string = "type";
        object = "reset";
        map.put(string, object);
        map = this.SHOW_DIALOG_DATA;
        string = "type";
        object = "show";
        map.put(string, object);
        map = this.CLOSE_OK_DIALOG_DATA;
        string = "type";
        object = "close";
        map.put(string, object);
        map = this.CLOSE_OK_DIALOG_DATA;
        string = "code";
        object = 0;
        map.put(string, object);
        map = this.CLOSE_CANCEL_DIALOG_DATA;
        string = "type";
        object = "close";
        map.put(string, object);
        map = this.CLOSE_CANCEL_DIALOG_DATA;
        string = "code";
        object = 1;
        map.put(string, object);
        map = this.CLOSE_CUSTOM_DIALOG_DATA;
        string = "type";
        object = "close";
        map.put(string, object);
        map = this.CLOSE_CUSTOM_DIALOG_DATA;
        string = "code";
        object = 2;
        map.put(string, object);
    }
}

