/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.FeatureUsageEventFileAppender;
import com.intellij.internal.statistic.eventLog.FeatureUsageEventLogger;
import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.internal.statistic.eventLog.LogEventsKt;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0010\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016H\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J \u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J4\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u000bH\u0002J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\f\u0010%\u001a\u00020\u0004*\u00020&H\u0002J\f\u0010'\u001a\u00020\u0004*\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/internal/statistic/eventLog/FeatureUsageFileEventLogger;", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageEventLogger;", "()V", "bucket", "", "build", "eventLogger", "Lorg/apache/log4j/Logger;", "fileAppender", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageEventFileAppender;", "lastEvent", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "lastEventTime", "", "myLogExecutor", "Ljava/util/concurrent/ThreadPoolExecutor;", "recorderVersion", "sessionId", "dispose", "", "logger", "getEventLogDir", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getLogFiles", "", "Ljava/io/File;", "log", "recorderId", "action", "isState", "", "data", "", "", "event", "logLastEvent", "asBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "shortedUUID", "intellij.platform.ide.impl"})
public final class FeatureUsageFileEventLogger
implements FeatureUsageEventLogger {
    private final ThreadPoolExecutor myLogExecutor;
    private final String sessionId;
    private final String build;
    private final String bucket = "-1";
    private final String recorderVersion = "2";
    private FeatureUsageEventFileAppender fileAppender;
    private final Logger eventLogger;
    private LogEvent lastEvent;
    private long lastEventTime;

    private final Path getEventLogDir() {
        return Paths.get(PathManager.getSystemPath(), new String[0]).resolve("event-log");
    }

    private final String shortedUUID(@NotNull String $receiver) {
        int start = StringsKt.lastIndexOf$default((CharSequence)$receiver, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (start > 0 && start + 1 < $receiver.length()) {
            String string = $receiver;
            int n = start + 1;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return string3;
        }
        return $receiver;
    }

    private final String asBuildNumber(@NotNull BuildNumber $receiver) {
        String str;
        String string = str = $receiver.asStringWithoutProductCodeAndSnapshot();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"str");
        return StringsKt.endsWith$default((String)string, (String)".", (boolean)false, (int)2, null) ? str + "0" : str;
    }

    public void log(@NotNull String recorderId, @NotNull String action, boolean isState) {
        Intrinsics.checkParameterIsNotNull((Object)recorderId, (String)"recorderId");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        Map map = Collections.emptyMap();
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"Collections.emptyMap()");
        this.log(recorderId, action, map, isState);
    }

    public void log(@NotNull String recorderId, @NotNull String action, @NotNull Map<String, ? extends Object> data, boolean isState) {
        Intrinsics.checkParameterIsNotNull((Object)recorderId, (String)"recorderId");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        this.myLogExecutor.execute(new Runnable(this, recorderId, action, isState, data){
            final /* synthetic */ FeatureUsageFileEventLogger this$0;
            final /* synthetic */ String $recorderId;
            final /* synthetic */ String $action;
            final /* synthetic */ boolean $isState;
            final /* synthetic */ Map $data;

            public final void run() {
                LogEvent event = LogEventsKt.newLogEvent(FeatureUsageFileEventLogger.access$getSessionId$p(this.this$0), FeatureUsageFileEventLogger.access$getBuild$p(this.this$0), FeatureUsageFileEventLogger.access$getBucket$p(this.this$0), this.$recorderId, FeatureUsageFileEventLogger.access$getRecorderVersion$p(this.this$0), this.$action, this.$isState);
                Map map = this.$data;
                for (Map.Entry<K, V> datum : map.entrySet()) {
                    event.getEvent().addData((String)datum.getKey(), datum.getValue());
                }
                FeatureUsageFileEventLogger.access$log(this.this$0, FeatureUsageFileEventLogger.access$getEventLogger$p(this.this$0), event);
            }
            {
                this.this$0 = featureUsageFileEventLogger;
                this.$recorderId = string;
                this.$action = string2;
                this.$isState = bl;
                this.$data = map;
            }
        });
    }

    private final void dispose(Logger logger) {
        this.myLogExecutor.execute(new Runnable(this, logger){
            final /* synthetic */ FeatureUsageFileEventLogger this$0;
            final /* synthetic */ Logger $logger;

            public final void run() {
                FeatureUsageFileEventLogger.access$log(this.this$0, this.$logger, LogEventsKt.newLogEvent(FeatureUsageFileEventLogger.access$getSessionId$p(this.this$0), FeatureUsageFileEventLogger.access$getBuild$p(this.this$0), FeatureUsageFileEventLogger.access$getBucket$p(this.this$0), "lifecycle", FeatureUsageFileEventLogger.access$getRecorderVersion$p(this.this$0), "ideaapp.closed", false));
                FeatureUsageFileEventLogger.access$logLastEvent(this.this$0, this.$logger);
            }
            {
                this.this$0 = featureUsageFileEventLogger;
                this.$logger = logger;
            }
        });
        this.myLogExecutor.shutdown();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void log(Logger logger, LogEvent event) {
        if (this.lastEvent != null && event.getTime() - this.lastEventTime <= (long)10000) {
            LogEvent logEvent = this.lastEvent;
            if (logEvent == null) {
                Intrinsics.throwNpe();
            }
            if (logEvent.shouldMerge(event)) {
                this.lastEventTime = event.getTime();
                LogEvent logEvent2 = this.lastEvent;
                if (logEvent2 == null) {
                    Intrinsics.throwNpe();
                }
                logEvent2.getEvent().increment();
                return;
            }
        }
        this.logLastEvent(logger);
        this.lastEvent = event;
        this.lastEventTime = event.getTime();
    }

    private final void logLastEvent(Logger logger) {
        if (this.lastEvent != null) {
            LogEvent logEvent = this.lastEvent;
            if (logEvent == null) {
                Intrinsics.throwNpe();
            }
            logger.info((Object)LogEventSerializer.INSTANCE.toString(logEvent));
        }
        this.lastEvent = null;
    }

    @NotNull
    public List<File> getLogFiles() {
        Object[] files2;
        FeatureUsageEventFileAppender featureUsageEventFileAppender = this.fileAppender;
        String activeLog = featureUsageEventFileAppender != null ? featureUsageEventFileAppender.getActiveLogName() : null;
        Object object = files2 = new File(this.getEventLogDir().toUri()).listFiles(new FileFilter(activeLog){
            final /* synthetic */ String $activeLog;

            public final boolean accept(@NotNull File f) {
                Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
                return !StringUtil.equals((CharSequence)f.getName(), (CharSequence)this.$activeLog);
            }
            {
                this.$activeLog = string;
            }
        });
        if (files2 == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public FeatureUsageFileEventLogger() {
        ThreadPoolExecutor threadPoolExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)this.getClass().getSimpleName());
        Intrinsics.checkExpressionValueIsNotNull((Object)threadPoolExecutor, (String)"ConcurrencyUtil.newSingl\u2026tor(javaClass.simpleName)");
        this.myLogExecutor = threadPoolExecutor;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        this.sessionId = this.shortedUUID(string);
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        BuildNumber buildNumber = applicationInfo.getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        this.build = this.asBuildNumber(buildNumber);
        this.bucket = "-1";
        this.recorderVersion = "2";
        Logger logger = Logger.getLogger((String)"feature-usage-event-logger");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getLogger(\"feature-usage-event-logger\")");
        this.eventLogger = logger;
        this.eventLogger.setLevel(Level.INFO);
        this.eventLogger.setAdditivity(false);
        PatternLayout pattern = new PatternLayout("%m\n");
        try {
            Path dir = this.getEventLogDir();
            FeatureUsageEventFileAppender featureUsageEventFileAppender = this.fileAppender = FeatureUsageEventFileAppender.create((Layout)pattern, dir);
            if (featureUsageEventFileAppender != null) {
                FeatureUsageEventFileAppender featureUsageEventFileAppender2;
                FeatureUsageEventFileAppender appender = featureUsageEventFileAppender2 = featureUsageEventFileAppender;
                appender.setMaxFileSize("200KB");
                this.eventLogger.addAppender((Appender)appender);
            }
        }
        catch (IOException e) {
            System.err.println("Unable to initialize logging for feature usage: " + e.getLocalizedMessage());
        }
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void applicationExiting() {
                this.dispose(eventLogger);
            }
        });
    }

    @NotNull
    public static final /* synthetic */ String access$getSessionId$p(FeatureUsageFileEventLogger $this) {
        return $this.sessionId;
    }

    @NotNull
    public static final /* synthetic */ String access$getBuild$p(FeatureUsageFileEventLogger $this) {
        return $this.build;
    }

    @NotNull
    public static final /* synthetic */ String access$getBucket$p(FeatureUsageFileEventLogger $this) {
        return $this.bucket;
    }

    @NotNull
    public static final /* synthetic */ String access$getRecorderVersion$p(FeatureUsageFileEventLogger $this) {
        return $this.recorderVersion;
    }

    public static final /* synthetic */ void access$log(FeatureUsageFileEventLogger $this, @NotNull Logger logger, @NotNull LogEvent event) {
        $this.log(logger, event);
    }

    public static final /* synthetic */ void access$logLastEvent(FeatureUsageFileEventLogger $this, @NotNull Logger logger) {
        $this.logLastEvent(logger);
    }
}

