/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.ide.actions.ActionsCollector;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.PluginId;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ActionsCollector", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED), @Storage(value="statistics.actions.xml", roamingType=RoamingType.DISABLED, deprecated=true)})
public class ActionsCollectorImpl
extends ActionsCollector
implements PersistentStateComponent<ActionsCollector.State> {
    private static final String DEFAULT_ID = "third.party.plugin.action";
    private final Set<String> myJBActions = new THashSet();
    private ActionsCollector.State myState = new ActionsCollector.State();

    public void record(@Nullable String actionId, @NotNull Class context) {
        if (context == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(0);
        }
        if (actionId == null) {
            return;
        }
        ActionsCollector.State state = this.getState();
        if (state == null) {
            return;
        }
        String key = ConvertUsagesUtil.escapeDescriptorName(actionId);
        if (!this.myJBActions.contains(key)) {
            key = ActionsCollectorImpl.isDevelopedByJetBrains(context) ? key : DEFAULT_ID;
            this.myJBActions.add(key);
        }
        FeatureUsageLogger.INSTANCE.log("actions", key);
        Integer count = (Integer)state.myValues.get(key);
        int value = count == null ? 1 : count + 1;
        state.myValues.put(key, value);
    }

    private static boolean isDevelopedByJetBrains(@NotNull Class aClass) {
        if (aClass == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(1);
        }
        PluginId pluginId = PluginManagerCore.getPluginByClassName(aClass.getName());
        return StatisticsUtilKt.isDevelopedByJetBrains(pluginId);
    }

    @Nullable
    public ActionsCollector.State getState() {
        return this.myState;
    }

    public void loadState(@NotNull ActionsCollector.State state) {
        if (state == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(2);
        }
        this.myState = state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "record";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isDevelopedByJetBrains";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

