/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.performance;

import com.intellij.internal.performance.FileTypeLatencyRecord;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e\"\u001d\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000f"}, d2={"latencyMap", "", "Lcom/intellij/openapi/fileTypes/FileType;", "Lcom/intellij/internal/performance/FileTypeLatencyRecord;", "getLatencyMap", "()Ljava/util/Map;", "getActionKey", "", "action", "recordTypingLatency", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "latencyInMS", "", "intellij.platform.ide.impl"})
public final class LatenciometerKt {
    @NotNull
    private static final Map<FileType, FileTypeLatencyRecord> latencyMap = new LinkedHashMap();

    @NotNull
    public static final Map<FileType, FileTypeLatencyRecord> getLatencyMap() {
        return latencyMap;
    }

    public static final void recordTypingLatency(@NotNull Editor editor, @NotNull String action, long latencyInMS) {
        FileTypeLatencyRecord fileTypeLatencyRecord;
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (virtualFile == null || (virtualFile = virtualFile.getFileType()) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"FileDocumentManager.getI\u2026ment)?.fileType ?: return");
        VirtualFile fileType = virtualFile;
        Map<FileType, FileTypeLatencyRecord> $receiver$iv = latencyMap;
        FileTypeLatencyRecord value$iv = $receiver$iv.get(fileType);
        if (value$iv == null) {
            FileTypeLatencyRecord answer$iv = new FileTypeLatencyRecord((FileType)fileType);
            $receiver$iv.put((FileType)fileType, answer$iv);
            fileTypeLatencyRecord = answer$iv;
        } else {
            fileTypeLatencyRecord = value$iv;
        }
        FileTypeLatencyRecord latencyRecord = fileTypeLatencyRecord;
        latencyRecord.update(LatenciometerKt.getActionKey(action), latencyInMS);
    }

    @NotNull
    public static final String getActionKey(@NotNull String action) {
        char c;
        char c2;
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        return action.length() == 1 ? ('A' <= (c2 = (c = action.charAt(0))) && 'Z' >= c2 || 'a' <= (c2 = c) && 'z' >= c2 || '0' <= (c2 = c) && '9' >= c2 ? "Letter" : (c == ' ' ? "Space" : action)) : action;
    }
}

