/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartElementDescriptor
extends NodeDescriptor {
    private final SmartPsiElementPointer mySmartPointer;

    public SmartElementDescriptor(@NotNull Project project, @Nullable NodeDescriptor parentDescriptor, @NotNull PsiElement element) {
        if (project == null) {
            SmartElementDescriptor.$$$reportNull$$$0(0);
        }
        if (element == null) {
            SmartElementDescriptor.$$$reportNull$$$0(1);
        }
        super(project, parentDescriptor);
        this.mySmartPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer(element);
    }

    @Nullable
    public final PsiElement getPsiElement() {
        return this.mySmartPointer.getElement();
    }

    public Object getElement() {
        return this.getPsiElement();
    }

    protected boolean isMarkReadOnly() {
        return this.getParentDescriptor() instanceof PsiDirectoryNode;
    }

    protected boolean isMarkModified() {
        return this.getParentDescriptor() instanceof PsiDirectoryNode;
    }

    public boolean update() {
        VirtualFile virtualFile;
        PsiElement element = this.mySmartPointer.getElement();
        if (element == null) {
            return true;
        }
        Icon icon = this.getIcon(element);
        Color color = null;
        if (this.isMarkModified() && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element)) != null) {
            color = FileStatusManager.getInstance((Project)this.myProject).getStatus(virtualFile).getColor();
        }
        if (CopyPasteManager.getInstance().isCutElement((Object)element)) {
            color = CopyPasteManager.CUT_COLOR;
        }
        boolean changes = !Comparing.equal((Object)icon, (Object)this.getIcon()) || !Comparing.equal((Object)color, (Object)this.myColor);
        this.setIcon(icon);
        this.myColor = color;
        return changes;
    }

    @Nullable
    protected Icon getIcon(@NotNull PsiElement element) {
        if (element == null) {
            SmartElementDescriptor.$$$reportNull$$$0(2);
        }
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        try {
            return element.getIcon(flags);
        }
        catch (IndexNotReadyException ignored) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/treeView/SmartElementDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

