/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ResourceUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.twelvemonkeys.imageio.stream.ByteArrayImageInputStream;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Base64;
import java.util.Iterator;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebView;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TipUIUtil {
    private static final Logger LOG = Logger.getInstance(TipUIUtil.class);
    private static final String SHORTCUT_ENTITY = "&shortcut:";

    private TipUIUtil() {
    }

    @NotNull
    public static String getPoweredByText(@NotNull TipAndTrickBean tip) {
        PluginDescriptor descriptor;
        if (tip == null) {
            TipUIUtil.$$$reportNull$$$0(0);
        }
        String string = (descriptor = tip.getPluginDescriptor()) instanceof IdeaPluginDescriptor && !"com.intellij".equals(descriptor.getPluginId().getIdString()) ? ((IdeaPluginDescriptor)descriptor).getName() : "";
        if (string == null) {
            TipUIUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private static TipAndTrickBean getTip(String tipFileName) {
        TipAndTrickBean tip = TipAndTrickBean.findByFileName(tipFileName);
        if (tip == null && StringUtil.isNotEmpty((String)tipFileName)) {
            tip = new TipAndTrickBean();
            tip.fileName = tipFileName;
        }
        return tip;
    }

    @Deprecated
    public static void openTipInBrowser(@Nullable TipAndTrickBean tip, JEditorPane browser) {
        browser.setText(TipUIUtil.getTipText(tip, browser));
    }

    private static String getTipText(@Nullable TipAndTrickBean tip, Component component) {
        if (tip == null) {
            return "";
        }
        try {
            PluginDescriptor pluginDescriptor = tip.getPluginDescriptor();
            ClassLoader tipLoader = pluginDescriptor == null ? TipUIUtil.class.getClassLoader() : (ClassLoader)ObjectUtils.notNull((Object)pluginDescriptor.getPluginClassLoader(), (Object)TipUIUtil.class.getClassLoader());
            URL url = ResourceUtil.getResource((ClassLoader)tipLoader, (String)"/tips/", (String)tip.fileName);
            if (url == null) {
                return TipUIUtil.getCantReadText(tip);
            }
            StringBuffer text = new StringBuffer(ResourceUtil.loadText((URL)url));
            TipUIUtil.updateShortcuts(text);
            TipUIUtil.updateImages(text, tipLoader, component);
            String replaced = text.toString().replace("&productName;", ApplicationNamesInfo.getInstance().getFullProductName());
            String major = ApplicationInfo.getInstance().getMajorVersion();
            replaced = replaced.replace("&majorVersion;", major);
            String minor = ApplicationInfo.getInstance().getMinorVersion();
            replaced = replaced.replace("&minorVersion;", minor);
            replaced = replaced.replace("&majorMinorVersion;", major + ("0".equals(minor) ? "" : "." + minor));
            replaced = replaced.replace("&settingsPath;", CommonBundle.settingsActionPath());
            URL cssResource = ResourceUtil.getResource((ClassLoader)tipLoader, (String)"/tips/", (String)(UIUtil.isUnderDarcula() ? "css/tips_darcula.css" : "css/tips.css"));
            if (cssResource != null) {
                try {
                    String inlinedCSS = new String(TipUIUtil.readBytes(cssResource), "utf-8");
                    inlinedCSS = inlinedCSS + "\nbody {background-color:#" + ColorUtil.toHex((Color)UIUtil.getTextFieldBackground()) + ";overflow:hidden;}";
                    replaced = replaced.replaceFirst("<link.*\\.css\">", "<style type=\"text/css\">\n" + inlinedCSS + "\n</style>");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return replaced;
        }
        catch (IOException e) {
            return TipUIUtil.getCantReadText(tip);
        }
    }

    @Deprecated
    public static void openTipInBrowser(String tipFileName, Browser browser, Class providerClass) {
        TipUIUtil.openTipInBrowser(TipUIUtil.getTip(tipFileName), browser);
    }

    public static void openTipInBrowser(@Nullable TipAndTrickBean tip, Browser browser) {
        browser.setText(TipUIUtil.getTipText(tip, browser.getComponent()));
    }

    private static String getCantReadText(TipAndTrickBean bean) {
        String plugin = TipUIUtil.getPoweredByText(bean);
        String product = ApplicationNamesInfo.getInstance().getFullProductName();
        if (!plugin.isEmpty()) {
            product = product + " and " + plugin + " plugin";
        }
        return IdeBundle.message((String)"error.unable.to.read.tip.of.the.day", (Object[])new Object[]{bean.fileName, product});
    }

    private static void updateImages(StringBuffer text, ClassLoader tipLoader, Component component) {
        boolean dark = UIUtil.isUnderDarcula();
        int index = text.indexOf("<img", 0);
        while (index != -1) {
            int srcIndex;
            int end = text.indexOf(">", index + 1);
            if (end == -1) {
                return;
            }
            String img = text.substring(index, end + 1).replace('\r', ' ').replace('\n', ' ');
            int endIndex = img.indexOf("\"", (srcIndex = img.indexOf("src=\"")) + 6);
            if (endIndex != -1) {
                String fileExtension;
                int extPoint;
                String path = img.substring(srcIndex + 5, endIndex);
                URL url = ResourceUtil.getResource((ClassLoader)tipLoader, (String)"/tips/", (String)path);
                if (url != null) {
                    path = url.toExternalForm();
                }
                String pathWithoutExtension = (extPoint = path.lastIndexOf(46)) != -1 ? path.substring(0, extPoint) : path;
                String string = fileExtension = extPoint != -1 ? path.substring(extPoint) : "";
                if (!pathWithoutExtension.endsWith("_dark") && !pathWithoutExtension.endsWith("@2x")) {
                    boolean hidpi = JBUI.isPixHiDPI((Component)component);
                    path = pathWithoutExtension + (hidpi ? "@2x" : "") + (dark ? "_dark" : "") + fileExtension;
                    if (url != null) {
                        String newImgTag = "<img src=\"" + url + "\" ";
                        try {
                            Trinity<String, BufferedImage, byte[]> trinity;
                            URL actualURL;
                            boolean fallbackUpscale = false;
                            try {
                                actualURL = new URL(path);
                                trinity = TipUIUtil.read(actualURL);
                            }
                            catch (IOException e) {
                                LOG.warn("Cannot find icon with path [" + path + "]");
                                fallbackUpscale = hidpi;
                                actualURL = url;
                                trinity = TipUIUtil.read(url);
                            }
                            newImgTag = Registry.is((String)"ide.javafx.tips") ? "<img src=\"data:image/" + (String)trinity.first + ";base64," + Base64.getEncoder().encodeToString((byte[])trinity.third) + "\" " : "<img src=\"" + actualURL.toExternalForm() + "\" ";
                            BufferedImage image = (BufferedImage)trinity.second;
                            int w = image.getWidth();
                            int h = image.getHeight();
                            if (hidpi) {
                                float k = 2.0f;
                                if (UIUtil.isJreHiDPI((Component)component)) {
                                    k = JBUI.sysScale((Component)component);
                                }
                                w = (int)((float)w / k);
                                h = (int)((float)h / k);
                            }
                            int userScale = PaintUtil.RoundingMode.ROUND_FLOOR_BIAS.round((double)JBUI.scale((float)1.0f));
                            w = userScale * w;
                            h = userScale * h;
                            if (fallbackUpscale) {
                                w *= 2;
                                h *= 2;
                            }
                            newImgTag = newImgTag + "width=\"" + w + "\" height=\"" + h + "\"";
                        }
                        catch (Exception ignore) {
                            newImgTag = newImgTag + "width=\"400\" height=\"200\"";
                        }
                        newImgTag = newImgTag + ">";
                        text.replace(index, end + 1, newImgTag);
                    }
                }
            }
            index = text.indexOf("<img", index + 1);
        }
    }

    private static Trinity<String, BufferedImage, byte[]> read(@NotNull URL url) throws IOException {
        if (url == null) {
            TipUIUtil.$$$reportNull$$$0(2);
        }
        byte[] bytes = TipUIUtil.readBytes(url);
        Iterator<ImageReader> readers = ImageIO.getImageReaders(new ByteArrayImageInputStream(bytes));
        String formatName = "png";
        if (readers.hasNext()) {
            formatName = readers.next().getFormatName();
        }
        return Trinity.create((Object)formatName, (Object)ImageIO.read(new ByteArrayInputStream(bytes)), (Object)bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readBytes(@NotNull URL url) throws IOException {
        if (url == null) {
            TipUIUtil.$$$reportNull$$$0(3);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        try (InputStream stream = null;){
            stream = url.openStream();
            int len = stream.read(buffer);
            while (len > 0) {
                baos.write(buffer, 0, len);
                len = stream.read(buffer);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    private static void updateShortcuts(StringBuffer text) {
        int lastIndex = 0;
        while ((lastIndex = text.indexOf(SHORTCUT_ENTITY, lastIndex)) >= 0) {
            Keymap defKeymap;
            int actionIdStart = lastIndex + SHORTCUT_ENTITY.length();
            int actionIdEnd = text.indexOf(";", actionIdStart);
            if (actionIdEnd < 0) {
                return;
            }
            String actionId = text.substring(actionIdStart, actionIdEnd);
            String shortcutText = TipUIUtil.getShortcutText(actionId, KeymapManager.getInstance().getActiveKeymap());
            if (shortcutText == null && (defKeymap = KeymapManager.getInstance().getKeymap(DefaultKeymap.getInstance().getDefaultKeymapName())) != null && (shortcutText = TipUIUtil.getShortcutText(actionId, defKeymap)) != null) {
                shortcutText = shortcutText + " in default keymap";
            }
            if (shortcutText == null) {
                shortcutText = "<no shortcut for action " + actionId + ">";
            }
            text.replace(lastIndex, actionIdEnd + 1, shortcutText);
            lastIndex += shortcutText.length();
        }
        return;
    }

    @Nullable
    private static String getShortcutText(String actionId, Keymap keymap) {
        for (Shortcut shortcut : keymap.getShortcuts(actionId)) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            return KeymapUtil.getShortcutText((Shortcut)shortcut);
        }
        return null;
    }

    @Deprecated
    @NotNull
    public static JEditorPane createTipBrowser() {
        SwingBrowser swingBrowser = new SwingBrowser();
        if (swingBrowser == null) {
            TipUIUtil.$$$reportNull$$$0(4);
        }
        return swingBrowser;
    }

    public static Browser createBrowser() {
        return Registry.is((String)"ide.javafx.tips") ? new JFXBrowser() : new SwingBrowser();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tip";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/TipUIUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/TipUIUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPoweredByText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTipBrowser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPoweredByText";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readBytes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JFXBrowser
    extends JPanel
    implements Browser {
        private final JFXPanel myPanel;
        private WebView myWebView;
        private String myRecentText = "";

        public JFXBrowser() {
            this.setLayout(new GridLayout(1, 1));
            this.setBackground(UIUtil.getTextFieldBackground());
            final Long mask = (Long)ReflectionUtil.getField(Component.class, (Object)this, Long.TYPE, (String)"eventMask");
            this.myPanel = new JFXPanel(){
                {
                    if (mask != null) {
                        this.enableEvents(mask);
                    }
                }
            };
            this.add((Component)this.myPanel);
            Platform.runLater(() -> {
                Platform.setImplicitExit((boolean)false);
                this.myPanel.addMouseWheelListener(new MouseWheelListener(){

                    @Override
                    public void mouseWheelMoved(MouseWheelEvent e) {
                        SwingUtilities.invokeLater(() -> this.dispatchEvent(e));
                    }
                });
                this.myWebView = new WebView();
                this.myPanel.setScene(new Scene((Parent)this.myWebView, 600.0, 400.0));
                this.myWebView.getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                    public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
                        if (newValue == Worker.State.SUCCEEDED) {
                            int height = 0;
                            int width = 0;
                            Integer size = (Integer)myWebView.getEngine().executeScript("document.body.children.length");
                            for (int i = 0; i < size; ++i) {
                                Object h;
                                Object w = myWebView.getEngine().executeScript("document.body.children[" + i + "].scrollWidth");
                                if (w instanceof Integer) {
                                    width = Math.max(width, (Integer)w);
                                }
                                if (!((h = myWebView.getEngine().executeScript("document.body.children[" + i + "].scrollHeight")) instanceof Integer)) continue;
                                height += ((Integer)h).intValue();
                            }
                            myPanel.setPreferredSize(new Dimension(width, height));
                            myPanel.revalidate();
                        }
                    }
                });
            });
        }

        public void setText(String html) {
            this.myRecentText = html;
            Platform.runLater(() -> this.myWebView.getEngine().loadContent(html));
        }

        @Override
        public void load(String url) throws IOException {
            this.setText(IOUtil.readString((DataInput)new DataInputStream(new URL(url).openStream())));
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        public String getText() {
            return this.myRecentText;
        }
    }

    private static class SwingBrowser
    extends JEditorPane
    implements Browser {
        SwingBrowser() {
            this.setEditable(false);
            this.setBackground(UIUtil.getTextFieldBackground());
            this.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        BrowserUtil.browse((URL)e.getURL());
                    }
                }
            });
            URL resource = ResourceUtil.getResource(TipUIUtil.class, (String)"/tips/css/", (String)(UIUtil.isUnderDarcula() ? "tips_darcula.css" : "tips.css"));
            HTMLEditorKit kit = UIUtil.getHTMLEditorKit((boolean)false);
            kit.getStyleSheet().addStyleSheet(UIUtil.loadStyleSheet((URL)resource));
            this.setEditorKit(kit);
        }

        @Override
        public void setText(String t) {
            super.setText(t);
            if (t != null && t.length() > 0) {
                this.setCaretPosition(0);
            }
        }

        @Override
        public void load(String url) throws IOException {
            this.setText(IOUtil.readString((DataInput)new DataInputStream(new URL(url).openStream())));
        }

        @Override
        public JComponent getComponent() {
            return this;
        }
    }

    public static interface Browser
    extends TextAccessor {
        public void load(String var1) throws IOException;

        public JComponent getComponent();
    }
}

