/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.ui.ConfigurableOptionsTopHitProvider;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PreloadingActivity;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionsTopHitProvider
implements SearchTopHitProvider {
    private static final Logger LOG = Logger.getInstance(OptionsTopHitProvider.class);

    @NotNull
    public abstract Collection<OptionDescription> getOptions(@Nullable Project var1);

    private Collection<OptionDescription> getCachedOptions(@Nullable Project project) {
        Project manager;
        Object object = manager = project != null ? project : ApplicationManager.getApplication();
        if (manager == null || manager.isDisposed()) {
            return Collections.emptyList();
        }
        CachedOptions cache = (CachedOptions)manager.getUserData(CachedOptions.KEY);
        if (cache == null) {
            cache = new CachedOptions((ComponentManager)manager);
        }
        return cache.map.computeIfAbsent(this.getClass(), type -> this.getOptions(project));
    }

    public final void consumeTopHits(@NonNls String pattern, Consumer<Object> collector, Project project) {
        if (!pattern.startsWith("#")) {
            return;
        }
        List parts = StringUtil.split((String)(pattern = pattern.substring(1)), (String)" ");
        if (parts.size() == 0) {
            return;
        }
        String id = (String)parts.get(0);
        if (this.getId().startsWith(id) || pattern.startsWith(" ")) {
            pattern = pattern.startsWith(" ") ? pattern.trim() : pattern.substring(id.length()).trim().toLowerCase();
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + pattern), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
            for (OptionDescription option : this.getCachedOptions(project)) {
                if (!matcher.matches(option.getOption())) continue;
                collector.consume((Object)option);
            }
        }
    }

    public abstract String getId();

    public boolean isEnabled(@Nullable Project project) {
        return true;
    }

    public static String messageApp(String property) {
        return StringUtil.stripHtml((String)ApplicationBundle.message((String)property, (Object[])new Object[0]), (boolean)false);
    }

    static String messageIde(String property) {
        return StringUtil.stripHtml((String)IdeBundle.message((String)property, (Object[])new Object[0]), (boolean)false);
    }

    static String messageKeyMap(String property) {
        return StringUtil.stripHtml((String)KeyMapBundle.message((String)property, (Object[])new Object[0]), (boolean)false);
    }

    public static final class Activity
    extends PreloadingActivity
    implements StartupActivity {
        @Override
        public void preload(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                Activity.$$$reportNull$$$0(0);
            }
            Activity.cacheAll(indicator, null);
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                Activity.$$$reportNull$$$0(1);
            }
            Activity.cacheAll(null, project);
        }

        private static void cacheAll(@Nullable ProgressIndicator indicator, @Nullable Project project) {
            Application application = ApplicationManager.getApplication();
            if (application != null && !application.isUnitTestMode()) {
                long millis = System.currentTimeMillis();
                String name = project == null ? "application" : "project";
                AtomicLong time = new AtomicLong();
                for (SearchTopHitProvider provider : (SearchTopHitProvider[])SearchTopHitProvider.EP_NAME.getExtensions()) {
                    if (provider instanceof ConfigurableOptionsTopHitProvider) {
                        application.invokeLater(() -> {
                            long millisOnEDT = System.currentTimeMillis();
                            Activity.cache((ConfigurableOptionsTopHitProvider)provider, indicator, project);
                            time.addAndGet(System.currentTimeMillis() - millisOnEDT);
                        });
                        continue;
                    }
                    if (!(provider instanceof OptionsTopHitProvider)) continue;
                    Activity.cache((OptionsTopHitProvider)provider, indicator, project);
                }
                application.invokeLater(() -> LOG.info(time.get() + " ms spent on EDT to cache options in " + name));
                long delta = System.currentTimeMillis() - millis;
                LOG.info(delta + " ms spent to cache options in " + name);
            }
        }

        private static void cache(@NotNull OptionsTopHitProvider provider, @Nullable ProgressIndicator indicator, @Nullable Project project) {
            if (provider == null) {
                Activity.$$$reportNull$$$0(2);
            }
            if (indicator != null && indicator.isCanceled()) {
                return;
            }
            if (project != null && project.isDisposed()) {
                return;
            }
            if (provider.isEnabled(project)) {
                provider.getCachedOptions(project);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/ui/OptionsTopHitProvider$Activity";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preload";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runActivity";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cache";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class CachedOptions
    implements Disposable {
        private static final Key<CachedOptions> KEY = Key.create((String)"cached top hits");
        private final ConcurrentHashMap<Class<?>, Collection<OptionDescription>> map = new ConcurrentHashMap();
        private final ComponentManager manager;

        private CachedOptions(ComponentManager manager) {
            this.manager = manager;
            Disposer.register((Disposable)manager, (Disposable)this);
            manager.putUserData(KEY, (Object)this);
        }

        public void dispose() {
            this.manager.putUserData(KEY, null);
            this.map.values().forEach(CachedOptions::dispose);
        }

        private static void dispose(Collection<OptionDescription> options) {
            if (options != null) {
                options.forEach(CachedOptions::dispose);
            }
        }

        private static void dispose(OptionDescription option) {
            if (option instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)option));
            }
        }
    }

    @Deprecated
    public static interface CoveredByToggleActions {
    }
}

