/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.StructureViewComposite;
import com.intellij.ide.util.StructureViewCompositeModel;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateLanguageStructureViewBuilder
extends TreeBasedStructureViewBuilder {
    private final VirtualFile myVirtualFile;
    private final Project myProject;

    @NotNull
    public static TemplateLanguageStructureViewBuilder create(@NotNull PsiFile psiFile, final @Nullable PairFunction<PsiFile, Editor, StructureViewModel> modelFactory) {
        if (psiFile == null) {
            TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(0);
        }
        TemplateLanguageStructureViewBuilder templateLanguageStructureViewBuilder = new TemplateLanguageStructureViewBuilder((PsiElement)psiFile){

            @Override
            protected TreeBasedStructureViewBuilder createMainBuilder(final @NotNull PsiFile psi) {
                if (psi == null) {
                    1.$$$reportNull$$$0(0);
                }
                return modelFactory == null ? null : new TreeBasedStructureViewBuilder(){

                    public boolean isRootNodeShown() {
                        return false;
                    }

                    @NotNull
                    public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                        StructureViewModel structureViewModel = (StructureViewModel)modelFactory.fun((Object)psi, (Object)editor);
                        if (structureViewModel == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return structureViewModel;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/TemplateLanguageStructureViewBuilder$1$1", "createStructureViewModel"));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/ide/structureView/impl/TemplateLanguageStructureViewBuilder$1", "createMainBuilder"));
            }
        };
        if (templateLanguageStructureViewBuilder == null) {
            TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(1);
        }
        return templateLanguageStructureViewBuilder;
    }

    protected TemplateLanguageStructureViewBuilder(PsiElement psiElement) {
        this.myProject = psiElement.getProject();
        this.myVirtualFile = psiElement.getContainingFile().getVirtualFile();
    }

    public boolean isRootNodeShown() {
        return false;
    }

    @NotNull
    public StructureView createStructureView(final FileEditor fileEditor, final @NotNull Project project) {
        if (project == null) {
            TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(2);
        }
        ArrayList<StructureViewComposite.StructureViewDescriptor> viewDescriptors = new ArrayList<StructureViewComposite.StructureViewDescriptor>();
        VirtualFile file2 = fileEditor == null ? null : fileEditor.getFile();
        PsiFile psiFile = file2 == null || !file2.isValid() ? null : PsiManager.getInstance((Project)project).findFile(file2);
        final List languages = TemplateLanguageStructureViewBuilder.getLanguages(psiFile).toList();
        for (Language language : languages) {
            StructureViewBuilder builder2 = this.getBuilder((PsiFile)ObjectUtils.notNull((Object)psiFile), language);
            if (builder2 == null) continue;
            StructureView structureView = builder2.createStructureView(fileEditor, project);
            String title = language.getDisplayName();
            Icon icon = ((FileType)ObjectUtils.notNull((Object)LanguageUtil.getLanguageFileType((Language)language), (Object)FileTypes.UNKNOWN)).getIcon();
            viewDescriptors.add(new StructureViewComposite.StructureViewDescriptor(title, structureView, icon));
        }
        StructureViewComposite.StructureViewDescriptor[] array = viewDescriptors.toArray(new StructureViewComposite.StructureViewDescriptor[0]);
        StructureViewComposite structureViewComposite = new StructureViewComposite(array){

            @Override
            public boolean isOutdated() {
                VirtualFile file2 = fileEditor == null ? null : fileEditor.getFile();
                PsiFile psiFile = file2 == null || !file2.isValid() ? null : PsiManager.getInstance((Project)project).findFile(file2);
                List newLanguages = TemplateLanguageStructureViewBuilder.getLanguages(psiFile).toList();
                if (!Comparing.equal((Object)languages, (Object)newLanguages)) {
                    return true;
                }
                if (psiFile == null) {
                    return true;
                }
                FileViewProvider viewProvider = psiFile.getViewProvider();
                Language baseLanguage = viewProvider.getBaseLanguage();
                StructureViewComposite.StructureViewDescriptor[] views = this.getStructureViews();
                boolean hasMainView = views.length > 0 && Comparing.equal((String)views[0].title, (String)baseLanguage.getDisplayName());
                JBIterable newAcceptedLanguages = JBIterable.from((Iterable)newLanguages).filter(o -> o == baseLanguage && hasMainView || o != baseLanguage && TemplateLanguageStructureViewBuilder.this.isAcceptableBaseLanguageFile(viewProvider.getPsi(o)));
                return views.length != newAcceptedLanguages.size();
            }
        };
        if (structureViewComposite == null) {
            TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(3);
        }
        return structureViewComposite;
    }

    @NotNull
    public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
        ArrayList<StructureViewComposite.StructureViewDescriptor> viewDescriptors = new ArrayList<StructureViewComposite.StructureViewDescriptor>();
        PsiFile psiFile = (PsiFile)ObjectUtils.notNull((Object)PsiManager.getInstance((Project)this.myProject).findFile(this.myVirtualFile));
        for (Language language : TemplateLanguageStructureViewBuilder.getLanguages(psiFile)) {
            StructureViewBuilder builder2 = this.getBuilder(psiFile, language);
            if (!(builder2 instanceof TreeBasedStructureViewBuilder)) continue;
            StructureViewModel model = ((TreeBasedStructureViewBuilder)builder2).createStructureViewModel(editor);
            String title = language.getDisplayName();
            Icon icon = ((FileType)ObjectUtils.notNull((Object)LanguageUtil.getLanguageFileType((Language)language), (Object)FileTypes.UNKNOWN)).getIcon();
            viewDescriptors.add(new StructureViewComposite.StructureViewDescriptor(title, model, icon));
        }
        StructureViewCompositeModel structureViewCompositeModel = new StructureViewCompositeModel(psiFile, editor, viewDescriptors);
        if (structureViewCompositeModel == null) {
            TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(4);
        }
        return structureViewCompositeModel;
    }

    @NotNull
    private static JBIterable<Language> getLanguages(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }
        FileViewProvider provider = psiFile.getViewProvider();
        Language baseLanguage = provider.getBaseLanguage();
        Language dataLanguage = provider instanceof TemplateLanguageFileViewProvider ? ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage() : null;
        JBIterable jBIterable = JBIterable.of((Object)baseLanguage).append((Object)dataLanguage).append((Iterable)JBIterable.from((Iterable)provider.getLanguages()).filter(o -> o != baseLanguage && o != dataLanguage));
        if (jBIterable == null) {
            TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @Nullable
    private StructureViewBuilder getBuilder(@NotNull PsiFile psiFile, @NotNull Language language) {
        if (psiFile == null) {
            TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(7);
        }
        if (language == null) {
            TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(8);
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        Language baseLanguage = viewProvider.getBaseLanguage();
        PsiFile psi = viewProvider.getPsi(language);
        if (psi == null) {
            return null;
        }
        if (language == baseLanguage) {
            return this.createMainBuilder(psi);
        }
        if (!this.isAcceptableBaseLanguageFile(psi)) {
            return null;
        }
        PsiStructureViewFactory factory = (PsiStructureViewFactory)LanguageStructureViewBuilder.INSTANCE.forLanguage(language);
        return factory == null ? null : factory.getStructureViewBuilder(psi);
    }

    protected boolean isAcceptableBaseLanguageFile(PsiFile dataFile) {
        return true;
    }

    @Nullable
    protected TreeBasedStructureViewBuilder createMainBuilder(@NotNull PsiFile psi) {
        StructureViewComposite.StructureViewDescriptor descriptor;
        if (psi == null) {
            TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(9);
        }
        if ((descriptor = this.createMainView(null, psi)) == null) {
            return null;
        }
        return new TreeBasedStructureViewBuilder(){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                Disposer.register((Disposable)descriptor.structureModel, (Disposable)descriptor.structureView);
                StructureViewModel structureViewModel = descriptor.structureModel;
                if (structureViewModel == null) {
                    3.$$$reportNull$$$0(0);
                }
                return structureViewModel;
            }

            @NotNull
            public StructureView createStructureView(FileEditor fileEditor, @NotNull Project project) {
                if (project == null) {
                    3.$$$reportNull$$$0(1);
                }
                StructureView structureView = descriptor.structureView;
                if (structureView == null) {
                    3.$$$reportNull$$$0(2);
                }
                return structureView;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/structureView/impl/TemplateLanguageStructureViewBuilder$3";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createStructureViewModel";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/structureView/impl/TemplateLanguageStructureViewBuilder$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createStructureView";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "createStructureView";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Deprecated
    protected StructureViewComposite.StructureViewDescriptor createMainView(FileEditor fileEditor, PsiFile mainFile) {
        throw new AssertionError();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/structureView/impl/TemplateLanguageStructureViewBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/structureView/impl/TemplateLanguageStructureViewBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createStructureView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createStructureViewModel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createStructureView";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBuilder";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createMainBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

