/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.CompoundProjectViewNodeDecorator;
import com.intellij.ide.projectView.impl.CompoundTreeStructureProvider;
import com.intellij.ide.projectView.impl.IdeViewForProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.ShowModulesAction;
import com.intellij.ide.scopeView.NamedScopeFilter;
import com.intellij.ide.scopeView.ScopePaneSelectInTarget;
import com.intellij.ide.scopeView.ScopeViewTreeModel;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ChangeListScope;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.stripe.ErrorStripePainter;
import com.intellij.ui.stripe.TreeUpdater;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.RestoreSelectionListener;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public final class ScopeViewPane
extends AbstractProjectViewPane {
    @NonNls
    public static final String ID = "Scope";
    private static final Logger LOG = Logger.getInstance(ScopeViewPane.class);
    private final IdeView myIdeView;
    private final NamedScopesHolder myDependencyValidationManager;
    private final NamedScopesHolder myNamedScopeManager;
    private final NamedScopesHolder.ScopeListener myScopeListener;
    private final ScopeViewTreeModel myTreeModel;
    private final AsyncTreeModel myAsyncTreeModel;
    private LinkedHashMap<String, NamedScopeFilter> myFilters;
    private JScrollPane myScrollPane;

    public ScopeViewPane(@NotNull Project project, @NotNull DependencyValidationManager dvm, @NotNull NamedScopeManager nsm) {
        if (project == null) {
            ScopeViewPane.$$$reportNull$$$0(0);
        }
        if (dvm == null) {
            ScopeViewPane.$$$reportNull$$$0(1);
        }
        if (nsm == null) {
            ScopeViewPane.$$$reportNull$$$0(2);
        }
        super(project);
        this.myIdeView = new IdeViewForProjectViewPane(() -> this);
        this.myScopeListener = new NamedScopesHolder.ScopeListener(){
            private final AtomicLong counter = new AtomicLong();

            public void scopesChanged() {
                if (ScopeViewPane.this.myProject.isDisposed()) {
                    return;
                }
                long count = this.counter.incrementAndGet();
                EdtExecutorService.getScheduledExecutorInstance().schedule(() -> {
                    if (count == this.counter.get()) {
                        ProjectView view;
                        ProjectView projectView = view = ScopeViewPane.this.myProject.isDisposed() ? null : ProjectView.getInstance(ScopeViewPane.this.myProject);
                        if (view == null) {
                            return;
                        }
                        ScopeViewPane.this.myFilters = ScopeViewPane.map(new NamedScopesHolder[]{ScopeViewPane.this.myDependencyValidationManager, ScopeViewPane.this.myNamedScopeManager});
                        String currentId = view.getCurrentViewId();
                        String currentSubId = ScopeViewPane.this.getSubId();
                        view.removeProjectPane(ScopeViewPane.this);
                        view.addProjectPane(ScopeViewPane.this);
                        if (currentId == null) {
                            return;
                        }
                        if (currentId.equals(ScopeViewPane.this.getId())) {
                            view.changeView(currentId, currentSubId);
                        } else {
                            view.changeView(currentId);
                        }
                    }
                }, 10L, TimeUnit.MILLISECONDS);
            }
        };
        this.myDependencyValidationManager = dvm;
        this.myNamedScopeManager = nsm;
        this.myFilters = ScopeViewPane.map(this.myDependencyValidationManager, this.myNamedScopeManager);
        this.myTreeModel = new ScopeViewTreeModel(project, new ProjectViewSettings.Delegate(project, ID));
        this.myTreeModel.setStructureProvider(CompoundTreeStructureProvider.get(project));
        this.myTreeModel.setNodeDecorator(CompoundProjectViewNodeDecorator.get(project));
        this.myAsyncTreeModel = new AsyncTreeModel((TreeModel)((Object)this.myTreeModel), true, this);
        this.myDependencyValidationManager.addScopeListener(this.myScopeListener);
        this.myNamedScopeManager.addScopeListener(this.myScopeListener);
        ChangeListManager.getInstance((Project)project).addChangeListListener((ChangeListListener)new ChangeListAdapter(){

            public void changeListAdded(ChangeList list2) {
                ScopeViewPane.this.myAsyncTreeModel.onValidThread(() -> ((NamedScopesHolder)ScopeViewPane.this.myDependencyValidationManager).fireScopeListeners());
            }

            public void changeListRemoved(ChangeList list2) {
                ScopeViewPane.this.myAsyncTreeModel.onValidThread(() -> ((NamedScopesHolder)ScopeViewPane.this.myDependencyValidationManager).fireScopeListeners());
            }

            public void changeListRenamed(ChangeList list2, String name) {
                ScopeViewPane.this.myAsyncTreeModel.onValidThread(() -> ((NamedScopesHolder)ScopeViewPane.this.myDependencyValidationManager).fireScopeListeners());
            }

            public void changeListsChanged() {
                NamedScopeFilter filter = ScopeViewPane.this.myTreeModel.getFilter();
                if (filter != null && filter.getScope() instanceof ChangeListScope) {
                    ScopeViewPane.this.myTreeModel.setFilter(filter);
                }
            }
        }, (Disposable)this);
        this.installComparator();
    }

    @Override
    public void dispose() {
        DnDAwareTree tree = this.myTree;
        if (tree != null) {
            ((JTree)((Object)tree)).setModel(null);
        }
        this.myDependencyValidationManager.removeScopeListener(this.myScopeListener);
        this.myNamedScopeManager.removeScopeListener(this.myScopeListener);
        super.dispose();
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            ScopeViewPane.$$$reportNull$$$0(3);
        }
        return ID;
    }

    @Override
    public int getWeight() {
        return 4;
    }

    @Override
    public String getTitle() {
        return IdeBundle.message((String)"scope.view.title", (Object[])new Object[0]);
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Ide.LocalScope;
    }

    @Override
    public JComponent createComponent() {
        this.onSubIdChange();
        if (this.myTree == null) {
            this.myTree = new ProjectViewTree((TreeModel)((Object)this.myAsyncTreeModel));
            this.myTree.setName("ScopeViewTree");
            this.myTree.setRootVisible(false);
            this.myTree.setShowsRootHandles(true);
            this.myTree.addTreeSelectionListener(new RestoreSelectionListener());
            this.myTree.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent event) {
                    if (event.isConsumed()) {
                        return;
                    }
                    if (10 == event.getKeyCode()) {
                        OpenSourceUtil.openSourcesFrom((DataProvider)ScopeViewPane.this, (boolean)ScreenReader.isActive());
                        event.consume();
                    }
                }
            });
            TreeUtil.installActions((JTree)((Object)this.myTree));
            ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.myTree));
            EditSourceOnDoubleClickHandler.install((JTree)((Object)this.myTree));
            CustomizationUtil.installPopupHandler((JComponent)((Object)this.myTree), "ScopeViewPopupMenu", "ScopeViewPopup");
            new TreeSpeedSearch((JTree)((Object)this.myTree));
            this.enableDnD();
        }
        if (this.myScrollPane == null) {
            this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree), (boolean)true);
            ErrorStripePainter painter = new ErrorStripePainter(true);
            Disposer.register((Disposable)this, (Disposable)new TreeUpdater<ErrorStripePainter>(painter, this.myScrollPane, (JTree)((Object)this.myTree)){

                @Override
                protected void update(ErrorStripePainter painter, int index, Object object) {
                    super.update(painter, index, ScopeViewPane.this.myTreeModel.getStripe(object, ScopeViewPane.this.myTree.isExpanded(index)));
                }
            });
        }
        return this.myScrollPane;
    }

    @Override
    @NotNull
    public ActionCallback updateFromRoot(boolean restoreExpandedPaths) {
        this.saveExpandedPaths();
        this.myTreeModel.invalidate(null);
        this.restoreExpandedPaths();
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            ScopeViewPane.$$$reportNull$$$0(4);
        }
        return actionCallback;
    }

    @Override
    public SelectInTarget createSelectInTarget() {
        return new ScopePaneSelectInTarget(this.myProject);
    }

    @Override
    public void select(Object object, VirtualFile file2, boolean requestFocus) {
        NamedScopeFilter current;
        PsiElement element = object instanceof PsiElement ? (PsiElement)object : null;
        if (this.select(element, file2, requestFocus, current = this.myTreeModel.getFilter())) {
            return;
        }
        for (NamedScopeFilter filter : this.getFilters()) {
            if (current == filter || !this.select(element, file2, requestFocus, filter)) continue;
            return;
        }
    }

    private boolean select(PsiElement element, VirtualFile file2, boolean requestFocus, NamedScopeFilter filter) {
        if (filter == null || !filter.accept(file2)) {
            return false;
        }
        String subId = filter.toString();
        if (!Objects.equals(subId, this.getSubId())) {
            if (!requestFocus) {
                return true;
            }
            ProjectView.getInstance(this.myProject).changeView(this.getId(), subId);
        }
        LOG.debug("select element: ", new Object[]{element, " in file: ", file2});
        TreeVisitor visitor = AbstractProjectViewPane.createVisitor(element, file2);
        if (visitor == null) {
            return true;
        }
        DnDAwareTree tree = this.myTree;
        TreeState.expand((JTree)((Object)tree), arg_0 -> ScopeViewPane.lambda$select$3((JTree)((Object)tree), visitor, element, file2, arg_0));
        return true;
    }

    private static boolean selectPath(@NotNull JTree tree, TreePath path) {
        if (tree == null) {
            ScopeViewPane.$$$reportNull$$$0(5);
        }
        if (path == null) {
            return false;
        }
        tree.expandPath(path);
        TreeUtil.selectPath((JTree)tree, (TreePath)path);
        return true;
    }

    @Override
    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            ScopeViewPane.$$$reportNull$$$0(6);
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            ScopeViewPane.$$$reportNull$$$0(7);
        }
        return actionCallback;
    }

    @Override
    protected void onSubIdChange() {
        this.myTreeModel.setFilter(this.getFilter(this.getSubId()));
    }

    @Override
    @NotNull
    public String[] getSubIds() {
        LinkedHashMap<String, NamedScopeFilter> map = this.myFilters;
        if (map == null || map.isEmpty()) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                ScopeViewPane.$$$reportNull$$$0(8);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = (String[])ContainerUtil.toArray(map.keySet(), (Object[])ArrayUtilRt.EMPTY_STRING_ARRAY);
        if (stringArray == null) {
            ScopeViewPane.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String getPresentableSubIdName(@NotNull String subId) {
        NamedScopeFilter filter;
        if (subId == null) {
            ScopeViewPane.$$$reportNull$$$0(10);
        }
        String string = (filter = this.getFilter(subId)) != null ? filter.getScope().getName() : this.getTitle();
        if (string == null) {
            ScopeViewPane.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public Icon getPresentableSubIdIcon(@NotNull String subId) {
        NamedScopeFilter filter;
        if (subId == null) {
            ScopeViewPane.$$$reportNull$$$0(12);
        }
        return (filter = this.getFilter(subId)) != null ? filter.getScope().getIcon() : this.getIcon();
    }

    @Override
    public void addToolbarActions(DefaultActionGroup actionGroup) {
        actionGroup.addAction((AnAction)new ShowModulesAction(this.myProject, ID)).setAsSecondary(true);
        actionGroup.addAction((AnAction)this.createFlattenModulesAction(() -> true)).setAsSecondary(true);
        AnAction editScopesAction = ActionManager.getInstance().getAction("ScopeView.EditScopes");
        if (editScopesAction != null) {
            actionGroup.addAction(editScopesAction).setAsSecondary(true);
        }
    }

    @Override
    protected void installComparator(AbstractTreeBuilder builder2, Comparator<NodeDescriptor> comparator2) {
        this.myTreeModel.setComparator(comparator2);
    }

    @Override
    @Nullable
    public Object getValueFromNode(@Nullable Object node) {
        return this.myTreeModel.getContent(node);
    }

    @Override
    public Object getData(String dataId) {
        Object data = super.getData(dataId);
        if (data != null) {
            return data;
        }
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            return this.myIdeView;
        }
        return null;
    }

    @NotNull
    Iterable<NamedScopeFilter> getFilters() {
        Collection<NamedScopeFilter> collection = this.myFilters.values();
        if (collection == null) {
            ScopeViewPane.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @Nullable
    NamedScopeFilter getFilter(@Nullable String subId) {
        LinkedHashMap<String, NamedScopeFilter> map = this.myFilters;
        return map == null || subId == null ? null : map.get(subId);
    }

    @NotNull
    private static LinkedHashMap<String, NamedScopeFilter> map(NamedScopesHolder ... holders) {
        LinkedHashMap<String, NamedScopeFilter> map = new LinkedHashMap<String, NamedScopeFilter>();
        for (NamedScopeFilter filter : NamedScopeFilter.list(holders)) {
            NamedScopeFilter old = map.put(filter.toString(), filter);
            if (old == null) continue;
            LOG.warn("DUPLICATED: " + filter);
        }
        LinkedHashMap<String, NamedScopeFilter> linkedHashMap = map;
        if (linkedHashMap == null) {
            ScopeViewPane.$$$reportNull$$$0(14);
        }
        return linkedHashMap;
    }

    private static /* synthetic */ void lambda$select$3(JTree tree, TreeVisitor visitor, PsiElement element, VirtualFile file2, AsyncPromise promise2) {
        TreeUtil.visit((JTree)tree, (TreeVisitor)visitor, path -> {
            if (ScopeViewPane.selectPath(tree, path) || element == null || Registry.is((String)"async.project.view.support.extra.select.disabled")) {
                promise2.setResult(null);
            } else {
                TreeUtil.visit((JTree)tree, (TreeVisitor)AbstractProjectViewPane.createVisitor(file2), path2 -> {
                    ScopeViewPane.selectPath(tree, path2);
                    promise2.setResult(null);
                });
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dvm";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nsm";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewPane";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewPane";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "updateFromRoot";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReady";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubIds";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableSubIdName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReady";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableSubIdName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableSubIdIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

