/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayDeque;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class ProjectViewTree
extends DnDAwareTree {
    private static final Logger LOG = Logger.getInstance(ProjectViewTree.class);

    protected ProjectViewTree(Project project, TreeModel model) {
        this(model);
    }

    public ProjectViewTree(TreeModel model) {
        super(model);
        NodeRenderer cellRenderer = new NodeRenderer(){

            protected void doPaint(Graphics2D g) {
                super.doPaint(g);
                this.setOpaque(false);
            }
        };
        cellRenderer.setOpaque(false);
        cellRenderer.setIconOpaque(false);
        this.setCellRenderer((TreeCellRenderer)cellRenderer);
        cellRenderer.setTransparentIconBackground(true);
        HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)((Object)this));
    }

    @Deprecated
    public DefaultMutableTreeNode getSelectedNode() {
        TreePath path = TreeUtil.getSelectedPathIfOne((JTree)((Object)this));
        return path == null ? null : (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)path.getLastPathComponent(), DefaultMutableTreeNode.class);
    }

    public final int getToggleClickCount() {
        NodeDescriptor descriptor;
        int count = super.getToggleClickCount();
        TreePath path = this.getSelectionPath();
        if (path != null && (descriptor = (NodeDescriptor)TreeUtil.getUserObject(NodeDescriptor.class, (Object)path.getLastPathComponent())) != null && !descriptor.expandOnDoubleClick()) {
            LOG.info("getToggleClickCount: -1 for " + descriptor.getClass().getName());
            return -1;
        }
        return count;
    }

    public void setToggleClickCount(int count) {
        if (count != 2) {
            LOG.info((Throwable)new IllegalStateException("setToggleClickCount: unexpected count = " + count));
        }
        super.setToggleClickCount(count);
    }

    public boolean isFileColorsEnabled() {
        return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
    }

    public static boolean isFileColorsEnabledFor(JTree tree) {
        boolean enabled = FileColorManagerImpl._isEnabled() && FileColorManagerImpl._isEnabledForProjectView();
        boolean opaque = tree.isOpaque();
        if (enabled && opaque) {
            tree.setOpaque(false);
        } else if (!enabled && !opaque) {
            tree.setOpaque(true);
        }
        return enabled;
    }

    @Nullable
    public Color getFileColorFor(Object object) {
        Color color;
        Project project;
        VirtualFile file2;
        Object value;
        DefaultMutableTreeNode node;
        if (object instanceof DefaultMutableTreeNode) {
            node = (DefaultMutableTreeNode)object;
            object = node.getUserObject();
        }
        if (object instanceof AbstractTreeNode && (value = (node = (AbstractTreeNode)object).getValue()) instanceof PsiElement) {
            return ProjectViewTree.getColorForElement((PsiElement)value);
        }
        if (object instanceof ProjectViewNode && (file2 = (node = (ProjectViewNode)object).getVirtualFile()) != null && (project = node.getProject()) != null && !project.isDisposed() && (color = VfsPresentationUtil.getFileBackgroundColor(project, file2)) != null) {
            return ColorUtil.softer((Color)color);
        }
        return null;
    }

    @Nullable
    public static Color getColorForElement(@Nullable PsiElement psi) {
        Color color = null;
        if (psi != null) {
            if (!psi.isValid()) {
                return null;
            }
            Project project = psi.getProject();
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)psi);
            if (file2 != null) {
                color = VfsPresentationUtil.getFileBackgroundColor(project, file2);
            } else if (psi instanceof PsiDirectory) {
                color = VfsPresentationUtil.getFileBackgroundColor(project, ((PsiDirectory)psi).getVirtualFile());
            } else if (psi instanceof PsiDirectoryContainer) {
                PsiDirectory[] dirs;
                for (PsiDirectory dir : dirs = ((PsiDirectoryContainer)psi).getDirectories()) {
                    Color c = VfsPresentationUtil.getFileBackgroundColor(project, dir.getVirtualFile());
                    if (c != null && color == null) {
                        color = c;
                        continue;
                    }
                    if (c == null) continue;
                    color = null;
                    break;
                }
            }
        }
        return color == null ? null : ColorUtil.softer(color);
    }

    public void collapsePath(TreePath path) {
        int row;
        int n = row = Registry.is((String)"async.project.view.collapse.tree.path.recursively") ? this.getRowForPath(path) : -1;
        if (row < 0) {
            super.collapsePath(path);
        } else {
            TreePath next;
            ArrayDeque<TreePath> deque = new ArrayDeque<TreePath>();
            deque.addFirst(path);
            while (++row < this.getRowCount() && path.isDescendant(next = this.getPathForRow(row))) {
                if (!this.isExpanded(next)) continue;
                deque.addFirst(next);
            }
            deque.forEach(x$0 -> super.collapsePath(x$0));
        }
    }
}

