/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.impl.FlattenModulesToggleAction;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.RootsProvider;
import com.intellij.ide.projectView.impl.AsyncProjectViewSupport;
import com.intellij.ide.projectView.impl.GroupByTypeComparator;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectViewDropTarget;
import com.intellij.ide.projectView.impl.ProjectViewFileVisitor;
import com.intellij.ide.projectView.impl.ProjectViewNodeVisitor;
import com.intellij.ide.projectView.impl.nodes.AbstractModuleNode;
import com.intellij.ide.projectView.impl.nodes.AbstractProjectNode;
import com.intellij.ide.projectView.impl.nodes.ModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeStructureBase;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.problems.ProblemListener;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.tree.project.ProjectFileNode;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class AbstractProjectViewPane
implements DataProvider,
Disposable,
BusyObject {
    private static final Logger LOG = Logger.getInstance(AbstractProjectViewPane.class);
    public static final ExtensionPointName<AbstractProjectViewPane> EP_NAME = ExtensionPointName.create((String)"com.intellij.projectViewPane");
    @NotNull
    protected final Project myProject;
    private Runnable myTreeChangeListener;
    protected DnDAwareTree myTree;
    protected AbstractTreeStructure myTreeStructure;
    private AbstractTreeBuilder myTreeBuilder;
    private final Map<String, TreeState> myReadTreeState;
    private final AtomicBoolean myTreeStateRestored;
    private String mySubId;
    @NonNls
    private static final String ELEMENT_SUBPANE = "subPane";
    @NonNls
    private static final String ATTRIBUTE_SUBID = "subId";
    private DnDTarget myDropTarget;
    private DnDSource myDragSource;
    private DnDManager myDndManager;

    private void queueUpdateByProblem() {
        if (Registry.is((String)"projectView.showHierarchyErrors") && this.myTreeBuilder != null) {
            this.myTreeBuilder.queueUpdate();
        }
    }

    protected AbstractProjectViewPane(@NotNull Project project) {
        if (project == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(0);
        }
        this.myReadTreeState = new HashMap<String, TreeState>();
        this.myTreeStateRestored = new AtomicBoolean();
        this.myProject = project;
        ProblemListener problemListener = new ProblemListener(){

            public void problemsAppeared(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                AbstractProjectViewPane.this.queueUpdateByProblem();
            }

            public void problemsChanged(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                AbstractProjectViewPane.this.queueUpdateByProblem();
            }

            public void problemsDisappeared(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                AbstractProjectViewPane.this.queueUpdateByProblem();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/ide/projectView/impl/AbstractProjectViewPane$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsAppeared";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsDisappeared";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        project.getMessageBus().connect((Disposable)this).subscribe(ProblemListener.TOPIC, (Object)problemListener);
        Disposer.register((Disposable)project, (Disposable)this);
    }

    protected final void fireTreeChangeListener() {
        if (this.myTreeChangeListener != null) {
            this.myTreeChangeListener.run();
        }
    }

    public final void setTreeChangeListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(1);
        }
        this.myTreeChangeListener = listener2;
    }

    public final void removeTreeChangeListener() {
        this.myTreeChangeListener = null;
    }

    public abstract String getTitle();

    public abstract Icon getIcon();

    @NotNull
    public abstract String getId();

    @Nullable
    public final String getSubId() {
        return this.mySubId;
    }

    public final void setSubId(@Nullable String subId) {
        if (Comparing.strEqual((String)this.mySubId, (String)subId)) {
            return;
        }
        this.saveExpandedPaths();
        this.mySubId = subId;
        this.onSubIdChange();
    }

    protected void onSubIdChange() {
    }

    public boolean isInitiallyVisible() {
        return true;
    }

    public boolean supportsManualOrder() {
        return false;
    }

    protected String getManualOrderOptionText() {
        return IdeBundle.message((String)"action.manual.order", (Object[])new Object[0]);
    }

    @NotNull
    public String[] getSubIds() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(2);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public String getPresentableSubIdName(@NotNull String subId) {
        if (subId == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(3);
        }
        throw new IllegalStateException("should not call");
    }

    public Icon getPresentableSubIdIcon(@NotNull String subId) {
        if (subId == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(4);
        }
        return this.getIcon();
    }

    public abstract JComponent createComponent();

    public JComponent getComponentToFocus() {
        return this.myTree;
    }

    public void expand(@Nullable Object[] path, boolean requestFocus) {
        if (this.getTreeBuilder() == null || path == null) {
            return;
        }
        this.getTreeBuilder().buildNodeForPath(path);
        DefaultMutableTreeNode node = this.getTreeBuilder().getNodeForPath(path);
        if (node == null) {
            return;
        }
        TreePath treePath = new TreePath(node.getPath());
        this.myTree.expandPath(treePath);
        if (requestFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.myTree), true));
        }
        TreeUtil.selectPath((JTree)((Object)this.myTree), (TreePath)treePath);
    }

    public void dispose() {
        if (this.myDndManager != null) {
            if (this.myDropTarget != null) {
                this.myDndManager.unregisterTarget(this.myDropTarget, (JComponent)((Object)this.myTree));
                this.myDropTarget = null;
            }
            if (this.myDragSource != null) {
                this.myDndManager.unregisterSource(this.myDragSource, (JComponent)((Object)this.myTree));
                this.myDragSource = null;
            }
            this.myDndManager = null;
        }
        this.setTreeBuilder(null);
        this.myTree = null;
        this.myTreeStructure = null;
    }

    @NotNull
    public abstract ActionCallback updateFromRoot(boolean var1);

    public void updateFrom(Object element, boolean forceResort, boolean updateStructure) {
        AsyncProjectViewSupport support;
        AbstractTreeBuilder builder2 = this.getTreeBuilder();
        if (builder2 != null) {
            builder2.queueUpdateFrom(element, forceResort, updateStructure);
        } else if (element instanceof PsiElement && (support = this.getAsyncSupport()) != null) {
            support.updateByElement((PsiElement)element, updateStructure);
        }
    }

    public abstract void select(Object var1, VirtualFile var2, boolean var3);

    public void selectModule(Module module, boolean requestFocus) {
        this.doSelectModuleOrGroup(module, requestFocus);
    }

    private void doSelectModuleOrGroup(Object toSelect2, boolean requestFocus) {
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)this.myProject);
        Runnable runnable2 = () -> {
            BaseProjectTreeBuilder builder2;
            ProjectView projectView;
            if (requestFocus && (projectView = ProjectView.getInstance(this.myProject)) != null) {
                projectView.changeView(this.getId(), this.getSubId());
            }
            if ((builder2 = (BaseProjectTreeBuilder)this.getTreeBuilder()) != null) {
                builder2.selectInWidth(toSelect2, requestFocus, (Condition<AbstractTreeNode>)((Condition)node -> node instanceof AbstractModuleNode || node instanceof ModuleGroupNode || node instanceof AbstractProjectNode));
            }
        };
        if (requestFocus) {
            windowManager.getToolWindow(ToolWindowId.PROJECT_VIEW).activate(runnable2);
        } else {
            runnable2.run();
        }
    }

    public void selectModuleGroup(ModuleGroup moduleGroup, boolean requestFocus) {
        this.doSelectModuleOrGroup(moduleGroup, requestFocus);
    }

    public TreePath[] getSelectionPaths() {
        return this.myTree == null ? null : this.myTree.getSelectionPaths();
    }

    public void addToolbarActions(DefaultActionGroup actionGroup) {
    }

    protected ToggleAction createFlattenModulesAction(BooleanSupplier isApplicable) {
        return new FlattenModulesToggleAction(this.myProject, () -> isApplicable.getAsBoolean() && ProjectView.getInstance(this.myProject).isShowModules(this.getId()), () -> ProjectView.getInstance(this.myProject).isFlattenModules(this.getId()), value -> ProjectView.getInstance(this.myProject).setFlattenModules((boolean)value, this.getId()));
    }

    @NotNull
    protected <T extends NodeDescriptor> List<T> getSelectedNodes(Class<T> nodeClass) {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(5);
            }
            return list2;
        }
        ArrayList<NodeDescriptor> result2 = new ArrayList<NodeDescriptor>();
        for (TreePath path : paths) {
            Object userObject = TreeUtil.getUserObject((Object)path.getLastPathComponent());
            if (userObject == null || !ReflectionUtil.isAssignable(nodeClass, userObject.getClass())) continue;
            result2.add((NodeDescriptor)userObject);
        }
        ArrayList<NodeDescriptor> arrayList = result2;
        if (arrayList == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public Object getData(String dataId) {
        Object data;
        Object object = data = this.myTreeStructure instanceof AbstractTreeStructureBase ? ((AbstractTreeStructureBase)this.myTreeStructure).getDataFromProviders(this.getSelectedNodes(AbstractTreeNode.class), dataId) : null;
        if (data != null) {
            return data;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            TreePath[] paths = this.getSelectionPaths();
            if (paths == null) {
                return null;
            }
            ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
            for (TreePath path : paths) {
                Object node = path.getLastPathComponent();
                Object userObject = TreeUtil.getUserObject((Object)node);
                if (userObject instanceof Navigatable) {
                    navigatables.add((Navigatable)userObject);
                    continue;
                }
                if (!(node instanceof Navigatable)) continue;
                navigatables.add((Navigatable)node);
            }
            if (navigatables.isEmpty()) {
                return null;
            }
            return navigatables.toArray(new Navigatable[0]);
        }
        return null;
    }

    public abstract int getWeight();

    public abstract SelectInTarget createSelectInTarget();

    public final TreePath getSelectedPath() {
        return this.myTree == null ? null : TreeUtil.getSelectedPathIfOne((JTree)((Object)this.myTree));
    }

    public final NodeDescriptor getSelectedDescriptor() {
        TreePath path = this.getSelectedPath();
        Object userObject = path == null ? null : TreeUtil.getUserObject((Object)path.getLastPathComponent());
        return userObject instanceof NodeDescriptor ? (NodeDescriptor)userObject : null;
    }

    @Deprecated
    public final DefaultMutableTreeNode getSelectedNode() {
        TreePath path = this.getSelectedPath();
        return path == null ? null : (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)path.getLastPathComponent(), DefaultMutableTreeNode.class);
    }

    public final Object getSelectedElement() {
        Object[] elements = this.getSelectedElements();
        return elements.length == 1 ? elements[0] : null;
    }

    @NotNull
    public final PsiElement[] getSelectedPSIElements() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(7);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (TreePath path : paths) {
            result2.addAll(this.getElementsFromNode(path.getLastPathComponent()));
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result2);
        if (psiElementArray == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(8);
        }
        return psiElementArray;
    }

    @NotNull
    public List<PsiElement> getElementsFromNode(@Nullable Object node) {
        Object value = this.getValueFromNode(node);
        JBIterable it = value instanceof PsiElement || value instanceof VirtualFile ? JBIterable.of((Object)value) : (value instanceof Object[] ? JBIterable.of((Object[])((Object[])value)) : (value instanceof Iterable ? JBIterable.from((Iterable)((Iterable)value)) : JBIterable.of((Object)TreeUtil.getUserObject((Object)node))));
        List list2 = it.flatten(o -> o instanceof RootsProvider ? ((RootsProvider)o).getRoots() : Collections.singleton(o)).map(o -> o instanceof VirtualFile ? PsiUtilCore.findFileSystemItem((Project)this.myProject, (VirtualFile)((VirtualFile)o)) : o).filter(PsiElement.class).filter(PsiElement::isValid).toList();
        if (list2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Deprecated
    @Nullable
    public PsiElement getPSIElementFromNode(@Nullable TreeNode node) {
        return (PsiElement)ContainerUtil.getFirstItem(this.getElementsFromNode(node));
    }

    @Nullable
    protected Module getNodeModule(@Nullable Object element) {
        if (element instanceof PsiElement) {
            PsiElement psiElement = (PsiElement)element;
            return ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        }
        return null;
    }

    @NotNull
    public final Object[] getSelectedElements() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(10);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<Object> list2 = new ArrayList<Object>(paths.length);
        for (TreePath path : paths) {
            Object lastPathComponent = path.getLastPathComponent();
            Object element = this.getValueFromNode(lastPathComponent);
            if (element instanceof Object[]) {
                Collections.addAll(list2, (Object[])element);
                continue;
            }
            if (element == null) continue;
            list2.add(element);
        }
        Object[] objectArray = ArrayUtil.toObjectArray(list2);
        if (objectArray == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(11);
        }
        return objectArray;
    }

    @Nullable
    public Object getValueFromNode(@Nullable Object node) {
        return AbstractProjectViewPane.extractValueFromNode(node);
    }

    @Deprecated
    protected Object exhumeElementFromNode(DefaultMutableTreeNode node) {
        return this.getValueFromNode(node);
    }

    @Nullable
    public static Object extractValueFromNode(@Nullable Object node) {
        Object userObject = TreeUtil.getUserObject((Object)node);
        Object element = null;
        if (userObject instanceof AbstractTreeNode) {
            AbstractTreeNode descriptor = (AbstractTreeNode)userObject;
            element = descriptor.getValue();
        } else if (userObject instanceof NodeDescriptor) {
            NodeDescriptor descriptor = (NodeDescriptor)userObject;
            element = descriptor.getElement();
            if (element instanceof AbstractTreeNode) {
                element = ((AbstractTreeNode)element).getValue();
            }
        } else if (userObject != null) {
            element = userObject;
        }
        return element;
    }

    public AbstractTreeBuilder getTreeBuilder() {
        return this.myTreeBuilder;
    }

    public AbstractTreeStructure getTreeStructure() {
        return this.myTreeStructure;
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(12);
        }
        List subPanes = element.getChildren(ELEMENT_SUBPANE);
        for (Element subPane : subPanes) {
            String subId = subPane.getAttributeValue(ATTRIBUTE_SUBID);
            TreeState treeState = TreeState.createFrom((Element)subPane);
            if (treeState.isEmpty()) continue;
            this.myReadTreeState.put(subId, treeState);
        }
    }

    public void writeExternal(Element element) {
        this.saveExpandedPaths();
        for (String subId : this.myReadTreeState.keySet()) {
            TreeState treeState = this.myReadTreeState.get(subId);
            Element subPane = new Element(ELEMENT_SUBPANE);
            if (subId != null) {
                subPane.setAttribute(ATTRIBUTE_SUBID, subId);
            }
            treeState.writeExternal(subPane);
            element.addContent(subPane);
        }
    }

    protected void saveExpandedPaths() {
        TreeState treeState;
        this.myTreeStateRestored.set(false);
        if (this.myTree != null && !(treeState = TreeState.createOn((JTree)((Object)this.myTree))).isEmpty()) {
            this.myReadTreeState.put(this.getSubId(), treeState);
        }
    }

    public final void restoreExpandedPaths() {
        if (this.myTreeStateRestored.getAndSet(true)) {
            return;
        }
        TreeState treeState = this.myReadTreeState.get(this.getSubId());
        if (treeState != null && !treeState.isEmpty()) {
            treeState.applyTo((JTree)((Object)this.myTree));
        }
    }

    protected Comparator<NodeDescriptor> createComparator() {
        return new GroupByTypeComparator(ProjectView.getInstance(this.myProject), this.getId());
    }

    public void installComparator() {
        this.installComparator(this.getTreeBuilder());
    }

    public void installComparator(AbstractTreeBuilder treeBuilder) {
        this.installComparator(treeBuilder, this.createComparator());
    }

    public void installComparator(Comparator<NodeDescriptor> comparator2) {
        this.installComparator(this.getTreeBuilder(), comparator2);
    }

    protected void installComparator(AbstractTreeBuilder builder2, Comparator<NodeDescriptor> comparator2) {
        if (builder2 != null) {
            builder2.setNodeDescriptorComparator(comparator2);
        }
    }

    public JTree getTree() {
        return this.myTree;
    }

    @NotNull
    public PsiDirectory[] getSelectedDirectories() {
        ArrayList directories = ContainerUtil.newArrayList();
        for (PsiDirectoryNode node : this.getSelectedNodes(PsiDirectoryNode.class)) {
            PsiDirectory directory = (PsiDirectory)node.getValue();
            if (directory == null) continue;
            directories.add(directory);
            Object parentValue = node.getParent().getValue();
            if (!(parentValue instanceof PsiDirectory) || !Registry.is((String)"projectView.choose.directory.on.compacted.middle.packages")) continue;
            while ((directory = directory.getParentDirectory()) != null && !directory.equals(parentValue)) {
                directories.add(directory);
            }
        }
        if (!directories.isEmpty()) {
            PsiDirectory[] psiDirectoryArray = directories.toArray(PsiDirectory.EMPTY_ARRAY);
            if (psiDirectoryArray == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(13);
            }
            return psiDirectoryArray;
        }
        PsiElement[] elements = this.getSelectedPSIElements();
        if (elements.length == 1) {
            PsiElement element = elements[0];
            if (element instanceof PsiDirectory) {
                PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{(PsiDirectory)element};
                if (psiDirectoryArray == null) {
                    AbstractProjectViewPane.$$$reportNull$$$0(14);
                }
                return psiDirectoryArray;
            }
            if (element instanceof PsiDirectoryContainer) {
                PsiDirectory[] psiDirectoryArray = ((PsiDirectoryContainer)element).getDirectories();
                if (psiDirectoryArray == null) {
                    AbstractProjectViewPane.$$$reportNull$$$0(15);
                }
                return psiDirectoryArray;
            }
            PsiFile containingFile = element.getContainingFile();
            if (containingFile != null) {
                PsiDirectory psiDirectory = containingFile.getContainingDirectory();
                if (psiDirectory != null) {
                    PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{psiDirectory};
                    if (psiDirectoryArray == null) {
                        AbstractProjectViewPane.$$$reportNull$$$0(16);
                    }
                    return psiDirectoryArray;
                }
                VirtualFile file2 = containingFile.getVirtualFile();
                if (file2 instanceof VirtualFileWindow) {
                    VirtualFile delegate = ((VirtualFileWindow)file2).getDelegate();
                    PsiFile delegatePsiFile = containingFile.getManager().findFile(delegate);
                    if (delegatePsiFile != null && delegatePsiFile.getContainingDirectory() != null) {
                        PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{delegatePsiFile.getContainingDirectory()};
                        if (psiDirectoryArray == null) {
                            AbstractProjectViewPane.$$$reportNull$$$0(17);
                        }
                        return psiDirectoryArray;
                    }
                }
                if (PsiDirectory.EMPTY_ARRAY == null) {
                    AbstractProjectViewPane.$$$reportNull$$$0(18);
                }
                return PsiDirectory.EMPTY_ARRAY;
            }
        } else {
            TreePath path = this.getSelectedPath();
            if (path != null) {
                Object component = path.getLastPathComponent();
                if (component instanceof DefaultMutableTreeNode) {
                    PsiDirectory[] psiDirectoryArray = this.getSelectedDirectoriesInAmbiguousCase((DefaultMutableTreeNode)component);
                    if (psiDirectoryArray == null) {
                        AbstractProjectViewPane.$$$reportNull$$$0(19);
                    }
                    return psiDirectoryArray;
                }
                PsiDirectory[] psiDirectoryArray = this.getSelectedDirectoriesInAmbiguousCase(component);
                if (psiDirectoryArray == null) {
                    AbstractProjectViewPane.$$$reportNull$$$0(20);
                }
                return psiDirectoryArray;
            }
        }
        if (PsiDirectory.EMPTY_ARRAY == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(21);
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    @Deprecated
    @NotNull
    protected PsiDirectory[] getSelectedDirectoriesInAmbiguousCase(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(22);
        }
        PsiDirectory[] psiDirectoryArray = this.getSelectedDirectoriesInAmbiguousCase(node.getUserObject());
        if (psiDirectoryArray == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(23);
        }
        return psiDirectoryArray;
    }

    @NotNull
    protected PsiDirectory[] getSelectedDirectoriesInAmbiguousCase(Object userObject) {
        PsiDirectory directory;
        VirtualFile file2;
        if (userObject instanceof AbstractModuleNode) {
            Module module = (Module)((AbstractModuleNode)((Object)userObject)).getValue();
            if (module != null) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                VirtualFile[] sourceRoots = moduleRootManager.getSourceRoots();
                ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>(sourceRoots.length);
                PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
                for (VirtualFile sourceRoot : sourceRoots) {
                    PsiDirectory directory2 = psiManager.findDirectory(sourceRoot);
                    if (directory2 == null) continue;
                    dirs.add(directory2);
                }
                PsiDirectory[] psiDirectoryArray = dirs.toArray(PsiDirectory.EMPTY_ARRAY);
                if (psiDirectoryArray == null) {
                    AbstractProjectViewPane.$$$reportNull$$$0(24);
                }
                return psiDirectoryArray;
            }
        } else if (userObject instanceof ProjectViewNode && (file2 = ((ProjectViewNode)userObject).getVirtualFile()) != null && file2.isValid() && file2.isDirectory() && (directory = PsiManager.getInstance((Project)this.myProject).findDirectory(file2)) != null) {
            PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{directory};
            if (psiDirectoryArray == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(25);
            }
            return psiDirectoryArray;
        }
        if (PsiDirectory.EMPTY_ARRAY == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(26);
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    @Nullable
    public static PsiElement[] getTransferedPsiElements(Transferable transferable) {
        try {
            Object transferData = transferable.getTransferData(DnDEventImpl.ourDataFlavor);
            if (transferData instanceof TransferableWrapper) {
                return ((TransferableWrapper)transferData).getPsiElements();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static TreeNode[] getTransferedTreeNodes(Transferable transferable) {
        try {
            Object transferData = transferable.getTransferData(DnDEventImpl.ourDataFlavor);
            if (transferData instanceof TransferableWrapper) {
                return ((TransferableWrapper)transferData).getTreeNodes();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void enableDnD() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myDropTarget = new ProjectViewDropTarget((JTree)((Object)this.myTree), this.myProject){

                @Override
                @Nullable
                protected PsiElement getPsiElement(@NotNull TreePath path) {
                    if (path == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return (PsiElement)ContainerUtil.getFirstItem(AbstractProjectViewPane.this.getElementsFromNode(path.getLastPathComponent()));
                }

                @Override
                @Nullable
                protected Module getModule(@NotNull PsiElement element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return AbstractProjectViewPane.this.getNodeModule(element);
                }

                @Override
                public void cleanUpOnLeave() {
                    AbstractProjectViewPane.this.beforeDnDLeave();
                    super.cleanUpOnLeave();
                }

                @Override
                public boolean update(DnDEvent event) {
                    AbstractProjectViewPane.this.beforeDnDUpdate();
                    return super.update(event);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "path";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/ide/projectView/impl/AbstractProjectViewPane$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getPsiElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getModule";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.myDragSource = new MyDragSource();
            this.myDndManager = DnDManager.getInstance();
            this.myDndManager.registerSource(this.myDragSource, (JComponent)((Object)this.myTree));
            this.myDndManager.registerTarget(this.myDropTarget, (JComponent)((Object)this.myTree));
        }
    }

    protected void beforeDnDUpdate() {
    }

    protected void beforeDnDLeave() {
    }

    public void setTreeBuilder(AbstractTreeBuilder treeBuilder) {
        if (treeBuilder != null) {
            Disposer.register((Disposable)this, (Disposable)treeBuilder);
        }
        this.myTreeBuilder = treeBuilder;
    }

    public boolean supportsFoldersAlwaysOnTop() {
        return true;
    }

    public boolean supportsSortByType() {
        return true;
    }

    private static boolean canDragElements(Object[] elements, DataContext dataContext, int dragAction) {
        for (Object element : elements) {
            if (!(element instanceof Module)) continue;
            return true;
        }
        return dragAction == 2 && MoveHandler.canMove(dataContext);
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(27);
        }
        if (this.myTreeBuilder == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(28);
            }
            return actionCallback;
        }
        if (this.myTreeBuilder.isDisposed()) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(29);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = this.myTreeBuilder.getUi().getReady(requestor);
        if (actionCallback == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(30);
        }
        return actionCallback;
    }

    @Deprecated
    public Promise<TreePath> promisePathToElement(Object element) {
        AbstractTreeBuilder builder2 = this.getTreeBuilder();
        if (builder2 != null) {
            DefaultMutableTreeNode node = builder2.getNodeForElement(element);
            if (node == null) {
                return Promises.rejectedPromise();
            }
            return Promises.resolvedPromise((Object)new TreePath(node.getPath()));
        }
        TreeVisitor visitor = AbstractProjectViewPane.createVisitor(element);
        if (visitor == null || this.myTree == null) {
            return Promises.rejectedPromise();
        }
        return TreeUtil.promiseVisit((JTree)((Object)this.myTree), (TreeVisitor)visitor);
    }

    AsyncProjectViewSupport getAsyncSupport() {
        return null;
    }

    @NotNull
    static List<TreeVisitor> createVisitors(Object ... objects) {
        List list2 = StreamEx.of((Object[])objects).map(AbstractProjectViewPane::createVisitor).nonNull().toImmutableList();
        if (list2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(31);
        }
        return list2;
    }

    @Nullable
    public static TreeVisitor createVisitor(Object object) {
        Object node;
        if (object instanceof AbstractTreeNode) {
            node = (AbstractTreeNode)object;
            object = node.getValue();
        }
        if (object instanceof ProjectFileNode) {
            node = (ProjectFileNode)object;
            object = node.getVirtualFile();
        }
        if (object instanceof VirtualFile) {
            return AbstractProjectViewPane.createVisitor((VirtualFile)object);
        }
        if (object instanceof PsiElement) {
            return AbstractProjectViewPane.createVisitor((PsiElement)object);
        }
        if (object != null) {
            LOG.warn("unsupported object: " + object);
        }
        return null;
    }

    @Nullable
    public static TreeVisitor createVisitor(VirtualFile file2) {
        return AbstractProjectViewPane.createVisitor(null, file2);
    }

    @Nullable
    public static TreeVisitor createVisitor(PsiElement element) {
        return AbstractProjectViewPane.createVisitor(element, null);
    }

    @Nullable
    public static TreeVisitor createVisitor(PsiElement element, VirtualFile file2) {
        return AbstractProjectViewPane.createVisitor(element, file2, null);
    }

    @Nullable
    static TreeVisitor createVisitor(PsiElement element, VirtualFile file2, Predicate<TreePath> predicate) {
        if (element != null && element.isValid()) {
            return new ProjectViewNodeVisitor(element, file2, predicate);
        }
        if (file2 != null) {
            return new ProjectViewFileVisitor(file2, predicate);
        }
        LOG.warn(element != null ? "element invalidated: " + element : "cannot create visitor without element and/or file");
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/AbstractProjectViewPane";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_SUBID;
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/AbstractProjectViewPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubIds";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPSIElements";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsFromNode";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDirectories";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDirectoriesInAmbiguousCase";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getReady";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setTreeChangeListener";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableSubIdName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableSubIdIcon";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedDirectoriesInAmbiguousCase";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getReady";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDragSource
    implements DnDSource {
        private MyDragSource() {
        }

        public boolean canStartDragging(DnDAction action, Point dragOrigin) {
            if ((action.getActionId() & 3) == 0) {
                return false;
            }
            Object[] elements = AbstractProjectViewPane.this.getSelectedElements();
            PsiElement[] psiElements = AbstractProjectViewPane.this.getSelectedPSIElements();
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)AbstractProjectViewPane.this.myTree));
            return psiElements.length > 0 || AbstractProjectViewPane.canDragElements(elements, dataContext, action.getActionId());
        }

        public DnDDragStartBean startDragging(DnDAction action, Point dragOrigin) {
            final PsiElement[] psiElements = AbstractProjectViewPane.this.getSelectedPSIElements();
            final TreePath[] paths = AbstractProjectViewPane.this.getSelectionPaths();
            return new DnDDragStartBean((Object)new TransferableWrapper(){

                @Override
                public List<File> asFileList() {
                    return PsiCopyPasteManager.asFileList(psiElements);
                }

                @Override
                @Nullable
                public TreePath[] getTreePaths() {
                    return paths;
                }

                @Override
                public TreeNode[] getTreeNodes() {
                    return TreePathUtil.toTreeNodes(this.getTreePaths());
                }

                @Override
                public PsiElement[] getPsiElements() {
                    return psiElements;
                }
            });
        }

        public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin) {
            TreePath[] paths = AbstractProjectViewPane.this.getSelectionPaths();
            if (paths == null) {
                return null;
            }
            int count = paths.length;
            JLabel label2 = new JLabel(String.format("%s item%s", count, count == 1 ? "" : "s"));
            label2.setOpaque(true);
            label2.setForeground(AbstractProjectViewPane.this.myTree.getForeground());
            label2.setBackground(AbstractProjectViewPane.this.myTree.getBackground());
            label2.setFont(AbstractProjectViewPane.this.myTree.getFont());
            label2.setSize(label2.getPreferredSize());
            BufferedImage image = UIUtil.createImage((int)label2.getWidth(), (int)label2.getHeight(), (int)2);
            Graphics2D g2 = (Graphics2D)image.getGraphics();
            g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
            label2.paint(g2);
            g2.dispose();
            return new Pair((Object)image, (Object)new Point(-image.getWidth(null), -image.getHeight(null)));
        }

        public void dragDropEnd() {
        }

        public void dropActionChanged(int gestureModifiers) {
        }
    }
}

