/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.SelectInEditorManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectInEditorManagerImpl
extends SelectInEditorManager
implements Disposable,
FocusListener,
CaretListener {
    private final Project myProject;
    private RangeHighlighter mySegmentHighlighter;
    private Editor myEditor;

    public SelectInEditorManagerImpl(Project project) {
        this.myProject = project;
    }

    public void dispose() {
        this.releaseAll();
    }

    public void selectInEditor(VirtualFile file2, int startOffset, int endOffset, boolean toSelectLine, boolean toUseNormalSelection) {
        ProperTextRange textRange;
        this.releaseAll();
        if (file2 instanceof VirtualFileWindow) {
            DocumentWindow documentWindow = ((VirtualFileWindow)file2).getDocumentWindow();
            textRange = documentWindow.injectedToHost(new TextRange(startOffset, endOffset));
            file2 = ((VirtualFileWindow)file2).getDelegate();
        } else {
            textRange = new ProperTextRange(startOffset, endOffset);
        }
        this.openEditor(file2, endOffset);
        Editor editor = this.openEditor(file2, textRange.getStartOffset());
        SwingUtilities.invokeLater(() -> this.lambda$selectInEditor$0(editor, toUseNormalSelection, toSelectLine, (TextRange)textRange));
    }

    private void doSelect(boolean toUseNormalSelection, @NotNull Editor editor, boolean toSelectLine, TextRange textRange) {
        if (editor == null) {
            SelectInEditorManagerImpl.$$$reportNull$$$0(0);
        }
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        if (toUseNormalSelection) {
            DocumentEx doc = (DocumentEx)editor.getDocument();
            if (toSelectLine) {
                int lineNumber = doc.getLineNumber(startOffset);
                if (lineNumber >= 0 && lineNumber < doc.getLineCount()) {
                    editor.getSelectionModel().setSelection(doc.getLineStartOffset(lineNumber), doc.getLineEndOffset(lineNumber) + doc.getLineSeparatorLength(lineNumber));
                }
            } else {
                editor.getSelectionModel().setSelection(startOffset, endOffset);
            }
            return;
        }
        TextAttributes selectionAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        this.releaseAll();
        if (toSelectLine) {
            DocumentEx doc = (DocumentEx)editor.getDocument();
            int lineNumber = doc.getLineNumber(startOffset);
            if (lineNumber >= 0 && lineNumber < doc.getLineCount()) {
                this.mySegmentHighlighter = editor.getMarkupModel().addRangeHighlighter(doc.getLineStartOffset(lineNumber), doc.getLineEndOffset(lineNumber) + doc.getLineSeparatorLength(lineNumber), 6001, selectionAttributes, HighlighterTargetArea.EXACT_RANGE);
            }
        } else {
            this.mySegmentHighlighter = editor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 6001, selectionAttributes, HighlighterTargetArea.EXACT_RANGE);
        }
        this.myEditor = editor;
        this.myEditor.getContentComponent().addFocusListener(this);
        this.myEditor.getCaretModel().addCaretListener((CaretListener)this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.releaseAll();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void caretPositionChanged(CaretEvent e) {
        this.releaseAll();
    }

    private void releaseAll() {
        if (this.mySegmentHighlighter != null && this.myEditor != null) {
            this.mySegmentHighlighter.dispose();
            this.myEditor.getContentComponent().removeFocusListener(this);
            this.myEditor.getCaretModel().removeCaretListener((CaretListener)this);
            this.mySegmentHighlighter = null;
            this.myEditor = null;
        }
    }

    @Nullable
    private Editor openEditor(VirtualFile file2, int textOffset) {
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, file2, textOffset);
        return FileEditorManager.getInstance((Project)this.myProject).openTextEditor(descriptor, false);
    }

    private /* synthetic */ void lambda$selectInEditor$0(Editor editor, boolean toUseNormalSelection, boolean toSelectLine, TextRange textRange) {
        if (editor != null && !editor.isDisposed()) {
            this.doSelect(toUseNormalSelection, editor, toSelectLine, textRange);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ide/impl/SelectInEditorManagerImpl", "doSelect"));
    }
}

