/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public class PatchProjectUtil {
    private PatchProjectUtil() {
    }

    public static void patchProject(Project project) {
        Map<Pattern, Set<Pattern>> excludePatterns = PatchProjectUtil.loadPatterns("idea.exclude.patterns");
        Map<Pattern, Set<Pattern>> includePatterns = PatchProjectUtil.loadPatterns("idea.include.patterns");
        if (excludePatterns.isEmpty() && includePatterns.isEmpty()) {
            return;
        }
        ModifiableModuleModel modulesModel = ModuleManager.getInstance((Project)project).getModifiableModel();
        Module[] modules = modulesModel.getModules();
        ModifiableRootModel[] models = new ModifiableRootModel[modules.length];
        for (int i = 0; i < modules.length; ++i) {
            ContentEntry[] contentEntries;
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)modules[i]);
            models[i] = rootManager.getModifiableModel();
            int idx = i;
            ModuleFileIndex fileIndex = rootManager.getFileIndex();
            for (ContentEntry contentEntry : contentEntries = models[i].getContentEntries()) {
                VirtualFile contentRoot = contentEntry.getFile();
                if (contentRoot == null) continue;
                HashSet<VirtualFile> included = new HashSet<VirtualFile>();
                fileIndex.iterateContentUnderDirectory(contentRoot, fileOrDir -> {
                    Set dirPatterns;
                    String relativeName = VfsUtilCore.getRelativePath((VirtualFile)fileOrDir, (VirtualFile)contentRoot, (char)'/');
                    for (Pattern module : excludePatterns.keySet()) {
                        if (module != null && !module.matcher(modules[idx].getName()).matches()) continue;
                        dirPatterns = (Set)excludePatterns.get(module);
                        for (Pattern pattern : dirPatterns) {
                            if (!pattern.matcher(relativeName).matches()) continue;
                            contentEntry.addExcludeFolder(fileOrDir.isDirectory() ? fileOrDir : fileOrDir.getParent());
                            return true;
                        }
                    }
                    if (includePatterns.isEmpty()) {
                        return true;
                    }
                    for (Pattern module : includePatterns.keySet()) {
                        if (module != null && !module.matcher(modules[idx].getName()).matches()) continue;
                        dirPatterns = (Set)includePatterns.get(module);
                        for (Pattern pattern : dirPatterns) {
                            if (!pattern.matcher(relativeName).matches()) continue;
                            included.add(fileOrDir);
                            return true;
                        }
                    }
                    return true;
                });
                PatchProjectUtil.processIncluded(contentEntry, included);
            }
        }
        ApplicationManager.getApplication().runWriteAction(() -> ModifiableModelCommitter.multiCommit(models, modulesModel));
    }

    public static void processIncluded(ContentEntry contentEntry, Set<VirtualFile> included) {
        if (included.isEmpty()) {
            return;
        }
        HashSet<VirtualFile> parents = new HashSet<VirtualFile>();
        for (VirtualFile file2 : included) {
            if (Comparing.equal((Object)file2, (Object)contentEntry.getFile())) {
                return;
            }
            VirtualFile parent = file2.getParent();
            if (parent == null || parents.contains(parent)) continue;
            parents.add(parent);
            for (VirtualFile toExclude : parent.getChildren()) {
                boolean toExcludeSibling = true;
                for (VirtualFile includeRoot : included) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)toExclude, (VirtualFile)includeRoot, (boolean)false)) continue;
                    toExcludeSibling = false;
                }
                if (!toExcludeSibling) continue;
                contentEntry.addExcludeFolder(toExclude.isDirectory() ? toExclude : toExclude.getParent());
            }
        }
        PatchProjectUtil.processIncluded(contentEntry, parents);
    }

    public static Map<Pattern, Set<Pattern>> loadPatterns(@NonNls String propertyKey) {
        HashMap<Pattern, Set<Pattern>> result2 = new HashMap<Pattern, Set<Pattern>>();
        String patterns = System.getProperty(propertyKey);
        if (patterns != null) {
            String[] pathPatterns;
            for (String excludedPattern : pathPatterns = patterns.split(";")) {
                String module = null;
                int idx = 0;
                if (excludedPattern.startsWith("[")) {
                    idx = excludedPattern.indexOf("]") + 1;
                    module = excludedPattern.substring(1, idx - 1);
                }
                Pattern modulePattern = module != null ? Pattern.compile(StringUtil.replace(module, (String)"*", (String)".*")) : null;
                Pattern pattern = Pattern.compile(FileUtil.convertAntToRegexp((String)excludedPattern.substring(idx)));
                HashSet<Pattern> dirPatterns = (HashSet<Pattern>)result2.get(modulePattern);
                if (dirPatterns == null) {
                    dirPatterns = new HashSet<Pattern>();
                    result2.put(modulePattern, dirPatterns);
                }
                dirPatterns.add(pattern);
            }
        }
        return result2;
    }
}

