/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserService;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserActionKt;
import com.intellij.ide.browsers.impl.WebBrowserServiceImpl;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.util.BitUtil;
import com.intellij.util.Url;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.function.Consumer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B%\b\u0014\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u000eH$J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/browsers/actions/BaseOpenInBrowserAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "(Lcom/intellij/ide/browsers/WebBrowser;)V", "text", "", "description", "icon", "Ljavax/swing/Icon;", "(Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getBrowser", "event", "update", "Companion", "intellij.xml.impl"})
public abstract class BaseOpenInBrowserAction
extends DumbAwareAction {
    public static final Companion Companion = new Companion(null);

    @Nullable
    protected abstract WebBrowser getBrowser(@NotNull AnActionEvent var1);

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        WebBrowser browser = this.getBrowser(e);
        if (browser == null) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        OpenInBrowserRequest openInBrowserRequest = Companion.doUpdate(e);
        if (openInBrowserRequest == null) {
            return;
        }
        OpenInBrowserRequest result2 = openInBrowserRequest;
        Presentation presentation = this.getTemplatePresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"templatePresentation");
        String description = presentation.getText();
        if (Intrinsics.areEqual((Object)"ContextToolbar", (Object)e.getPlace())) {
            boolean exists;
            Shortcut[] shortcuts;
            Shortcut[] shortcutArray;
            StringBuilder builder2 = new StringBuilder(description);
            builder2.append(" (");
            KeymapManager keymapManager2 = KeymapManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)keymapManager2, (String)"KeymapManager.getInstance()");
            Shortcut[] shortcutArray2 = keymapManager2.getActiveKeymap().getShortcuts("WebOpenInAction");
            Intrinsics.checkExpressionValueIsNotNull((Object)shortcutArray2, (String)"KeymapManager.getInstanc\u2026rtcuts(\"WebOpenInAction\")");
            Shortcut[] shortcutArray3 = shortcutArray = (shortcuts = shortcutArray2);
            boolean bl = exists = !(shortcutArray3.length == 0);
            if (exists) {
                builder2.append(KeymapUtil.getShortcutText((Shortcut)shortcuts[0]));
            }
            if (HtmlUtil.isHtmlFile((PsiElement)result2.getFile())) {
                builder2.append(exists ? ", " : "").append("hold Shift to open URL of local file");
            }
            builder2.append(')');
            description = builder2.toString();
        }
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
        presentation2.setText(description);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block0: {
            WebBrowser webBrowser;
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            WebBrowser webBrowser2 = this.getBrowser(e);
            if (webBrowser2 == null) break block0;
            WebBrowser it = webBrowser = webBrowser2;
            UsageTrigger.trigger("OpenInBrowser." + it.getName());
            Companion.open(e, it);
        }
    }

    protected BaseOpenInBrowserAction(@NotNull WebBrowser browser) {
        Intrinsics.checkParameterIsNotNull((Object)browser, (String)"browser");
        super(browser.getName(), null, browser.getIcon());
    }

    protected BaseOpenInBrowserAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    @JvmStatic
    @Nullable
    public static final OpenInBrowserRequest doUpdate(@NotNull AnActionEvent event) {
        return Companion.doUpdate(event);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\"\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/browsers/actions/BaseOpenInBrowserAction$Companion;", "", "()V", "doUpdate", "Lcom/intellij/ide/browsers/OpenInBrowserRequest;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "open", "", "request", "preferLocalUrl", "", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "intellij.xml.impl"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final OpenInBrowserRequest doUpdate(@NotNull AnActionEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            DataContext dataContext = event.getDataContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"event.dataContext");
            OpenInBrowserRequest request = BaseOpenInBrowserActionKt.access$createRequest(dataContext);
            boolean applicable = request != null && WebBrowserServiceImpl.Companion.getProvider(request) != null;
            Presentation presentation = event.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"event.presentation");
            presentation.setEnabledAndVisible(applicable);
            return applicable ? request : null;
        }

        public final void open(@NotNull AnActionEvent event, @Nullable WebBrowser browser) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            DataContext dataContext = event.getDataContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"event.dataContext");
            this.open(BaseOpenInBrowserActionKt.access$createRequest(dataContext), BitUtil.isSet((int)event.getModifiers(), (int)1), browser);
        }

        public final void open(@Nullable OpenInBrowserRequest request, boolean preferLocalUrl, @Nullable WebBrowser browser) {
            if (request == null) {
                return;
            }
            try {
                Collection collection = WebBrowserService.getInstance().getUrlsToOpen(request, preferLocalUrl);
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"WebBrowserService.getIns\u2026(request, preferLocalUrl)");
                Collection urls = collection;
                if (!urls.isEmpty()) {
                    BaseOpenInBrowserActionKt.access$chooseUrl(urls).onSuccess((Consumer)new Consumer<Url>(browser, request){
                        final /* synthetic */ WebBrowser $browser;
                        final /* synthetic */ OpenInBrowserRequest $request;

                        public final void accept(Url url) {
                            ApplicationManager.getApplication().saveAll();
                            BrowserLauncher browserLauncher = BrowserLauncher.Companion.getInstance();
                            String string = url.toExternalForm();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toExternalForm()");
                            browserLauncher.browse(string, this.$browser, this.$request.getProject());
                        }
                        {
                            this.$browser = webBrowser;
                            this.$request = openInBrowserRequest;
                        }
                    });
                }
            }
            catch (WebBrowserUrlProvider.BrowserException e) {
                Messages.showErrorDialog((String)e.getMessage(), (String)IdeBundle.message((String)"browser.error", (Object[])new Object[0]));
            }
            catch (Exception e) {
                BaseOpenInBrowserActionKt.access$getLOG$p().error((Throwable)e);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

