/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.SearchEverywhereClassifier;
import com.intellij.ide.actions.searcheverywhere.ContributorSearchResult;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.gotoByName.QuickSearchComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.TextIcon;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Alarm;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchEverywhereUI
extends BorderLayoutPanel
implements Disposable,
DataProvider,
QuickSearchComponent {
    private static final Logger LOG = Logger.getInstance(SearchEverywhereUI.class);
    public static final int SINGLE_CONTRIBUTOR_ELEMENTS_LIMIT = 30;
    public static final int MULTIPLE_CONTRIBUTORS_ELEMENTS_LIMIT = 15;
    private final List<SearchEverywhereContributor> myServiceContributors;
    private final List<SearchEverywhereContributor> myShownContributors;
    private final Map<String, SearchEverywhereContributorFilter<?>> myContributorFilters;
    private final Project myProject;
    private SETab mySelectedTab;
    private final JTextField mySearchField;
    private final JPanel suggestionsPanel;
    private final JCheckBox myNonProjectCB;
    private final List<SETab> myTabs = new ArrayList<SETab>();
    private boolean nonProjectCheckBoxAutoSet = true;
    private String notFoundString;
    private final JBList<Object> myResultsList = new JBList();
    private final SearchListModel myListModel = new SearchListModel();
    private JBPopup myHint;
    private CalcThread myCalcThread;
    private volatile ActionCallback myCurrentWorker = ActionCallback.DONE;
    private int myCalcThreadRestartRequestId = 0;
    private final Object myWorkerRestartRequestLock = new Object();
    private final Alarm listOperationsAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)ApplicationManager.getApplication());
    private final Alarm emptyListAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)ApplicationManager.getApplication());
    private Runnable searchFinishedHandler = () -> {};
    private final List<ViewTypeListener> myViewTypeListeners = new ArrayList<ViewTypeListener>();
    private ViewType myViewType = ViewType.SHORT;
    private final MoreRenderer moreRenderer = new MoreRenderer();
    private final GroupTitleRenderer groupTitleRenderer = new GroupTitleRenderer();

    public SearchEverywhereUI(Project project, List<SearchEverywhereContributor> serviceContributors, List<SearchEverywhereContributor> contributors, Map<String, SearchEverywhereContributorFilter<?>> filters) {
        this.withBackground(JBUI.CurrentTheme.SearchEverywhere.dialogBackground());
        this.myProject = project;
        this.myServiceContributors = serviceContributors;
        this.myShownContributors = contributors;
        this.myContributorFilters = filters;
        this.myNonProjectCB = new JBCheckBox();
        this.myNonProjectCB.setOpaque(false);
        this.myNonProjectCB.setFocusable(false);
        JPanel contributorsPanel = this.createTabPanel(contributors);
        JPanel settingsPanel = this.createSettingsPanel();
        this.mySearchField = this.createSearchField();
        this.suggestionsPanel = this.createSuggestionsPanel();
        this.myResultsList.setModel((ListModel)this.myListModel);
        this.myResultsList.setFocusable(false);
        this.myResultsList.setCellRenderer((ListCellRenderer)new CompositeCellRenderer());
        this.myResultsList.setSelectionMode(2);
        this.myResultsList.addListSelectionListener(e -> {
            boolean multiselectAllowed;
            int[] selectedIndices = this.myResultsList.getSelectedIndices();
            if (selectedIndices.length > 1 && !(multiselectAllowed = Arrays.stream(selectedIndices).allMatch(i -> this.myListModel.getContributorForIndex(i).isMultiselectSupported()))) {
                int index = this.myResultsList.getLeadSelectionIndex();
                this.myResultsList.setSelectedIndex(index);
            }
        });
        ScrollingUtil.installActions(this.myResultsList, (JComponent)this.getSearchField());
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setOpaque(false);
        topPanel.add((Component)contributorsPanel, "West");
        topPanel.add((Component)settingsPanel, "East");
        topPanel.add((Component)this.mySearchField, "South");
        WindowMoveListener moveListener = new WindowMoveListener((Component)((Object)this));
        topPanel.addMouseListener(moveListener);
        topPanel.addMouseMotionListener(moveListener);
        this.addToTop(topPanel);
        this.addToCenter(this.suggestionsPanel);
        this.initSearchActions();
    }

    public Dimension getMinimumSize() {
        return this.calcPrefSize(ViewType.SHORT);
    }

    public Dimension getPreferredSize() {
        return this.calcPrefSize(this.myViewType);
    }

    private Dimension calcPrefSize(ViewType viewType) {
        Dimension size = super.getPreferredSize();
        if (viewType == ViewType.SHORT) {
            size.height -= this.suggestionsPanel.getPreferredSize().height;
        }
        return size;
    }

    private JPanel createSuggestionsPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.setOpaque(false);
        pnl.setBorder(JBUI.Borders.customLine((Color)JBUI.CurrentTheme.SearchEverywhere.searchFieldBorderColor(), (int)1, (int)0, (int)0, (int)0));
        JBScrollPane resultsScroll = new JBScrollPane(this.myResultsList);
        resultsScroll.setBorder(null);
        resultsScroll.setHorizontalScrollBarPolicy(31);
        resultsScroll.setPreferredSize((Dimension)JBUI.size((int)670, (int)JBUI.CurrentTheme.SearchEverywhere.maxListHeight()));
        pnl.add((Component)resultsScroll, "Center");
        String hint = IdeBundle.message((String)"searcheverywhere.history.shortcuts.hint", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)SearchTextField.ALT_SHOW_HISTORY_KEYSTROKE), KeymapUtil.getKeystrokeText((KeyStroke)SearchTextField.SHOW_HISTORY_KEYSTROKE)});
        JLabel hintLabel = HintUtil.createAdComponent(hint, (Border)JBUI.Borders.emptyLeft((int)8), 2);
        hintLabel.setOpaque(false);
        hintLabel.setForeground((Color)JBColor.GRAY);
        Dimension size = hintLabel.getPreferredSize();
        size.height = JBUI.scale((int)17);
        hintLabel.setPreferredSize(size);
        pnl.add((Component)hintLabel, "South");
        return pnl;
    }

    private void updateViewType(ViewType viewType) {
        if (this.myViewType != viewType) {
            this.myViewType = viewType;
            this.myViewTypeListeners.forEach(listener2 -> listener2.suggestionsShown(viewType));
        }
    }

    public JTextField getSearchField() {
        return this.mySearchField;
    }

    public void setUseNonProjectItems(boolean use) {
        this.doSetUseNonProjectItems(use, false);
    }

    private void doSetUseNonProjectItems(boolean use, boolean isAutoSet) {
        this.myNonProjectCB.setSelected(use);
        this.nonProjectCheckBoxAutoSet = isAutoSet;
    }

    public boolean isUseNonProjectItems() {
        return this.myNonProjectCB.isSelected();
    }

    public void switchToContributor(String contributorID) {
        SETab selectedTab = this.myTabs.stream().filter(tab -> tab.getID().equals(contributorID)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Contributor %s is not supported", contributorID)));
        this.switchToTab(selectedTab);
    }

    private void switchToNextTab() {
        int currentIndex = this.myTabs.indexOf(this.mySelectedTab);
        SETab nextTab = currentIndex == this.myTabs.size() - 1 ? this.myTabs.get(0) : this.myTabs.get(currentIndex + 1);
        this.switchToTab(nextTab);
    }

    private void switchToPrevTab() {
        int currentIndex = this.myTabs.indexOf(this.mySelectedTab);
        SETab prevTab = currentIndex == 0 ? this.myTabs.get(this.myTabs.size() - 1) : this.myTabs.get(currentIndex - 1);
        this.switchToTab(prevTab);
    }

    private void switchToTab(SETab tab) {
        this.mySelectedTab = tab;
        String checkBoxText = tab.getContributor().map(SearchEverywhereContributor::includeNonProjectItemsText).orElse(IdeBundle.message((String)"checkbox.include.non.project.items", (Object[])new Object[]{IdeUICustomization.getInstance().getProjectConceptName()}));
        if (checkBoxText.indexOf(27) != -1) {
            DialogUtil.setTextWithMnemonic((AbstractButton)this.myNonProjectCB, (String)checkBoxText);
        } else {
            this.myNonProjectCB.setText(checkBoxText);
            this.myNonProjectCB.setDisplayedMnemonicIndex(-1);
            this.myNonProjectCB.setMnemonic(0);
        }
        if (this.nonProjectCheckBoxAutoSet && this.isUseNonProjectItems()) {
            this.doSetUseNonProjectItems(false, true);
        }
        this.myResultsList.getEmptyText().setText(this.getEmptyText());
        this.repaint();
        this.rebuildList();
    }

    public void setSearchFinishedHandler(@NotNull Runnable searchFinishedHandler) {
        if (searchFinishedHandler == null) {
            SearchEverywhereUI.$$$reportNull$$$0(0);
        }
        this.searchFinishedHandler = searchFinishedHandler;
    }

    public String getSelectedContributorID() {
        return this.mySelectedTab.getID();
    }

    public void dispose() {
        this.stopSearching();
    }

    @Nullable
    public Object getData(String dataId) {
        IntStream indicesStream = Arrays.stream(this.myResultsList.getSelectedIndices()).filter(i -> !this.myListModel.isMoreElement(i));
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            List elements = indicesStream.mapToObj(i -> {
                SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(i);
                Object item = this.myListModel.getElementAt(i);
                Object psi = contributor.getDataForItem(item, CommonDataKeys.PSI_ELEMENT.getName());
                return (PsiElement)psi;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            return PsiUtilCore.toPsiElementArray(elements);
        }
        return indicesStream.mapToObj(i -> {
            SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(i);
            Object item = this.myListModel.getElementAt(i);
            return contributor.getDataForItem(item, dataId);
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public void registerHint(JBPopup h) {
        if (this.myHint != null && this.myHint.isVisible() && this.myHint != h) {
            this.myHint.cancel();
        }
        this.myHint = h;
    }

    public void unregisterHint() {
        this.registerHint(null);
    }

    public Component asComponent() {
        return this;
    }

    private void hideHint() {
        if (this.myHint != null && this.myHint.isVisible()) {
            this.myHint.cancel();
        }
    }

    private void updateHint(Object element) {
        if (this.myHint == null || !this.myHint.isVisible()) {
            return;
        }
        PopupUpdateProcessor updateProcessor = (PopupUpdateProcessor)((Object)this.myHint.getUserData(PopupUpdateProcessor.class));
        if (updateProcessor != null) {
            updateProcessor.updatePopup(element);
        }
    }

    private boolean isAllTabSelected() {
        return "SearchEverywhereContributor.All".equals(this.getSelectedContributorID());
    }

    private JTextField createSearchField() {
        ExtendableTextField searchField = new ExtendableTextField(){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.height = JBUI.scale((int)29);
                return size;
            }
        };
        ExtendableTextComponent.Extension searchExtension = new ExtendableTextComponent.Extension(){

            public Icon getIcon(boolean hovered) {
                return AllIcons.Actions.Find;
            }

            public boolean isIconBeforeText() {
                return true;
            }

            public int getIconGap() {
                return JBUI.scale((int)10);
            }
        };
        ExtendableTextComponent.Extension hintExtension = new ExtendableTextComponent.Extension(){
            private final TextIcon icon = new TextIcon(IdeBundle.message((String)"searcheverywhere.switch.scope.hint", (Object[])new Object[0]), (Color)JBColor.GRAY, null, 0);
            {
                this.icon.setFont(RelativeFont.SMALL.derive(SearchEverywhereUI.this.getFont()));
            }

            public Icon getIcon(boolean hovered) {
                return this.icon;
            }
        };
        searchField.setExtensions(new ExtendableTextComponent.Extension[]{searchExtension, hintExtension});
        Insets insets = JBUI.CurrentTheme.SearchEverywhere.searchFieldInsets();
        JBEmptyBorder empty = JBUI.Borders.empty((int)insets.top, (int)insets.left, (int)insets.bottom, (int)insets.right);
        Border topLine = JBUI.Borders.customLine((Color)JBUI.CurrentTheme.SearchEverywhere.searchFieldBorderColor(), (int)1, (int)0, (int)0, (int)0);
        searchField.setBorder(JBUI.Borders.merge((Border)empty, (Border)topLine, (boolean)true));
        searchField.setBackground(JBUI.CurrentTheme.SearchEverywhere.searchFieldBackground());
        searchField.setFocusTraversalKeysEnabled(false);
        return searchField;
    }

    private JPanel createSettingsPanel() {
        JPanel res = new JPanel();
        BoxLayout bl = new BoxLayout(res, 0);
        res.setLayout(bl);
        res.setOpaque(false);
        res.add(this.myNonProjectCB);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addAction((AnAction)new ShowInFindToolWindowAction());
        actionGroup.addAction((AnAction)new ShowFilterAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("search.everywhere.toolbar", (ActionGroup)actionGroup, true);
        toolbar.setLayoutPolicy(0);
        toolbar.updateActionsImmediately();
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setOpaque(false);
        toolbarComponent.setBorder((Border)JBUI.Borders.empty((int)2, (int)18, (int)2, (int)9));
        res.add(toolbarComponent);
        return res;
    }

    @NotNull
    private JPanel createTabPanel(List<SearchEverywhereContributor> contributors) {
        JPanel contributorsPanel = new JPanel(new FlowLayout(0, 0, 0));
        contributorsPanel.setOpaque(false);
        SETab allTab = new SETab(null);
        contributorsPanel.add(allTab);
        this.myTabs.add(allTab);
        contributors.stream().filter(SearchEverywhereContributor::isShownInSeparateTab).forEach(contributor -> {
            SETab tab = new SETab((SearchEverywhereContributor)contributor);
            contributorsPanel.add(tab);
            this.myTabs.add(tab);
        });
        this.switchToTab(allTab);
        JPanel jPanel = contributorsPanel;
        if (jPanel == null) {
            SearchEverywhereUI.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildList() {
        String pattern;
        assert (EventQueue.isDispatchThread()) : "Must be EDT";
        if (this.myCalcThread != null && !this.myCurrentWorker.isProcessed()) {
            this.myCurrentWorker = this.myCalcThread.cancel();
        }
        if (this.myCalcThread != null && !this.myCalcThread.isCanceled()) {
            this.myCalcThread.cancel();
        }
        this.updateViewType((pattern = this.getSearchPattern()).isEmpty() ? ViewType.SHORT : ViewType.FULL);
        String matcherString = this.mySelectedTab.getContributor().map(contributor -> contributor.filterControlSymbols(pattern)).orElse(pattern);
        MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + matcherString), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
        MatcherHolder.associateMatcher(this.myResultsList, (Matcher)matcher);
        Object object = this.myWorkerRestartRequestLock;
        synchronized (object) {
            int currentRestartRequest = ++this.myCalcThreadRestartRequestId;
            this.myCurrentWorker.doWhenProcessed(() -> {
                Object object = this.myWorkerRestartRequestLock;
                synchronized (object) {
                    if (currentRestartRequest != this.myCalcThreadRestartRequestId) {
                        return;
                    }
                    this.myCalcThread = new CalcThread(pattern, null);
                    this.myCurrentWorker = this.myCalcThread.start();
                }
            });
        }
    }

    @NotNull
    private String getSearchPattern() {
        String string = Optional.ofNullable(this.mySearchField).map(JTextComponent::getText).orElse("");
        if (string == null) {
            SearchEverywhereUI.$$$reportNull$$$0(2);
        }
        return string;
    }

    private void initSearchActions() {
        this.mySearchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    if (e.getModifiers() == 0) {
                        SearchEverywhereUI.this.switchToNextTab();
                        e.consume();
                    } else if (e.getModifiers() == 1) {
                        SearchEverywhereUI.this.switchToPrevTab();
                        e.consume();
                    }
                }
                if (e.isShiftDown()) {
                    if (e.getKeyCode() == 40) {
                        SearchEverywhereUI.this.myResultsList.dispatchEvent((AWTEvent)e);
                        e.consume();
                    }
                    if (e.getKeyCode() == 38) {
                        SearchEverywhereUI.this.myResultsList.dispatchEvent((AWTEvent)e);
                        e.consume();
                    }
                }
                int[] indices = SearchEverywhereUI.this.myResultsList.getSelectedIndices();
                if (e.getKeyCode() == 10 && indices.length != 0) {
                    SearchEverywhereUI.this.elementsSelected(indices, e.getModifiers());
                }
            }
        });
        AnAction escape = ActionManager.getInstance().getAction("EditorEscape");
        DumbAwareAction.create(__ -> {
            this.stopSearching();
            this.searchFinishedHandler.run();
        }).registerCustomShortcutSet(escape == null ? CommonShortcuts.ESCAPE : escape.getShortcutSet(), (JComponent)((Object)this));
        this.mySearchField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String newSearchString = SearchEverywhereUI.this.getSearchPattern();
                if (SearchEverywhereUI.this.nonProjectCheckBoxAutoSet && SearchEverywhereUI.this.isUseNonProjectItems() && !newSearchString.contains(SearchEverywhereUI.this.notFoundString)) {
                    SearchEverywhereUI.this.doSetUseNonProjectItems(false, true);
                }
                SearchEverywhereUI.this.rebuildList();
            }
        });
        this.myNonProjectCB.addItemListener(e -> this.rebuildList());
        this.myNonProjectCB.addActionListener(e -> {
            this.nonProjectCheckBoxAutoSet = false;
        });
        this.myResultsList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                boolean multiSelectMode;
                boolean bl = multiSelectMode = e.isShiftDown() || e.isControlDown();
                if (e.getButton() == 1 && !multiSelectMode) {
                    e.consume();
                    int i = SearchEverywhereUI.this.myResultsList.locationToIndex(e.getPoint());
                    if (i > -1) {
                        SearchEverywhereUI.this.myResultsList.setSelectedIndex(i);
                        SearchEverywhereUI.this.elementsSelected(new int[]{i}, e.getModifiers());
                    }
                }
            }
        });
        this.myResultsList.addListSelectionListener(e -> {
            Object selectedValue = this.myResultsList.getSelectedValue();
            if (selectedValue != null && this.myHint != null && this.myHint.isVisible()) {
                this.updateHint(selectedValue);
            }
        });
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void exitDumbMode() {
                ApplicationManager.getApplication().invokeLater(() -> SearchEverywhereUI.this.rebuildList());
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(ProgressWindow.TOPIC, pw -> Disposer.register((Disposable)pw, () -> this.myResultsList.repaint()));
        this.mySearchField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!SearchEverywhereUI.this.isHintComponent(e.getOppositeComponent())) {
                    SearchEverywhereUI.this.stopSearching();
                    SearchEverywhereUI.this.searchFinishedHandler.run();
                }
            }
        });
    }

    private boolean isHintComponent(Component component) {
        if (this.myHint != null && !this.myHint.isDisposed()) {
            return SwingUtilities.isDescendingFrom(component, this.myHint.getContent());
        }
        return false;
    }

    private void elementsSelected(int[] indexes, int modifiers) {
        if (indexes.length == 1 && this.myListModel.isMoreElement(indexes[0])) {
            SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(indexes[0]);
            this.showMoreElements(contributor);
            return;
        }
        indexes = Arrays.stream(indexes).filter(i -> !this.myListModel.isMoreElement(i)).toArray();
        boolean closePopup = false;
        for (int i2 : indexes) {
            SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(i2);
            Object value = this.myListModel.getElementAt(i2);
            closePopup |= contributor.processSelectedItem(value, modifiers, this.getSearchPattern());
        }
        if (closePopup) {
            this.stopSearching();
            this.searchFinishedHandler.run();
        } else {
            this.myResultsList.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMoreElements(SearchEverywhereContributor contributor) {
        Object object = this.myWorkerRestartRequestLock;
        synchronized (object) {
            int currentRestartRequest = ++this.myCalcThreadRestartRequestId;
            this.myCurrentWorker.doWhenProcessed(() -> {
                Object object = this.myWorkerRestartRequestLock;
                synchronized (object) {
                    if (currentRestartRequest != this.myCalcThreadRestartRequestId) {
                        return;
                    }
                    this.myCalcThread = new CalcThread(this.getSearchPattern(), contributor);
                    this.myCurrentWorker = this.myCalcThread.start();
                }
            });
        }
    }

    private void stopSearching() {
        this.listOperationsAlarm.cancelAllRequests();
        if (this.myCalcThread != null && !this.myCalcThread.isCanceled()) {
            this.myCalcThread.cancel();
        }
    }

    private void handleEmptyResults() {
        assert (EventQueue.isDispatchThread()) : "Must be EDT";
        if (this.nonProjectCheckBoxAutoSet && !this.isUseNonProjectItems() && !this.getSearchPattern().isEmpty()) {
            this.doSetUseNonProjectItems(true, true);
            this.notFoundString = this.getSearchPattern();
            return;
        }
        this.hideHint();
    }

    @NotNull
    private List<SearchEverywhereContributor> getUsedContributors() {
        SearchEverywhereContributorFilter<?> contributorsFilter = this.myContributorFilters.get("SearchEverywhereContributor.All");
        ArrayList<SearchEverywhereContributor> contributors = new ArrayList<SearchEverywhereContributor>(this.myServiceContributors);
        this.myShownContributors.stream().filter(contributor -> contributorsFilter.isSelected((Object)contributor.getSearchProviderId())).forEach(contributor -> contributors.add((SearchEverywhereContributor)contributor));
        ArrayList<SearchEverywhereContributor> arrayList = contributors;
        if (arrayList == null) {
            SearchEverywhereUI.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public ViewType getViewType() {
        return this.myViewType;
    }

    public void addViewTypeListener(ViewTypeListener listener2) {
        this.myViewTypeListeners.add(listener2);
    }

    public void removeViewTypeListener(ViewTypeListener listener2) {
        this.myViewTypeListeners.remove(listener2);
    }

    private static JLabel groupInfoLabel(String text) {
        JLabel label2 = new JLabel(text);
        label2.setForeground(UIUtil.getLabelDisabledForeground());
        label2.setFont(UIUtil.getLabelFont().deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL)));
        label2.setOpaque(false);
        return label2;
    }

    private String getEmptyText() {
        return this.mySelectedTab.getContributor().map(c -> IdeBundle.message((String)"searcheverywhere.nothing.found.for.contributor.anywhere", (Object[])new Object[]{c.getGroupName()})).orElse(IdeBundle.message((String)"searcheverywhere.nothing.found.for.all.anywhere", (Object[])new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchFinishedHandler";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTabPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchPattern";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedContributors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSearchFinishedHandler";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ViewTypeListener {
        public void suggestionsShown(ViewType var1);
    }

    public static enum ViewType {
        FULL,
        SHORT;

    }

    private class ShowFilterAction
    extends ToggleAction
    implements DumbAware {
        private JBPopup myFilterPopup;

        public ShowFilterAction() {
            super("Filter", "Filter files by type", AllIcons.General.Filter);
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myFilterPopup != null && !this.myFilterPopup.isDisposed();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                this.showPopup(e.getInputEvent().getComponent());
            } else if (this.myFilterPopup != null && !this.myFilterPopup.isDisposed()) {
                this.myFilterPopup.cancel();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowFilterAction.$$$reportNull$$$0(0);
            }
            Icon icon = this.getTemplatePresentation().getIcon();
            e.getPresentation().setIcon(this.isActive() ? ExecutionUtil.getLiveIndicator((Icon)icon) : icon);
            e.getPresentation().setEnabled(SearchEverywhereUI.this.myContributorFilters.get(SearchEverywhereUI.this.getSelectedContributorID()) != null);
            e.getPresentation().putClientProperty("selected", (Object)this.isSelected(e));
        }

        private boolean isActive() {
            String contributorID = SearchEverywhereUI.this.getSelectedContributorID();
            SearchEverywhereContributorFilter filter = (SearchEverywhereContributorFilter)SearchEverywhereUI.this.myContributorFilters.get(contributorID);
            if (filter == null) {
                return false;
            }
            return filter.getAllElements().size() != filter.getSelectedElements().size();
        }

        private void showPopup(Component anchor2) {
            if (this.myFilterPopup != null) {
                return;
            }
            JBPopupListener popupCloseListener = new JBPopupListener(){

                public void onClosed(LightweightWindowEvent event) {
                    ShowFilterAction.this.myFilterPopup = null;
                }
            };
            this.myFilterPopup = JBPopupFactory.getInstance().createComponentPopupBuilder(this.createFilterPanel(), null).setModalContext(false).setFocusable(false).setResizable(true).setCancelOnClickOutside(false).setMinSize(new Dimension(200, 200)).setDimensionServiceKey(SearchEverywhereUI.this.myProject, "Search_Everywhere_Filter_Popup", false).addListener(popupCloseListener).createPopup();
            Disposer.register((Disposable)SearchEverywhereUI.this, (Disposable)this.myFilterPopup);
            this.myFilterPopup.showUnderneathOf(anchor2);
        }

        private JComponent createFilterPanel() {
            SearchEverywhereContributorFilter filter = (SearchEverywhereContributorFilter)SearchEverywhereUI.this.myContributorFilters.get(SearchEverywhereUI.this.getSelectedContributorID());
            final ElementsChooser chooser = this.createChooser(filter);
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 1));
            panel2.add(chooser);
            JPanel buttons = new JPanel();
            JButton all = new JButton("All");
            all.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    chooser.setAllElementsMarked(true);
                }
            });
            buttons.add(all);
            JButton none = new JButton("None");
            none.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    chooser.setAllElementsMarked(false);
                }
            });
            buttons.add(none);
            JButton invert = new JButton("Invert");
            invert.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    chooser.invertSelection();
                }
            });
            buttons.add(invert);
            panel2.add(buttons);
            return panel2;
        }

        private <T> ElementsChooser<T> createChooser(final SearchEverywhereContributorFilter<T> filter) {
            ElementsChooser res = new ElementsChooser<T>(filter.getAllElements(), false){

                @Override
                protected String getItemText(@NotNull T value) {
                    if (value == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return filter.getElementText(value);
                }

                @Override
                @Nullable
                protected Icon getItemIcon(@NotNull T value) {
                    if (value == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    return filter.getElementIcon(value);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "value";
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$ShowFilterAction$5";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getItemText";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getItemIcon";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            res.markElements(filter.getSelectedElements());
            ElementsChooser.ElementsMarkListener<Object> listener2 = (element, isMarked) -> {
                filter.setSelected(element, isMarked);
                SearchEverywhereUI.this.rebuildList();
            };
            res.addElementsMarkListener(listener2);
            return res;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$ShowFilterAction", "update"));
        }
    }

    private class ShowInFindToolWindowAction
    extends DumbAwareAction {
        public ShowInFindToolWindowAction() {
            super(IdeBundle.message((String)"searcheverywhere.show.in.find.window.button.name", (Object[])new Object[0]), IdeBundle.message((String)"searcheverywhere.show.in.find.window.button.name", (Object[])new Object[0]), AllIcons.General.Pin_tab);
        }

        public void actionPerformed(AnActionEvent e) {
            SearchEverywhereUI.this.stopSearching();
            Collection contributors = SearchEverywhereUI.this.isAllTabSelected() ? SearchEverywhereUI.this.getUsedContributors() : Collections.singleton(SearchEverywhereUI.this.mySelectedTab.getContributor().get());
            contributors = contributors.stream().filter(SearchEverywhereContributor::showInFindResults).collect(Collectors.toList());
            if (contributors.isEmpty()) {
                return;
            }
            final String searchText = SearchEverywhereUI.this.getSearchPattern();
            final boolean everywhere = SearchEverywhereUI.this.isUseNonProjectItems();
            String contributorsString = contributors.stream().map(SearchEverywhereContributor::getGroupName).collect(Collectors.joining(", "));
            final UsageViewPresentation presentation = new UsageViewPresentation();
            String tabCaptionText = IdeBundle.message((String)"searcheverywhere.found.matches.title", (Object[])new Object[]{searchText, contributorsString});
            presentation.setCodeUsagesString(tabCaptionText);
            presentation.setUsagesInGeneratedCodeString(IdeBundle.message((String)"searcheverywhere.found.matches.generated.code.title", (Object[])new Object[]{searchText, contributorsString}));
            presentation.setTargetsNodeText(IdeBundle.message((String)"searcheverywhere.found.targets.title", (Object[])new Object[]{searchText, contributorsString}));
            presentation.setTabName(tabCaptionText);
            presentation.setTabText(tabCaptionText);
            final LinkedHashSet<Usage> usages = new LinkedHashSet<Usage>();
            final LinkedHashSet<PsiElement> targets = new LinkedHashSet<PsiElement>();
            Collection cached = contributors.stream().flatMap(contributor -> SearchEverywhereUI.this.myListModel.getFoundItems((SearchEverywhereContributor)contributor).stream()).collect(Collectors.toList());
            this.fillUsages(cached, usages, targets);
            final Collection contributorsForAdditionalSearch = contributors.stream().filter(contributor -> SearchEverywhereUI.this.myListModel.hasMoreElements((SearchEverywhereContributor)contributor)).collect(Collectors.toList());
            SearchEverywhereUI.this.searchFinishedHandler.run();
            if (!contributorsForAdditionalSearch.isEmpty()) {
                ProgressManager.getInstance().run((Task)new Task.Modal(SearchEverywhereUI.this.myProject, tabCaptionText, true){
                    private final ProgressIndicator progressIndicator;
                    {
                        super(arg0, arg1, arg2);
                        this.progressIndicator = new ProgressIndicatorBase();
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        contributorsForAdditionalSearch.forEach(contributor -> {
                            if (!this.progressIndicator.isCanceled()) {
                                List foundElements = contributor.search(searchText, everywhere, (SearchEverywhereContributorFilter)SearchEverywhereUI.this.myContributorFilters.get(contributor.getSearchProviderId()), this.progressIndicator);
                                ShowInFindToolWindowAction.this.fillUsages(foundElements, usages, targets);
                            }
                        });
                    }

                    public void onCancel() {
                        this.progressIndicator.cancel();
                    }

                    public void onSuccess() {
                        ShowInFindToolWindowAction.this.showInFindWindow(targets, usages, presentation);
                    }

                    public void onThrowable(@NotNull Throwable error) {
                        if (error == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        this.progressIndicator.cancel();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "indicator";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "error";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$ShowInFindToolWindowAction$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "run";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onThrowable";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            } else {
                this.showInFindWindow(targets, usages, presentation);
            }
        }

        private void fillUsages(Collection<Object> foundElements, Collection<Usage> usages, Collection<PsiElement> targets) {
            foundElements.stream().filter(o -> o instanceof PsiElement).forEach(o -> {
                PsiElement element = (PsiElement)o;
                if (element.getTextRange() != null) {
                    UsageInfo usageInfo = new UsageInfo(element);
                    usages.add((Usage)new UsageInfo2UsageAdapter(usageInfo));
                } else {
                    targets.add(element);
                }
            });
        }

        private void showInFindWindow(Collection<PsiElement> targets, Collection<Usage> usages, UsageViewPresentation presentation) {
            UsageTarget[] targetsArray = targets.isEmpty() ? UsageTarget.EMPTY_ARRAY : PsiElement2UsageTargetAdapter.convert(PsiUtilCore.toPsiElementArray(targets));
            Usage[] usagesArray = usages.toArray(Usage.EMPTY_ARRAY);
            UsageViewManager.getInstance((Project)SearchEverywhereUI.this.myProject).showUsages(targetsArray, usagesArray, presentation);
        }

        public void update(AnActionEvent e) {
            Boolean enabled = SearchEverywhereUI.this.mySelectedTab.getContributor().map(contributor -> contributor.showInFindResults()).orElse(true);
            e.getPresentation().setEnabled(enabled.booleanValue());
        }
    }

    private static class SearchListModel
    extends AbstractListModel<Object> {
        private static final Object MORE_ELEMENT = new Object();
        private final List<Pair<Object, SearchEverywhereContributor>> listElements = new ArrayList<Pair<Object, SearchEverywhereContributor>>();

        private SearchListModel() {
        }

        @Override
        public int getSize() {
            return this.listElements.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.listElements.get((int)index).first;
        }

        public Collection<Object> getFoundItems(SearchEverywhereContributor contributor) {
            return this.listElements.stream().filter(pair -> pair.second == contributor && pair.first != MORE_ELEMENT).map(pair -> pair.getFirst()).collect(Collectors.toList());
        }

        public boolean hasMoreElements(SearchEverywhereContributor contributor) {
            return this.listElements.stream().anyMatch(pair -> pair.first == MORE_ELEMENT && pair.second == contributor);
        }

        public void addElements(List<Object> items, SearchEverywhereContributor contributor, boolean hasMore) {
            if (items.isEmpty()) {
                return;
            }
            List pairsToAdd = items.stream().map(o -> Pair.create((Object)o, (Object)contributor)).collect(Collectors.toList());
            int insertPoint = this.contributors().lastIndexOf(contributor);
            if (insertPoint < 0) {
                int startIndex = this.listElements.size();
                this.listElements.addAll(pairsToAdd);
                if (hasMore) {
                    this.listElements.add((Pair<Object, SearchEverywhereContributor>)Pair.create((Object)MORE_ELEMENT, (Object)contributor));
                }
                int endIndex = this.listElements.size() - 1;
                this.fireIntervalAdded(this, startIndex, endIndex);
            } else {
                boolean hadMoreBeforeAdd = this.isMoreElement(insertPoint);
                if (!hadMoreBeforeAdd) {
                    ++insertPoint;
                }
                int startIndex = insertPoint;
                int endIndex = startIndex + pairsToAdd.size() - 1;
                this.listElements.addAll(insertPoint, pairsToAdd);
                if (hasMore && !hadMoreBeforeAdd) {
                    this.listElements.add(insertPoint + pairsToAdd.size(), (Pair<Object, SearchEverywhereContributor>)Pair.create((Object)MORE_ELEMENT, (Object)contributor));
                    ++endIndex;
                }
                this.fireIntervalAdded(this, startIndex, endIndex);
                if (hadMoreBeforeAdd && !hasMore) {
                    this.listElements.remove(endIndex + 1);
                    this.fireIntervalRemoved(this, endIndex + 1, endIndex + 1);
                }
            }
        }

        public void clear() {
            int index = this.listElements.size() - 1;
            this.listElements.clear();
            if (index >= 0) {
                this.fireIntervalRemoved(this, 0, index);
            }
        }

        public boolean contains(Object val) {
            return this.values().contains(val);
        }

        public boolean isMoreElement(int index) {
            return this.listElements.get((int)index).first == MORE_ELEMENT;
        }

        public SearchEverywhereContributor getContributorForIndex(int index) {
            return (SearchEverywhereContributor)this.listElements.get((int)index).second;
        }

        public boolean isGroupFirstItem(int index) {
            return index == 0 || this.listElements.get((int)index).second != this.listElements.get((int)(index - 1)).second;
        }

        public int getItemsForContributor(SearchEverywhereContributor contributor) {
            List<SearchEverywhereContributor> contributorsList = this.contributors();
            int first = contributorsList.indexOf(contributor);
            int last = contributorsList.lastIndexOf(contributor);
            if (this.isMoreElement(last)) {
                --last;
            }
            return last - first + 1;
        }

        @NotNull
        private List<SearchEverywhereContributor> contributors() {
            List list2 = Lists.transform(this.listElements, pair -> (SearchEverywhereContributor)pair.getSecond());
            if (list2 == null) {
                SearchListModel.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @NotNull
        private List<Object> values() {
            List list2 = Lists.transform(this.listElements, pair -> pair.getFirst());
            if (list2 == null) {
                SearchListModel.$$$reportNull$$$0(1);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$SearchListModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "contributors";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "values";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class GroupTitleRenderer
    extends JPanel {
        private final JLabel titleLabel;
        private final BorderLayout myLayout = new BorderLayout();

        public GroupTitleRenderer() {
            this.setLayout(this.myLayout);
            this.setBackground(UIUtil.getListBackground((boolean)false));
            this.titleLabel = SearchEverywhereUI.groupInfoLabel("Group");
            SeparatorComponent separatorComponent = new SeparatorComponent(this.titleLabel.getPreferredSize().height / 2, JBUI.CurrentTheme.SearchEverywhere.listSeparatorColor(), null);
            JBPanel topPanel = ((BorderLayoutPanel)JBUI.Panels.simplePanel((int)5, (int)0).addToCenter((Component)separatorComponent).addToLeft((Component)this.titleLabel).withBorder((Border)JBUI.Borders.empty((int)0, (int)7))).withBackground(UIUtil.getListBackground());
            this.add((Component)topPanel, "North");
        }

        public GroupTitleRenderer withDisplayedData(String title, Component itemContent) {
            this.titleLabel.setText(title);
            Component prevContent = this.myLayout.getLayoutComponent("Center");
            if (prevContent != null) {
                this.remove(prevContent);
            }
            this.add(itemContent, "Center");
            return this;
        }
    }

    public static class MoreRenderer
    extends JPanel
    implements ListCellRenderer<Object> {
        final JLabel label = SearchEverywhereUI.access$3400("... more");

        private MoreRenderer() {
            super(new BorderLayout());
            this.add((Component)this.label, "Center");
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(UIUtil.getListBackground((boolean)isSelected));
            return this;
        }
    }

    private class CompositeCellRenderer
    implements ListCellRenderer<Object> {
        private CompositeCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (SearchEverywhereUI.this.myListModel.isMoreElement(index)) {
                Component cmp = SearchEverywhereUI.this.moreRenderer.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
                return this.wrap(cmp, 1, 7);
            }
            SearchEverywhereContributor contributor = SearchEverywhereUI.this.myListModel.getContributorForIndex(index);
            Component component = SearchEverywhereClassifier.EP_Manager.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
            if (component == null) {
                component = contributor.getElementsRenderer((JList)SearchEverywhereUI.this.myResultsList).getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
            }
            if (SearchEverywhereUI.this.isAllTabSelected() && SearchEverywhereUI.this.myListModel.isGroupFirstItem(index)) {
                component = SearchEverywhereUI.this.groupTitleRenderer.withDisplayedData(contributor.getGroupName(), component);
            }
            return this.wrap(component, 1, 0);
        }

        private Component wrap(Component cmp, int verticalGap, int hotizontalGap) {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setOpaque(cmp.isOpaque());
            if (cmp.isOpaque()) {
                panel2.setBackground(cmp.getBackground());
            }
            panel2.add(cmp, "Center");
            panel2.setBorder((Border)JBUI.Borders.empty((int)verticalGap, (int)hotizontalGap));
            return panel2;
        }
    }

    private class CalcThread
    implements Runnable {
        private final String pattern;
        private final ProgressIndicator myProgressIndicator;
        private final ActionCallback myDone;
        private final SearchEverywhereContributor contributorToExpand;

        private CalcThread(@Nullable String pattern, SearchEverywhereContributor expand) {
            if (pattern == null) {
                CalcThread.$$$reportNull$$$0(0);
            }
            this.myProgressIndicator = new ProgressIndicatorBase();
            this.myDone = new ActionCallback();
            this.pattern = pattern;
            this.contributorToExpand = expand;
        }

        @Override
        public void run() {
            try {
                this.check();
                if (this.contributorToExpand == null) {
                    this.resetList();
                } else {
                    this.showMore(this.contributorToExpand);
                }
            }
            catch (ProcessCanceledException ignore) {
                this.myDone.setRejected();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                this.myDone.setRejected();
            }
            finally {
                if (!this.isCanceled()) {
                    SearchEverywhereUI.this.listOperationsAlarm.addRequest(() -> SearchEverywhereUI.this.myResultsList.getEmptyText().setText(SearchEverywhereUI.this.getEmptyText()), 0);
                }
                if (!this.myDone.isProcessed()) {
                    this.myDone.setDone();
                }
            }
        }

        private void resetList() {
            SearchEverywhereUI.this.listOperationsAlarm.cancelAllRequests();
            SearchEverywhereUI.this.emptyListAlarm.cancelAllRequests();
            SearchEverywhereUI.this.listOperationsAlarm.addRequest(() -> {
                Dimension oldSize = SearchEverywhereUI.this.getPreferredSize();
                SearchEverywhereUI.this.myResultsList.getEmptyText().setText(IdeBundle.message((String)"label.choosebyname.searching", (Object[])new Object[0]));
                SearchEverywhereUI.this.myListModel.clear();
                Dimension newSize = SearchEverywhereUI.this.getPreferredSize();
                SearchEverywhereUI.this.firePropertyChange("preferredSize", oldSize, newSize);
            }, 200);
            boolean anyFound = false;
            SearchEverywhereContributor selectedContributor = SearchEverywhereUI.this.mySelectedTab.getContributor().orElse(null);
            if (selectedContributor != null) {
                anyFound = this.addContributorItems(selectedContributor, 30, true);
            } else {
                boolean clearBefore = true;
                for (SearchEverywhereContributor contributor : SearchEverywhereUI.this.getUsedContributors()) {
                    int count = SearchEverywhereUI.this.myServiceContributors.contains(contributor) ? -1 : 15;
                    anyFound |= this.addContributorItems(contributor, count, clearBefore);
                    clearBefore = false;
                }
            }
            if (!anyFound) {
                SearchEverywhereUI.this.emptyListAlarm.addRequest(() -> SearchEverywhereUI.this.handleEmptyResults(), 50);
            }
        }

        private void showMore(SearchEverywhereContributor contributor) {
            int delta = SearchEverywhereUI.this.isAllTabSelected() ? 15 : 30;
            int size = SearchEverywhereUI.this.myListModel.getItemsForContributor(contributor) + delta;
            this.addContributorItems(contributor, size, false);
        }

        private boolean addContributorItems(SearchEverywhereContributor contributor, int count, boolean clearBefore) {
            boolean found;
            ContributorSearchResult results = contributor.search(this.pattern, SearchEverywhereUI.this.isUseNonProjectItems(), (SearchEverywhereContributorFilter)SearchEverywhereUI.this.myContributorFilters.get(contributor.getSearchProviderId()), this.myProgressIndicator, count);
            boolean bl = found = !results.isEmpty();
            if (clearBefore) {
                SearchEverywhereUI.this.listOperationsAlarm.cancelAllRequests();
            }
            SearchEverywhereUI.this.listOperationsAlarm.addRequest(() -> {
                List<Object> itemsToAdd;
                if (this.isCanceled()) {
                    return;
                }
                Dimension oldSize = SearchEverywhereUI.this.getPreferredSize();
                if (clearBefore) {
                    SearchEverywhereUI.this.myListModel.clear();
                }
                if (!(itemsToAdd = results.getItems().stream().filter(o -> !SearchEverywhereUI.this.myListModel.contains(o)).collect(Collectors.toList())).isEmpty()) {
                    SearchEverywhereUI.this.updateViewType(ViewType.FULL);
                    SearchEverywhereUI.this.myListModel.addElements(itemsToAdd, contributor, results.hasMoreItems());
                    ScrollingUtil.ensureSelectionExists((JList)SearchEverywhereUI.this.myResultsList);
                }
                SearchEverywhereUI.this.firePropertyChange("preferredSize", oldSize, SearchEverywhereUI.this.getPreferredSize());
            }, 50);
            return found;
        }

        protected void check() {
            this.myProgressIndicator.checkCanceled();
            if (this.myDone.isRejected()) {
                throw new ProcessCanceledException();
            }
            assert (SearchEverywhereUI.this.myCalcThread == this) : "There are two CalcThreads running before one of them was cancelled";
        }

        private boolean isCanceled() {
            return this.myProgressIndicator.isCanceled() || this.myDone.isRejected();
        }

        public ActionCallback cancel() {
            this.myProgressIndicator.cancel();
            return this.myDone;
        }

        public ActionCallback start() {
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)this);
            return this.myDone;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$CalcThread", "<init>"));
        }
    }

    private class SETab
    extends JLabel {
        private final SearchEverywhereContributor myContributor;

        public SETab(SearchEverywhereContributor contributor) {
            super(contributor == null ? IdeBundle.message((String)"searcheverywhere.allelements.tab.name", (Object[])new Object[0]) : contributor.getGroupName());
            this.myContributor = contributor;
            Insets insets = JBUI.CurrentTheme.SearchEverywhere.tabInsets();
            this.setBorder((Border)JBUI.Borders.empty((int)insets.top, (int)insets.left, (int)insets.bottom, (int)insets.right));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SearchEverywhereUI.this.switchToTab(SETab.this);
                }
            });
        }

        public String getID() {
            return this.getContributor().map(SearchEverywhereContributor::getSearchProviderId).orElse("SearchEverywhereContributor.All");
        }

        public Optional<SearchEverywhereContributor> getContributor() {
            return Optional.ofNullable(this.myContributor);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = JBUI.scale((int)29);
            return size;
        }

        @Override
        public boolean isOpaque() {
            return SearchEverywhereUI.this.mySelectedTab == this;
        }

        @Override
        public Color getBackground() {
            return SearchEverywhereUI.this.mySelectedTab == this ? JBUI.CurrentTheme.SearchEverywhere.selectedTabColor() : super.getBackground();
        }
    }
}

