/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoFileAction;
import com.intellij.ide.actions.searcheverywhere.AbstractGotoSEContributor;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoFileConfiguration;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.IdeUICustomization;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSearchEverywhereContributor
extends AbstractGotoSEContributor<FileType> {
    public FileSearchEverywhereContributor(Project project) {
        super(project);
    }

    @NotNull
    public String getGroupName() {
        if ("Files" == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(0);
        }
        return "Files";
    }

    public String includeNonProjectItemsText() {
        return IdeBundle.message((String)"checkbox.include.non.project.files", (Object[])new Object[]{IdeUICustomization.getInstance().getProjectConceptName()});
    }

    public int getSortWeight() {
        return 200;
    }

    @Override
    protected FilteringGotoByModel<FileType> createModel(Project project) {
        return new GotoFileModel(project){

            @Override
            public boolean isSlashlessMatchingEnabled() {
                return false;
            }
        };
    }

    @Override
    public boolean processSelectedItem(Object selected, int modifiers, String searchText) {
        VirtualFile file2;
        if (selected instanceof PsiFile && (file2 = ((PsiFile)selected).getVirtualFile()) != null) {
            Pair<Integer, Integer> pos = FileSearchEverywhereContributor.getLineAndColumn(searchText);
            OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, file2, ((Integer)pos.first).intValue(), ((Integer)pos.second).intValue());
            descriptor.setUseCurrentWindow(FileSearchEverywhereContributor.openInCurrentWindow(modifiers));
            if (descriptor.canNavigate()) {
                descriptor.navigate(true);
                return true;
            }
        }
        return super.processSelectedItem(selected, modifiers, searchText);
    }

    @Override
    public Object getDataForItem(Object element, String dataId) {
        if (CommonDataKeys.PSI_FILE.is(dataId) && element instanceof PsiFile) {
            return element;
        }
        return super.getDataForItem(element, dataId);
    }

    @Override
    protected boolean isDumbModeSupported() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/searcheverywhere/FileSearchEverywhereContributor", "getGroupName"));
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<FileType> {
        @NotNull
        public SearchEverywhereContributor<FileType> createContributor(AnActionEvent initEvent) {
            FileSearchEverywhereContributor fileSearchEverywhereContributor = new FileSearchEverywhereContributor(initEvent.getProject());
            if (fileSearchEverywhereContributor == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return fileSearchEverywhereContributor;
        }

        @Nullable
        public SearchEverywhereContributorFilter<FileType> createFilter(AnActionEvent initEvent) {
            Project project = initEvent.getProject();
            if (project == null) {
                return null;
            }
            List items = Stream.of(FileTypeManager.getInstance().getRegisteredFileTypes()).sorted(GotoFileAction.FileTypeComparator.INSTANCE).collect(Collectors.toList());
            return new PersistentSearchEverywhereContributorFilter<FileType>(items, GotoFileConfiguration.getInstance(project), FileType::getName, FileType::getIcon);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/searcheverywhere/FileSearchEverywhereContributor$Factory", "createContributor"));
        }
    }
}

