/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionAction;
import com.intellij.ide.actions.SetShortcutAction;
import com.intellij.ide.actions.searcheverywhere.ContributorSearchResult;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.util.gotoByName.GotoActionItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionSearchEverywhereContributor
implements SearchEverywhereContributor<Void> {
    private static final Logger LOG = Logger.getInstance(ActionSearchEverywhereContributor.class);
    private final Project myProject;
    private final Component myContextComponent;
    private final GotoActionModel myModel;
    private final GotoActionItemProvider myProvider;

    public ActionSearchEverywhereContributor(Project project, Component contextComponent, Editor editor) {
        this.myProject = project;
        this.myContextComponent = contextComponent;
        this.myModel = new GotoActionModel(project, contextComponent, editor);
        this.myProvider = new GotoActionItemProvider(this.myModel);
    }

    @NotNull
    public String getGroupName() {
        if ("Actions" == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(0);
        }
        return "Actions";
    }

    public String includeNonProjectItemsText() {
        return IdeBundle.message((String)"checkbox.disabled.included", (Object[])new Object[0]);
    }

    public int getSortWeight() {
        return 400;
    }

    public boolean isShownInSeparateTab() {
        return true;
    }

    public ContributorSearchResult<Object> search(String pattern, boolean everywhere, SearchEverywhereContributorFilter<Void> filter, ProgressIndicator progressIndicator, int elementsLimit) {
        if (StringUtil.isEmptyOrSpaces((String)pattern)) {
            return ContributorSearchResult.empty();
        }
        ContributorSearchResult.Builder builder2 = ContributorSearchResult.builder();
        this.myProvider.filterElements(pattern, (Processor<GotoActionModel.MatchedValue>)((Processor)element -> {
            if (progressIndicator.isCanceled()) {
                return false;
            }
            if (!everywhere && element.value instanceof GotoActionModel.ActionWrapper && !((GotoActionModel.ActionWrapper)element.value).isAvailable()) {
                return true;
            }
            if (element == null) {
                LOG.error("Null action has been returned from model");
                return true;
            }
            if (builder2.itemsCount() < elementsLimit) {
                builder2.addItem(element);
                return true;
            }
            builder2.setHasMore(true);
            return false;
        }));
        return builder2.build();
    }

    public ListCellRenderer getElementsRenderer(JList<?> list2) {
        return this.myModel.getListCellRenderer();
    }

    public boolean showInFindResults() {
        return false;
    }

    @NotNull
    public String getSearchProviderId() {
        String string = ActionSearchEverywhereContributor.class.getSimpleName();
        if (string == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(1);
        }
        return string;
    }

    public Object getDataForItem(Object element, String dataId) {
        if (SetShortcutAction.SELECTED_ACTION.is(dataId)) {
            Comparable value = ((GotoActionModel.MatchedValue)element).value;
            if (value instanceof GotoActionModel.ActionWrapper) {
                value = ((GotoActionModel.ActionWrapper)value).getAction();
            }
            if (value instanceof AnAction) {
                return value;
            }
        }
        return null;
    }

    public boolean processSelectedItem(Object selected, int modifiers, String text) {
        selected = ((GotoActionModel.MatchedValue)selected).value;
        if (selected instanceof BooleanOptionDescription) {
            BooleanOptionDescription option;
            option.setOptionState(!(option = (BooleanOptionDescription)selected).isOptionEnabled());
            return false;
        }
        GotoActionAction.openOptionOrPerformAction(selected, "", this.myProject, this.myContextComponent);
        boolean inplaceChange = selected instanceof GotoActionModel.ActionWrapper && ((GotoActionModel.ActionWrapper)selected).getAction() instanceof ToggleAction;
        return !inplaceChange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/actions/searcheverywhere/ActionSearchEverywhereContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchProviderId";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<Void> {
        @NotNull
        public SearchEverywhereContributor<Void> createContributor(AnActionEvent initEvent) {
            ActionSearchEverywhereContributor actionSearchEverywhereContributor = new ActionSearchEverywhereContributor(initEvent.getProject(), (Component)initEvent.getData(PlatformDataKeys.CONTEXT_COMPONENT), (Editor)initEvent.getData(CommonDataKeys.EDITOR));
            if (actionSearchEverywhereContributor == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return actionSearchEverywhereContributor;
        }

        @Nullable
        public SearchEverywhereContributorFilter<Void> createFilter(AnActionEvent initEvent) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/searcheverywhere/ActionSearchEverywhereContributor$Factory", "createContributor"));
        }
    }
}

