/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.actions.runAnything.RunAnythingCache;
import com.intellij.ide.actions.runAnything.RunAnythingHistoryItem;
import com.intellij.ide.actions.runAnything.RunAnythingIconHandler;
import com.intellij.ide.actions.runAnything.RunAnythingMore;
import com.intellij.ide.actions.runAnything.RunAnythingMyAccessibleComponent;
import com.intellij.ide.actions.runAnything.RunAnythingRunConfigurationProvider;
import com.intellij.ide.actions.runAnything.RunAnythingSEOption;
import com.intellij.ide.actions.runAnything.RunAnythingSearchListModel;
import com.intellij.ide.actions.runAnything.RunAnythingUtil;
import com.intellij.ide.actions.runAnything.activity.RunAnythingCommandExecutionProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingRecentCommandProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingRecentProjectProvider;
import com.intellij.ide.actions.runAnything.groups.RunAnythingCompletionGroup;
import com.intellij.ide.actions.runAnything.groups.RunAnythingGeneralGroup;
import com.intellij.ide.actions.runAnything.groups.RunAnythingGroup;
import com.intellij.ide.actions.runAnything.groups.RunAnythingRecentGroup;
import com.intellij.ide.actions.runAnything.items.RunAnythingItem;
import com.intellij.ide.actions.runAnything.ui.RunAnythingScrollingUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ide.ui.laf.intellij.MacIntelliJTextBorder;
import com.intellij.ide.ui.laf.intellij.WinIntelliJTextBorder;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.collectors.fus.ui.persistence.ToolbarClicksCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.PoppedIcon;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.keymap.impl.ModifierKeyDoubleClickHandler;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.OnOffButton;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.TextUI;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunAnythingAction
extends AnAction
implements CustomComponentAction,
DumbAware,
DataProvider {
    public static final String RUN_ANYTHING_HISTORY_KEY = "RunAnythingHistoryKey";
    public static final int SEARCH_FIELD_COLUMNS = 25;
    public static final Icon UNKNOWN_CONFIGURATION_ICON = AllIcons.Actions.Run_anything;
    public static final AtomicBoolean SHIFT_IS_PRESSED = new AtomicBoolean(false);
    public static final AtomicBoolean ALT_IS_PRESSED = new AtomicBoolean(false);
    public static final Key<JBPopup> RUN_ANYTHING_POPUP = new Key("RunAnythingPopup");
    public static final String RUN_ANYTHING_ACTION_ID = "RunAnything";
    public static final DataKey<Executor> EXECUTOR_KEY = DataKey.create((String)"EXECUTOR_KEY");
    static final String RUN_ANYTHING = "RunAnything";
    private static final Logger LOG = Logger.getInstance(RunAnythingAction.class);
    private static final Border RENDERER_BORDER = JBUI.Borders.empty((int)1, (int)0);
    private static final Icon RUN_ANYTHING_POPPED_ICON = new PoppedIcon(AllIcons.Actions.Run_anything, 16, 16);
    private static final String HELP_PLACEHOLDER = "?";
    private static final NotNullLazyValue<Boolean> IS_ACTION_ENABLED = new NotNullLazyValue<Boolean>(){

        @NotNull
        protected Boolean compute() {
            Boolean bl = Arrays.stream(RunAnythingProvider.EP_NAME.getExtensions()).anyMatch(provider -> !(provider instanceof RunAnythingRunConfigurationProvider) && !(provider instanceof RunAnythingRecentProjectProvider) && !(provider instanceof RunAnythingRecentCommandProvider) && !(provider instanceof RunAnythingCommandExecutionProvider));
            if (bl == null) {
                1.$$$reportNull$$$0(0);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/runAnything/RunAnythingAction$1", "compute"));
        }
    };
    private MyListRenderer myRenderer;
    private MySearchTextField myPopupField;
    private JBPopup myPopup;
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)ApplicationManager.getApplication());
    private JBList myList;
    private AnActionEvent myActionEvent;
    private boolean myIsUsedTrigger;
    private Component myContextComponent;
    private CalcThread myCalcThread;
    private volatile ActionCallback myCurrentWorker = ActionCallback.DONE;
    private int myCalcThreadRestartRequestId = 0;
    private final Object myWorkerRestartRequestLock = new Object();
    private int myHistoryIndex = 0;
    private boolean mySkipFocusGain = false;
    private volatile JBPopup myBalloon;
    private int myPopupActualWidth;
    private Component myFocusOwner;
    private Editor myEditor;
    @Nullable
    private VirtualFile myVirtualFile;
    private RunAnythingHistoryItem myHistoryItem;
    private DataContext myDataContext;
    private JLabel myTextFieldTitle;
    private boolean myIsItemSelected;
    private String myLastInputText = null;

    public JComponent createCustomComponent(Presentation presentation) {
        BorderLayoutPanel panel2 = new BorderLayoutPanel(){

            public Dimension getPreferredSize() {
                return JBUI.size((int)25);
            }
        };
        panel2.setOpaque(false);
        JBLabel label2 = new JBLabel(AllIcons.Actions.Run_anything){
            {
                this.enableEvents(16L);
                this.enableEvents(32L);
            }
        };
        panel2.add((Component)label2, "Center");
        RunAnythingUtil.initTooltip((JComponent)label2);
        label2.addMouseListener(new MouseAdapter((JLabel)label2, (JPanel)panel2){
            final /* synthetic */ JLabel val$label;
            final /* synthetic */ JPanel val$panel;
            {
                this.val$label = jLabel;
                this.val$panel = jPanel;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (RunAnythingAction.this.myBalloon != null) {
                    RunAnythingAction.this.myBalloon.cancel();
                }
                RunAnythingAction.this.myFocusOwner = IdeFocusManager.findInstance().getFocusOwner();
                this.val$label.setToolTipText(null);
                IdeTooltipManager.getInstance().hideCurrentNow(false);
                ActionToolbarImpl toolbar = (ActionToolbarImpl)UIUtil.getParentOfType(ActionToolbarImpl.class, (Component)this.val$panel);
                if (toolbar != null) {
                    ToolbarClicksCollector.record(RunAnythingAction.this, toolbar.getPlace());
                }
                RunAnythingAction.this.actionPerformed(null, e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (RunAnythingAction.this.myBalloon == null || RunAnythingAction.this.myBalloon.isDisposed()) {
                    this.val$label.setIcon(RUN_ANYTHING_POPPED_ICON);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (RunAnythingAction.this.myBalloon == null || RunAnythingAction.this.myBalloon.isDisposed()) {
                    this.val$label.setIcon(AllIcons.Actions.Run_anything);
                }
            }
        });
        return panel2;
    }

    private void updateComponents() {
        this.myList = new JBList(new RunAnythingSearchListModel.RunAnythingMainListModel()){
            int lastKnownHeight;
            {
                this.lastKnownHeight = JBUI.scale((int)30);
            }

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                if (size.height == -1) {
                    size.height = this.lastKnownHeight;
                } else {
                    this.lastKnownHeight = size.height;
                }
                int width = RunAnythingAction.this.myBalloon != null ? ((RunAnythingAction)RunAnythingAction.this).myBalloon.getSize().width : 0;
                return new Dimension(Math.max(width, Math.min(size.width - 2, RunAnythingUtil.getPopupMaxWidth())), RunAnythingAction.this.myList.isEmpty() ? JBUI.scale((int)30) : size.height);
            }

            public void clearSelection() {
            }

            public Object getSelectedValue() {
                try {
                    return super.getSelectedValue();
                }
                catch (Exception e) {
                    return null;
                }
            }
        };
        this.myRenderer = new MyListRenderer();
        this.myList.setCellRenderer((ListCellRenderer)((Object)this.myRenderer));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (clickCount > 1 && clickCount % 2 == 0 || RunAnythingAction.this.myList.getModel() instanceof RunAnythingSettingsModel) {
                    event.consume();
                    int i = RunAnythingAction.this.myList.locationToIndex(event.getPoint());
                    if (i != -1) {
                        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)RunAnythingAction.this.getField(), true));
                        ApplicationManager.getApplication().invokeLater(() -> {
                            RunAnythingAction.this.myList.setSelectedIndex(i);
                            RunAnythingAction.this.executeCommand();
                        });
                    }
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/runAnything/RunAnythingAction$6", "onClick"));
            }
        }.installOn((Component)this.myList);
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        return null;
    }

    private void initSearchField(final MySearchTextField search2) {
        JBTextField editor = search2.getTextEditor();
        editor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter((JTextField)editor){
            final /* synthetic */ JTextField val$editor;
            {
                this.val$editor = jTextField;
            }

            protected void textChanged(DocumentEvent e) {
                RunAnythingAction.this.myIsUsedTrigger = true;
                String pattern = this.val$editor.getText();
                if (this.val$editor.hasFocus()) {
                    ApplicationManager.getApplication().invokeLater(() -> RunAnythingAction.this.myIsItemSelected = false);
                    if (!RunAnythingAction.this.myIsItemSelected) {
                        RunAnythingAction.this.myLastInputText = null;
                        RunAnythingAction.this.clearSelection();
                        RunAnythingAction.this.rebuildList(pattern);
                    }
                    if (!RunAnythingAction.isHelpMode(pattern)) {
                        RunAnythingAction.adjustMainListEmptyText(RunAnythingAction.this.myPopupField.getTextEditor());
                        return;
                    }
                    RunAnythingAction.adjustEmptyText(RunAnythingAction.this.myPopupField.getTextEditor(), (BooleanFunction<JBTextField>)((BooleanFunction)field -> true), "", IdeBundle.message((String)"run.anything.help.list.empty.secondary.text", (Object[])new Object[0]));
                }
            }
        });
        editor.addFocusListener(new FocusAdapter((JTextField)editor){
            final /* synthetic */ JTextField val$editor;
            {
                this.val$editor = jTextField;
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (RunAnythingAction.this.mySkipFocusGain) {
                    RunAnythingAction.this.mySkipFocusGain = false;
                    return;
                }
                String text = RunAnythingUtil.getInitialTextForNavigation(RunAnythingAction.this.myEditor);
                text = text != null ? text.trim() : "";
                search2.setText(text);
                search2.getTextEditor().setForeground(UIUtil.getLabelForeground());
                search2.selectText();
                this.val$editor.setColumns(25);
                SwingUtilities.invokeLater(() -> {
                    JComponent parent = (JComponent)this.val$editor.getParent();
                    parent.revalidate();
                    parent.repaint();
                });
                RunAnythingAction.this.rebuildList(text);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (RunAnythingAction.this.myPopup instanceof AbstractPopup && RunAnythingAction.this.myPopup.isVisible() && (RunAnythingAction.this.myList == e.getOppositeComponent() || ((AbstractPopup)RunAnythingAction.this.myPopup).getPopupWindow() == e.getOppositeComponent())) {
                    return;
                }
                RunAnythingAction.this.onPopupFocusLost();
            }
        });
    }

    private static void adjustMainListEmptyText(@NotNull JBTextField editor) {
        if (editor == null) {
            RunAnythingAction.$$$reportNull$$$0(0);
        }
        RunAnythingAction.adjustEmptyText(editor, (BooleanFunction<JBTextField>)((BooleanFunction)field -> field.getText().isEmpty()), IdeBundle.message((String)"run.anything.main.list.empty.primary.text", (Object[])new Object[0]), IdeBundle.message((String)"run.anything.main.list.empty.secondary.text", (Object[])new Object[0]));
    }

    private static boolean isHelpMode(@NotNull String pattern) {
        if (pattern == null) {
            RunAnythingAction.$$$reportNull$$$0(1);
        }
        return pattern.startsWith(HELP_PLACEHOLDER);
    }

    private void clearSelection() {
        this.myList.getSelectionModel().clearSelection();
    }

    @NotNull
    private ActionCallback onPopupFocusLost() {
        ActionCallback result2 = new ActionCallback();
        UIUtil.invokeLaterIfNeeded(() -> {
            try {
                if (this.myCalcThread != null) {
                    this.myCalcThread.cancel();
                }
                this.myAlarm.cancelAllRequests();
                if (this.myBalloon != null && !this.myBalloon.isDisposed() && this.myPopup != null && !this.myPopup.isDisposed()) {
                    this.myBalloon.cancel();
                    this.myPopup.cancel();
                }
                SwingUtilities.invokeLater(() -> ActionToolbarImpl.updateAllToolbarsImmediately());
            }
            finally {
                result2.setDone();
            }
        });
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            RunAnythingAction.$$$reportNull$$$0(2);
        }
        return actionCallback;
    }

    private SearchTextField getField() {
        return this.myPopupField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeCommand() {
        IdeFocusManager focusManager;
        block9: {
            ActionCallback callback2;
            RunAnythingGroup group;
            String pattern = this.getField().getText();
            int index = this.myList.getSelectedIndex();
            if (pattern.isEmpty() && index == -1) {
                return;
            }
            Project project = this.getProject();
            RunAnythingSearchListModel model = RunAnythingAction.getSearchingModel(this.myList);
            if (index != -1 && model != null && this.isMoreItem(index) && (group = model.findGroupByMoreIndex(index)) != null) {
                this.myCurrentWorker.doWhenProcessed(() -> {
                    this.myCalcThread = new CalcThread(project, pattern, true);
                    this.myPopupActualWidth = 0;
                    model.triggerMoreStatistics(project, group);
                    this.myCurrentWorker = this.myCalcThread.insert(index, group);
                });
                return;
            }
            Object value = this.myList.getSelectedValue();
            focusManager = IdeFocusManager.findInstanceByComponent((Component)this.getField().getTextEditor());
            if (this.myPopup != null && this.myPopup.isVisible()) {
                this.myPopup.cancel();
            }
            if (value instanceof BooleanOptionDescription) {
                this.updateOption((BooleanOptionDescription)value);
                return;
            }
            if (model != null) {
                model.triggerExecCategoryStatistics(project, index);
            }
            Runnable onDone = null;
            try {
                DataContext dataContext = this.createDataContext(this.myDataContext, ALT_IS_PRESSED.get());
                if (SHIFT_IS_PRESSED.get()) {
                    RunAnythingUtil.triggerShiftStatistics(dataContext);
                }
                onDone = () -> RunAnythingUtil.executeMatched(dataContext, pattern);
                this.triggerUsed();
                callback2 = this.onPopupFocusLost();
                if (onDone == null) break block9;
            }
            catch (Throwable throwable) {
                this.triggerUsed();
                ActionCallback callback3 = this.onPopupFocusLost();
                if (onDone != null) {
                    callback3.doWhenDone(onDone);
                }
                throw throwable;
            }
            callback2.doWhenDone(onDone);
        }
        focusManager.requestDefaultFocus(true);
    }

    @NotNull
    private DataContext createDataContext(@NotNull DataContext parentDataContext, boolean isAltPressed) {
        if (parentDataContext == null) {
            RunAnythingAction.$$$reportNull$$$0(3);
        }
        HashMap map = ContainerUtil.newHashMap();
        map.put(CommonDataKeys.VIRTUAL_FILE.getName(), this.getWorkDirectory(this.getModule(), isAltPressed));
        map.put(EXECUTOR_KEY.getName(), RunAnythingAction.getExecutor());
        DataContext dataContext = SimpleDataContext.getSimpleContext(map, parentDataContext);
        if (dataContext == null) {
            RunAnythingAction.$$$reportNull$$$0(4);
        }
        return dataContext;
    }

    @NotNull
    private Project getProject() {
        Project project = (Project)CommonDataKeys.PROJECT.getData(this.myActionEvent.getDataContext());
        assert (project != null);
        Project project2 = project;
        if (project2 == null) {
            RunAnythingAction.$$$reportNull$$$0(5);
        }
        return project2;
    }

    @Nullable
    private Module getModule() {
        Module moduleForFile;
        Module moduleForFile2;
        Module module = (Module)this.myActionEvent.getData(LangDataKeys.MODULE);
        if (module != null) {
            return module;
        }
        Project project = this.getProject();
        if (this.myVirtualFile != null && (moduleForFile2 = ModuleUtilCore.findModuleForFile((VirtualFile)this.myVirtualFile, (Project)project)) != null) {
            return moduleForFile2;
        }
        VirtualFile[] selectedFiles = FileEditorManager.getInstance((Project)project).getSelectedFiles();
        if (selectedFiles.length != 0 && (moduleForFile = ModuleUtilCore.findModuleForFile((VirtualFile)selectedFiles[0], (Project)project)) != null) {
            return moduleForFile;
        }
        return null;
    }

    @NotNull
    private VirtualFile getWorkDirectory(@Nullable Module module, boolean isAltPressed) {
        if (isAltPressed) {
            if (this.myVirtualFile != null) {
                VirtualFile virtualFile = this.myVirtualFile.isDirectory() ? this.myVirtualFile : this.myVirtualFile.getParent();
                if (virtualFile == null) {
                    RunAnythingAction.$$$reportNull$$$0(6);
                }
                return virtualFile;
            }
            VirtualFile[] selectedFiles = FileEditorManager.getInstance((Project)this.getProject()).getSelectedFiles();
            if (selectedFiles.length > 0) {
                VirtualFile virtualFile = selectedFiles[0].getParent();
                if (virtualFile == null) {
                    RunAnythingAction.$$$reportNull$$$0(7);
                }
                return virtualFile;
            }
        }
        VirtualFile virtualFile = this.getBaseDirectory(module);
        if (virtualFile == null) {
            RunAnythingAction.$$$reportNull$$$0(8);
        }
        return virtualFile;
    }

    @NotNull
    private VirtualFile getBaseDirectory(@Nullable Module module) {
        VirtualFile projectBaseDir = this.getProject().getBaseDir();
        if (module == null) {
            VirtualFile virtualFile = projectBaseDir;
            if (virtualFile == null) {
                RunAnythingAction.$$$reportNull$$$0(9);
            }
            return virtualFile;
        }
        VirtualFile firstContentRoot = this.getFirstContentRoot(module);
        if (firstContentRoot == null) {
            VirtualFile virtualFile = projectBaseDir;
            if (virtualFile == null) {
                RunAnythingAction.$$$reportNull$$$0(10);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = firstContentRoot;
        if (virtualFile == null) {
            RunAnythingAction.$$$reportNull$$$0(11);
        }
        return virtualFile;
    }

    @Nullable
    public VirtualFile getFirstContentRoot(@NotNull Module module) {
        if (module == null) {
            RunAnythingAction.$$$reportNull$$$0(12);
        }
        if (module.isDisposed()) {
            return null;
        }
        return (VirtualFile)ArrayUtil.getFirstElement((Object[])ModuleRootManager.getInstance((Module)module).getContentRoots());
    }

    private void updateOption(BooleanOptionDescription value) {
        value.setOptionState(!value.isOptionEnabled());
        this.myList.revalidate();
        this.myList.repaint();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getField(), true));
    }

    private boolean isMoreItem(int index) {
        RunAnythingSearchListModel model = RunAnythingAction.getSearchingModel(this.myList);
        return model != null && model.isMoreIndex(index);
    }

    @Nullable
    public static RunAnythingSearchListModel getSearchingModel(@NotNull JBList list2) {
        ListModel model;
        if (list2 == null) {
            RunAnythingAction.$$$reportNull$$$0(13);
        }
        return (model = list2.getModel()) instanceof RunAnythingSearchListModel ? (RunAnythingSearchListModel)model : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildList(String pattern) {
        assert (EventQueue.isDispatchThread()) : "Must be EDT";
        if (this.myCalcThread != null && !this.myCurrentWorker.isProcessed()) {
            this.myCurrentWorker = this.myCalcThread.cancel();
        }
        if (this.myCalcThread != null && !this.myCalcThread.isCanceled()) {
            this.myCalcThread.cancel();
        }
        Object object = this.myWorkerRestartRequestLock;
        synchronized (object) {
            int currentRestartRequest = ++this.myCalcThreadRestartRequestId;
            this.myCurrentWorker.doWhenProcessed(() -> {
                Object object = this.myWorkerRestartRequestLock;
                synchronized (object) {
                    if (currentRestartRequest != this.myCalcThreadRestartRequestId) {
                        return;
                    }
                    this.myCalcThread = new CalcThread(this.getProject(), pattern, false);
                    this.myPopupActualWidth = 0;
                    this.myCurrentWorker = this.myCalcThread.start();
                }
            });
        }
    }

    public void update(AnActionEvent e) {
        boolean isEnabled = (Boolean)IS_ACTION_ENABLED.getValue();
        e.getPresentation().setVisible(isEnabled);
        e.getPresentation().setEnabled(isEnabled);
    }

    public void actionPerformed(AnActionEvent e) {
        if (Registry.is((String)"ide.suppress.double.click.handler") && e.getInputEvent() instanceof KeyEvent && ((KeyEvent)e.getInputEvent()).getKeyCode() == 17) {
            return;
        }
        this.actionPerformed(e, null);
    }

    public void actionPerformed(AnActionEvent e, MouseEvent me) {
        RelativePoint showPoint;
        Window wnd;
        if (this.myBalloon != null && this.myBalloon.isVisible()) {
            this.rebuildList(this.myPopupField.getText());
            return;
        }
        this.myCurrentWorker = ActionCallback.DONE;
        if (e != null) {
            this.myEditor = (Editor)e.getData(CommonDataKeys.EDITOR);
            this.myVirtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        }
        if (e == null && this.myFocusOwner != null) {
            e = AnActionEvent.createFromAnAction((AnAction)this, (InputEvent)me, (String)"unknown", (DataContext)DataManager.getInstance().getDataContext(this.myFocusOwner));
        }
        if (e == null) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> LookupManager.getInstance(project).hideActiveLookup());
        this.updateComponents();
        this.myContextComponent = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(e.getDataContext());
        Window window = wnd = this.myContextComponent != null ? SwingUtilities.windowForComponent(this.myContextComponent) : KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (wnd == null && this.myContextComponent instanceof Window) {
            wnd = (Window)this.myContextComponent;
        }
        if (wnd == null || wnd.getParent() != null) {
            return;
        }
        this.myActionEvent = e;
        HashMap dataMap = ContainerUtil.newHashMap();
        dataMap.put(CommonDataKeys.PROJECT.getName(), project);
        dataMap.put(LangDataKeys.MODULE.getName(), this.getModule());
        this.myDataContext = this.createDataContext(SimpleDataContext.getSimpleContext(dataMap, e.getDataContext()), ALT_IS_PRESSED.get());
        if (this.myPopupField != null) {
            Disposer.dispose((Disposable)this.myPopupField);
        }
        this.myPopupField = new MySearchTextField();
        this.myPopupField.setPreferredSize(new Dimension(500, 43));
        final JBTextField textEditor = this.myPopupField.getTextEditor();
        textEditor.setFont(UIUtil.getLabelFont().deriveFont(18.0f));
        textEditor.putClientProperty((Object)"JTextField.match", (Object)UNKNOWN_CONFIGURATION_ICON);
        this.setHandleMatchedConfiguration();
        RunAnythingAction.adjustMainListEmptyText(textEditor);
        textEditor.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                this.updateByModifierKeysEvent(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.updateByModifierKeysEvent(e);
            }

            private void updateByModifierKeysEvent(@NotNull KeyEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                String message = e.isShiftDown() && e.isAltDown() ? IdeBundle.message((String)"run.anything.run.in.context.debug.title", (Object[])new Object[0]) : (e.isShiftDown() ? IdeBundle.message((String)"run.anything.run.debug.title", (Object[])new Object[0]) : (e.isAltDown() ? IdeBundle.message((String)"run.anything.run.in.context.title", (Object[])new Object[0]) : IdeBundle.message((String)"run.anything.run.anything.title", (Object[])new Object[0])));
                RunAnythingAction.this.myTextFieldTitle.setText(message);
                RunAnythingAction.this.updateMatchedRunConfigurationStuff(e.isAltDown());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/runAnything/RunAnythingAction$9", "updateByModifierKeysEvent"));
            }
        });
        this.myPopupField.getTextEditor().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                RunAnythingAction.this.myHistoryIndex = 0;
                RunAnythingAction.this.myHistoryItem = null;
            }
        });
        this.initSearchField(this.myPopupField);
        JBTextField editor = this.myPopupField.getTextEditor();
        editor.setColumns(25);
        JPanel panel2 = new JPanel(new BorderLayout());
        this.myTextFieldTitle = new JLabel(IdeBundle.message((String)"run.anything.run.anything.title", (Object[])new Object[0]));
        NonOpaquePanel topPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        Color foregroundColor = UIUtil.isUnderDarcula() ? (UIUtil.isUnderWin10LookAndFeel() ? JBColor.WHITE : new JBColor((Color)Gray._240, (Color)Gray._200)) : UIUtil.getLabelForeground();
        this.myTextFieldTitle.setForeground(foregroundColor);
        this.myTextFieldTitle.setBorder(BorderFactory.createEmptyBorder(3, 5, 5, 0));
        if (SystemInfo.isMac) {
            this.myTextFieldTitle.setFont(this.myTextFieldTitle.getFont().deriveFont(1, (float)this.myTextFieldTitle.getFont().getSize() - 1.0f));
        } else {
            this.myTextFieldTitle.setFont(this.myTextFieldTitle.getFont().deriveFont(1));
        }
        topPanel.add((Component)this.myTextFieldTitle, "West");
        JPanel controls = new JPanel(new BorderLayout());
        controls.setOpaque(false);
        JLabel settings = new JLabel(AllIcons.General.GearPlain);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    11.$$$reportNull$$$0(0);
                }
                RunAnythingAction.this.showSettings();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/runAnything/RunAnythingAction$11", "onClick"));
            }
        }.installOn((Component)settings);
        settings.setBorder((Border)(UIUtil.isUnderWin10LookAndFeel() ? JBUI.Borders.emptyLeft((int)6) : JBUI.Borders.empty()));
        controls.add((Component)settings, "East");
        controls.setBorder((Border)(UIUtil.isUnderWin10LookAndFeel() ? JBUI.Borders.emptyTop((int)1) : JBUI.Borders.empty()));
        topPanel.add((Component)controls, "East");
        panel2.add((Component)((Object)this.myPopupField), "Center");
        panel2.add((Component)topPanel, "North");
        panel2.setBorder((Border)JBUI.Borders.empty((int)3, (int)5, (int)4, (int)5));
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RunAnythingAction.this.updateAdText(RunAnythingAction.this.myDataContext);
                Object selectedValue = RunAnythingAction.this.myList.getSelectedValue();
                if (selectedValue == null || RunAnythingAction.this.myList.getModel() instanceof RunAnythingSettingsModel) {
                    return;
                }
                String lastInput = textEditor.getText();
                RunAnythingAction.this.myIsItemSelected = true;
                if (RunAnythingAction.this.isMoreItem(RunAnythingAction.this.myList.getSelectedIndex())) {
                    textEditor.setText(RunAnythingAction.this.myLastInputText != null ? RunAnythingAction.this.myLastInputText : "");
                    return;
                }
                textEditor.setText(selectedValue instanceof RunAnythingItem ? ((RunAnythingItem)selectedValue).getCommand() : RunAnythingAction.this.myLastInputText);
                if (RunAnythingAction.this.myLastInputText == null) {
                    RunAnythingAction.this.myLastInputText = lastInput;
                }
            }
        });
        DataManager.registerDataProvider((JComponent)panel2, (DataProvider)this);
        ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)editor);
        this.myBalloon = builder2.setCancelOnClickOutside(true).setModalContext(false).setRequestFocus(true).setCancelCallback(() -> !this.mySkipFocusGain).createPopup();
        this.myBalloon.getContent().setBorder((Border)JBUI.Borders.empty());
        Window window2 = WindowManager.getInstance().suggestParentWindow(project);
        project.getMessageBus().connect((Disposable)this.myBalloon).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
            }

            public void exitDumbMode() {
                ApplicationManager.getApplication().invokeLater(() -> RunAnythingAction.this.rebuildList(RunAnythingAction.this.myPopupField.getText()));
            }
        });
        Component parent = UIUtil.findUltimateParent((Component)window2);
        if (parent != null) {
            int height;
            int n = height = UISettings.getInstance().getShowMainToolbar() ? 135 : 115;
            if (parent instanceof IdeFrameImpl && ((IdeFrameImpl)parent).isInFullScreen()) {
                height -= 20;
            }
            showPoint = new RelativePoint(parent, new Point((parent.getSize().width - panel2.getPreferredSize().width) / 2, height));
        } else {
            showPoint = JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext());
        }
        this.myList.setFont(UIUtil.getListFont());
        this.myBalloon.show(showPoint);
        this.initSearchActions(this.myBalloon, this.myPopupField);
        IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)project);
        focusManager.requestFocus((Component)editor, true);
    }

    public static void adjustEmptyText(@NotNull JBTextField textEditor, @NotNull BooleanFunction<JBTextField> function, @NotNull String leftText, @NotNull String rightText) {
        if (textEditor == null) {
            RunAnythingAction.$$$reportNull$$$0(14);
        }
        if (function == null) {
            RunAnythingAction.$$$reportNull$$$0(15);
        }
        if (leftText == null) {
            RunAnythingAction.$$$reportNull$$$0(16);
        }
        if (rightText == null) {
            RunAnythingAction.$$$reportNull$$$0(17);
        }
        textEditor.putClientProperty((Object)"StatusVisibleFunction", function);
        StatusText statusText = textEditor.getEmptyText();
        statusText.setIsVerticalFlow(false);
        statusText.setShowAboveCenter(false);
        statusText.setText(leftText, SimpleTextAttributes.GRAY_ATTRIBUTES);
        statusText.appendSecondaryText(rightText, SimpleTextAttributes.GRAY_ATTRIBUTES, null);
        statusText.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
    }

    private void setHandleMatchedConfiguration() {
        this.myPopupField.getTextEditor().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                RunAnythingAction.this.updateMatchedRunConfigurationStuff(ALT_IS_PRESSED.get());
            }
        });
    }

    private void updateMatchedRunConfigurationStuff(boolean isAltPressed) {
        JBTextField textField2 = this.myPopupField.getTextEditor();
        String pattern = textField2.getText();
        DataContext dataContext = this.createDataContext(this.myDataContext, isAltPressed);
        RunAnythingProvider provider = RunAnythingProvider.findMatchedProvider(dataContext, pattern);
        if (provider == null) {
            return;
        }
        Object value = provider.findMatchingValue(dataContext, pattern);
        if (value == null) {
            return;
        }
        Icon icon = provider.getIcon(value);
        if (icon == null) {
            return;
        }
        textField2.putClientProperty((Object)"JTextField.match", (Object)icon);
    }

    private void updateAdText(@NotNull DataContext dataContext) {
        String adText;
        RunAnythingProvider provider;
        Object value;
        if (dataContext == null) {
            RunAnythingAction.$$$reportNull$$$0(18);
        }
        if ((value = this.myList.getSelectedValue()) instanceof RunAnythingItem && (provider = RunAnythingProvider.findMatchedProvider(dataContext, ((RunAnythingItem)value).getCommand())) != null && (adText = provider.getAdText()) != null) {
            this.setAdText(adText);
        }
    }

    private void showSettings() {
        this.myPopupField.setText("");
        RunAnythingSettingsModel model = new RunAnythingSettingsModel();
        RunAnythingCompletionGroup.createCompletionGroups().stream().map(group -> new RunAnythingSEOption(this.getProject(), IdeBundle.message((String)"run.anything.group.settings.title", (Object[])new Object[]{group.getTitle()}), group.getTitle())).forEach(model::addElement);
        if (this.myCalcThread != null && !this.myCurrentWorker.isProcessed()) {
            this.myCurrentWorker = this.myCalcThread.cancel();
        }
        if (this.myCalcThread != null && !this.myCalcThread.isCanceled()) {
            this.myCalcThread.cancel();
        }
        this.myCurrentWorker.doWhenProcessed(() -> {
            this.myList.setModel((ListModel)model);
            this.updatePopupBounds();
        });
    }

    private void initSearchActions(@NotNull JBPopup balloon, @NotNull MySearchTextField searchTextField) {
        if (balloon == null) {
            RunAnythingAction.$$$reportNull$$$0(19);
        }
        if (searchTextField == null) {
            RunAnythingAction.$$$reportNull$$$0(20);
        }
        JBTextField editor = searchTextField.getTextEditor();
        DumbAwareAction.create(e -> RunAnythingUtil.jumpNextGroup(true, this.myList)).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"TAB"}), (JComponent)editor, (Disposable)balloon);
        DumbAwareAction.create(e -> RunAnythingUtil.jumpNextGroup(false, this.myList)).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"shift TAB"}), (JComponent)editor, (Disposable)balloon);
        AnAction escape = ActionManager.getInstance().getAction("EditorEscape");
        DumbAwareAction.create(e -> {
            this.triggerUsed();
            if (this.myBalloon != null && this.myBalloon.isVisible()) {
                this.myBalloon.cancel();
            }
            if (this.myPopup != null && this.myPopup.isVisible()) {
                this.myPopup.cancel();
            }
        }).registerCustomShortcutSet(escape == null ? CommonShortcuts.ESCAPE : escape.getShortcutSet(), (JComponent)editor, (Disposable)balloon);
        DumbAwareAction.create(e -> this.executeCommand()).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ENTER", "shift ENTER", "alt ENTER", "alt shift ENTER", "meta ENTER"}), (JComponent)editor, (Disposable)balloon);
        DumbAwareAction.create(e -> {
            RunAnythingSearchListModel model = RunAnythingAction.getSearchingModel(this.myList);
            if (model == null) {
                return;
            }
            Object selectedValue = this.myList.getSelectedValue();
            int index = this.myList.getSelectedIndex();
            if (!(selectedValue instanceof RunAnythingItem) || this.isMoreItem(index)) {
                return;
            }
            RunAnythingCache.getInstance(this.getProject()).getState().getCommands().remove(((RunAnythingItem)selectedValue).getCommand());
            model.remove(index);
            model.shiftIndexes(index, -1);
            if (model.size() > 0) {
                ScrollingUtil.selectItem((JList)this.myList, (int)(index < model.size() ? index : index - 1));
            }
            SwingUtilities.invokeLater(() -> {
                if (this.myCalcThread != null) {
                    this.myCalcThread.updatePopup();
                }
            });
        }).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"shift BACK_SPACE"}), (JComponent)editor, (Disposable)balloon);
        new DumbAwareAction((JTextField)editor){
            final /* synthetic */ JTextField val$editor;
            {
                this.val$editor = jTextField;
            }

            public void actionPerformed(AnActionEvent e) {
                PropertiesComponent storage2 = PropertiesComponent.getInstance((Project)e.getProject());
                String[] values = storage2.getValues(RunAnythingAction.RUN_ANYTHING_HISTORY_KEY);
                if (values != null && values.length > RunAnythingAction.this.myHistoryIndex) {
                    List data = StringUtil.split((String)values[RunAnythingAction.this.myHistoryIndex], (String)"\t");
                    RunAnythingAction.this.myHistoryItem = new RunAnythingHistoryItem((String)data.get(0), (String)data.get(1), (String)data.get(2));
                    RunAnythingAction.this.myHistoryIndex++;
                    this.val$editor.setText(((RunAnythingAction)RunAnythingAction.this).myHistoryItem.pattern);
                    this.val$editor.setCaretPosition(((RunAnythingAction)RunAnythingAction.this).myHistoryItem.pattern.length());
                    this.val$editor.moveCaretPosition(0);
                }
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(this.val$editor.getCaretPosition() == 0);
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"LEFT"}), (JComponent)editor, (Disposable)balloon);
    }

    private void triggerUsed() {
        if (this.myIsUsedTrigger) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("RunAnything");
        }
        this.myIsUsedTrigger = false;
    }

    public void setAdText(@NotNull String s) {
        if (s == null) {
            RunAnythingAction.$$$reportNull$$$0(21);
        }
        this.myPopup.setAdText(s, 2);
    }

    @NotNull
    public static Executor getExecutor() {
        Executor runExecutor = DefaultRunExecutor.getRunExecutorInstance();
        Executor debugExecutor = ExecutorRegistry.getInstance().getExecutorById(ToolWindowId.DEBUG);
        Executor executor = !SHIFT_IS_PRESSED.get() ? runExecutor : debugExecutor;
        if (executor == null) {
            RunAnythingAction.$$$reportNull$$$0(22);
        }
        return executor;
    }

    private void installActions() {
        RunAnythingScrollingUtil.installActions((JList)this.myList, (JTextField)this.getField().getTextEditor(), () -> {
            this.myIsItemSelected = true;
            this.getField().getTextEditor().setText(this.myLastInputText);
            this.clearSelection();
        }, UISettings.getInstance().getCycleScrolling());
        ScrollingUtil.installActions((JList)this.myList, (JComponent)this.getField().getTextEditor());
    }

    protected void resetFields() {
        if (this.myBalloon != null) {
            JBPopup balloonToBeCanceled = this.myBalloon;
            SwingUtilities.invokeLater(() -> balloonToBeCanceled.cancel());
            this.myBalloon = null;
        }
        this.myCurrentWorker.doWhenProcessed(() -> {
            CalcThread lock = this.myCalcThread;
            if (lock != null) {
                CalcThread calcThread = lock;
                synchronized (calcThread) {
                    this.myContextComponent = null;
                    this.myFocusOwner = null;
                    this.myPopup = null;
                    this.myHistoryIndex = 0;
                    this.myPopupActualWidth = 0;
                    this.myCurrentWorker = ActionCallback.DONE;
                    this.myCalcThread = null;
                    this.myEditor = null;
                    this.myVirtualFile = null;
                }
            }
        });
        this.mySkipFocusGain = false;
    }

    private void updatePopupBounds() {
        if (this.myPopup == null || !this.myPopup.isVisible()) {
            return;
        }
        Container parent = this.getField().getParent();
        Dimension size = this.myList.getParent().getParent().getPreferredSize();
        size.width = this.myPopupActualWidth - 2;
        if (size.width + 2 < parent.getWidth()) {
            size.width = parent.getWidth();
        }
        if (this.myList.getItemsCount() == 0) {
            size.height = JBUI.scale((int)30);
        }
        Dimension sz = new Dimension(size.width, this.myList.getPreferredSize().height);
        if (!SystemInfo.isMac) {
            if (sz.width > RunAnythingUtil.getPopupMaxWidth() || sz.height > RunAnythingUtil.getPopupMaxWidth()) {
                JBScrollPane pane = new JBScrollPane();
                int extraWidth = pane.getVerticalScrollBar().getWidth() + 1;
                int extraHeight = pane.getHorizontalScrollBar().getHeight() + 1;
                sz = new Dimension(Math.min(RunAnythingUtil.getPopupMaxWidth(), Math.max(this.getField().getWidth(), sz.width + extraWidth)), Math.min(RunAnythingUtil.getPopupMaxWidth(), sz.height + extraHeight));
                sz.width += 20;
            } else {
                sz.width += 2;
            }
        }
        sz.height += 2;
        sz.width = Math.max(sz.width, this.myPopup.getSize().width);
        this.myPopup.setSize(sz);
        if (this.myActionEvent != null && this.myActionEvent.getInputEvent() == null) {
            Point p = parent.getLocationOnScreen();
            p.y += parent.getHeight();
            if (parent.getWidth() < sz.width) {
                p.x -= sz.width - parent.getWidth();
            }
            this.myPopup.setLocation(p);
        } else {
            try {
                RunAnythingUtil.adjustPopup(this.myBalloon, this.myPopup);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        ModifierKeyDoubleClickHandler.getInstance().registerAction("RunAnything", 17, -1, false);
        IdeEventQueue.getInstance().addPostprocessor(event -> {
            if (event instanceof KeyEvent) {
                int keyCode = ((KeyEvent)event).getKeyCode();
                if (keyCode == 16) {
                    SHIFT_IS_PRESSED.set(event.getID() == 401);
                } else if (keyCode == 18) {
                    ALT_IS_PRESSED.set(event.getID() == 401);
                }
            }
            return false;
        }, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/runAnything/RunAnythingAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDataContext";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textEditor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftText";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightText";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "balloon";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchTextField";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/runAnything/RunAnythingAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "onPopupFocusLost";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkDirectory";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDirectory";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustMainListEmptyText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isHelpMode";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 22: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDataContext";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFirstContentRoot";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSearchingModel";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "adjustEmptyText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "updateAdText";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "initSearchActions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setAdText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RunAnythingSettingsModel
    extends DefaultListModel<RunAnythingSEOption> {
        private RunAnythingSettingsModel() {
        }
    }

    static class MySearchTextField
    extends SearchTextField
    implements DataProvider,
    Disposable {
        public MySearchTextField() {
            super(false, "RunAnythingHistory");
            JBTextField editor = this.getTextEditor();
            editor.setOpaque(false);
            editor.putClientProperty("JTextField.Search.noBorderRing", Boolean.TRUE);
            if (UIUtil.isUnderDarcula()) {
                editor.setBackground((Color)Gray._45);
                editor.setForeground((Color)Gray._240);
            }
        }

        protected boolean customSetupUIAndTextField(@NotNull SearchTextField.TextFieldWithProcessing textField2, @NotNull Consumer<? super TextUI> uiConsumer) {
            if (textField2 == null) {
                MySearchTextField.$$$reportNull$$$0(0);
            }
            if (uiConsumer == null) {
                MySearchTextField.$$$reportNull$$$0(1);
            }
            if (UIUtil.isUnderDarcula()) {
                uiConsumer.consume((Object)new RunAnythingIconHandler.MyDarcula());
                textField2.setBorder((Border)new DarculaTextBorder());
            } else if (SystemInfo.isMac) {
                uiConsumer.consume((Object)new RunAnythingIconHandler.MyMacUI());
                textField2.setBorder((Border)new MacIntelliJTextBorder());
            } else {
                uiConsumer.consume((Object)new RunAnythingIconHandler.MyWinUI());
                textField2.setBorder((Border)new WinIntelliJTextBorder());
            }
            return true;
        }

        protected boolean isSearchControlUISupported() {
            return true;
        }

        protected boolean hasIconsOutsideOfTextField() {
            return false;
        }

        protected void showPopup() {
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (PlatformDataKeys.PREDEFINED_TEXT.is(dataId)) {
                return this.getTextEditor().getText();
            }
            return null;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "textField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "uiConsumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/actions/runAnything/RunAnythingAction$MySearchTextField";
            objectArray[2] = "customSetupUIAndTextField";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CalcThread
    implements Runnable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final String myPattern;
        private final ProgressIndicator myProgressIndicator;
        private final ActionCallback myDone;
        @NotNull
        private final RunAnythingSearchListModel myListModel;

        public CalcThread(@NotNull Project project, String pattern, boolean reuseModel) {
            if (project == null) {
                CalcThread.$$$reportNull$$$0(0);
            }
            if (pattern == null) {
                CalcThread.$$$reportNull$$$0(1);
            }
            this.myProgressIndicator = new ProgressIndicatorBase();
            this.myDone = new ActionCallback();
            this.myProject = project;
            this.myPattern = pattern;
            RunAnythingSearchListModel model = RunAnythingAction.getSearchingModel(RunAnythingAction.this.myList);
            this.myListModel = reuseModel && model != null ? model : (RunAnythingAction.isHelpMode(pattern) ? new RunAnythingSearchListModel.RunAnythingHelpListModel() : new RunAnythingSearchListModel.RunAnythingMainListModel());
        }

        @Override
        public void run() {
            try {
                this.check();
                SwingUtilities.invokeLater(() -> {
                    RunAnythingAction.this.myList.getEmptyText().setText("Searching...");
                    if (RunAnythingAction.getSearchingModel(RunAnythingAction.this.myList) != null) {
                        RunAnythingAction.this.myAlarm.cancelAllRequests();
                        RunAnythingAction.this.myAlarm.addRequest(() -> {
                            if (!this.myDone.isRejected()) {
                                RunAnythingAction.this.myList.setModel((ListModel)this.myListModel);
                                this.updatePopup();
                            }
                        }, 50);
                    } else {
                        RunAnythingAction.this.myList.setModel((ListModel)this.myListModel);
                    }
                });
                if (this.myPattern.trim().length() == 0) {
                    this.buildGroups(true);
                    return;
                }
                if (RunAnythingAction.isHelpMode(RunAnythingAction.this.myPopupField.getText())) {
                    this.buildHelpGroups(this.myListModel);
                    return;
                }
                this.check();
                this.buildGroups(false);
            }
            catch (ProcessCanceledException ignore) {
                this.myDone.setRejected();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                this.myDone.setRejected();
            }
            finally {
                if (!this.isCanceled()) {
                    SwingUtilities.invokeLater(() -> RunAnythingAction.this.myList.getEmptyText().setText(IdeBundle.message((String)"run.anything.command.empty.list.title", (Object[])new Object[0])));
                    this.updatePopup();
                }
                if (!this.myDone.isProcessed()) {
                    this.myDone.setDone();
                }
            }
        }

        private void buildGroups(boolean isRecent) {
            this.buildAllGroups(this.myPattern, () -> this.check(), isRecent);
            this.updatePopup();
        }

        private void buildHelpGroups(@NotNull RunAnythingSearchListModel listModel) {
            if (listModel == null) {
                CalcThread.$$$reportNull$$$0(2);
            }
            listModel.getGroups().forEach(group -> {
                group.collectItems(RunAnythingAction.this.myDataContext, this.myListModel, this.trimHelpPattern(), () -> this.check());
                this.check();
            });
            this.updatePopup();
        }

        private void runReadAction(@NotNull Runnable action) {
            if (action == null) {
                CalcThread.$$$reportNull$$$0(3);
            }
            if (!DumbService.getInstance((Project)this.myProject).isDumb()) {
                ApplicationManager.getApplication().runReadAction(action);
                this.updatePopup();
            }
        }

        protected void check() {
            this.myProgressIndicator.checkCanceled();
            if (this.myDone.isRejected()) {
                throw new ProcessCanceledException();
            }
            if (RunAnythingAction.this.myBalloon == null || RunAnythingAction.this.myBalloon.isDisposed()) {
                throw new ProcessCanceledException();
            }
            assert (RunAnythingAction.this.myCalcThread == this) : "There are two CalcThreads running before one of them was cancelled";
        }

        private void buildAllGroups(@NotNull String pattern, @NotNull Runnable checkCancellation, boolean isRecent) {
            if (pattern == null) {
                CalcThread.$$$reportNull$$$0(4);
            }
            if (checkCancellation == null) {
                CalcThread.$$$reportNull$$$0(5);
            }
            if (isRecent) {
                RunAnythingRecentGroup.INSTANCE.collectItems(RunAnythingAction.this.myDataContext, this.myListModel, pattern, checkCancellation);
            } else {
                this.buildCompletionGroups(pattern, checkCancellation);
            }
        }

        private void buildCompletionGroups(@NotNull String pattern, @NotNull Runnable checkCancellation) {
            if (pattern == null) {
                CalcThread.$$$reportNull$$$0(6);
            }
            if (checkCancellation == null) {
                CalcThread.$$$reportNull$$$0(7);
            }
            LOG.assertTrue(this.myListModel instanceof RunAnythingSearchListModel.RunAnythingMainListModel);
            ((StreamEx)StreamEx.of((Object)RunAnythingRecentGroup.INSTANCE).select(RunAnythingGroup.class).append(this.myListModel.getGroups().stream().filter(group -> group instanceof RunAnythingCompletionGroup || group instanceof RunAnythingGeneralGroup).filter(group -> RunAnythingCache.getInstance(this.myProject).isGroupVisible(group.getTitle())))).forEach(group -> {
                if (pattern == null) {
                    CalcThread.$$$reportNull$$$0(13);
                }
                if (checkCancellation == null) {
                    CalcThread.$$$reportNull$$$0(14);
                }
                this.runReadAction(() -> {
                    if (pattern == null) {
                        CalcThread.$$$reportNull$$$0(15);
                    }
                    if (checkCancellation == null) {
                        CalcThread.$$$reportNull$$$0(16);
                    }
                    group.collectItems(RunAnythingAction.this.myDataContext, this.myListModel, pattern, checkCancellation);
                });
                checkCancellation.run();
            });
        }

        private boolean isCanceled() {
            return this.myProgressIndicator.isCanceled() || this.myDone.isRejected();
        }

        void updatePopup() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CalcThread.this.myListModel.update();
                    RunAnythingAction.this.myList.revalidate();
                    RunAnythingAction.this.myList.repaint();
                    RunAnythingAction.this.myRenderer.recalculateWidth();
                    if (RunAnythingAction.this.myBalloon == null || RunAnythingAction.this.myBalloon.isDisposed()) {
                        return;
                    }
                    if (RunAnythingAction.this.myPopup == null || !RunAnythingAction.this.myPopup.isVisible()) {
                        RunAnythingAction.this.installActions();
                        JBScrollPane content = new JBScrollPane((Component)RunAnythingAction.this.myList){
                            {
                                if (UIUtil.isUnderDarcula()) {
                                    this.setBorder(null);
                                }
                            }

                            public Dimension getPreferredSize() {
                                Dimension size = super.getPreferredSize();
                                Dimension listSize = RunAnythingAction.this.myList.getPreferredSize();
                                if (size.height > listSize.height || RunAnythingAction.this.myList.getModel().getSize() == 0) {
                                    size.height = Math.max(JBUI.scale((int)30), listSize.height);
                                }
                                if (RunAnythingAction.this.myBalloon != null && size.width < ((RunAnythingAction)RunAnythingAction.this).myBalloon.getSize().width) {
                                    size.width = ((RunAnythingAction)RunAnythingAction.this).myBalloon.getSize().width;
                                }
                                return size;
                            }
                        };
                        content.setHorizontalScrollBarPolicy(31);
                        content.setMinimumSize(new Dimension(((RunAnythingAction)RunAnythingAction.this).myBalloon.getSize().width, 30));
                        ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)content, null);
                        RunAnythingAction.this.myPopup = builder2.setRequestFocus(false).setCancelKeyEnabled(false).setResizable(true).setCancelCallback(() -> {
                            boolean canClose;
                            JBPopup balloon = RunAnythingAction.this.myBalloon;
                            AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
                            if (event instanceof MouseEvent) {
                                Component comp = ((MouseEvent)event).getComponent();
                                if (balloon != null && UIUtil.getWindow((Component)comp) == UIUtil.getWindow((Component)balloon.getContent())) {
                                    return false;
                                }
                            }
                            boolean bl = canClose = balloon == null || balloon.isDisposed() || !RunAnythingAction.this.getField().getTextEditor().hasFocus() && !RunAnythingAction.this.mySkipFocusGain;
                            if (canClose) {
                                PropertiesComponent.getInstance().setValue("run.anything.max.popup.width", Math.max(content.getWidth(), JBUI.scale((int)600)), JBUI.scale((int)600));
                            }
                            return canClose;
                        }).setShowShadow(false).setShowBorder(false).createPopup();
                        CalcThread.this.myProject.putUserData(RUN_ANYTHING_POPUP, (Object)RunAnythingAction.this.myPopup);
                        RunAnythingAction.this.myPopup.getContent().setBorder(null);
                        Disposer.register((Disposable)RunAnythingAction.this.myPopup, (Disposable)new Disposable(){

                            public void dispose() {
                                CalcThread.this.myProject.putUserData(RUN_ANYTHING_POPUP, null);
                                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                                    JLabel label2;
                                    Component component;
                                    RunAnythingAction.this.resetFields();
                                    SwingUtilities.invokeLater(() -> ActionToolbarImpl.updateAllToolbarsImmediately());
                                    if (RunAnythingAction.this.myActionEvent != null && RunAnythingAction.this.myActionEvent.getInputEvent() instanceof MouseEvent && (component = RunAnythingAction.this.myActionEvent.getInputEvent().getComponent()) != null && (label2 = (JLabel)UIUtil.getParentOfType(JLabel.class, (Component)component)) != null) {
                                        SwingUtilities.invokeLater(() -> label2.setIcon(AllIcons.Actions.Run_anything));
                                    }
                                    RunAnythingAction.this.myActionEvent = null;
                                    RunAnythingAction.this.myLastInputText = null;
                                });
                            }
                        });
                        RunAnythingAction.this.updatePopupBounds();
                        RunAnythingAction.this.myPopup.show(new RelativePoint((Component)RunAnythingAction.this.getField().getParent(), new Point(0, RunAnythingAction.this.getField().getParent().getHeight())));
                        ActionManager.getInstance().addAnActionListener((AnActionListener)new AnActionListener.Adapter(){

                            public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                                if (action instanceof TextComponentEditorAction) {
                                    return;
                                }
                                if (RunAnythingAction.this.myPopup != null) {
                                    RunAnythingAction.this.myPopup.cancel();
                                }
                            }
                        }, (Disposable)RunAnythingAction.this.myPopup);
                    } else {
                        RunAnythingAction.this.myList.revalidate();
                        RunAnythingAction.this.myList.repaint();
                    }
                    if (RunAnythingAction.this.myList.getModel().getSize() > 0) {
                        RunAnythingAction.this.updatePopupBounds();
                    }
                }
            });
        }

        public ActionCallback cancel() {
            this.myProgressIndicator.cancel();
            return this.myDone;
        }

        public ActionCallback insert(int index, @NotNull RunAnythingGroup group) {
            if (group == null) {
                CalcThread.$$$reportNull$$$0(8);
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (group == null) {
                    CalcThread.$$$reportNull$$$0(10);
                }
                this.runReadAction(() -> {
                    if (group == null) {
                        CalcThread.$$$reportNull$$$0(11);
                    }
                    try {
                        RunAnythingGroup.SearchResult result2 = group.getItems(RunAnythingAction.this.myDataContext, this.myListModel, this.trimHelpPattern(), true, this::check);
                        this.check();
                        SwingUtilities.invokeLater(() -> {
                            if (group == null) {
                                CalcThread.$$$reportNull$$$0(12);
                            }
                            try {
                                int shift = 0;
                                int i = index + 1;
                                for (Object o : result2) {
                                    this.myListModel.insertElementAt(o, i);
                                    ++shift;
                                    ++i;
                                }
                                this.myListModel.shiftIndexes(index, shift);
                                if (!result2.isNeedMore()) {
                                    group.resetMoreIndex();
                                }
                                RunAnythingAction.this.clearSelection();
                                ScrollingUtil.selectItem((JList)RunAnythingAction.this.myList, (int)index);
                                this.myDone.setDone();
                            }
                            catch (Exception e) {
                                this.myDone.setRejected();
                            }
                        });
                    }
                    catch (Exception e) {
                        this.myDone.setRejected();
                    }
                });
            });
            return this.myDone;
        }

        @NotNull
        public String trimHelpPattern() {
            String string = RunAnythingAction.isHelpMode(this.myPattern) ? this.myPattern.substring(RunAnythingAction.HELP_PLACEHOLDER.length()) : this.myPattern;
            if (string == null) {
                CalcThread.$$$reportNull$$$0(9);
            }
            return string;
        }

        public ActionCallback start() {
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)this);
            return this.myDone;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listModel";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 5: 
                case 7: 
                case 14: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "checkCancellation";
                    break;
                }
                case 8: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/runAnything/RunAnythingAction$CalcThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/runAnything/RunAnythingAction$CalcThread";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "trimHelpPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "buildHelpGroups";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "runReadAction";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "buildAllGroups";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "buildCompletionGroups";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "insert";
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$insert$12";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$11";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$10";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$buildCompletionGroups$9";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$8";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyListRenderer
    extends ColoredListCellRenderer {
        private final RunAnythingMyAccessibleComponent myMainPanel = new RunAnythingMyAccessibleComponent(new BorderLayout());
        private final JLabel myTitle = new JLabel();

        private MyListRenderer() {
        }

        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int width;
            String title;
            Color bg;
            Component cmp = null;
            if (RunAnythingAction.this.isMoreItem(index)) {
                cmp = RunAnythingMore.get(isSelected);
            }
            if (cmp == null) {
                if (value instanceof RunAnythingItem) {
                    cmp = ((RunAnythingItem)value).createComponent(isSelected);
                } else {
                    cmp = super.getListCellRendererComponent(list2, value, index, isSelected, isSelected);
                    JPanel p = new JPanel(new BorderLayout());
                    p.setBackground(UIUtil.getListBackground((boolean)isSelected));
                    p.add(cmp, "Center");
                    cmp = p;
                }
                if (value instanceof BooleanOptionDescription) {
                    JPanel panel2 = new JPanel(new BorderLayout());
                    panel2.setBackground(UIUtil.getListBackground((boolean)isSelected));
                    panel2.add(cmp, "Center");
                    OnOffButton button = new OnOffButton();
                    button.setSelected(((BooleanOptionDescription)value).isOptionEnabled());
                    OnOffButton rightComponent = button;
                    panel2.add((Component)rightComponent, "East");
                    JLabel settingLabel = new JLabel(RunAnythingUtil.getSettingText((OptionDescription)value));
                    settingLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
                    panel2.add((Component)settingLabel, "West");
                    panel2.add((Component)rightComponent, "East");
                    cmp = panel2;
                }
            }
            if ((bg = cmp.getBackground()) == null) {
                ((Component)cmp).setBackground(UIUtil.getListBackground((boolean)isSelected));
                bg = cmp.getBackground();
            }
            this.myMainPanel.removeAll();
            RunAnythingSearchListModel model = RunAnythingAction.getSearchingModel(RunAnythingAction.this.myList);
            if (model != null && (title = model.getTitle(index)) != null) {
                this.myTitle.setText(title);
                this.myMainPanel.add((Component)RunAnythingUtil.createTitle(" " + title), "North");
            }
            JPanel wrapped = new JPanel(new BorderLayout());
            wrapped.setBackground(bg);
            wrapped.setBorder(RENDERER_BORDER);
            wrapped.add(cmp, "Center");
            this.myMainPanel.add((Component)wrapped, "Center");
            if (cmp instanceof Accessible) {
                this.myMainPanel.setAccessible((Accessible)((Object)cmp));
            }
            if ((width = this.myMainPanel.getPreferredSize().width) > RunAnythingAction.this.myPopupActualWidth) {
                RunAnythingAction.this.myPopupActualWidth = width;
            }
            return this.myMainPanel;
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
            if (list2 == null) {
                MyListRenderer.$$$reportNull$$$0(0);
            }
        }

        public void recalculateWidth() {
            RunAnythingSearchListModel model = RunAnythingAction.getSearchingModel(RunAnythingAction.this.myList);
            if (model == null) {
                return;
            }
            this.myTitle.setIcon(EmptyIcon.ICON_16);
            this.myTitle.setFont(RunAnythingUtil.getTitleFont());
            for (int index = 0; index < model.getSize(); ++index) {
                String title = model.getTitle(index);
                if (title == null) continue;
                this.myTitle.setText(title);
            }
            this.myTitle.setForeground((Color)Gray._122);
            this.myTitle.setAlignmentY(1.0f);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/actions/runAnything/RunAnythingAction$MyListRenderer", "customizeCellRenderer"));
        }
    }
}

