/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.GotoFileConfiguration;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GotoFileAction
extends GotoActionBase
implements DumbAware {
    public static final String ID = "GotoFile";

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GotoFileAction.$$$reportNull$$$0(0);
        }
        if (Experiments.isFeatureEnabled((String)"new.search.everywhere")) {
            this.showInSearchEverywherePopup(FileSearchEverywhereContributor.class.getSimpleName(), e, true);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public void gotoActionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.file");
        final GotoFileModel gotoFileModel = new GotoFileModel(project);
        GotoActionBase.GotoActionCallback<FileType> callback2 = new GotoActionBase.GotoActionCallback<FileType>(){

            @Override
            protected ChooseByNameFilter<FileType> createFilter(@NotNull ChooseByNamePopup popup2) {
                if (popup2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new GotoFileFilter(popup2, gotoFileModel, project);
            }

            @Override
            public void elementChosen(ChooseByNamePopup popup2, Object element) {
                if (element == null) {
                    return;
                }
                ApplicationManager.getApplication().assertIsDispatchThread();
                Navigatable n = (Navigatable)element;
                if (element instanceof PsiFile) {
                    VirtualFile file2 = ((PsiFile)element).getVirtualFile();
                    if (file2 == null) {
                        return;
                    }
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file2, popup2.getLinePosition(), popup2.getColumnPosition());
                    n = descriptor.setUseCurrentWindow(popup2.isOpenInCurrentWindowRequested());
                }
                if (n.canNavigate()) {
                    n.navigate(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/ide/actions/GotoFileAction$1", "createFilter"));
            }
        };
        this.showNavigationPopup(e, gotoFileModel, callback2, IdeBundle.message((String)"go.to.file.toolwindow.title", (Object[])new Object[0]), true, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/GotoFileAction", "actionPerformed"));
    }

    public static class FileTypeComparator
    implements Comparator<FileType> {
        public static final Comparator<FileType> INSTANCE = new FileTypeComparator();

        @Override
        public int compare(FileType o1, FileType o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == FileTypes.UNKNOWN) {
                return 1;
            }
            if (o2 == FileTypes.UNKNOWN) {
                return -1;
            }
            if (o1.isBinary() && !o2.isBinary()) {
                return 1;
            }
            if (!o1.isBinary() && o2.isBinary()) {
                return -1;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }

    protected static class GotoFileFilter
    extends ChooseByNameFilter<FileType> {
        GotoFileFilter(ChooseByNamePopup popup2, GotoFileModel model, Project project) {
            super(popup2, model, GotoFileConfiguration.getInstance(project), project);
        }

        @Override
        @NotNull
        protected List<FileType> getAllFilterValues() {
            ArrayList<FileType> elements = new ArrayList<FileType>();
            ContainerUtil.addAll(elements, (Object[])FileTypeManager.getInstance().getRegisteredFileTypes());
            Collections.sort(elements, FileTypeComparator.INSTANCE);
            ArrayList<FileType> arrayList = elements;
            if (arrayList == null) {
                GotoFileFilter.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        @Override
        protected String textForFilterValue(@NotNull FileType value) {
            if (value == null) {
                GotoFileFilter.$$$reportNull$$$0(1);
            }
            return value.getName();
        }

        @Override
        protected Icon iconForFilterValue(@NotNull FileType value) {
            if (value == null) {
                GotoFileFilter.$$$reportNull$$$0(2);
            }
            return value.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/GotoFileAction$GotoFileFilter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllFilterValues";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/GotoFileAction$GotoFileFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "textForFilterValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "iconForFilterValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

