/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.GotoClassPresentationUpdater;
import com.intellij.ide.actions.searcheverywhere.ClassSearchEverywhereContributor;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNameLanguageFilter;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.GotoClassSymbolConfiguration;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.navigation.AnonymousElementProvider;
import com.intellij.navigation.ChooseByNameRegistry;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoClassAction
extends GotoActionBase
implements DumbAware {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GotoClassAction.$$$reportNull$$$0(0);
        }
        if (Experiments.isFeatureEnabled((String)"new.search.everywhere")) {
            this.showInSearchEverywherePopup(ClassSearchEverywhereContributor.class.getSimpleName(), e, true);
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        if (!DumbService.getInstance((Project)project).isDumb()) {
            super.actionPerformed(e);
        } else {
            String message = IdeBundle.message((String)"go.to.class.dumb.mode.message", (Object[])new Object[]{GotoClassPresentationUpdater.getActionTitle()});
            DumbService.getInstance((Project)project).showDumbModeNotification(message);
            AnAction action = ActionManager.getInstance().getAction("GotoFile");
            InputEvent event = ActionCommand.getInputEvent("GotoFile");
            Component component = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
            ActionManager.getInstance().tryToExecute(action, event, component, e.getPlace(), true);
        }
    }

    @Override
    public void gotoActionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GotoClassAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.class");
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final GotoClassModel2 model = new GotoClassModel2(project);
        String pluralKinds = StringUtil.capitalize((String)StringUtil.join(GotoClassPresentationUpdater.getElementKinds(), s -> StringUtil.pluralize((String)s), (String)"/"));
        String title = IdeBundle.message((String)"go.to.class.toolwindow.title", (Object[])new Object[]{pluralKinds});
        this.showNavigationPopup(e, model, new GotoActionBase.GotoActionCallback<Language>(){

            @Override
            protected ChooseByNameFilter<Language> createFilter(@NotNull ChooseByNamePopup popup2) {
                if (popup2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new ChooseByNameLanguageFilter(popup2, model, GotoClassSymbolConfiguration.getInstance(project), project);
            }

            @Override
            public void elementChosen(ChooseByNamePopup popup2, Object element) {
                GotoClassAction.handleSubMemberNavigation(popup2, element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/ide/actions/GotoClassAction$1", "createFilter"));
            }
        }, title, true);
    }

    static void handleSubMemberNavigation(ChooseByNamePopup popup2, Object element) {
        if (element instanceof PsiElement && ((PsiElement)element).isValid()) {
            OpenFileDescriptor descriptor;
            OpenFileDescriptor n;
            PsiElement psiElement = GotoClassAction.getElement((PsiElement)element, popup2);
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)(psiElement = psiElement.getNavigationElement()));
            if (file2 != null && popup2.getLinePosition() != -1 && (n = (descriptor = new OpenFileDescriptor(psiElement.getProject(), file2, popup2.getLinePosition(), popup2.getColumnPosition())).setUseCurrentWindow(popup2.isOpenInCurrentWindowRequested())).canNavigate()) {
                n.navigate(true);
                return;
            }
            if (file2 != null && popup2.getMemberPattern() != null) {
                NavigationUtil.activateFileWithPsiElement(psiElement, !popup2.isOpenInCurrentWindowRequested());
                Navigatable member = GotoClassAction.findMember(popup2.getMemberPattern(), popup2.getTrimmedText(), psiElement, file2);
                if (member != null) {
                    member.navigate(true);
                }
            }
            NavigationUtil.activateFileWithPsiElement(psiElement, !popup2.isOpenInCurrentWindowRequested());
        } else {
            EditSourceUtil.navigate((NavigationItem)((NavigationItem)element), (boolean)true, (boolean)popup2.isOpenInCurrentWindowRequested());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Navigatable findMember(String memberPattern, String fullPattern, PsiElement psiElement, VirtualFile file2) {
        PsiStructureViewFactory factory = (PsiStructureViewFactory)LanguageStructureViewBuilder.INSTANCE.forLanguage(psiElement.getLanguage());
        StructureViewBuilder builder2 = factory == null ? null : factory.getStructureViewBuilder(psiElement.getContainingFile());
        FileEditor[] editors = FileEditorManager.getInstance((Project)psiElement.getProject()).getEditors(file2);
        if (builder2 == null || editors.length == 0) {
            return null;
        }
        StructureView view = builder2.createStructureView(editors[0], psiElement.getProject());
        try {
            StructureViewTreeElement element = GotoClassAction.findElement(view.getTreeModel().getRoot(), psiElement, 4);
            if (element == null) {
                Navigatable navigatable = null;
                return navigatable;
            }
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)memberPattern).build();
            int max = Integer.MIN_VALUE;
            Object target2 = null;
            for (TreeElement treeElement : element.getChildren()) {
                int degree;
                if (!(treeElement instanceof StructureViewTreeElement)) continue;
                Object value = ((StructureViewTreeElement)treeElement).getValue();
                if (value instanceof PsiElement && value instanceof Navigatable && fullPattern.equals(CopyReferenceAction.elementToFqn((PsiElement)value))) {
                    Navigatable navigatable = (Navigatable)value;
                    return navigatable;
                }
                String presentableText = treeElement.getPresentation().getPresentableText();
                if (presentableText == null || (degree = matcher.matchingDegree(presentableText)) <= max) continue;
                max = degree;
                target2 = ((StructureViewTreeElement)treeElement).getValue();
            }
            Navigatable navigatable = target2 instanceof Navigatable ? (Navigatable)target2 : null;
            return navigatable;
        }
        finally {
            Disposer.dispose((Disposable)view);
        }
    }

    @Nullable
    private static StructureViewTreeElement findElement(StructureViewTreeElement node, PsiElement element, int hopes) {
        Object value = node.getValue();
        if (value instanceof PsiElement) {
            if (((PsiElement)value).isEquivalentTo(element)) {
                return node;
            }
            if (hopes != 0) {
                for (TreeElement child : node.getChildren()) {
                    StructureViewTreeElement e;
                    if (!(child instanceof StructureViewTreeElement) || (e = GotoClassAction.findElement((StructureViewTreeElement)child, element, hopes - 1)) == null) continue;
                    return e;
                }
            }
        }
        return null;
    }

    @NotNull
    private static PsiElement getElement(@NotNull PsiElement element, ChooseByNamePopup popup2) {
        String path;
        if (element == null) {
            GotoClassAction.$$$reportNull$$$0(2);
        }
        if ((path = popup2.getPathToAnonymous()) != null) {
            PsiElement psiElement = GotoClassAction.getElement(element, path);
            if (psiElement == null) {
                GotoClassAction.$$$reportNull$$$0(3);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            GotoClassAction.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement getElement(@NotNull PsiElement element, @NotNull String path) {
        if (element == null) {
            GotoClassAction.$$$reportNull$$$0(5);
        }
        if (path == null) {
            GotoClassAction.$$$reportNull$$$0(6);
        }
        String[] classes = path.split("\\$");
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (String cls : classes) {
            if (cls.isEmpty()) continue;
            try {
                indexes.add(Integer.parseInt(cls) - 1);
            }
            catch (Exception e) {
                PsiElement psiElement = element;
                if (psiElement == null) {
                    GotoClassAction.$$$reportNull$$$0(7);
                }
                return psiElement;
            }
        }
        PsiElement current = element;
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            PsiElement[] anonymousClasses = GotoClassAction.getAnonymousClasses(current);
            if (index >= 0 && index < anonymousClasses.length) {
                current = anonymousClasses[index];
                continue;
            }
            PsiElement psiElement = current;
            if (psiElement == null) {
                GotoClassAction.$$$reportNull$$$0(8);
            }
            return psiElement;
        }
        PsiElement psiElement = current;
        if (psiElement == null) {
            GotoClassAction.$$$reportNull$$$0(9);
        }
        return psiElement;
    }

    @NotNull
    private static PsiElement[] getAnonymousClasses(@NotNull PsiElement element) {
        if (element == null) {
            GotoClassAction.$$$reportNull$$$0(10);
        }
        for (AnonymousElementProvider provider : (AnonymousElementProvider[])Extensions.getExtensions((ExtensionPointName)AnonymousElementProvider.EP_NAME)) {
            PsiElement[] elements = provider.getAnonymousElements(element);
            if (elements.length <= 0) continue;
            if (elements == null) {
                GotoClassAction.$$$reportNull$$$0(11);
            }
            return elements;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            GotoClassAction.$$$reportNull$$$0(12);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    protected boolean hasContributors(DataContext dataContext) {
        return ChooseByNameRegistry.getInstance().getClassModelContributors().length > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/GotoClassAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/GotoClassAction";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnonymousClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "gotoActionPerformed";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAnonymousClasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

