/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.actions.searcheverywhere.ActionSearchEverywhereContributor;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoActionItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.HeldDownKeyListener;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Random;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoActionAction
extends GotoActionBase
implements DumbAware {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GotoActionAction.$$$reportNull$$$0(0);
        }
        if (Experiments.isFeatureEnabled((String)"new.search.everywhere") && e.getProject() != null) {
            this.showInSearchEverywherePopup(ActionSearchEverywhereContributor.class.getSimpleName(), e, false);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public void gotoActionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GotoActionAction.$$$reportNull$$$0(1);
        }
        final Project project = e.getProject();
        final Component component = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.action");
        GotoActionModel model = new GotoActionModel(project, component, editor);
        GotoActionBase.GotoActionCallback<Object> callback2 = new GotoActionBase.GotoActionCallback<Object>(){

            @Override
            public void elementChosen(@NotNull ChooseByNamePopup popup2, @NotNull Object element) {
                if (popup2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (project != null) {
                    project.putUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY, null);
                }
                String enteredText = popup2.getTrimmedText();
                int modifiers = popup2.isClosedByShiftEnter() ? 1 : 0;
                GotoActionAction.openOptionOrPerformAction(((GotoActionModel.MatchedValue)element).value, enteredText, project, component, modifiers);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "popup";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/actions/GotoActionAction$1";
                objectArray[2] = "elementChosen";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Pair<String, Integer> start = GotoActionAction.getInitialText(false, e);
        this.showNavigationPopup(callback2, null, GotoActionAction.createPopup(project, model, (String)start.first, (Integer)start.second, component, e), false);
    }

    @NotNull
    private static ChooseByNamePopup createPopup(@Nullable Project project, final @NotNull GotoActionModel model, String initialText, int initialIndex, final Component component, final AnActionEvent event) {
        ChooseByNamePopup oldPopup;
        if (model == null) {
            GotoActionAction.$$$reportNull$$$0(2);
        }
        ChooseByNamePopup chooseByNamePopup = oldPopup = project == null ? null : (ChooseByNamePopup)project.getUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY);
        if (oldPopup != null) {
            oldPopup.close(false);
        }
        final Disposable disposable = Disposer.newDisposable();
        final ShortcutSet altEnterShortcutSet = KeymapUtil.getActiveKeymapShortcuts((String)"ShowIntentionActions");
        KeymapManager km = KeymapManager.getInstance();
        final Keymap activeKeymap = km != null ? km.getActiveKeymap() : null;
        final ChooseByNamePopup popup2 = new ChooseByNamePopup(project, model, new GotoActionItemProvider(model), oldPopup, initialText, false, initialIndex){
            private boolean myPaintInternalInfo;

            @Override
            protected void initUI(ChooseByNamePopupComponent.Callback callback2, ModalityState modalityState, boolean allowMultipleSelection) {
                super.initUI(callback2, modalityState, allowMultipleSelection);
                this.myList.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        Object value = myList.getSelectedValue();
                        String text = this.getText(value);
                        if (text != null && myDropdownPopup != null) {
                            myDropdownPopup.setAdText(text, 2);
                        }
                        String description = this.getValueDescription(value);
                        ActionMenu.showDescriptionInStatusBar(true, myList, description);
                    }

                    @Nullable
                    private String getText(@Nullable Object o) {
                        if (o instanceof GotoActionModel.MatchedValue) {
                            GotoActionModel.ActionWrapper aw;
                            GotoActionModel.MatchedValue mv = (GotoActionModel.MatchedValue)o;
                            if (myPaintInternalInfo && mv.value instanceof GotoActionModel.ActionWrapper) {
                                AnAction action = ((GotoActionModel.ActionWrapper)mv.value).getAction();
                                String actionId = ActionManager.getInstance().getId(action);
                                return StringUtil.notNullize((String)actionId, (String)("class: " + action.getClass().getName()));
                            }
                            if (mv.value instanceof BooleanOptionDescription || mv.value instanceof GotoActionModel.ActionWrapper && ((GotoActionModel.ActionWrapper)mv.value).getAction() instanceof ToggleAction) {
                                return "Press " + KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(10, 0)) + " to toggle option";
                            }
                            if (altEnterShortcutSet.getShortcuts().length > 0 && mv.value instanceof GotoActionModel.ActionWrapper && activeKeymap != null && (aw = (GotoActionModel.ActionWrapper)mv.value).isAvailable()) {
                                boolean actionWithoutShortcuts;
                                String actionId = ActionManager.getInstance().getId(aw.getAction());
                                boolean bl = actionWithoutShortcuts = activeKeymap.getShortcuts(actionId).length == 0;
                                if (actionWithoutShortcuts && new Random().nextInt(2) > 0) {
                                    String altEnter = KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)altEnterShortcutSet);
                                    return "Press " + altEnter + " to assign a shortcut for the selected action";
                                }
                            }
                        }
                        return this.getAdText();
                    }
                });
                this.myList.addMouseMotionListener(new MouseMotionAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        int index = myList.locationToIndex(e.getPoint());
                        if (index == -1) {
                            return;
                        }
                        Object value = myList.getModel().getElementAt(index);
                        String description = this.getValueDescription(value);
                        ActionMenu.showDescriptionInStatusBar(true, myList, description);
                    }
                });
                if (Registry.is((String)"show.configurables.ids.in.settings")) {
                    new HeldDownKeyListener(){

                        protected void heldKeyTriggered(JComponent component, boolean pressed) {
                            myPaintInternalInfo = pressed;
                            ListSelectionEvent event = new ListSelectionEvent((Object)this, -1, -1, false);
                            for (ListSelectionListener listener2 : myList.getListSelectionListeners()) {
                                listener2.valueChanged(event);
                            }
                        }
                    }.installOn((JComponent)this.myTextField);
                }
            }

            @Nullable
            private String getValueDescription(@Nullable Object value) {
                if (value instanceof GotoActionModel.MatchedValue) {
                    GotoActionModel.MatchedValue mv = (GotoActionModel.MatchedValue)value;
                    if (mv.value instanceof GotoActionModel.ActionWrapper) {
                        AnAction action = ((GotoActionModel.ActionWrapper)mv.value).getAction();
                        return action.getTemplatePresentation().getDescription();
                    }
                }
                return null;
            }

            @Override
            @NotNull
            protected Set<Object> filter(@NotNull Set<Object> elements) {
                if (elements == null) {
                    2.$$$reportNull$$$0(0);
                }
                Set<Object> set2 = super.filter(model.sortItems(elements));
                if (set2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return set2;
            }

            @Override
            protected boolean closeForbidden(boolean ok) {
                if (!ok) {
                    return false;
                }
                Object element = this.getChosenElement();
                return element instanceof GotoActionModel.MatchedValue && GotoActionAction.processOptionInplace(((GotoActionModel.MatchedValue)element).value, this, component, event) || super.closeForbidden(true);
            }

            @Override
            public void setDisposed(boolean disposedFlag) {
                super.setDisposed(disposedFlag);
                Disposer.dispose((Disposable)disposable);
                ActionMenu.showDescriptionInStatusBar(true, this.myList, null);
                for (ListSelectionListener listener2 : this.myList.getListSelectionListeners()) {
                    this.myList.removeListSelectionListener(listener2);
                }
                UIUtil.dispose((Component)this.myList);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "elements";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/actions/GotoActionAction$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/actions/GotoActionAction$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "filter";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "filter";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect(disposable).subscribe(ProgressWindow.TOPIC, pw -> Disposer.register((Disposable)pw, (Disposable)new Disposable(){

            public void dispose() {
                if (!popup2.checkDisposed()) {
                    popup2.repaintList();
                }
            }
        }));
        if (project != null) {
            project.putUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY, (Object)popup2);
        }
        popup2.addMouseClickListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent me) {
                Object element;
                if (me == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((element = popup2.getSelectionByPoint(me.getPoint())) instanceof GotoActionModel.MatchedValue && GotoActionAction.processOptionInplace(((GotoActionModel.MatchedValue)element).value, popup2, component, event)) {
                    me.consume();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "me", "com/intellij/ide/actions/GotoActionAction$4", "mouseClicked"));
            }
        });
        DumbAwareAction.create(e -> {
            GotoActionModel.ActionWrapper aw;
            Comparable value;
            Object o = popup2.getChosenElement();
            if (o instanceof GotoActionModel.MatchedValue && activeKeymap != null && (value = ((GotoActionModel.MatchedValue)o).value) instanceof GotoActionModel.ActionWrapper && (aw = (GotoActionModel.ActionWrapper)value).isAvailable()) {
                String id = ActionManager.getInstance().getId(aw.getAction());
                KeymapPanel.addKeyboardShortcut(id, ActionShortcutRestrictions.getInstance().getForActionId(id), activeKeymap, component, new QuickList[0]);
            }
        }).registerCustomShortcutSet(altEnterShortcutSet, (JComponent)popup2.getTextField(), disposable);
        ChooseByNamePopup chooseByNamePopup2 = popup2;
        if (chooseByNamePopup2 == null) {
            GotoActionAction.$$$reportNull$$$0(3);
        }
        return chooseByNamePopup2;
    }

    private static boolean processOptionInplace(Object value, ChooseByNamePopup popup2, Component component, AnActionEvent e) {
        AnAction action;
        if (value instanceof BooleanOptionDescription) {
            BooleanOptionDescription option;
            option.setOptionState(!(option = (BooleanOptionDescription)value).isOptionEnabled());
            GotoActionAction.repaint(popup2);
            return true;
        }
        if (value instanceof GotoActionModel.ActionWrapper && (action = ((GotoActionModel.ActionWrapper)value).getAction()) instanceof ToggleAction) {
            GotoActionAction.performAction(action, component, e, 0, () -> GotoActionAction.repaint(popup2));
            return true;
        }
        return false;
    }

    private static void repaint(@Nullable ChooseByNamePopup popup2) {
        if (popup2 != null) {
            popup2.repaintListImmediate();
        }
    }

    public static void openOptionOrPerformAction(@NotNull Object element, String enteredText, @Nullable Project project, Component component) {
        if (element == null) {
            GotoActionAction.$$$reportNull$$$0(4);
        }
        GotoActionAction.openOptionOrPerformAction(element, enteredText, project, component, 0);
    }

    private static void openOptionOrPerformAction(Object element, String enteredText, @Nullable Project project, Component component, @JdkConstants.InputEventMask int modifiers) {
        if (element instanceof OptionDescription) {
            OptionDescription optionDescription = (OptionDescription)element;
            String configurableId = optionDescription.getConfigurableId();
            Project disposable = project != null ? project : ApplicationManager.getApplication();
            TransactionGuard guard = TransactionGuard.getInstance();
            if (optionDescription.hasExternalEditor()) {
                guard.submitTransactionLater((Disposable)disposable, () -> optionDescription.invokeInternalEditor());
            } else {
                guard.submitTransactionLater((Disposable)disposable, () -> ShowSettingsUtilImpl.showSettingsDialog(project, configurableId, enteredText));
            }
        } else {
            ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> GotoActionAction.performAction(element, component, null, modifiers, null)));
        }
    }

    public static void performAction(@NotNull Object element, @Nullable Component component, @Nullable AnActionEvent e) {
        if (element == null) {
            GotoActionAction.$$$reportNull$$$0(5);
        }
        GotoActionAction.performAction(element, component, e, 0, null);
    }

    private static void performAction(Object element, @Nullable Component component, @Nullable AnActionEvent e, @JdkConstants.InputEventMask int modifiers, @Nullable Runnable callback2) {
        if (component == null) {
            return;
        }
        AnAction action = element instanceof AnAction ? (AnAction)element : ((GotoActionModel.ActionWrapper)element).getAction();
        TransactionGuard.getInstance().submitTransactionLater((Disposable)ApplicationManager.getApplication(), () -> {
            DataManager instance = DataManager.getInstance();
            DataContext context = instance != null ? instance.getDataContext(component) : DataContext.EMPTY_CONTEXT;
            InputEvent inputEvent = e != null ? e.getInputEvent() : null;
            AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, (InputEvent)inputEvent, (String)"GoToAction", (DataContext)context);
            if (inputEvent == null && modifiers != 0) {
                event = new AnActionEvent(null, event.getDataContext(), event.getPlace(), event.getPresentation(), event.getActionManager(), modifiers);
            }
            if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action, (AnActionEvent)event, (boolean)false)) {
                if (action instanceof ActionGroup && !((ActionGroup)action).canBePerformed(context)) {
                    ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(event.getPresentation().getText(), (ActionGroup)action, context, false, callback2, -1);
                    Window window = SwingUtilities.getWindowAncestor(component);
                    if (window != null) {
                        popup2.showInCenterOf((Component)window);
                    } else {
                        popup2.showInFocusCenter();
                    }
                } else {
                    ActionManagerEx manager = ActionManagerEx.getInstanceEx();
                    manager.fireBeforeActionPerformed(action, context, event);
                    ActionUtil.performActionDumbAware((AnAction)action, (AnActionEvent)event);
                    if (callback2 != null) {
                        callback2.run();
                    }
                    manager.fireAfterActionPerformed(action, context, event);
                }
            }
        });
    }

    @Override
    protected boolean requiresProject() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/GotoActionAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/GotoActionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "gotoActionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "openOptionOrPerformAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

