/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.Patches;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ClipboardUtil;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.Consumer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.FutureResult;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.datatransfer.DataTransferer;

public class ClipboardSynchronizer
implements Disposable,
ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.ClipboardSynchronizer");
    private final ClipboardHandler myClipboardHandler = ApplicationManager.getApplication().isHeadlessEnvironment() && ApplicationManager.getApplication().isUnitTestMode() ? new HeadlessClipboardHandler() : (Patches.SLOW_GETTING_CLIPBOARD_CONTENTS && SystemInfo.isMac ? new MacClipboardHandler() : (Patches.SLOW_GETTING_CLIPBOARD_CONTENTS && SystemInfo.isXWindow ? new XWinClipboardHandler() : new ClipboardHandler()));

    public static ClipboardSynchronizer getInstance() {
        return (ClipboardSynchronizer)ApplicationManager.getApplication().getComponent(ClipboardSynchronizer.class);
    }

    public void initComponent() {
        this.myClipboardHandler.init();
    }

    public void dispose() {
        this.myClipboardHandler.dispose();
    }

    public void areDataFlavorsAvailableAsync(@NotNull Consumer<Boolean> callback2, DataFlavor ... flavors) {
        Supplier<Boolean> availabilitySupplier;
        Boolean available;
        if (callback2 == null) {
            ClipboardSynchronizer.$$$reportNull$$$0(0);
        }
        if (flavors == null) {
            ClipboardSynchronizer.$$$reportNull$$$0(1);
        }
        if ((available = (availabilitySupplier = () -> {
            if (flavors == null) {
                ClipboardSynchronizer.$$$reportNull$$$0(11);
            }
            return ClipboardUtil.handleClipboardSafely(() -> {
                if (flavors == null) {
                    ClipboardSynchronizer.$$$reportNull$$$0(12);
                }
                return this.myClipboardHandler.areDataFlavorsAvailable(flavors);
            }, () -> false);
        }).get()).booleanValue()) {
            callback2.consume((Object)available);
        } else {
            AtomicInteger counter = new AtomicInteger();
            Timer timer = new Timer(50, event -> {});
            timer.addActionListener(event -> {
                if (callback2 == null) {
                    ClipboardSynchronizer.$$$reportNull$$$0(10);
                }
                Boolean a = (Boolean)availabilitySupplier.get();
                if (counter.incrementAndGet() > 3 || a.booleanValue()) {
                    timer.stop();
                }
                callback2.consume((Object)a);
            });
            timer.start();
        }
    }

    public void getContentsAsync(@NotNull Consumer<Transferable> callback2) {
        Supplier<Transferable> transferableSupplier;
        Transferable transferable;
        if (callback2 == null) {
            ClipboardSynchronizer.$$$reportNull$$$0(2);
        }
        if ((transferable = (transferableSupplier = () -> ClipboardUtil.handleClipboardSafely(this.myClipboardHandler::getContents, () -> null)).get()) != null) {
            callback2.consume((Object)transferable);
        } else {
            AtomicInteger counter = new AtomicInteger();
            Timer timer = new Timer(50, event -> {});
            timer.addActionListener(event -> {
                if (callback2 == null) {
                    ClipboardSynchronizer.$$$reportNull$$$0(9);
                }
                Transferable t = (Transferable)transferableSupplier.get();
                if (counter.incrementAndGet() > 3) {
                    timer.stop();
                }
                callback2.consume((Object)t);
            });
            timer.start();
        }
    }

    public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
        if (flavors == null) {
            ClipboardSynchronizer.$$$reportNull$$$0(3);
        }
        return ClipboardUtil.handleClipboardSafely(() -> {
            if (flavors == null) {
                ClipboardSynchronizer.$$$reportNull$$$0(8);
            }
            return this.myClipboardHandler.areDataFlavorsAvailable(flavors);
        }, () -> false);
    }

    @Nullable
    public Transferable getContents() {
        return ClipboardUtil.handleClipboardSafely(this.myClipboardHandler::getContents, () -> null);
    }

    @Nullable
    public Object getData(@NotNull DataFlavor dataFlavor) {
        if (dataFlavor == null) {
            ClipboardSynchronizer.$$$reportNull$$$0(4);
        }
        return ClipboardUtil.handleClipboardSafely(() -> {
            if (dataFlavor == null) {
                ClipboardSynchronizer.$$$reportNull$$$0(7);
            }
            try {
                return this.myClipboardHandler.getData(dataFlavor);
            }
            catch (UnsupportedFlavorException | IOException e) {
                LOG.debug((Throwable)e);
                return null;
            }
        }, () -> null);
    }

    public void setContent(@NotNull Transferable content, @NotNull ClipboardOwner owner) {
        if (content == null) {
            ClipboardSynchronizer.$$$reportNull$$$0(5);
        }
        if (owner == null) {
            ClipboardSynchronizer.$$$reportNull$$$0(6);
        }
        this.myClipboardHandler.setContent(content, owner);
    }

    public void resetContent() {
        this.myClipboardHandler.resetContent();
    }

    @Nullable
    private static Clipboard getClipboard() {
        try {
            return Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (IllegalStateException e) {
            if (SystemInfo.isWindows) {
                LOG.debug("Clipboard is busy");
            } else {
                LOG.warn((Throwable)e);
            }
            return null;
        }
    }

    private static boolean areDataFlavorsAvailable(Transferable contents, DataFlavor ... flavors) {
        for (DataFlavor flavor : flavors) {
            if (!contents.isDataFlavorSupported(flavor)) continue;
            return true;
        }
        return false;
    }

    private static boolean areDataFlavorsAvailable(Collection<DataFlavor> contents, DataFlavor ... flavors) {
        for (DataFlavor flavor : flavors) {
            if (!contents.contains(flavor)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavors";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlavor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/ClipboardSynchronizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "areDataFlavorsAvailableAsync";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getContentsAsync";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "areDataFlavorsAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setContent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getData$12";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$areDataFlavorsAvailable$9";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getContentsAsync$8";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$areDataFlavorsAvailableAsync$4";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$areDataFlavorsAvailableAsync$2";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HeadlessClipboardHandler
    extends ClipboardHandler {
        private volatile Transferable myContent = null;

        private HeadlessClipboardHandler() {
        }

        @Override
        public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
            Transferable content;
            if (flavors == null) {
                HeadlessClipboardHandler.$$$reportNull$$$0(0);
            }
            return (content = this.myContent) != null && ClipboardSynchronizer.areDataFlavorsAvailable(content, flavors);
        }

        @Override
        public Transferable getContents() throws IllegalStateException {
            return this.myContent;
        }

        @Override
        @Nullable
        public Object getData(@NotNull DataFlavor dataFlavor) throws IOException, UnsupportedFlavorException {
            if (dataFlavor == null) {
                HeadlessClipboardHandler.$$$reportNull$$$0(1);
            }
            return this.myContent.getTransferData(dataFlavor);
        }

        @Override
        public void setContent(@NotNull Transferable content, @NotNull ClipboardOwner owner) {
            if (content == null) {
                HeadlessClipboardHandler.$$$reportNull$$$0(2);
            }
            if (owner == null) {
                HeadlessClipboardHandler.$$$reportNull$$$0(3);
            }
            this.myContent = content;
        }

        @Override
        public void resetContent() {
            this.myContent = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flavors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataFlavor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/ClipboardSynchronizer$HeadlessClipboardHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "areDataFlavorsAvailable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class XWinClipboardHandler
    extends ClipboardHandler {
        private static final String DATA_TRANSFER_TIMEOUT_PROPERTY = "sun.awt.datatransfer.timeout";
        private static final String LONG_TIMEOUT = "2000";
        private static final String SHORT_TIMEOUT = "100";
        private static final FlavorTable FLAVOR_MAP = (FlavorTable)SystemFlavorMap.getDefaultFlavorMap();
        private volatile Transferable myCurrentContent = null;

        private XWinClipboardHandler() {
        }

        @Override
        public void init() {
            if (System.getProperty(DATA_TRANSFER_TIMEOUT_PROPERTY) == null) {
                System.setProperty(DATA_TRANSFER_TIMEOUT_PROPERTY, LONG_TIMEOUT);
            }
        }

        @Override
        public void dispose() {
            this.resetContent();
        }

        @Override
        public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
            Transferable currentContent;
            if (flavors == null) {
                XWinClipboardHandler.$$$reportNull$$$0(0);
            }
            if ((currentContent = this.myCurrentContent) != null) {
                return ClipboardSynchronizer.areDataFlavorsAvailable(currentContent, flavors);
            }
            Collection<DataFlavor> contents = XWinClipboardHandler.checkContentsQuick();
            if (contents != null) {
                return ClipboardSynchronizer.areDataFlavorsAvailable(contents, flavors);
            }
            return super.areDataFlavorsAvailable(flavors);
        }

        @Override
        public Transferable getContents() throws IllegalStateException {
            Transferable currentContent = this.myCurrentContent;
            if (currentContent != null) {
                return currentContent;
            }
            Collection<DataFlavor> contents = XWinClipboardHandler.checkContentsQuick();
            if (contents != null && contents.isEmpty()) {
                return null;
            }
            return super.getContents();
        }

        @Override
        @Nullable
        public Object getData(@NotNull DataFlavor dataFlavor) throws IOException, UnsupportedFlavorException {
            Transferable currentContent;
            if (dataFlavor == null) {
                XWinClipboardHandler.$$$reportNull$$$0(1);
            }
            if ((currentContent = this.myCurrentContent) != null) {
                return currentContent.getTransferData(dataFlavor);
            }
            Collection<DataFlavor> contents = XWinClipboardHandler.checkContentsQuick();
            if (contents != null && !contents.contains(dataFlavor)) {
                return null;
            }
            return super.getData(dataFlavor);
        }

        @Override
        public void setContent(@NotNull Transferable content, @NotNull ClipboardOwner owner) {
            if (content == null) {
                XWinClipboardHandler.$$$reportNull$$$0(2);
            }
            if (owner == null) {
                XWinClipboardHandler.$$$reportNull$$$0(3);
            }
            this.myCurrentContent = content;
            super.setContent(content, owner);
        }

        @Override
        public void resetContent() {
            this.myCurrentContent = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private static Collection<DataFlavor> checkContentsQuick() {
            Clipboard clipboard = ClipboardSynchronizer.getClipboard();
            if (clipboard == null) {
                return null;
            }
            Class<?> aClass = clipboard.getClass();
            if (!"sun.awt.X11.XClipboard".equals(aClass.getName())) {
                return null;
            }
            Method getClipboardFormats = ReflectionUtil.getDeclaredMethod(aClass, (String)"getClipboardFormats", (Class[])new Class[0]);
            if (getClipboardFormats == null) {
                return null;
            }
            String timeout = System.getProperty(DATA_TRANSFER_TIMEOUT_PROPERTY);
            System.setProperty(DATA_TRANSFER_TIMEOUT_PROPERTY, SHORT_TIMEOUT);
            try {
                Set<DataFlavor> set2;
                long[] formats = (long[])getClipboardFormats.invoke((Object)clipboard, new Object[0]);
                if (formats == null || formats.length == 0) {
                    Set<DataFlavor> set3 = Collections.emptySet();
                    return set3;
                }
                Set<DataFlavor> set4 = set2 = DataTransferer.getInstance().getFlavorsForFormats(formats, FLAVOR_MAP).keySet();
                return set4;
            }
            catch (IllegalAccessException | IllegalArgumentException formats) {
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IllegalStateException) {
                    throw (IllegalStateException)cause;
                }
            }
            finally {
                System.setProperty(DATA_TRANSFER_TIMEOUT_PROPERTY, timeout);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flavors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataFlavor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/ClipboardSynchronizer$XWinClipboardHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "areDataFlavorsAvailable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MacClipboardHandler
    extends ClipboardHandler {
        private Pair<String, Transferable> myFullTransferable;

        private MacClipboardHandler() {
        }

        @Nullable
        private Transferable doGetContents() {
            return super.getContents();
        }

        @Override
        public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
            if (flavors == null) {
                MacClipboardHandler.$$$reportNull$$$0(0);
            }
            if (this.myFullTransferable == null) {
                return super.areDataFlavorsAvailable(flavors);
            }
            Transferable contents = this.getContents();
            return contents != null && ClipboardSynchronizer.areDataFlavorsAvailable(contents, flavors);
        }

        @Override
        public Transferable getContents() {
            Transferable transferable = this.doGetContents();
            if (transferable != null && this.myFullTransferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String stringData = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (stringData != null && stringData.equals(this.myFullTransferable.getFirst())) {
                        return (Transferable)this.myFullTransferable.getSecond();
                    }
                }
                catch (UnsupportedFlavorException | IOException e) {
                    LOG.info((Throwable)e);
                }
            }
            this.myFullTransferable = null;
            return transferable;
        }

        @Override
        @Nullable
        public Object getData(@NotNull DataFlavor dataFlavor) throws IOException, UnsupportedFlavorException {
            if (dataFlavor == null) {
                MacClipboardHandler.$$$reportNull$$$0(1);
            }
            if (this.myFullTransferable == null) {
                return super.getData(dataFlavor);
            }
            Transferable contents = this.getContents();
            return contents == null ? null : contents.getTransferData(dataFlavor);
        }

        @Override
        public void setContent(@NotNull Transferable content, @NotNull ClipboardOwner owner) {
            if (content == null) {
                MacClipboardHandler.$$$reportNull$$$0(2);
            }
            if (owner == null) {
                MacClipboardHandler.$$$reportNull$$$0(3);
            }
            if (Registry.is((String)"ide.mac.useNativeClipboard") && content.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String stringData = (String)content.getTransferData(DataFlavor.stringFlavor);
                    this.myFullTransferable = Pair.create((Object)stringData, (Object)content);
                    super.setContent(new StringSelection(stringData), owner);
                }
                catch (UnsupportedFlavorException | IOException e) {
                    LOG.info((Throwable)e);
                }
            } else {
                this.myFullTransferable = null;
                super.setContent(content, owner);
            }
        }

        @Nullable
        private static Transferable getContentsSafe() {
            FutureResult result2 = new FutureResult();
            Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> {
                Transferable transferable = MacClipboardHandler.getClipboardContentNatively();
                if (transferable != null) {
                    result2.set((Object)transferable);
                }
            });
            try {
                return (Transferable)result2.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (Exception ignored) {
                return null;
            }
        }

        @Nullable
        private static Transferable getClipboardContentNatively() {
            String plainText = "public.utf8-plain-text";
            ID pasteboard = Foundation.invoke((String)"NSPasteboard", (String)"generalPasteboard", (Object[])new Object[0]);
            ID types = Foundation.invoke((ID)pasteboard, (String)"types", (Object[])new Object[0]);
            ID count = Foundation.invoke((ID)types, (String)"count", (Object[])new Object[0]);
            ID plainTextType = null;
            for (int i = 0; i < count.intValue(); ++i) {
                ID each = Foundation.invoke((ID)types, (String)"objectAtIndex:", (Object[])new Object[]{i});
                String eachType = Foundation.toStringViaUTF8((ID)each);
                if (!plainText.equals(eachType)) continue;
                plainTextType = each;
                break;
            }
            StringSelection result2 = null;
            if (plainTextType != null) {
                ID text = Foundation.invoke((ID)pasteboard, (String)"stringForType:", (Object[])new Object[]{plainTextType});
                String value = Foundation.toStringViaUTF8((ID)text);
                if (value == null) {
                    LOG.info(String.format("[Clipboard] Strange string value (null?) for type: %s", plainTextType));
                } else {
                    result2 = new StringSelection(value);
                }
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flavors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataFlavor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/ClipboardSynchronizer$MacClipboardHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "areDataFlavorsAvailable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClipboardHandler {
        private ClipboardHandler() {
        }

        public void init() {
        }

        public void dispose() {
        }

        public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
            Clipboard clipboard;
            if (flavors == null) {
                ClipboardHandler.$$$reportNull$$$0(0);
            }
            if ((clipboard = ClipboardSynchronizer.getClipboard()) == null) {
                return false;
            }
            for (DataFlavor flavor : flavors) {
                if (!clipboard.isDataFlavorAvailable(flavor)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public Transferable getContents() {
            Clipboard clipboard = ClipboardSynchronizer.getClipboard();
            return clipboard == null ? null : clipboard.getContents(this);
        }

        @Nullable
        public Object getData(@NotNull DataFlavor dataFlavor) throws IOException, UnsupportedFlavorException {
            Clipboard clipboard;
            if (dataFlavor == null) {
                ClipboardHandler.$$$reportNull$$$0(1);
            }
            return (clipboard = ClipboardSynchronizer.getClipboard()) == null ? null : clipboard.getData(dataFlavor);
        }

        public void setContent(@NotNull Transferable content, @NotNull ClipboardOwner owner) {
            Clipboard clipboard;
            if (content == null) {
                ClipboardHandler.$$$reportNull$$$0(2);
            }
            if (owner == null) {
                ClipboardHandler.$$$reportNull$$$0(3);
            }
            if ((clipboard = ClipboardSynchronizer.getClipboard()) != null) {
                clipboard.setContents(content, owner);
            }
        }

        public void resetContent() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flavors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataFlavor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/ClipboardSynchronizer$ClipboardHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "areDataFlavorsAvailable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

