/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.revisions.RecentChange;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.ui.views.RecentChangeDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class RecentChangesPopup {
    public static void show(Project project, IdeaGateway gw, LocalHistoryFacade vcs) {
        List<RecentChange> cc = vcs.getRecentChanges(gw.createTransientRootEntry());
        String title = LocalHistoryBundle.message("recent.changes.popup.title", new Object[0]);
        if (cc.isEmpty()) {
            Messages.showInfoMessage((Project)project, (String)LocalHistoryBundle.message("recent.changes.to.changes", new Object[0]), (String)title);
            return;
        }
        JBPopupFactory.getInstance().createPopupChooserBuilder(cc).setSelectionMode(0).setRenderer((ListCellRenderer)new RecentChangesListCellRenderer()).setTitle(title).setItemChosenCallback(change -> new RecentChangeDialog(project, gw, (RecentChange)change).show()).createPopup().showCenteredInCurrentWindow(project);
    }

    private static class RecentChangesListCellRenderer
    implements ListCellRenderer {
        private final JPanel myPanel = new JPanel(new BorderLayout());
        private final JLabel myActionLabel = new JLabel("", 2);
        private final JLabel myDateLabel = new JLabel("", 4);
        private final JPanel mySpacePanel = new JPanel();

        public RecentChangesListCellRenderer() {
            this.myPanel.add((Component)this.myActionLabel, "West");
            this.myPanel.add((Component)this.myDateLabel, "East");
            this.myPanel.add((Component)this.mySpacePanel, "Center");
            Dimension d = new Dimension(40, this.mySpacePanel.getPreferredSize().height);
            this.mySpacePanel.setMinimumSize(d);
            this.mySpacePanel.setMaximumSize(d);
            this.mySpacePanel.setPreferredSize(d);
        }

        public Component getListCellRendererComponent(JList l, Object val, int i, boolean isSelected, boolean cellHasFocus) {
            RecentChange c = (RecentChange)val;
            this.myActionLabel.setText(c.getChangeName());
            this.myDateLabel.setText(DateFormatUtil.formatPrettyDateTime((long)c.getTimestamp()));
            this.updateColors(isSelected);
            return this.myPanel;
        }

        private void updateColors(boolean isSelected) {
            Color bg = isSelected ? UIUtil.getTableSelectionBackground() : UIUtil.getTableBackground();
            Color fg = isSelected ? UIUtil.getTableSelectionForeground() : UIUtil.getTableForeground();
            this.setColors(bg, fg, this.myPanel, this.myActionLabel, this.myDateLabel, this.mySpacePanel);
        }

        private void setColors(Color bg, Color fg, JComponent ... cc) {
            for (JComponent c : cc) {
                c.setBackground(bg);
                c.setForeground(fg);
            }
        }
    }
}

