/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl.livePreview;

import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindUtil;
import com.intellij.find.impl.FindResultImpl;
import com.intellij.find.impl.livePreview.LivePreview;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LivePreviewController
implements LivePreview.Delegate,
FindUtil.ReplaceDelegate {
    public static final int USER_ACTIVITY_TRIGGERING_DELAY = 30;
    public static final int MATCHES_LIMIT = 10000;
    protected EditorSearchSession myComponent;
    private int myUserActivityDelay;
    private final Alarm myLivePreviewAlarm;
    protected SearchResults mySearchResults;
    private LivePreview myLivePreview;
    private final boolean myReplaceDenied = false;
    private boolean mySuppressUpdate;
    private boolean myTrackingDocument;
    private boolean myChanged;
    private boolean myListeningSelection;
    private final SelectionListener mySelectionListener;
    private boolean myDisposed;
    private final DocumentListener myDocumentListener;

    public void setTrackingSelection(boolean b) {
        if (b) {
            if (!this.myListeningSelection) {
                this.getEditor().getSelectionModel().addSelectionListener(this.mySelectionListener);
            }
        } else if (this.myListeningSelection) {
            this.getEditor().getSelectionModel().removeSelectionListener(this.mySelectionListener);
        }
        this.myListeningSelection = b;
    }

    private void smartUpdate() {
        if (this.myLivePreview == null) {
            return;
        }
        this.myLivePreview.inSmartUpdate();
        FindModel findModel = this.mySearchResults.getFindModel();
        if (findModel != null) {
            this.updateInBackground(findModel, false);
        }
    }

    public void moveCursor(SearchResults.Direction direction) {
        if (direction == SearchResults.Direction.UP) {
            this.mySearchResults.prevOccurrence(false);
        } else {
            this.mySearchResults.nextOccurrence(false);
        }
    }

    public boolean isReplaceDenied() {
        return false;
    }

    public LivePreviewController(SearchResults searchResults, @Nullable EditorSearchSession component, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            LivePreviewController.$$$reportNull$$$0(0);
        }
        this.myUserActivityDelay = 30;
        this.myReplaceDenied = false;
        this.mySelectionListener = e -> this.smartUpdate();
        this.myDocumentListener = new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (!LivePreviewController.this.myTrackingDocument) {
                    LivePreviewController.this.myChanged = true;
                    return;
                }
                if (!LivePreviewController.this.mySuppressUpdate) {
                    LivePreviewController.this.smartUpdate();
                } else {
                    LivePreviewController.this.mySuppressUpdate = false;
                }
            }
        };
        this.mySearchResults = searchResults;
        this.myComponent = component;
        this.getEditor().getDocument().addDocumentListener(this.myDocumentListener);
        this.myLivePreviewAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, parentDisposable);
    }

    public int getUserActivityDelay() {
        return this.myUserActivityDelay;
    }

    public void setUserActivityDelay(int userActivityDelay) {
        this.myUserActivityDelay = userActivityDelay;
    }

    public void updateInBackground(@NotNull FindModel findModel, boolean allowedToChangedEditorSelection) {
        if (findModel == null) {
            LivePreviewController.$$$reportNull$$$0(1);
        }
        int stamp = this.mySearchResults.getStamp();
        this.myLivePreviewAlarm.cancelAllRequests();
        FindModel copy = new FindModel();
        copy.copyFrom(findModel);
        Runnable request = () -> {
            if (findModel == null) {
                LivePreviewController.$$$reportNull$$$0(3);
            }
            if (this.myDisposed) {
                return;
            }
            Project project = this.mySearchResults.getProject();
            if (project != null && project.isDisposed()) {
                return;
            }
            this.mySearchResults.updateThreadSafe(copy, allowedToChangedEditorSelection, null, stamp).doWhenRejected(() -> {
                if (findModel == null) {
                    LivePreviewController.$$$reportNull$$$0(4);
                }
                this.updateInBackground(findModel, allowedToChangedEditorSelection);
            });
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            request.run();
        } else {
            this.myLivePreviewAlarm.addRequest(request, this.myUserActivityDelay);
        }
    }

    @Override
    public String getStringToReplace(@NotNull Editor editor, @Nullable FindResult findResult) throws FindManager.MalformedReplacementStringException {
        if (editor == null) {
            LivePreviewController.$$$reportNull$$$0(2);
        }
        if (findResult == null) {
            return null;
        }
        String foundString = editor.getDocument().getText((TextRange)findResult);
        CharSequence documentText = editor.getDocument().getImmutableCharSequence();
        FindModel currentModel = this.mySearchResults.getFindModel();
        if (currentModel != null && currentModel.isReplaceState()) {
            FindManager findManager = FindManager.getInstance((Project)this.mySearchResults.getProject());
            return findManager.getStringToReplace(foundString, currentModel, findResult.getStartOffset(), documentText);
        }
        return null;
    }

    @Nullable
    public TextRange performReplace(FindResult occurrence, String replacement, Editor editor) {
        Project project = this.mySearchResults.getProject();
        if (!ReadonlyStatusHandler.ensureDocumentWritable((Project)project, (Document)editor.getDocument())) {
            return null;
        }
        FindModel findModel = this.mySearchResults.getFindModel();
        CommandProcessor.getInstance().runUndoTransparentAction(() -> this.getEditor().getCaretModel().moveToOffset(occurrence.getEndOffset()));
        TextRange result2 = FindUtil.doReplace(project, editor.getDocument(), findModel, new FindResultImpl(occurrence.getStartOffset(), occurrence.getEndOffset()), replacement, true, new ArrayList<Pair<TextRange, String>>());
        this.myLivePreview.inSmartUpdate();
        this.mySearchResults.updateThreadSafe(findModel, true, result2, this.mySearchResults.getStamp());
        return result2;
    }

    private void performReplaceAll(Editor e) {
        Project project = this.mySearchResults.getProject();
        if (!ReadonlyStatusHandler.ensureDocumentWritable((Project)project, (Document)e.getDocument())) {
            return;
        }
        if (this.mySearchResults.getFindModel() != null) {
            int offset;
            FindModel copy = new FindModel();
            copy.copyFrom(this.mySearchResults.getFindModel());
            SelectionModel selectionModel = this.mySearchResults.getEditor().getSelectionModel();
            if (!selectionModel.hasSelection() || copy.isGlobal()) {
                copy.setGlobal(true);
                offset = 0;
            } else {
                offset = selectionModel.getBlockSelectionStarts()[0];
            }
            FindUtil.replace(project, e, offset, copy, this);
        }
    }

    @Override
    public boolean shouldReplace(TextRange range2, String replace) {
        for (RangeMarker r : this.mySearchResults.getExcluded()) {
            if (!TextRange.areSegmentsEqual((Segment)r, (Segment)range2)) continue;
            return false;
        }
        return true;
    }

    public boolean canReplace() {
        if (this.mySearchResults != null && this.mySearchResults.getCursor() != null && !this.isReplaceDenied()) {
            String replacement;
            try {
                replacement = this.getStringToReplace(this.getEditor(), this.mySearchResults.getCursor());
            }
            catch (FindManager.MalformedReplacementStringException e) {
                return false;
            }
            return replacement != null;
        }
        return false;
    }

    private Editor getEditor() {
        return this.mySearchResults.getEditor();
    }

    public void performReplace() throws FindManager.MalformedReplacementStringException {
        this.mySuppressUpdate = true;
        String replacement = this.getStringToReplace(this.getEditor(), this.mySearchResults.getCursor());
        if (replacement == null) {
            return;
        }
        TextRange textRange = this.performReplace(this.mySearchResults.getCursor(), replacement, this.getEditor());
        if (textRange == null) {
            this.mySuppressUpdate = false;
        }
        if (this.myComponent != null) {
            this.myComponent.addTextToRecent(this.myComponent.getComponent().getReplaceTextComponent());
            this.myComponent.clearUndoInTextFields();
        }
    }

    public void exclude() {
        this.mySearchResults.exclude(this.mySearchResults.getCursor());
    }

    public void performReplaceAll() {
        this.performReplaceAll(this.getEditor());
    }

    public void setTrackingDocument(boolean trackingDocument) {
        this.myTrackingDocument = trackingDocument;
    }

    public void setLivePreview(LivePreview livePreview) {
        if (this.myLivePreview != null) {
            this.myLivePreview.dispose();
            this.myLivePreview.setDelegate(null);
        }
        this.myLivePreview = livePreview;
        if (this.myLivePreview != null) {
            this.myLivePreview.setDelegate(this);
        }
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.off();
        this.mySearchResults.dispose();
        this.getEditor().getDocument().removeDocumentListener(this.myDocumentListener);
        this.myDisposed = true;
    }

    public void on() {
        if (this.myDisposed) {
            return;
        }
        this.mySearchResults.setMatchesLimit(10000);
        this.setTrackingDocument(true);
        if (this.myChanged) {
            this.mySearchResults.clear();
            this.myChanged = false;
        }
        this.setLivePreview(new LivePreview(this.mySearchResults));
    }

    public void off() {
        if (this.myDisposed) {
            return;
        }
        this.setTrackingDocument(false);
        this.setLivePreview(null);
        this.setTrackingSelection(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/find/impl/livePreview/LivePreviewController";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateInBackground";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getStringToReplace";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$updateInBackground$2";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

