/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.facet.impl.ProjectFacetManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectFacetManager")
public class ProjectFacetManagerImpl
extends ProjectFacetManagerEx
implements PersistentStateComponent<ProjectFacetManagerState> {
    @NonNls
    public static final String COMPONENT_NAME = "ProjectFacetManager";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.ProjectFacetManagerImpl");
    private ProjectFacetManagerState myState = new ProjectFacetManagerState();
    private final Project myProject;
    private volatile MultiMap<FacetTypeId<?>, Module> myIndex;

    public ProjectFacetManagerImpl(Project project) {
        this.myProject = project;
        ProjectWideFacetListenersRegistry.getInstance((Project)project).registerListener((ProjectWideFacetListener)new ProjectWideFacetAdapter<Facet>(){

            public void facetAdded(Facet facet) {
                ProjectFacetManagerImpl.this.myIndex = null;
            }

            public void facetRemoved(Facet facet) {
                ProjectFacetManagerImpl.this.myIndex = null;
            }
        }, (Disposable)project);
        project.getMessageBus().connect((Disposable)project).subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    2.$$$reportNull$$$0(1);
                }
                ProjectFacetManagerImpl.this.myIndex = null;
            }

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (module == null) {
                    2.$$$reportNull$$$0(3);
                }
                ProjectFacetManagerImpl.this.myIndex = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/facet/impl/ProjectFacetManagerImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public ProjectFacetManagerState getState() {
        return this.myState;
    }

    public void loadState(@NotNull ProjectFacetManagerState state) {
        if (state == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(0);
        }
        this.myState = state;
    }

    @NotNull
    private MultiMap<FacetTypeId<?>, Module> getIndex() {
        MultiMap index = this.myIndex;
        if (index == null) {
            index = MultiMap.createLinked();
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                for (Facet facet : FacetManager.getInstance((Module)module).getAllFacets()) {
                    index.putValue((Object)facet.getTypeId(), (Object)module);
                }
            }
            this.myIndex = index;
        }
        MultiMap multiMap = index;
        if (multiMap == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(1);
        }
        return multiMap;
    }

    @NotNull
    public <F extends Facet> List<F> getFacets(@NotNull FacetTypeId<F> typeId) {
        if (typeId == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(2);
        }
        List list2 = ContainerUtil.concat((Iterable)this.getIndex().get(typeId), module -> {
            if (typeId == null) {
                ProjectFacetManagerImpl.$$$reportNull$$$0(11);
            }
            return FacetManager.getInstance((Module)module).getFacetsByType(typeId);
        });
        if (list2 == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public List<Module> getModulesWithFacet(@NotNull FacetTypeId<?> typeId) {
        if (typeId == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(4);
        }
        List<Module> list2 = Collections.unmodifiableList((List)this.getIndex().get(typeId));
        if (list2 == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(5);
        }
        return list2;
    }

    public boolean hasFacets(@NotNull FacetTypeId<?> typeId) {
        if (typeId == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(6);
        }
        return this.getIndex().containsKey(typeId);
    }

    public <F extends Facet> List<F> getFacets(@NotNull FacetTypeId<F> typeId, Module[] modules) {
        if (typeId == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(7);
        }
        ArrayList result2 = new ArrayList();
        for (Module module : modules) {
            result2.addAll(FacetManager.getInstance((Module)module).getFacetsByType(typeId));
        }
        return result2;
    }

    public <C extends FacetConfiguration> C createDefaultConfiguration(@NotNull FacetType<?, C> facetType) {
        if (facetType == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(8);
        }
        FacetConfiguration configuration = facetType.createDefaultConfiguration();
        DefaultFacetConfigurationState state = this.myState.getDefaultConfigurations().get(facetType.getStringId());
        if (state != null) {
            Element defaultConfiguration = state.getDefaultConfiguration();
            try {
                FacetUtil.loadFacetConfiguration(configuration, defaultConfiguration);
            }
            catch (InvalidDataException e) {
                LOG.info((Throwable)e);
            }
        }
        return (C)configuration;
    }

    public <C extends FacetConfiguration> void setDefaultConfiguration(@NotNull FacetType<?, C> facetType, @NotNull C configuration) {
        Map<String, DefaultFacetConfigurationState> defaultConfigurations;
        DefaultFacetConfigurationState state;
        if (facetType == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(9);
        }
        if (configuration == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(10);
        }
        if ((state = (defaultConfigurations = this.myState.getDefaultConfigurations()).get(facetType.getStringId())) == null) {
            state = new DefaultFacetConfigurationState();
            defaultConfigurations.put(facetType.getStringId(), state);
        }
        try {
            Element element = FacetUtil.saveFacetConfiguration(configuration);
            state.setDefaultConfiguration(element);
        }
        catch (WriteExternalException e) {
            LOG.info((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/ProjectFacetManagerImpl";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/ProjectFacetManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacets";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesWithFacet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFacets";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModulesWithFacet";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasFacets";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultConfiguration";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultConfiguration";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFacets$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ProjectFacetManagerState {
        private Map<String, DefaultFacetConfigurationState> myDefaultConfigurations = new HashMap<String, DefaultFacetConfigurationState>();

        @Tag(value="default-configurations")
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false, keyAttributeName="facet-type")
        public Map<String, DefaultFacetConfigurationState> getDefaultConfigurations() {
            return this.myDefaultConfigurations;
        }

        public void setDefaultConfigurations(Map<String, DefaultFacetConfigurationState> defaultConfigurations) {
            this.myDefaultConfigurations = defaultConfigurations;
        }
    }

    @Tag(value="default-facet-configuration")
    public static class DefaultFacetConfigurationState {
        private Element myDefaultConfiguration;

        @Tag(value="configuration")
        public Element getDefaultConfiguration() {
            return this.myDefaultConfiguration;
        }

        public void setDefaultConfiguration(Element defaultConfiguration) {
            this.myDefaultConfiguration = defaultConfiguration;
        }
    }
}

