/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.sm.SMStacktraceParserEx;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.execution.testframework.sm.runner.history.actions.ImportTestsGroup;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.config.Storage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTRunnerConsoleProperties
extends TestConsoleProperties
implements SMStacktraceParserEx {
    private final RunProfile myConfiguration;
    @NotNull
    private final String myTestFrameworkName;
    private final CompositeFilter myCustomFilter;
    private boolean myIdBasedTestTree;
    private boolean myPrintTestingStartedTime;

    public SMTRunnerConsoleProperties(@NotNull RunConfiguration config, @NotNull String testFrameworkName, @NotNull Executor executor) {
        if (config == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(0);
        }
        if (testFrameworkName == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(2);
        }
        this(config.getProject(), (RunProfile)config, testFrameworkName, executor);
    }

    public SMTRunnerConsoleProperties(@NotNull Project project, @NotNull RunProfile config, @NotNull String testFrameworkName, @NotNull Executor executor) {
        if (project == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(3);
        }
        if (config == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(4);
        }
        if (testFrameworkName == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(5);
        }
        if (executor == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(6);
        }
        super((Storage)SMTRunnerConsoleProperties.getStorage(testFrameworkName), project, executor);
        this.myIdBasedTestTree = false;
        this.myPrintTestingStartedTime = true;
        this.myConfiguration = config;
        this.myTestFrameworkName = testFrameworkName;
        this.myCustomFilter = new CompositeFilter(project);
    }

    @NotNull
    private static Storage.PropertiesComponentStorage getStorage(String testFrameworkName) {
        Storage.PropertiesComponentStorage propertiesComponentStorage = new Storage.PropertiesComponentStorage(testFrameworkName + "Support.", PropertiesComponent.getInstance());
        if (propertiesComponentStorage == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(7);
        }
        return propertiesComponentStorage;
    }

    @Override
    public RunProfile getConfiguration() {
        return this.myConfiguration;
    }

    @Override
    @Nullable
    protected AnAction createImportAction() {
        return new ImportTestsGroup(this);
    }

    public boolean isIdBasedTestTree() {
        return this.myIdBasedTestTree;
    }

    public void setIdBasedTestTree(boolean idBasedTestTree) {
        this.myIdBasedTestTree = idBasedTestTree;
    }

    public boolean isPrintTestingStartedTime() {
        return this.myPrintTestingStartedTime;
    }

    public void setPrintTestingStartedTime(boolean printTestingStartedTime) {
        this.myPrintTestingStartedTime = printTestingStartedTime;
    }

    @Override
    @Nullable
    public Navigatable getErrorNavigatable(@NotNull Location<?> location, @NotNull String stacktrace) {
        if (location == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(8);
        }
        if (stacktrace == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(9);
        }
        return this.getErrorNavigatable(location.getProject(), stacktrace);
    }

    @Override
    @Nullable
    public Navigatable getErrorNavigatable(final @NotNull Project project, @NotNull String stacktrace) {
        String[] lines2;
        if (project == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(10);
        }
        if (stacktrace == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(11);
        }
        if (this.myCustomFilter.isEmpty()) {
            return null;
        }
        int stacktraceLength = stacktrace.length();
        for (String line : lines2 = StringUtil.splitByLines((String)stacktrace)) {
            HyperlinkInfo info;
            Filter.Result result2;
            try {
                result2 = this.myCustomFilter.applyFilter(line, stacktraceLength);
            }
            catch (Throwable t) {
                throw new RuntimeException("Error while applying " + this.myCustomFilter + " to '" + line + "'", t);
            }
            HyperlinkInfo hyperlinkInfo = info = result2 != null ? result2.getFirstHyperlinkInfo() : null;
            if (info == null) continue;
            if (info instanceof FileHyperlinkInfo) {
                return ((FileHyperlinkInfo)info).getDescriptor();
            }
            return new Navigatable(){

                public void navigate(boolean requestFocus) {
                    info.navigate(project);
                }

                public boolean canNavigate() {
                    return true;
                }

                public boolean canNavigateToSource() {
                    return true;
                }
            };
        }
        return null;
    }

    public void addStackTraceFilter(Filter filter) {
        this.myCustomFilter.addFilter(filter);
    }

    @Deprecated
    @Nullable
    protected Navigatable findSuitableNavigatableForLine(@NotNull Project project, @NotNull VirtualFile file2, int line) {
        Document doc;
        PsiFile psi;
        if (project == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(13);
        }
        PsiFile psiFile = psi = (doc = FileDocumentManager.getInstance().getDocument(file2)) == null ? null : PsiDocumentManager.getInstance((Project)project).getPsiFile(doc);
        if (psi == null) {
            return null;
        }
        int offset = doc.getLineStartOffset(line);
        int endOffset = doc.getLineEndOffset(line);
        for (int i = offset + 1; i < endOffset; ++i) {
            PsiElement el = psi.findElementAt(i);
            if (el == null || el instanceof PsiWhiteSpace) continue;
            offset = el.getTextOffset();
            break;
        }
        return new OpenFileDescriptor(project, file2, offset);
    }

    public boolean fixEmptySuite() {
        return false;
    }

    @Nullable
    public SMTestLocator getTestLocator() {
        return null;
    }

    @Nullable
    public TestProxyFilterProvider getFilterProvider() {
        return null;
    }

    @Nullable
    public AbstractRerunFailedTestsAction createRerunFailedTestsAction(ConsoleView consoleView) {
        return null;
    }

    @NotNull
    public String getTestFrameworkName() {
        String string = this.myTestFrameworkName;
        if (string == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(14);
        }
        return string;
    }

    public boolean isUndefined() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacktrace";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorage";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFrameworkName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 14: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getErrorNavigatable";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableNavigatableForLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

