/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.PanelContentUI;
import com.intellij.execution.dashboard.RunDashboardAnimator;
import com.intellij.execution.dashboard.RunDashboardContent;
import com.intellij.execution.dashboard.RunDashboardContributor;
import com.intellij.execution.dashboard.RunDashboardGroupingRule;
import com.intellij.execution.dashboard.RunDashboardListener;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.tree.RunDashboardGrouper;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="RunDashboard", storages={@Storage(value="$WORKSPACE_FILE$")})
public class RunDashboardManagerImpl
implements RunDashboardManager,
PersistentStateComponent<State> {
    private static final float DEFAULT_CONTENT_PROPORTION = 0.3f;
    @NonNls
    private static final String HELP_ID = "run-dashboard.reference";
    @NotNull
    private final Project myProject;
    @NotNull
    private final ContentManager myContentManager;
    @NotNull
    private final ContentManagerListener myContentManagerListener;
    @NotNull
    private State myState;
    @NotNull
    private final List<RunDashboardGrouper> myGroupers;
    @NotNull
    private final Condition<Content> myReuseCondition;
    @NotNull
    private final AtomicBoolean myListenersInitialized;
    private boolean myShowConfigurations;
    private RunDashboardContent myDashboardContent;
    private Content myToolWindowContent;
    private ContentManager myToolWindowContentManager;
    private ContentManagerListener myToolWindowContentManagerListener;
    private final Map<Content, Content> myDashboardToToolWindowContents;

    public RunDashboardManagerImpl(@NotNull Project project) {
        if (project == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(0);
        }
        this.myState = new State();
        this.myListenersInitialized = new AtomicBoolean();
        this.myShowConfigurations = true;
        this.myDashboardToToolWindowContents = new HashMap<Content, Content>();
        this.myProject = project;
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        PanelContentUI contentUI = new PanelContentUI();
        this.myContentManager = contentFactory.createContentManager((ContentUI)contentUI, false, project);
        this.myContentManagerListener = new DashboardContentManagerListener();
        this.myContentManager.addContentManagerListener(this.myContentManagerListener);
        this.myReuseCondition = this::canReuseContent;
        this.myGroupers = Arrays.stream(RunDashboardGroupingRule.EP_NAME.getExtensions()).map(RunDashboardGrouper::new).collect(Collectors.toList());
    }

    private void initToolWindowContentListeners() {
        if (!this.myListenersInitialized.compareAndSet(false, true)) {
            return;
        }
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){
            private volatile boolean myUpdateStarted;

            @Override
            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!this.myUpdateStarted) {
                    RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
                }
            }

            @Override
            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!this.myUpdateStarted) {
                    RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
                }
            }

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!this.myUpdateStarted) {
                    RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
                }
            }

            @Override
            public void beginUpdate() {
                this.myUpdateStarted = true;
            }

            @Override
            public void endUpdate() {
                this.myUpdateStarted = false;
                RunDashboardManagerImpl.this.updateDashboard(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "settings";
                objectArray2[1] = "com/intellij/execution/dashboard/RunDashboardManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2) {
                if (executorId == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (env == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (handler2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                RunDashboardManagerImpl.this.updateToolWindowContent();
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(env.getRunnerAndConfigurationSettings());
            }

            public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2, int exitCode) {
                if (executorId == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (env == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (handler2 == null) {
                    2.$$$reportNull$$$0(5);
                }
                RunDashboardManagerImpl.this.updateToolWindowContent();
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(env.getRunnerAndConfigurationSettings());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorId";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "env";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/dashboard/RunDashboardManagerImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStarted";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(RunDashboardManager.DASHBOARD_TOPIC, (Object)new RunDashboardListener(){

            public void contentChanged(boolean withStructure) {
                RunDashboardManagerImpl.this.updateDashboard(withStructure);
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void exitDumbMode() {
                RunDashboardManagerImpl.this.updateDashboard(false);
            }
        });
        this.myContentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(ContentManagerEvent event) {
                RunDashboardManagerImpl.this.updateToolWindowContent();
                RunDashboardManagerImpl.this.updateDashboard(true);
            }

            public void contentRemoved(ContentManagerEvent event) {
                if (RunDashboardManagerImpl.this.myContentManager.getContentCount() == 0 && !RunDashboardManagerImpl.this.isShowConfigurations()) {
                    RunDashboardManagerImpl.this.setShowConfigurations(true);
                }
            }
        });
    }

    public ContentManager getDashboardContentManager() {
        return this.myContentManager;
    }

    public String getToolWindowId() {
        return ToolWindowId.RUN_DASHBOARD;
    }

    public Icon getToolWindowIcon() {
        return AllIcons.Toolwindows.ToolWindowRun;
    }

    public String getToolWindowContextHelpId() {
        return HELP_ID;
    }

    public boolean isToolWindowAvailable() {
        return this.hasContent();
    }

    public void createToolWindowContent(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(1);
        }
        this.myDashboardContent = new RunDashboardContent(this.myProject, this.myContentManager, this.myGroupers);
        this.myToolWindowContent = ContentFactory.SERVICE.getInstance().createContent((JComponent)this.myDashboardContent, null, false);
        this.myToolWindowContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        this.myToolWindowContent.setHelpId(this.getToolWindowContextHelpId());
        this.myToolWindowContent.setCloseable(false);
        Disposer.register((Disposable)this.myToolWindowContent, (Disposable)this.myDashboardContent);
        Disposer.register((Disposable)this.myToolWindowContent, () -> {
            this.myDashboardContent = null;
            this.myToolWindowContent = null;
            this.myToolWindowContentManager.removeContentManagerListener(this.myToolWindowContentManagerListener);
            this.myToolWindowContentManager = null;
            this.myToolWindowContentManagerListener = null;
            this.myDashboardToToolWindowContents.clear();
        });
        this.myToolWindowContentManager = toolWindow.getContentManager();
        this.myToolWindowContentManager.addContent(this.myToolWindowContent);
        this.myToolWindowContentManagerListener = new ToolWindowContentManagerListener();
        this.myToolWindowContentManager.addContentManagerListener(this.myToolWindowContentManagerListener);
    }

    public List<Pair<RunnerAndConfigurationSettings, RunContentDescriptor>> getRunConfigurations() {
        ArrayList<Pair<RunnerAndConfigurationSettings, RunContentDescriptor>> result2 = new ArrayList<Pair<RunnerAndConfigurationSettings, RunContentDescriptor>>();
        List<RunnerAndConfigurationSettings> configurations = RunManager.getInstance((Project)this.myProject).getAllSettings().stream().filter(settings -> this.myState.configurationTypes.contains(settings.getType().getId())).collect(Collectors.toList());
        ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance(this.myProject);
        configurations.forEach(configurationSettings -> {
            List<RunContentDescriptor> descriptors = this.filterByContent(executionManager.getDescriptors((Condition<RunnerAndConfigurationSettings>)((Condition)settings -> Comparing.equal((Object)settings.getConfiguration(), (Object)configurationSettings.getConfiguration()))));
            if (descriptors.isEmpty() && this.isShowInDashboard(configurationSettings.getConfiguration())) {
                result2.add(Pair.create((Object)configurationSettings, null));
            } else {
                descriptors.forEach(descriptor -> result2.add(Pair.create((Object)configurationSettings, (Object)descriptor)));
            }
        });
        List storedConfigurations = configurations.stream().map(RunnerAndConfigurationSettings::getConfiguration).collect(Collectors.toList());
        List<RunContentDescriptor> notStoredDescriptors = this.filterByContent(executionManager.getDescriptors((Condition<RunnerAndConfigurationSettings>)((Condition)settings -> !storedConfigurations.contains(settings.getConfiguration()))));
        notStoredDescriptors.forEach(descriptor -> {
            Set<RunnerAndConfigurationSettings> settings = executionManager.getConfigurations((RunContentDescriptor)descriptor);
            settings.forEach(setting -> result2.add(Pair.create((Object)setting, (Object)descriptor)));
        });
        return result2;
    }

    private List<RunContentDescriptor> filterByContent(List<RunContentDescriptor> descriptors) {
        return descriptors.stream().filter(descriptor -> {
            Content content = descriptor.getAttachedContent();
            return content != null && content.getManager() == this.myContentManager;
        }).collect(Collectors.toList());
    }

    public boolean isShowConfigurations() {
        return this.myShowConfigurations;
    }

    public void setShowConfigurations(boolean value) {
        this.myShowConfigurations = value;
        this.updateToolWindowContent();
        this.updateDashboard(false);
    }

    public float getContentProportion() {
        return this.myState.contentProportion;
    }

    public RunDashboardAnimator getAnimator() {
        if (this.myDashboardContent == null) {
            return null;
        }
        return this.myDashboardContent.getAnimator();
    }

    public boolean isShowInDashboard(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(2);
        }
        if (this.myState.configurationTypes.contains(runConfiguration.getType().getId())) {
            RunDashboardContributor contributor = this.getContributor(runConfiguration.getType());
            return contributor == null || contributor.isShowInDashboard(runConfiguration);
        }
        return false;
    }

    @NotNull
    public Set<String> getTypes() {
        Set<String> set2 = Collections.unmodifiableSet(this.myState.configurationTypes);
        if (set2 == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(3);
        }
        return set2;
    }

    public void setTypes(@NotNull Set<String> types) {
        if (types == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(4);
        }
        this.myState.configurationTypes.clear();
        this.myState.configurationTypes.addAll(types);
        if (!this.myState.configurationTypes.isEmpty()) {
            this.initToolWindowContentListeners();
        }
        this.updateDashboard(true);
    }

    @Nullable
    public RunDashboardContributor getContributor(@NotNull ConfigurationType type) {
        if (type == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(5);
        }
        for (RunDashboardContributor contributor : (RunDashboardContributor[])RunDashboardContributor.EP_NAME.getExtensions()) {
            if (!type.equals(contributor.getType())) continue;
            return contributor;
        }
        return null;
    }

    private void updateDashboardIfNeeded(@Nullable RunnerAndConfigurationSettings settings) {
        if (settings != null && (this.getContributor(settings.getType()) != null || this.isShowInDashboard(settings.getConfiguration()))) {
            this.updateDashboard(true);
        }
    }

    @NotNull
    public Condition<Content> getReuseCondition() {
        Condition<Content> condition = this.myReuseCondition;
        if (condition == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(6);
        }
        return condition;
    }

    private boolean canReuseContent(Content content) {
        RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
        if (descriptor == null) {
            return false;
        }
        ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance(this.myProject);
        Set<RunnerAndConfigurationSettings> descriptorConfigurations = executionManager.getConfigurations(descriptor);
        if (descriptorConfigurations.isEmpty()) {
            return true;
        }
        HashSet storedConfigurations = new HashSet(RunManager.getInstance((Project)this.myProject).getAllConfigurationsList());
        return descriptorConfigurations.stream().noneMatch(descriptorConfiguration -> {
            RunConfiguration configuration = descriptorConfiguration.getConfiguration();
            return this.isShowInDashboard(configuration) && storedConfigurations.contains(configuration);
        });
    }

    public void updateDashboard(boolean withStructure) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        if (toolWindowManager == null) {
            return;
        }
        toolWindowManager.invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (withStructure) {
                boolean available = this.hasContent();
                ToolWindow toolWindow = toolWindowManager.getToolWindow(this.getToolWindowId());
                if (toolWindow == null) {
                    if (!this.myState.configurationTypes.isEmpty() || available) {
                        toolWindow = this.createToolWindow(toolWindowManager, available);
                    }
                    if (available) {
                        toolWindow.show(null);
                    }
                    return;
                }
                boolean doShow = !toolWindow.isAvailable() && available;
                toolWindow.setAvailable(available, null);
                if (doShow) {
                    toolWindow.show(null);
                }
            }
            if (this.myDashboardContent != null) {
                this.myDashboardContent.updateContent(withStructure);
            }
        });
    }

    private ToolWindow createToolWindow(ToolWindowManager toolWindowManager, boolean available) {
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(this.getToolWindowId(), true, ToolWindowAnchor.BOTTOM, (Disposable)this.myProject, true);
        toolWindow.setIcon(this.getToolWindowIcon());
        toolWindow.setAvailable(available, null);
        this.createToolWindowContent(toolWindow);
        return toolWindow;
    }

    private boolean hasContent() {
        return !this.getRunConfigurations().isEmpty();
    }

    private void updateToolWindowContent() {
        AppUIUtil.invokeLaterIfProjectAlive(this.myProject, () -> {
            if (this.myToolWindowContent == null || this.myToolWindowContentManager == null || this.myToolWindowContentManagerListener == null) {
                return;
            }
            boolean containsConfigurationsContent = false;
            for (Content content : this.myToolWindowContentManager.getContents()) {
                if (!this.myToolWindowContent.equals(content)) continue;
                containsConfigurationsContent = true;
                break;
            }
            if (this.myShowConfigurations) {
                if (!containsConfigurationsContent) {
                    this.myToolWindowContentManager.removeContentManagerListener(this.myToolWindowContentManagerListener);
                    this.myDashboardToToolWindowContents.clear();
                    this.myToolWindowContentManager.removeAllContents(true);
                    this.myToolWindowContentManager.addContent(this.myToolWindowContent);
                    this.myToolWindowContentManager.addContentManagerListener(this.myToolWindowContentManagerListener);
                }
                this.updateToolWindowContentTabHeader(this.myContentManager.getSelectedContent());
            } else if (containsConfigurationsContent) {
                this.myToolWindowContentManager.removeContentManagerListener(this.myToolWindowContentManagerListener);
                this.myToolWindowContentManager.removeContent(this.myToolWindowContent, false);
                for (Content dashboardContent : this.myContentManager.getContents()) {
                    this.addToolWindowContent(dashboardContent);
                }
                Content contentToSelect = this.myDashboardToToolWindowContents.get(this.myContentManager.getSelectedContent());
                if (contentToSelect != null) {
                    this.myToolWindowContentManager.setSelectedContent(contentToSelect, true);
                }
                this.myToolWindowContentManager.addContentManagerListener(this.myToolWindowContentManagerListener);
            }
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
            if (toolWindowManager == null) {
                return;
            }
            ToolWindow toolWindow = toolWindowManager.getToolWindow(this.getToolWindowId());
            if (toolWindow instanceof ToolWindowImpl) {
                ToolWindowContentUi contentUi = ((ToolWindowImpl)toolWindow).getContentUI();
                contentUi.revalidate();
                contentUi.repaint();
            }
        });
    }

    private void addToolWindowContent(final Content dashboardContent) {
        if (this.myToolWindowContentManager == null) {
            return;
        }
        final Content toolWindowContent = ContentFactory.SERVICE.getInstance().createContent((JComponent)this.myDashboardContent, dashboardContent.getDisplayName(), false);
        toolWindowContent.setIcon(dashboardContent.getIcon());
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String property = evt.getPropertyName();
                if ("displayName".equals(property)) {
                    toolWindowContent.setDisplayName(dashboardContent.getDisplayName());
                } else if ("icon".equals(property)) {
                    toolWindowContent.setIcon(dashboardContent.getIcon());
                }
            }
        };
        Disposer.register((Disposable)toolWindowContent, () -> dashboardContent.removePropertyChangeListener(propertyChangeListener));
        dashboardContent.addPropertyChangeListener(propertyChangeListener);
        toolWindowContent.setShouldDisposeContent(false);
        toolWindowContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        toolWindowContent.setHelpId(this.getToolWindowContextHelpId());
        this.myToolWindowContentManager.addContent(toolWindowContent);
        this.myDashboardToToolWindowContents.put(dashboardContent, toolWindowContent);
    }

    private void updateToolWindowContentTabHeader(@Nullable Content content) {
        if (content != null) {
            this.myToolWindowContent.setDisplayName(content.getDisplayName());
            this.myToolWindowContent.setIcon(content.getIcon());
            this.myToolWindowContent.setCloseable(true);
        } else {
            this.myToolWindowContent.setDisplayName(null);
            this.myToolWindowContent.setIcon(null);
            this.myToolWindowContent.setCloseable(false);
        }
    }

    @Nullable
    public State getState() {
        List<RuleState> ruleStates = this.myState.ruleStates;
        ruleStates.clear();
        for (RunDashboardGrouper grouper : this.myGroupers) {
            if (grouper.getRule().isAlwaysEnabled()) continue;
            ruleStates.add(new RuleState(grouper.getRule().getName(), grouper.isEnabled()));
        }
        if (this.myDashboardContent != null) {
            this.myState.contentProportion = this.myDashboardContent.getContentProportion();
        }
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(7);
        }
        this.myState = state;
        if (!this.myState.configurationTypes.isEmpty()) {
            this.initToolWindowContentListeners();
        }
        block0: for (RuleState ruleState : state.ruleStates) {
            for (RunDashboardGrouper grouper : this.myGroupers) {
                if (!grouper.getRule().getName().equals(ruleState.name) || grouper.getRule().isAlwaysEnabled()) continue;
                grouper.setEnabled(ruleState.enabled);
                continue block0;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/dashboard/RunDashboardManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/dashboard/RunDashboardManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReuseCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowContent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isShowInDashboard";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTypes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContributor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ToolWindowContentManagerListener
    extends ContentManagerAdapter {
        private ToolWindowContentManagerListener() {
        }

        public void contentRemoveQuery(ContentManagerEvent event) {
            if (event.getContent().equals(RunDashboardManagerImpl.this.myToolWindowContent)) {
                Content content = RunDashboardManagerImpl.this.myContentManager.getSelectedContent();
                if (content != null) {
                    RunDashboardManagerImpl.this.myContentManager.removeContent(content, true);
                }
                event.consume();
                return;
            }
            Content dashboardContent = this.getDashboardContent(event.getContent());
            if (dashboardContent == null || dashboardContent.getManager() == null) {
                return;
            }
            RunDashboardManagerImpl.this.myDashboardToToolWindowContents.remove(dashboardContent);
            if (!RunDashboardManagerImpl.this.myContentManager.removeContent(dashboardContent, true)) {
                event.consume();
                RunDashboardManagerImpl.this.myDashboardToToolWindowContents.put(dashboardContent, event.getContent());
            }
        }

        public void selectionChanged(ContentManagerEvent event) {
            if (event.getContent().equals(RunDashboardManagerImpl.this.myToolWindowContent)) {
                return;
            }
            if (event.getOperation() != ContentManagerEvent.ContentOperation.add) {
                return;
            }
            Content dashboardContent = this.getDashboardContent(event.getContent());
            if (dashboardContent == null || dashboardContent.getManager() == null || RunDashboardManagerImpl.this.myContentManager.isSelected(dashboardContent)) {
                return;
            }
            RunDashboardManagerImpl.this.myContentManager.removeContentManagerListener(RunDashboardManagerImpl.this.myContentManagerListener);
            RunDashboardManagerImpl.this.myContentManager.setSelectedContent(dashboardContent);
            RunDashboardManagerImpl.this.myContentManager.addContentManagerListener(RunDashboardManagerImpl.this.myContentManagerListener);
        }

        private Content getDashboardContent(Content content) {
            for (Map.Entry entry : RunDashboardManagerImpl.this.myDashboardToToolWindowContents.entrySet()) {
                if (!((Content)entry.getValue()).equals(content)) continue;
                return (Content)entry.getKey();
            }
            return null;
        }
    }

    private class DashboardContentManagerListener
    extends ContentManagerAdapter {
        private DashboardContentManagerListener() {
        }

        public void contentAdded(ContentManagerEvent event) {
            if (RunDashboardManagerImpl.this.myShowConfigurations || RunDashboardManagerImpl.this.myToolWindowContentManager == null) {
                return;
            }
            Content toolWindowContent = (Content)RunDashboardManagerImpl.this.myDashboardToToolWindowContents.get(event.getContent());
            if (toolWindowContent == null) {
                RunDashboardManagerImpl.this.addToolWindowContent(event.getContent());
            } else if (!RunDashboardManagerImpl.this.myToolWindowContentManager.isSelected(toolWindowContent)) {
                RunDashboardManagerImpl.this.myToolWindowContentManager.setSelectedContent(toolWindowContent);
            }
        }

        public void contentRemoved(ContentManagerEvent event) {
            if (RunDashboardManagerImpl.this.myShowConfigurations || RunDashboardManagerImpl.this.myToolWindowContentManager == null) {
                return;
            }
            Content toolWindowContent = (Content)RunDashboardManagerImpl.this.myDashboardToToolWindowContents.remove(event.getContent());
            if (toolWindowContent != null && toolWindowContent.getManager() != null) {
                RunDashboardManagerImpl.this.myToolWindowContentManager.removeContentManagerListener(RunDashboardManagerImpl.this.myToolWindowContentManagerListener);
                RunDashboardManagerImpl.this.myToolWindowContentManager.removeContent(toolWindowContent, true);
                RunDashboardManagerImpl.this.myToolWindowContentManager.addContentManagerListener(RunDashboardManagerImpl.this.myToolWindowContentManagerListener);
            }
        }

        public void selectionChanged(ContentManagerEvent event) {
            if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                this.contentAdded(event);
            }
            if (RunDashboardManagerImpl.this.myToolWindowContentManager == null || RunDashboardManagerImpl.this.myToolWindowContent == null || !RunDashboardManagerImpl.this.myShowConfigurations) {
                return;
            }
            Content content = event.getOperation() == ContentManagerEvent.ContentOperation.add ? event.getContent() : null;
            RunDashboardManagerImpl.this.updateToolWindowContentTabHeader(content);
        }
    }

    private static class RuleState {
        public String name;
        public boolean enabled = true;

        RuleState() {
        }

        RuleState(String name, boolean enabled) {
            this.name = name;
            this.enabled = enabled;
        }
    }

    static class State {
        public final Set<String> configurationTypes = new THashSet();
        public final List<RuleState> ruleStates = new ArrayList<RuleState>();
        public float contentProportion = 0.3f;

        State() {
        }
    }
}

