/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.AppTopics;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.execution.console.ConsoleHistoryModel;
import com.intellij.execution.console.ConsoleHistoryModelProvider;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.HistoryRootType;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actions.ContentChooser;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.XppReader;
import gnu.trove.TObjectHashingStrategy;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

public class ConsoleHistoryController {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.execution.console.ConsoleHistoryController");
    private static final Map<LanguageConsoleView, ConsoleHistoryController> ourControllers = ContainerUtil.createConcurrentWeakMap((TObjectHashingStrategy)ContainerUtil.identityStrategy());
    private final LanguageConsoleView myConsole;
    private final AnAction myHistoryNext;
    private final AnAction myHistoryPrev;
    private final AnAction myBrowseHistory;
    private boolean myMultiline;
    private ModelHelper myHelper;
    private long myLastSaveStamp;

    @Deprecated
    public ConsoleHistoryController(@NotNull String type, @Nullable String persistenceId, @NotNull LanguageConsoleView console) {
        if (type == null) {
            ConsoleHistoryController.$$$reportNull$$$0(0);
        }
        if (console == null) {
            ConsoleHistoryController.$$$reportNull$$$0(1);
        }
        this(new ConsoleRootType(type, null){}, persistenceId, console);
    }

    public ConsoleHistoryController(@NotNull ConsoleRootType rootType, @Nullable String persistenceId, @NotNull LanguageConsoleView console) {
        if (rootType == null) {
            ConsoleHistoryController.$$$reportNull$$$0(2);
        }
        if (console == null) {
            ConsoleHistoryController.$$$reportNull$$$0(3);
        }
        this(rootType, ConsoleHistoryController.fixNullPersistenceId(persistenceId, console), console, ConsoleHistoryModelProvider.findModelForConsole(ConsoleHistoryController.fixNullPersistenceId(persistenceId, console), console));
    }

    private ConsoleHistoryController(@NotNull ConsoleRootType rootType, @NotNull String persistenceId, @NotNull LanguageConsoleView console, @NotNull ConsoleHistoryModel model) {
        if (rootType == null) {
            ConsoleHistoryController.$$$reportNull$$$0(4);
        }
        if (persistenceId == null) {
            ConsoleHistoryController.$$$reportNull$$$0(5);
        }
        if (console == null) {
            ConsoleHistoryController.$$$reportNull$$$0(6);
        }
        if (model == null) {
            ConsoleHistoryController.$$$reportNull$$$0(7);
        }
        this.myHistoryNext = new MyAction(true, ConsoleHistoryController.getKeystrokesUpDown(true));
        this.myHistoryPrev = new MyAction(false, ConsoleHistoryController.getKeystrokesUpDown(false));
        this.myBrowseHistory = new MyBrowseAction();
        this.myHelper = new ModelHelper(rootType, persistenceId, model);
        this.myConsole = console;
    }

    public void setModel(@NotNull ConsoleHistoryModel model) {
        if (model == null) {
            ConsoleHistoryController.$$$reportNull$$$0(8);
        }
        this.myHelper = new ModelHelper(this.myHelper.myRootType, this.myHelper.myId, model);
    }

    public static ConsoleHistoryController getController(@NotNull LanguageConsoleView console) {
        if (console == null) {
            ConsoleHistoryController.$$$reportNull$$$0(9);
        }
        return ourControllers.get(console);
    }

    public static void addToHistory(@NotNull LanguageConsoleView consoleView, @Nullable String command) {
        ConsoleHistoryController controller;
        if (consoleView == null) {
            ConsoleHistoryController.$$$reportNull$$$0(10);
        }
        if ((controller = ConsoleHistoryController.getController(consoleView)) != null) {
            controller.addToHistory(command);
        }
    }

    public void addToHistory(@Nullable String command) {
        this.getModel().addToHistory(command);
    }

    public boolean hasHistory() {
        return !this.getModel().isEmpty();
    }

    @NotNull
    private static String fixNullPersistenceId(@Nullable String persistenceId, @NotNull LanguageConsoleView console) {
        if (console == null) {
            ConsoleHistoryController.$$$reportNull$$$0(11);
        }
        if (StringUtil.isNotEmpty((String)persistenceId)) {
            String string = persistenceId;
            if (string == null) {
                ConsoleHistoryController.$$$reportNull$$$0(12);
            }
            return string;
        }
        String url = console.getProject().getPresentableUrl();
        String string = StringUtil.isNotEmpty((String)url) ? url : "default";
        if (string == null) {
            ConsoleHistoryController.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean isMultiline() {
        return this.myMultiline;
    }

    public ConsoleHistoryController setMultiline(boolean multiline) {
        this.myMultiline = multiline;
        return this;
    }

    ConsoleHistoryModel getModel() {
        return this.myHelper.getModel();
    }

    public void install() {
        class Listener
        implements ProjectEx.ProjectSaved,
        FileDocumentManagerListener {
            Listener() {
            }

            public void beforeDocumentSaving(@NotNull Document document) {
                if (document == null) {
                    Listener.$$$reportNull$$$0(0);
                }
                if (document == ConsoleHistoryController.this.myConsole.getEditorDocument()) {
                    ConsoleHistoryController.this.saveHistory();
                }
            }

            @Override
            public void saved(@NotNull Project project) {
                if (project == null) {
                    Listener.$$$reportNull$$$0(1);
                }
                ConsoleHistoryController.this.saveHistory();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/console/ConsoleHistoryController$1Listener";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeDocumentSaving";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "saved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        Listener listener2 = new Listener();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myConsole).subscribe(ProjectEx.ProjectSaved.TOPIC, (Object)listener2);
        this.myConsole.getProject().getMessageBus().connect((Disposable)this.myConsole).subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)listener2);
        ConsoleHistoryController original = ourControllers.put(this.myConsole, this);
        LOG.assertTrue(original == null, (Object)("History controller already installed for: " + this.myConsole.getTitle()));
        Disposer.register((Disposable)this.myConsole, (Disposable)new Disposable(){

            public void dispose() {
                ConsoleHistoryController controller = ConsoleHistoryController.getController(ConsoleHistoryController.this.myConsole);
                if (controller == ConsoleHistoryController.this) {
                    ourControllers.remove(ConsoleHistoryController.this.myConsole);
                }
                ConsoleHistoryController.this.saveHistory();
            }
        });
        if (this.myHelper.getModel().getHistorySize() == 0) {
            this.loadHistory(this.myHelper.getId());
        }
        this.configureActions();
        this.myLastSaveStamp = this.getCurrentTimeStamp();
    }

    private long getCurrentTimeStamp() {
        return this.getModel().getModificationCount() + this.myConsole.getEditorDocument().getModificationStamp();
    }

    private void configureActions() {
        EmptyAction.setupAction((AnAction)this.myHistoryNext, (String)"Console.History.Next", null);
        EmptyAction.setupAction((AnAction)this.myHistoryPrev, (String)"Console.History.Previous", null);
        EmptyAction.setupAction((AnAction)this.myBrowseHistory, (String)"Console.History.Browse", null);
        if (!this.myMultiline) {
            ConsoleHistoryController.addShortcuts(this.myHistoryNext, ConsoleHistoryController.getShortcutUpDown(true));
            ConsoleHistoryController.addShortcuts(this.myHistoryPrev, ConsoleHistoryController.getShortcutUpDown(false));
        }
        this.myHistoryNext.registerCustomShortcutSet(this.myHistoryNext.getShortcutSet(), this.myConsole.getCurrentEditor().getComponent());
        this.myHistoryPrev.registerCustomShortcutSet(this.myHistoryPrev.getShortcutSet(), this.myConsole.getCurrentEditor().getComponent());
        this.myBrowseHistory.registerCustomShortcutSet(this.myBrowseHistory.getShortcutSet(), this.myConsole.getCurrentEditor().getComponent());
    }

    public boolean loadHistory(String id) {
        String prev2 = this.myHelper.getContent();
        boolean result2 = this.myHelper.loadHistory(id, this.myConsole.getVirtualFile());
        String userValue = this.myHelper.getContent();
        if (prev2 != userValue && userValue != null) {
            this.setConsoleText(new ConsoleHistoryModel.Entry(userValue, -1), false, false);
        }
        return result2;
    }

    private void saveHistory() {
        if (this.myLastSaveStamp == this.getCurrentTimeStamp()) {
            return;
        }
        this.myHelper.setContent(this.myConsole.getEditorDocument().getText());
        this.myHelper.saveHistory();
        this.myLastSaveStamp = this.getCurrentTimeStamp();
    }

    public AnAction getHistoryNext() {
        return this.myHistoryNext;
    }

    public AnAction getHistoryPrev() {
        return this.myHistoryPrev;
    }

    public AnAction getBrowseHistory() {
        return this.myBrowseHistory;
    }

    protected void setConsoleText(ConsoleHistoryModel.Entry command, boolean storeUserText, boolean regularMode) {
        if (regularMode && this.myMultiline && StringUtil.isEmptyOrSpaces((String)command.getText())) {
            return;
        }
        EditorEx editor = this.myConsole.getCurrentEditor();
        Document document = editor.getDocument();
        WriteCommandAction.writeCommandAction((Project)this.myConsole.getProject()).run(() -> {
            int offset;
            String text;
            if (storeUserText) {
                text = document.getText();
                if (Comparing.equal((String)command.getText(), (String)text) && this.myHelper.getContent() != null) {
                    return;
                }
                this.myHelper.setContent(text);
                this.myHelper.getModel().setContent(text);
            }
            text = StringUtil.notNullize((String)command.getText());
            if (regularMode) {
                if (this.myMultiline) {
                    offset = this.insertTextMultiline(text, editor, document);
                } else {
                    document.setText((CharSequence)text);
                    offset = command.getOffset() == -1 ? document.getTextLength() : command.getOffset();
                }
            } else {
                offset = 0;
                try {
                    document.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
                    document.setText((CharSequence)text);
                }
                finally {
                    document.putUserData(UndoConstants.DONT_RECORD_UNDO, null);
                }
            }
            editor.getCaretModel().moveToOffset(offset);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        });
    }

    protected int insertTextMultiline(String text, Editor editor, Document document) {
        TextRange selection = EditorUtil.getSelectionInAnyMode(editor);
        int start = document.getLineStartOffset(document.getLineNumber(selection.getStartOffset()));
        int end = document.getLineEndOffset(document.getLineNumber(selection.getEndOffset()));
        document.replaceString(start, end, (CharSequence)text);
        editor.getSelectionModel().setSelection(start, start + text.length());
        return start;
    }

    private boolean canMoveInEditor(boolean next) {
        EditorEx consoleEditor = this.myConsole.getCurrentEditor();
        Document document = consoleEditor.getDocument();
        CaretModel caretModel = consoleEditor.getCaretModel();
        if (LookupManager.getActiveLookup(consoleEditor) != null) {
            return false;
        }
        if (next) {
            return document.getLineNumber(caretModel.getOffset()) == 0;
        }
        int lineCount = document.getLineCount();
        return !(lineCount != 0 && document.getLineNumber(caretModel.getOffset()) != lineCount - 1 || !StringUtil.isEmptyOrSpaces((String)document.getText().substring(caretModel.getOffset())) && !this.myHelper.getModel().prevOnLastLine());
    }

    @NotNull
    private static String getHistoryName(@NotNull ConsoleRootType rootType, @NotNull String id) {
        if (rootType == null) {
            ConsoleHistoryController.$$$reportNull$$$0(14);
        }
        if (id == null) {
            ConsoleHistoryController.$$$reportNull$$$0(15);
        }
        String string = rootType.getConsoleTypeId() + "/" + PathUtil.makeFileName((String)rootType.getHistoryPathName(id), (String)rootType.getDefaultFileExtension());
        if (string == null) {
            ConsoleHistoryController.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    public static VirtualFile getContentFile(@NotNull ConsoleRootType rootType, @NotNull String id, ScratchFileService.Option option) {
        if (rootType == null) {
            ConsoleHistoryController.$$$reportNull$$$0(17);
        }
        if (id == null) {
            ConsoleHistoryController.$$$reportNull$$$0(18);
        }
        String pathName = PathUtil.makeFileName((String)rootType.getContentPathName(id), (String)rootType.getDefaultFileExtension());
        try {
            return rootType.findFile(null, pathName, option);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (rootType == null) {
                    ConsoleHistoryController.$$$reportNull$$$0(21);
                }
                String message = String.format("Unable to open '%s/%s'\nReason: %s", rootType.getId(), pathName, e.getLocalizedMessage());
                Messages.showErrorDialog((String)message, (String)"Unable to Open File");
            });
            return null;
        }
    }

    private static ShortcutSet getShortcutUpDown(boolean isUp) {
        AnAction action = ActionManager.getInstance().getActionOrStub(isUp ? "EditorUp" : "EditorDown");
        if (action != null) {
            return action.getShortcutSet();
        }
        return new CustomShortcutSet(KeyStroke.getKeyStroke(isUp ? 38 : 40, 0));
    }

    private static void addShortcuts(@NotNull AnAction action, @NotNull ShortcutSet newShortcuts) {
        if (action == null) {
            ConsoleHistoryController.$$$reportNull$$$0(19);
        }
        if (newShortcuts == null) {
            ConsoleHistoryController.$$$reportNull$$$0(20);
        }
        if (action.getShortcutSet().getShortcuts().length == 0) {
            action.registerCustomShortcutSet(newShortcuts, null);
        } else {
            action.registerCustomShortcutSet((ShortcutSet)new CompositeShortcutSet(new ShortcutSet[]{action.getShortcutSet(), newShortcuts}), null);
        }
    }

    private static Collection<KeyStroke> getKeystrokesUpDown(boolean isUp) {
        ArrayList<KeyStroke> result2 = new ArrayList<KeyStroke>();
        ShortcutSet shortcutSet = ConsoleHistoryController.getShortcutUpDown(isUp);
        for (Shortcut shortcut : shortcutSet.getShortcuts()) {
            if (!shortcut.isKeyboard() || ((KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
            result2.add(((KeyboardShortcut)shortcut).getFirstKeyStroke());
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 2: 
            case 4: 
            case 14: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistenceId";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/console/ConsoleHistoryController";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newShortcuts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/console/ConsoleHistoryController";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "fixNullPersistenceId";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getController";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addToHistory";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fixNullPersistenceId";
                break;
            }
            case 12: 
            case 13: 
            case 16: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getHistoryName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getContentFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addShortcuts";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getContentFile$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ModelHelper {
        private final ConsoleRootType myRootType;
        private final String myId;
        private final ConsoleHistoryModel myModel;
        private String myContent;

        public ModelHelper(ConsoleRootType rootType, String id, ConsoleHistoryModel model) {
            this.myRootType = rootType;
            this.myId = id;
            this.myModel = model;
        }

        public ConsoleHistoryModel getModel() {
            return this.myModel;
        }

        public void setContent(String userValue) {
            this.myContent = userValue;
        }

        public String getId() {
            return this.myId;
        }

        public String getContent() {
            return this.myContent;
        }

        @NotNull
        private String getOldHistoryFilePath(String id) {
            String pathName = this.myRootType.getConsoleTypeId() + Long.toHexString(StringHash.calc((String)id));
            String string = PathManager.getSystemPath() + File.separator + "userHistory" + File.separator + pathName + ".hist.xml";
            if (string == null) {
                ModelHelper.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean loadHistory(String id, VirtualFile consoleFile) {
            try {
                VirtualFile file2;
                VirtualFile virtualFile = file2 = this.myRootType.isHidden() ? null : HistoryRootType.getInstance().findFile(null, ConsoleHistoryController.getHistoryName(this.myRootType, id), ScratchFileService.Option.existing_only);
                if (file2 == null) {
                    if (this.loadHistoryOld(id)) {
                        if (!this.myRootType.isHidden()) {
                            WriteAction.run(() -> VfsUtil.saveText((VirtualFile)consoleFile, (String)this.myContent));
                        }
                        return true;
                    }
                    return false;
                }
                String[] split = VfsUtilCore.loadText(file2).split(this.myRootType.getEntrySeparator());
                this.getModel().resetEntries(Arrays.asList(split));
                return true;
            }
            catch (Exception ignored) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean loadHistoryOld(String id) {
            File file2 = new File(PathUtil.toSystemDependentName((String)this.getOldHistoryFilePath(id)));
            if (!file2.exists()) {
                return false;
            }
            try (XppReader xmlReader = null;){
                xmlReader = new XppReader((Reader)new InputStreamReader((InputStream)new FileInputStream(file2), StandardCharsets.UTF_8), (XmlPullParser)new MXParser());
                String text = this.loadHistory((HierarchicalStreamReader)xmlReader, id);
                if (text != null) {
                    this.myContent = text;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }

        private void saveHistory() {
            try {
                if (this.getModel().isEmpty()) {
                    return;
                }
                WriteAction.run(() -> {
                    VirtualFile file2 = HistoryRootType.getInstance().findFile(null, ConsoleHistoryController.getHistoryName(this.myRootType, this.myId), ScratchFileService.Option.create_if_missing);
                    VfsUtil.saveText((VirtualFile)file2, (String)StringUtil.join(this.getModel().getEntries(), (String)this.myRootType.getEntrySeparator()));
                });
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        }

        @Nullable
        private String loadHistory(HierarchicalStreamReader in, String expectedId) {
            if (!in.getNodeName().equals("console-history")) {
                return null;
            }
            String id = in.getAttribute("id");
            if (!expectedId.equals(id)) {
                return null;
            }
            ArrayList entries = ContainerUtil.newArrayList();
            String consoleContent = null;
            while (in.hasMoreChildren()) {
                in.moveDown();
                if ("history-entry".equals(in.getNodeName())) {
                    entries.add(StringUtil.notNullize((String)in.getValue()));
                } else if ("console-content".equals(in.getNodeName())) {
                    consoleContent = StringUtil.notNullize((String)in.getValue());
                }
                in.moveUp();
            }
            this.getModel().resetEntries(entries);
            return consoleContent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/ConsoleHistoryController$ModelHelper", "getOldHistoryFilePath"));
        }
    }

    private class MyBrowseAction
    extends DumbAwareAction {
        private MyBrowseAction() {
        }

        public void update(AnActionEvent e) {
            boolean enabled = ConsoleHistoryController.this.hasHistory();
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            String title = ConsoleHistoryController.this.myConsole.getTitle() + " History";
            ContentChooser<String> chooser = new ContentChooser<String>(ConsoleHistoryController.this.myConsole.getProject(), title, true, true){

                @Override
                protected void removeContentAt(String content) {
                    ConsoleHistoryController.this.getModel().removeFromHistory(content);
                }

                @Override
                protected String getStringRepresentationFor(String content) {
                    return content;
                }

                @Override
                @NotNull
                protected List<String> getContents() {
                    List<String> list2 = ConsoleHistoryController.this.getModel().getEntries();
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list2;
                }

                @Override
                protected Editor createIdeaEditor(String text) {
                    PsiFile consoleFile = ConsoleHistoryController.this.myConsole.getFile();
                    Language language = consoleFile.getLanguage();
                    Project project = consoleFile.getProject();
                    PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("a." + consoleFile.getFileType().getDefaultExtension(), language, (CharSequence)StringUtil.convertLineSeparators((String)text), false, true);
                    VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
                    if (virtualFile instanceof LightVirtualFile) {
                        ((LightVirtualFile)virtualFile).setWritable(false);
                    }
                    Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
                    EditorFactory editorFactory = EditorFactory.getInstance();
                    EditorEx editor = (EditorEx)editorFactory.createViewer(document, project);
                    editor.getSettings().setFoldingOutlineShown(false);
                    editor.getSettings().setLineMarkerAreaShown(false);
                    editor.getSettings().setIndentGuidesShown(false);
                    SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)psiFile.getViewProvider().getVirtualFile());
                    editor.setHighlighter(new LexerEditorHighlighter(highlighter, editor.getColorsScheme()));
                    return editor;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/ConsoleHistoryController$MyBrowseAction$1", "getContents"));
                }
            };
            chooser.setContentIcon(null);
            chooser.setSplitterOrientation(false);
            chooser.setSelectedIndex(Math.max(0, ConsoleHistoryController.this.getModel().getHistorySize() - 1));
            if (chooser.showAndGet() && ConsoleHistoryController.this.myConsole.getCurrentEditor().getComponent().isShowing()) {
                ConsoleHistoryController.this.setConsoleText(new ConsoleHistoryModel.Entry(chooser.getSelectedText(), -1), false, true);
            }
        }
    }

    private class MyAction
    extends DumbAwareAction {
        private final boolean myNext;
        @NotNull
        private final Collection<KeyStroke> myUpDownKeystrokes;

        public MyAction(@NotNull boolean next, Collection<KeyStroke> upDownKeystrokes) {
            if (upDownKeystrokes == null) {
                MyAction.$$$reportNull$$$0(0);
            }
            this.myNext = next;
            this.myUpDownKeystrokes = upDownKeystrokes;
            this.getTemplatePresentation().setVisible(false);
        }

        public void actionPerformed(AnActionEvent e) {
            ConsoleHistoryModel.Entry command;
            boolean hasHistory = ConsoleHistoryController.this.getModel().hasHistory();
            ConsoleHistoryModel.Entry entry = command = this.myNext ? ConsoleHistoryController.this.getModel().getHistoryNext() : ConsoleHistoryController.this.getModel().getHistoryPrev();
            if (!ConsoleHistoryController.this.myMultiline && command == null) {
                return;
            }
            ConsoleHistoryController.this.setConsoleText(command, this.myNext && !hasHistory, true);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            boolean enabled = ConsoleHistoryController.this.myMultiline || !this.isUpDownKey(e) || ConsoleHistoryController.this.canMoveInEditor(this.myNext);
            e.getPresentation().setEnabled(enabled);
        }

        private boolean isUpDownKey(AnActionEvent e) {
            InputEvent event = e.getInputEvent();
            if (!(event instanceof KeyEvent)) {
                return false;
            }
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent((KeyEvent)event);
            return this.myUpDownKeystrokes.contains(keyStroke);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upDownKeystrokes", "com/intellij/execution/console/ConsoleHistoryController$MyAction", "<init>"));
        }
    }
}

