/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.compound;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.ExecutionTargetManagerImpl;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerIconProvider;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.compound.CompoundRunConfigurationSettingsEditor;
import com.intellij.execution.compound.CompoundRunConfigurationType;
import com.intellij.execution.compound.SettingsAndEffectiveTarget;
import com.intellij.execution.compound.TypeNameTarget;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.WithoutOwnBeforeRunSteps;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\u0018\u0000 52\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u00015B!\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0013J\"\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$H\u0016J\u001a\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\rH\u0002J\u0012\u0010*\u001a\u00020\u00162\b\u0010+\u001a\u0004\u0018\u00010\u001fH\u0002J\b\u0010,\u001a\u00020\u0016H\u0002J\u0010\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020/H\u0016J\u001c\u00100\u001a\u00020\u00162\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u001dJ\u0014\u00102\u001a\u00020\u00162\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001003J\u0010\u00104\u001a\u00020\u00162\u0006\u0010.\u001a\u00020/H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/execution/compound/CompoundRunConfiguration;", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "Lcom/intellij/execution/RunnerIconProvider;", "Lcom/intellij/execution/configurations/WithoutOwnBeforeRunSteps;", "", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "isInitialized", "", "sortedConfigurationsWithTargets", "Ljava/util/TreeMap;", "Lcom/intellij/execution/configurations/RunConfiguration;", "Lcom/intellij/execution/ExecutionTarget;", "unsortedConfigurations", "", "Lcom/intellij/execution/compound/TypeNameTarget;", "checkConfiguration", "", "clone", "getConfigurationEditor", "Lcom/intellij/execution/compound/CompoundRunConfigurationSettingsEditor;", "getConfigurationsWithEffectiveRunTargets", "Lcom/intellij/execution/compound/SettingsAndEffectiveTarget;", "getConfigurationsWithTargets", "", "runManager", "Lcom/intellij/execution/impl/RunManagerImpl;", "getExecutorIcon", "Ljavax/swing/Icon;", "configuration", "executor", "Lcom/intellij/execution/Executor;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "hasRunningSingletons", "initIfNeed", "_runManager", "markInitialized", "readExternal", "element", "Lorg/jdom/Element;", "setConfigurationsWithTargets", "value", "setConfigurationsWithoutTargets", "", "writeExternal", "Companion", "intellij.platform.lang.impl"})
public final class CompoundRunConfiguration
extends RunConfigurationBase
implements RunnerIconProvider,
WithoutOwnBeforeRunSteps,
Cloneable {
    private List<TypeNameTarget> unsortedConfigurations;
    private TreeMap<RunConfiguration, ExecutionTarget> sortedConfigurationsWithTargets;
    private boolean isInitialized;
    @JvmField
    @NotNull
    public static final Comparator<RunConfiguration> COMPARATOR;
    public static final Companion Companion;

    @JvmOverloads
    @NotNull
    public final Map<RunConfiguration, ExecutionTarget> getConfigurationsWithTargets(@Nullable RunManagerImpl runManager) {
        this.initIfNeed(runManager);
        return this.sortedConfigurationsWithTargets;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Map getConfigurationsWithTargets$default(CompoundRunConfiguration compoundRunConfiguration, RunManagerImpl runManagerImpl, int n, Object object) {
        if ((n & 1) != 0) {
            runManagerImpl = null;
        }
        return compoundRunConfiguration.getConfigurationsWithTargets(runManagerImpl);
    }

    @JvmOverloads
    @NotNull
    public final Map<RunConfiguration, ExecutionTarget> getConfigurationsWithTargets() {
        return CompoundRunConfiguration.getConfigurationsWithTargets$default(this, null, 1, null);
    }

    public final void setConfigurationsWithTargets(@NotNull Map<RunConfiguration, ? extends ExecutionTarget> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        this.markInitialized();
        this.sortedConfigurationsWithTargets.clear();
        this.sortedConfigurationsWithTargets.putAll(value);
    }

    /*
     * WARNING - void declaration
     */
    public final void setConfigurationsWithoutTargets(@NotNull Collection<? extends RunConfiguration> value) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        Iterable iterable = value;
        CompoundRunConfiguration compoundRunConfiguration = this;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        void var4_5 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map = destination$iv$iv;
            RunConfiguration it = (RunConfiguration)element$iv$iv;
            Pair pair = TuplesKt.to((Object)it, null);
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map map = destination$iv$iv;
        compoundRunConfiguration.setConfigurationsWithTargets(map);
    }

    private final void initIfNeed(RunManagerImpl _runManager) {
        if (this.isInitialized) {
            return;
        }
        this.sortedConfigurationsWithTargets.clear();
        RunManagerImpl runManagerImpl = _runManager;
        if (runManagerImpl == null) {
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            runManagerImpl = RunManagerImpl.Companion.getInstanceImpl(project);
        }
        RunManagerImpl runManager = runManagerImpl;
        ExecutionTargetManager executionTargetManager = ExecutionTargetManager.getInstance((Project)this.getProject());
        if (executionTargetManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.execution.ExecutionTargetManagerImpl");
        }
        ExecutionTargetManagerImpl targetManager = (ExecutionTargetManagerImpl)executionTargetManager;
        for (TypeNameTarget typeNameTarget : this.unsortedConfigurations) {
            ExecutionTarget executionTarget;
            String type = typeNameTarget.component1();
            String name = typeNameTarget.component2();
            String targetId = typeNameTarget.component3();
            RunnerAndConfigurationSettings settings = runManager.findConfigurationByTypeAndName(type, name);
            if (settings == null || settings.getConfiguration() == this) continue;
            if (targetId != null) {
                String string;
                String it = string;
                executionTarget = targetManager.findTargetByIdFor(settings, it);
            } else {
                executionTarget = null;
            }
            ExecutionTarget target2 = executionTarget;
            this.sortedConfigurationsWithTargets.put(settings.getConfiguration(), target2);
        }
        this.markInitialized();
    }

    private final void markInitialized() {
        this.unsortedConfigurations = CollectionsKt.emptyList();
        this.isInitialized = true;
    }

    @NotNull
    public CompoundRunConfigurationSettingsEditor getConfigurationEditor() {
        return new CompoundRunConfigurationSettingsEditor(this.getProject());
    }

    public void checkConfiguration() {
        if (this.sortedConfigurationsWithTargets.isEmpty()) {
            throw (Throwable)new RuntimeConfigurationException("There is nothing to run");
        }
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        RunnerAndConfigurationSettingsImpl temp = new RunnerAndConfigurationSettingsImpl(RunManagerImpl.Companion.getInstanceImpl(project), (RunConfiguration)this, false, false, null, 28, null);
        if (ExecutionTargetManager.getInstance((Project)this.getProject()).getTargetsFor((RunnerAndConfigurationSettings)temp).isEmpty()) {
            throw (Throwable)new RuntimeConfigurationException("No suitable targets to run on; please choose a target for each configuration");
        }
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        try {
            this.checkConfiguration();
        }
        catch (RuntimeConfigurationException e) {
            throw (Throwable)new ExecutionException(e.getMessage());
        }
        return new RunProfileState(this, executor){
            final /* synthetic */ CompoundRunConfiguration this$0;
            final /* synthetic */ Executor $executor;

            @Nullable
            public final Void execute(Executor $noName_0, @NotNull ProgramRunner<RunnerSettings> $noName_1) {
                Intrinsics.checkParameterIsNotNull($noName_1, (String)"<anonymous parameter 1>");
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ getState.1 this$0;

                    public final void run() {
                        for (SettingsAndEffectiveTarget settingsAndEffectiveTarget : this.this$0.this$0.getConfigurationsWithEffectiveRunTargets()) {
                            RunnerAndConfigurationSettings settings = settingsAndEffectiveTarget.component1();
                            ExecutionTarget target2 = settingsAndEffectiveTarget.component2();
                            ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)settings, (Executor)this.this$0.$executor, (ExecutionTarget)target2);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                return null;
            }
            {
                this.this$0 = compoundRunConfiguration;
                this.$executor = executor;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SettingsAndEffectiveTarget> getConfigurationsWithEffectiveRunTargets() {
        void $receiver$iv$iv;
        void $receiver$iv$iv$iv;
        Map $receiver$iv;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        RunManagerImpl runManager = RunManagerImpl.Companion.getInstanceImpl(project);
        ExecutionTarget executionTarget = ExecutionTargetManager.getActiveTarget((Project)this.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)executionTarget, (String)"ExecutionTargetManager.getActiveTarget(project)");
        ExecutionTarget activeTarget = executionTarget;
        ExecutionTarget defaultTarget = DefaultExecutionTarget.INSTANCE;
        Map map = $receiver$iv = (Map)this.sortedConfigurationsWithTargets;
        Collection destination$iv$iv = new ArrayList();
        void var8_8 = $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator = var8_8.entrySet().iterator();
        while (iterator.hasNext()) {
            SettingsAndEffectiveTarget settingsAndEffectiveTarget;
            SettingsAndEffectiveTarget settingsAndEffectiveTarget2;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry $configuration_specifiedTarget = element$iv$iv = (element$iv$iv$iv = iterator.next());
            Object object = $configuration_specifiedTarget;
            RunConfiguration configuration = (RunConfiguration)object.getKey();
            object = $configuration_specifiedTarget;
            ExecutionTarget specifiedTarget = (ExecutionTarget)object.getValue();
            RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettingsImpl = runManager.getSettings(configuration);
            if (runnerAndConfigurationSettingsImpl != null) {
                Object it = object = runnerAndConfigurationSettingsImpl;
                ExecutionTarget executionTarget2 = specifiedTarget;
                if (executionTarget2 == null) {
                    executionTarget2 = ExecutionTargetManager.canRun((RunnerAndConfigurationSettings)((RunnerAndConfigurationSettings)it), (ExecutionTarget)activeTarget) ? activeTarget : defaultTarget;
                }
                ExecutionTarget effectiveTarget = executionTarget2;
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)it;
                ExecutionTarget executionTarget3 = effectiveTarget;
                Intrinsics.checkExpressionValueIsNotNull((Object)executionTarget3, (String)"effectiveTarget");
                settingsAndEffectiveTarget2 = new SettingsAndEffectiveTarget(runnerAndConfigurationSettings, executionTarget3);
            } else {
                settingsAndEffectiveTarget2 = null;
            }
            if (settingsAndEffectiveTarget2 == null) continue;
            SettingsAndEffectiveTarget it$iv$iv = settingsAndEffectiveTarget = settingsAndEffectiveTarget2;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.readExternal(element);
        List children2 = element.getChildren("toRun");
        if (children2.isEmpty()) {
            this.unsortedConfigurations = CollectionsKt.emptyList();
            return;
        }
        THashSet list2 = new THashSet();
        for (Element child : children2) {
            String name;
            String type;
            if (child.getAttributeValue("type") == null) {
                continue;
            }
            if (child.getAttributeValue("name") == null) {
                continue;
            }
            list2.add((Object)new TypeNameTarget(type, name, child.getAttributeValue("targetId")));
        }
        this.unsortedConfigurations = CollectionsKt.toList((Iterable)((Iterable)list2));
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.writeExternal(element);
        Map map = this.sortedConfigurationsWithTargets;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            RunConfiguration configuration = (RunConfiguration)entry2.getKey();
            entry2 = entry;
            ExecutionTarget target2 = (ExecutionTarget)entry2.getValue();
            Element child = new Element("toRun");
            ConfigurationType configurationType = configuration.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)configurationType, (String)"configuration.type");
            child.setAttribute("type", configurationType.getId());
            child.setAttribute("name", configuration.getName());
            if (target2 != null) {
                ExecutionTarget executionTarget;
                ExecutionTarget it = executionTarget;
                child.setAttribute("targetId", it.getId());
            }
            element.addContent(child);
        }
    }

    @NotNull
    public RunConfiguration clone() {
        RunConfiguration runConfiguration = super.clone();
        if (runConfiguration == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.execution.compound.CompoundRunConfiguration");
        }
        CompoundRunConfiguration clone = (CompoundRunConfiguration)runConfiguration;
        clone.unsortedConfigurations = this.unsortedConfigurations;
        clone.sortedConfigurationsWithTargets = new TreeMap(COMPARATOR);
        clone.sortedConfigurationsWithTargets.putAll((Map<RunConfiguration, ExecutionTarget>)this.sortedConfigurationsWithTargets);
        return (RunConfiguration)clone;
    }

    @Nullable
    public Icon getExecutorIcon(@NotNull RunConfiguration configuration, @NotNull Executor executor) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        return Intrinsics.areEqual((Object)DefaultRunExecutor.EXECUTOR_ID, (Object)executor.getId()) && this.hasRunningSingletons() ? AllIcons.Actions.Restart : executor.getIcon();
    }

    private final boolean hasRunningSingletons() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Project project2 = project;
        if (project2.isDisposed()) {
            return false;
        }
        List<RunContentDescriptor> list2 = ExecutionManagerImpl.getInstance(project2).getRunningDescriptors((Condition<RunnerAndConfigurationSettings>)((Condition)new Condition<RunnerAndConfigurationSettings>(this, project2){
            final /* synthetic */ CompoundRunConfiguration this$0;
            final /* synthetic */ Project $project;

            public final boolean value(RunnerAndConfigurationSettings s) {
                RunManagerImpl manager = RunManagerImpl.Companion.getInstanceImpl(this.$project);
                Map map = CompoundRunConfiguration.access$getSortedConfigurationsWithTargets$p(this.this$0);
                for (Map.Entry<K, V> entry : map.entrySet()) {
                    Map.Entry<K, V> entry2 = entry;
                    RunConfiguration configuration = (RunConfiguration)entry2.getKey();
                    if (configuration instanceof CompoundRunConfiguration && CompoundRunConfiguration.access$hasRunningSingletons((CompoundRunConfiguration)configuration)) {
                        return true;
                    }
                    ConfigurationType configurationType = configuration.getType();
                    String string = configuration.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configuration.name");
                    RunnerAndConfigurationSettings settings = manager.findConfigurationByTypeAndName(configurationType, string);
                    if (settings == null || !settings.isSingleton()) continue;
                    RunnerAndConfigurationSettings runnerAndConfigurationSettings = s;
                    Intrinsics.checkExpressionValueIsNotNull((Object)runnerAndConfigurationSettings, (String)"s");
                    if (!Intrinsics.areEqual((Object)configuration, (Object)runnerAndConfigurationSettings.getConfiguration())) continue;
                    return true;
                }
                return false;
            }
            {
                this.this$0 = compoundRunConfiguration;
                this.$project = project;
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ExecutionManagerImpl.get\u2026      }\n      false\n    }");
        Collection collection = list2;
        return !collection.isEmpty();
    }

    @JvmOverloads
    public CompoundRunConfiguration(@NotNull Project project, @NotNull String name, @NotNull ConfigurationFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(project, factory, name);
        this.unsortedConfigurations = CollectionsKt.emptyList();
        this.sortedConfigurationsWithTargets = new TreeMap(COMPARATOR);
    }

    @JvmOverloads
    public /* synthetic */ CompoundRunConfiguration(Project project, String string, ConfigurationFactory configurationFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            CompoundRunConfigurationType compoundRunConfigurationType = CompoundRunConfigurationType.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)compoundRunConfigurationType), (String)"CompoundRunConfigurationType.getInstance()");
            configurationFactory = (ConfigurationFactory)ArraysKt.first((Object[])compoundRunConfigurationType.getConfigurationFactories());
        }
        this(project, string, configurationFactory);
    }

    @JvmOverloads
    public CompoundRunConfiguration(@NotNull Project project, @NotNull String name) {
        this(project, name, null, 4, null);
    }

    static {
        Companion = new Companion(null);
        COMPARATOR = Companion.COMPARATOR.1.INSTANCE;
    }

    @NotNull
    public static final /* synthetic */ TreeMap access$getSortedConfigurationsWithTargets$p(CompoundRunConfiguration $this) {
        return $this.sortedConfigurationsWithTargets;
    }

    public static final /* synthetic */ void access$setSortedConfigurationsWithTargets$p(CompoundRunConfiguration $this, @NotNull TreeMap treeMap) {
        $this.sortedConfigurationsWithTargets = treeMap;
    }

    public static final /* synthetic */ boolean access$hasRunningSingletons(CompoundRunConfiguration $this) {
        return $this.hasRunningSingletons();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/execution/compound/CompoundRunConfiguration$Companion;", "", "()V", "COMPARATOR", "Ljava/util/Comparator;", "Lcom/intellij/execution/configurations/RunConfiguration;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

