/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetListener;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.ExecutionTargetProvider;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.TargetAwareRunProfile;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExecutionTargetManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ExecutionTargetManagerImpl
extends ExecutionTargetManager
implements PersistentStateComponent<Element> {
    public static final ExecutionTarget MULTIPLE_TARGETS = new ExecutionTarget(){

        @NotNull
        public String getId() {
            if ("multiple_targets" == null) {
                1.$$$reportNull$$$0(0);
            }
            return "multiple_targets";
        }

        @NotNull
        public String getDisplayName() {
            if ("Multiple specified" == null) {
                1.$$$reportNull$$$0(1);
            }
            return "Multiple specified";
        }

        public Icon getIcon() {
            return null;
        }

        public boolean canRun(@NotNull RunnerAndConfigurationSettings configuration) {
            if (configuration == null) {
                1.$$$reportNull$$$0(2);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/ExecutionTargetManagerImpl$1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/ExecutionTargetManagerImpl$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "canRun";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object myActiveTargetLock;
    @Nullable
    private ExecutionTarget myActiveTarget;
    @Nullable
    private String mySavedActiveTargetId;

    public ExecutionTargetManagerImpl(@NotNull Project project) {
        if (project == null) {
            ExecutionTargetManagerImpl.$$$reportNull$$$0(0);
        }
        this.myActiveTargetLock = new Object();
        this.myProject = project;
        project.getMessageBus().connect().subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (settings == RunManager.getInstance((Project)ExecutionTargetManagerImpl.this.myProject).getSelectedConfiguration()) {
                    ExecutionTargetManagerImpl.this.updateActiveTarget(settings);
                }
            }

            @Override
            public void runConfigurationSelected() {
                ExecutionTargetManagerImpl.this.updateActiveTarget();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/ExecutionTargetManagerImpl$2", "runConfigurationChanged"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getState() {
        Element state = new Element("state");
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            String id;
            String string = id = this.myActiveTarget == null ? this.mySavedActiveTargetId : this.myActiveTarget.getId();
            if (id != null && !id.equals(DefaultExecutionTarget.INSTANCE.getId())) {
                state.setAttribute("SELECTED_TARGET", id);
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element state) {
        if (state == null) {
            ExecutionTargetManagerImpl.$$$reportNull$$$0(1);
        }
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            if (this.myActiveTarget == null && this.mySavedActiveTargetId == null) {
                this.mySavedActiveTargetId = state.getAttributeValue("SELECTED_TARGET");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public ExecutionTarget getActiveTarget() {
        Object object = this.myActiveTargetLock;
        // MONITORENTER : object
        if (this.myActiveTarget == null) {
            this.updateActiveTarget();
        }
        ExecutionTarget executionTarget = this.myActiveTarget;
        // MONITOREXIT : object
        if (executionTarget != null) return executionTarget;
        ExecutionTargetManagerImpl.$$$reportNull$$$0(2);
        return executionTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveTarget(@NotNull ExecutionTarget target2) {
        if (target2 == null) {
            ExecutionTargetManagerImpl.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            this.updateActiveTarget(RunManager.getInstance((Project)this.myProject).getSelectedConfiguration(), target2);
        }
    }

    private void updateActiveTarget() {
        this.updateActiveTarget(RunManager.getInstance((Project)this.myProject).getSelectedConfiguration());
    }

    private void updateActiveTarget(@Nullable RunnerAndConfigurationSettings settings) {
        this.updateActiveTarget(settings, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActiveTarget(@Nullable RunnerAndConfigurationSettings settings, @Nullable ExecutionTarget toSelect2) {
        ExecutionTarget toNotify;
        List<ExecutionTarget> suitable = settings == null ? Collections.singletonList(DefaultExecutionTarget.INSTANCE) : this.getTargetsFor(settings);
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            if (toSelect2 == null) {
                toSelect2 = this.myActiveTarget;
            }
            int index = -1;
            if (toSelect2 != null) {
                index = suitable.indexOf(toSelect2);
            } else if (this.mySavedActiveTargetId != null) {
                int size = suitable.size();
                for (int i = 0; i < size; ++i) {
                    if (!suitable.get(i).getId().equals(this.mySavedActiveTargetId)) continue;
                    index = i;
                    break;
                }
            }
            toNotify = this.doSetActiveTarget(index >= 0 ? suitable.get(index) : this.getDefaultTarget(suitable));
        }
        if (toNotify != null) {
            ((ExecutionTargetListener)this.myProject.getMessageBus().syncPublisher(TOPIC)).activeTargetChanged(toNotify);
        }
    }

    private ExecutionTarget getDefaultTarget(List<ExecutionTarget> suitable) {
        ExecutionTarget result2 = this.mySavedActiveTargetId == null ? (ExecutionTarget)ContainerUtil.find(suitable, ExecutionTarget::isReady) : (ExecutionTarget)ContainerUtil.getFirstItem(suitable);
        return result2 != null ? result2 : DefaultExecutionTarget.INSTANCE;
    }

    @Nullable
    private ExecutionTarget doSetActiveTarget(@NotNull ExecutionTarget newTarget) {
        if (newTarget == null) {
            ExecutionTargetManagerImpl.$$$reportNull$$$0(4);
        }
        this.mySavedActiveTargetId = null;
        ExecutionTarget prev2 = this.myActiveTarget;
        this.myActiveTarget = newTarget;
        if (prev2 != null && !prev2.equals((Object)this.myActiveTarget)) {
            return this.myActiveTarget;
        }
        return null;
    }

    protected boolean doCanRun(@Nullable RunnerAndConfigurationSettings settings, @NotNull ExecutionTarget target2) {
        if (target2 == null) {
            ExecutionTargetManagerImpl.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            return false;
        }
        boolean isCompound = settings.getConfiguration() instanceof CompoundRunConfiguration;
        if (isCompound && target2 == MULTIPLE_TARGETS) {
            return true;
        }
        ExecutionTarget defaultTarget = DefaultExecutionTarget.INSTANCE;
        boolean checkFallbackToDefault = isCompound && !target2.equals((Object)defaultTarget);
        return this.doWithEachNonCompoundWithSpecifiedTarget(settings, (Processor<Pair<RunnerAndConfigurationSettings, ExecutionTarget>>)((Processor)each -> {
            RunConfiguration configuration;
            if (target2 == null) {
                ExecutionTargetManagerImpl.$$$reportNull$$$0(9);
            }
            if (!((configuration = ((RunnerAndConfigurationSettings)each.first).getConfiguration()) instanceof TargetAwareRunProfile)) {
                return true;
            }
            TargetAwareRunProfile targetAwareProfile = (TargetAwareRunProfile)configuration;
            return target2.canRun((RunnerAndConfigurationSettings)each.first) && targetAwareProfile.canRunOn(target2) || checkFallbackToDefault && defaultTarget.canRun((RunnerAndConfigurationSettings)each.first) && targetAwareProfile.canRunOn(defaultTarget);
        }));
    }

    @NotNull
    public List<ExecutionTarget> getTargetsFor(@Nullable RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            List<ExecutionTarget> list2 = Collections.emptyList();
            if (list2 == null) {
                ExecutionTargetManagerImpl.$$$reportNull$$$0(6);
            }
            return list2;
        }
        ExecutionTargetProvider[] providers = (ExecutionTargetProvider[])Extensions.getExtensions((ExtensionPointName)ExecutionTargetProvider.EXTENSION_NAME);
        LinkedHashSet<ExecutionTarget> result2 = new LinkedHashSet<ExecutionTarget>();
        THashSet specifiedTargets = new THashSet();
        this.doWithEachNonCompoundWithSpecifiedTarget(settings, (Processor<Pair<RunnerAndConfigurationSettings, ExecutionTarget>>)((Processor)arg_0 -> this.lambda$getTargetsFor$1(providers, result2, (Set)specifiedTargets, arg_0)));
        if (!result2.isEmpty()) {
            specifiedTargets.forEach(it -> result2.retainAll(Collections.singleton(it)));
            if (result2.isEmpty()) {
                result2.add(MULTIPLE_TARGETS);
            }
        }
        List<ExecutionTarget> list3 = Collections.unmodifiableList(ContainerUtil.filter(result2, it -> this.doCanRun(settings, (ExecutionTarget)it)));
        if (list3 == null) {
            ExecutionTargetManagerImpl.$$$reportNull$$$0(7);
        }
        return list3;
    }

    private boolean doWithEachNonCompoundWithSpecifiedTarget(@Nullable RunnerAndConfigurationSettings settings, @NotNull Processor<Pair<RunnerAndConfigurationSettings, ExecutionTarget>> action) {
        if (action == null) {
            ExecutionTargetManagerImpl.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            return true;
        }
        RunManagerImpl runManager = (RunManagerImpl)RunManager.getInstance((Project)this.myProject);
        THashSet recursionGuard = new THashSet();
        LinkedList<Pair> toProcess = new LinkedList<Pair>();
        toProcess.add(Pair.create((Object)settings, null));
        while (!toProcess.isEmpty()) {
            Pair eachWithTarget = (Pair)toProcess.pollFirst();
            if (!recursionGuard.add(eachWithTarget.first)) continue;
            RunConfiguration eachConfiguration = ((RunnerAndConfigurationSettings)eachWithTarget.first).getConfiguration();
            if (eachConfiguration instanceof CompoundRunConfiguration) {
                for (Map.Entry<RunConfiguration, ExecutionTarget> subConfigWithTarget : ((CompoundRunConfiguration)eachConfiguration).getConfigurationsWithTargets().entrySet()) {
                    RunnerAndConfigurationSettingsImpl subSettings = runManager.getSettings(subConfigWithTarget.getKey());
                    if (subSettings == null) continue;
                    toProcess.add(Pair.create((Object)subSettings, (Object)subConfigWithTarget.getValue()));
                }
                continue;
            }
            if (action.process((Object)Pair.create((Object)eachWithTarget.first, (Object)eachWithTarget.second))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public ExecutionTarget findTargetByIdFor(@Nullable RunnerAndConfigurationSettings settings, @Nullable String id) {
        if (id == null) {
            return null;
        }
        return (ExecutionTarget)ContainerUtil.find(this.getTargetsFor(settings), it -> it.getId().equals(id));
    }

    public void update() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.updateActiveTarget();
    }

    public void reset() {
        this.mySavedActiveTargetId = null;
        this.myActiveTarget = null;
    }

    private /* synthetic */ boolean lambda$getTargetsFor$1(ExecutionTargetProvider[] providers, LinkedHashSet result2, Set specifiedTargets, Pair each) {
        for (ExecutionTargetProvider eachTargetProvider : providers) {
            List supportedTargets = eachTargetProvider.getTargets(this.myProject, (RunnerAndConfigurationSettings)each.first);
            if (each.second != null) {
                if (!supportedTargets.contains(each.second)) continue;
                result2.add(each.second);
                specifiedTargets.add(each.second);
                break;
            }
            result2.addAll(supportedTargets);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ExecutionTargetManagerImpl";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTarget";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ExecutionTargetManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveTarget";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetsFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setActiveTarget";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doSetActiveTarget";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doCanRun";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doWithEachNonCompoundWithSpecifiedTarget";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doCanRun$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

