/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ChangeCorrector;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ByChar {
    @NotNull
    public static FairDiffIterable compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ByChar.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            ByChar.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            ByChar.$$$reportNull$$$0(2);
        }
        indicator.checkCanceled();
        int[] chars1 = ByChar.getAllChars(text1);
        int[] chars2 = ByChar.getAllChars(text2);
        FairDiffIterable fairDiffIterable = DiffIterableUtil.diff(chars1, chars2, indicator);
        if (fairDiffIterable == null) {
            ByChar.$$$reportNull$$$0(3);
        }
        return fairDiffIterable;
    }

    @NotNull
    public static FairDiffIterable compareTwoStep(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ByChar.$$$reportNull$$$0(4);
        }
        if (text2 == null) {
            ByChar.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            ByChar.$$$reportNull$$$0(6);
        }
        indicator.checkCanceled();
        CharOffsets chars1 = ByChar.getNonSpaceChars(text1);
        CharOffsets chars2 = ByChar.getNonSpaceChars(text2);
        FairDiffIterable nonSpaceChanges = DiffIterableUtil.diff(chars1.characters, chars2.characters, indicator);
        FairDiffIterable fairDiffIterable = ByChar.matchAdjustmentSpaces(chars1, chars2, text1, text2, nonSpaceChanges, indicator);
        if (fairDiffIterable == null) {
            ByChar.$$$reportNull$$$0(7);
        }
        return fairDiffIterable;
    }

    @NotNull
    public static DiffIterable compareIgnoreWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ByChar.$$$reportNull$$$0(8);
        }
        if (text2 == null) {
            ByChar.$$$reportNull$$$0(9);
        }
        if (indicator == null) {
            ByChar.$$$reportNull$$$0(10);
        }
        indicator.checkCanceled();
        CharOffsets chars1 = ByChar.getNonSpaceChars(text1);
        CharOffsets chars2 = ByChar.getNonSpaceChars(text2);
        FairDiffIterable changes = DiffIterableUtil.diff(chars1.characters, chars2.characters, indicator);
        DiffIterable diffIterable = ByChar.matchAdjustmentSpacesIW(chars1, chars2, text1, text2, changes);
        if (diffIterable == null) {
            ByChar.$$$reportNull$$$0(11);
        }
        return diffIterable;
    }

    @NotNull
    public static FairDiffIterable comparePunctuation(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ByChar.$$$reportNull$$$0(12);
        }
        if (text2 == null) {
            ByChar.$$$reportNull$$$0(13);
        }
        if (indicator == null) {
            ByChar.$$$reportNull$$$0(14);
        }
        indicator.checkCanceled();
        CharOffsets chars1 = ByChar.getPunctuationChars(text1);
        CharOffsets chars2 = ByChar.getPunctuationChars(text2);
        FairDiffIterable nonSpaceChanges = DiffIterableUtil.diff(chars1.characters, chars2.characters, indicator);
        FairDiffIterable fairDiffIterable = ByChar.transfer(chars1, chars2, text1, text2, nonSpaceChanges, indicator);
        if (fairDiffIterable == null) {
            ByChar.$$$reportNull$$$0(15);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static FairDiffIterable transfer(@NotNull CharOffsets chars1, @NotNull CharOffsets chars2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes, @NotNull ProgressIndicator indicator) {
        if (chars1 == null) {
            ByChar.$$$reportNull$$$0(16);
        }
        if (chars2 == null) {
            ByChar.$$$reportNull$$$0(17);
        }
        if (text1 == null) {
            ByChar.$$$reportNull$$$0(18);
        }
        if (text2 == null) {
            ByChar.$$$reportNull$$$0(19);
        }
        if (changes == null) {
            ByChar.$$$reportNull$$$0(20);
        }
        if (indicator == null) {
            ByChar.$$$reportNull$$$0(21);
        }
        DiffIterableUtil.ChangeBuilder builder2 = new DiffIterableUtil.ChangeBuilder(text1.length(), text2.length());
        for (Range range2 : changes.iterateUnchanged()) {
            int count = range2.end1 - range2.start1;
            for (int i = 0; i < count; ++i) {
                int offset1 = chars1.offsets[range2.start1 + i];
                int offset2 = chars2.offsets[range2.start2 + i];
                builder2.markEqual(offset1, offset2);
            }
        }
        FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(builder2.finish());
        if (fairDiffIterable == null) {
            ByChar.$$$reportNull$$$0(22);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static FairDiffIterable matchAdjustmentSpaces(@NotNull CharOffsets chars1, @NotNull CharOffsets chars2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes, @NotNull ProgressIndicator indicator) {
        if (chars1 == null) {
            ByChar.$$$reportNull$$$0(23);
        }
        if (chars2 == null) {
            ByChar.$$$reportNull$$$0(24);
        }
        if (text1 == null) {
            ByChar.$$$reportNull$$$0(25);
        }
        if (text2 == null) {
            ByChar.$$$reportNull$$$0(26);
        }
        if (changes == null) {
            ByChar.$$$reportNull$$$0(27);
        }
        if (indicator == null) {
            ByChar.$$$reportNull$$$0(28);
        }
        FairDiffIterable fairDiffIterable = new ChangeCorrector.DefaultCharChangeCorrector(chars1, chars2, text1, text2, changes, indicator).build();
        if (fairDiffIterable == null) {
            ByChar.$$$reportNull$$$0(29);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static DiffIterable matchAdjustmentSpacesIW(@NotNull CharOffsets chars1, @NotNull CharOffsets chars2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes) {
        if (chars1 == null) {
            ByChar.$$$reportNull$$$0(30);
        }
        if (chars2 == null) {
            ByChar.$$$reportNull$$$0(31);
        }
        if (text1 == null) {
            ByChar.$$$reportNull$$$0(32);
        }
        if (text2 == null) {
            ByChar.$$$reportNull$$$0(33);
        }
        if (changes == null) {
            ByChar.$$$reportNull$$$0(34);
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Range ch : changes.iterateChanges()) {
            int startOffset2;
            int endOffset2;
            int startOffset1;
            int endOffset1;
            if (ch.start1 == ch.end1) {
                startOffset1 = endOffset1 = ByChar.expandForwardW(chars1, chars2, text1, text2, ch, true);
            } else {
                startOffset1 = chars1.offsets[ch.start1];
                endOffset1 = chars1.offsets[ch.end1 - 1] + 1;
            }
            if (ch.start2 == ch.end2) {
                startOffset2 = endOffset2 = ByChar.expandForwardW(chars1, chars2, text1, text2, ch, false);
            } else {
                startOffset2 = chars2.offsets[ch.start2];
                endOffset2 = chars2.offsets[ch.end2 - 1] + 1;
            }
            ranges.add(new Range(startOffset1, endOffset1, startOffset2, endOffset2));
        }
        DiffIterable diffIterable = DiffIterableUtil.create(ranges, text1.length(), text2.length());
        if (diffIterable == null) {
            ByChar.$$$reportNull$$$0(35);
        }
        return diffIterable;
    }

    private static int expandForwardW(@NotNull CharOffsets chars1, @NotNull CharOffsets chars2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull Range ch, boolean left) {
        if (chars1 == null) {
            ByChar.$$$reportNull$$$0(36);
        }
        if (chars2 == null) {
            ByChar.$$$reportNull$$$0(37);
        }
        if (text1 == null) {
            ByChar.$$$reportNull$$$0(38);
        }
        if (text2 == null) {
            ByChar.$$$reportNull$$$0(39);
        }
        if (ch == null) {
            ByChar.$$$reportNull$$$0(40);
        }
        int offset1 = ch.start1 == 0 ? 0 : chars1.offsets[ch.start1 - 1] + 1;
        int offset2 = ch.start2 == 0 ? 0 : chars2.offsets[ch.start2 - 1] + 1;
        int start = left ? offset1 : offset2;
        return start + TrimUtil.expandWhitespacesForward(text1, text2, offset1, offset2, text1.length(), text2.length());
    }

    @NotNull
    private static int[] getAllChars(@NotNull CharSequence text) {
        if (text == null) {
            ByChar.$$$reportNull$$$0(41);
        }
        int[] chars = new int[text.length()];
        for (int i = 0; i < text.length(); ++i) {
            chars[i] = text.charAt(i);
        }
        if (chars == null) {
            ByChar.$$$reportNull$$$0(42);
        }
        return chars;
    }

    @NotNull
    private static CharOffsets getNonSpaceChars(@NotNull CharSequence text) {
        if (text == null) {
            ByChar.$$$reportNull$$$0(43);
        }
        TIntArrayList chars = new TIntArrayList(text.length());
        TIntArrayList offsets = new TIntArrayList(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (StringUtil.isWhiteSpace((char)c)) continue;
            chars.add((int)c);
            offsets.add(i);
        }
        CharOffsets charOffsets = new CharOffsets(chars.toNativeArray(), offsets.toNativeArray());
        if (charOffsets == null) {
            ByChar.$$$reportNull$$$0(44);
        }
        return charOffsets;
    }

    @NotNull
    private static CharOffsets getPunctuationChars(@NotNull CharSequence text) {
        if (text == null) {
            ByChar.$$$reportNull$$$0(45);
        }
        TIntArrayList chars = new TIntArrayList(text.length());
        TIntArrayList offsets = new TIntArrayList(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!TrimUtil.isPunctuation(c)) continue;
            chars.add((int)c);
            offsets.add(i);
        }
        CharOffsets charOffsets = new CharOffsets(chars.toNativeArray(), offsets.toNativeArray());
        if (charOffsets == null) {
            ByChar.$$$reportNull$$$0(46);
        }
        return charOffsets;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 22: 
            case 29: 
            case 35: 
            case 42: 
            case 44: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 22: 
            case 29: 
            case 35: 
            case 42: 
            case 44: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 19: 
            case 26: 
            case 33: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: 
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 22: 
            case 29: 
            case 35: 
            case 42: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/comparison/ByChar";
                break;
            }
            case 16: 
            case 23: 
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars1";
                break;
            }
            case 17: 
            case 24: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars2";
                break;
            }
            case 20: 
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ch";
                break;
            }
            case 41: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/comparison/ByChar";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "compare";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "compareTwoStep";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "compareIgnoreWhitespaces";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "comparePunctuation";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "transfer";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "matchAdjustmentSpaces";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "matchAdjustmentSpacesIW";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChars";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonSpaceChars";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getPunctuationChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 22: 
            case 29: 
            case 35: 
            case 42: 
            case 44: 
            case 46: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compareTwoStep";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "compareIgnoreWhitespaces";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "comparePunctuation";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "transfer";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "matchAdjustmentSpaces";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "matchAdjustmentSpacesIW";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "expandForwardW";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getAllChars";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getNonSpaceChars";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getPunctuationChars";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 22: 
            case 29: 
            case 35: 
            case 42: 
            case 44: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class CharOffsets {
        public final int[] characters;
        public final int[] offsets;

        public CharOffsets(int[] characters, int[] offsets) {
            this.characters = characters;
            this.offsets = offsets;
        }
    }
}

