/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.codeInsight.daemon.OutsidersPsiFileSupport;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.actions.DocumentFragmentContent;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContentImpl;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.contents.FileContentImpl;
import com.intellij.diff.contents.FileDocumentContentImpl;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UIBasedFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.testFramework.BinaryLightVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.LightColors;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffContentFactoryImpl
extends DiffContentFactoryEx {
    private static final Logger LOG = Logger.getInstance(DiffContentFactoryImpl.class);

    @NotNull
    public EmptyContent createEmpty() {
        EmptyContent emptyContent = new EmptyContent();
        if (emptyContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(0);
        }
        return emptyContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(1);
        }
        DocumentContent documentContent = this.create(null, text);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(2);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable FileType type) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(3);
        }
        DocumentContent documentContent = this.create(null, text, type);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(4);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable FileType type, boolean respectLineSeparators) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(5);
        }
        DocumentContent documentContent = this.create(null, text, type, respectLineSeparators);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(6);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable VirtualFile highlightFile) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(7);
        }
        DocumentContent documentContent = this.create(null, text, highlightFile);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(8);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable DocumentContent referent) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(9);
        }
        DocumentContent documentContent = this.create(null, text, referent);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(10);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(11);
        }
        DocumentContent documentContent = this.create(project, text, (FileType)null);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(12);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable FileType type) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(13);
        }
        DocumentContent documentContent = this.create(project, text, type, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(14);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable FileType type, boolean respectLineSeparators) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(15);
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project, text, type, null, null, null, respectLineSeparators, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(16);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @NotNull FilePath filePath) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(17);
        }
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(18);
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project, text, filePath.getFileType(), filePath, filePath.getName(), filePath.getVirtualFile(), true, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(19);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable VirtualFile highlightFile) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(20);
        }
        FileType fileType = highlightFile != null ? highlightFile.getFileType() : null;
        FilePath filePath = highlightFile != null ? VcsUtil.getFilePath((VirtualFile)highlightFile) : null;
        String fileName = highlightFile != null ? highlightFile.getName() : null;
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project, text, fileType, filePath, fileName, highlightFile, true, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(21);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable DocumentContent referent) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(22);
        }
        if (referent == null) {
            DocumentContent documentContent = this.create(text);
            if (documentContent == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(23);
            }
            return documentContent;
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project, text, referent.getContentType(), null, null, referent.getHighlightFile(), false, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(24);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent createEditable(@Nullable Project project, @NotNull String text, @Nullable FileType fileType) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(25);
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project, text, fileType, null, null, null, false, false);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(26);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull Document document, @Nullable DocumentContent referent) {
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(27);
        }
        DocumentContent documentContent = this.create(null, document, referent);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(28);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(29);
        }
        DocumentContent documentContent = this.create(project, document, (FileType)null);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(30);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document, @Nullable FileType fileType) {
        VirtualFile file2;
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(31);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile(document)) != null) {
            FileDocumentContentImpl fileDocumentContentImpl = new FileDocumentContentImpl(project, document, file2);
            if (fileDocumentContentImpl == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(32);
            }
            return fileDocumentContentImpl;
        }
        DocumentContentImpl documentContentImpl = new DocumentContentImpl(project, document, fileType, null, null, null, null);
        if (documentContentImpl == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(33);
        }
        return documentContentImpl;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document, @Nullable VirtualFile highlightFile) {
        VirtualFile file2;
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(34);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile(document)) != null && file2.equals(highlightFile)) {
            FileDocumentContentImpl fileDocumentContentImpl = new FileDocumentContentImpl(project, document, file2);
            if (fileDocumentContentImpl == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(35);
            }
            return fileDocumentContentImpl;
        }
        if (highlightFile == null) {
            DocumentContentImpl documentContentImpl = new DocumentContentImpl(document);
            if (documentContentImpl == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(36);
            }
            return documentContentImpl;
        }
        DocumentContentImpl documentContentImpl = new DocumentContentImpl(project, document, highlightFile.getFileType(), highlightFile, null, null, null);
        if (documentContentImpl == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(37);
        }
        return documentContentImpl;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document, @Nullable DocumentContent referent) {
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(38);
        }
        if (referent == null) {
            DocumentContentImpl documentContentImpl = new DocumentContentImpl(document);
            if (documentContentImpl == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(39);
            }
            return documentContentImpl;
        }
        DocumentContentImpl documentContentImpl = new DocumentContentImpl(project, document, referent.getContentType(), referent.getHighlightFile(), null, null, null);
        if (documentContentImpl == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(40);
        }
        return documentContentImpl;
    }

    @NotNull
    public DiffContent create(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(41);
        }
        DiffContent diffContent = DiffContentFactoryImpl.createContentFromFile(project, file2);
        if (diffContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(42);
        }
        return diffContent;
    }

    @Nullable
    public DocumentContent createDocument(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(43);
        }
        return (DocumentContent)ObjectUtils.tryCast((Object)DiffContentFactoryImpl.createContentFromFile(project, file2), DocumentContent.class);
    }

    @Nullable
    public FileContent createFile(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(44);
        }
        if (file2.isDirectory()) {
            return null;
        }
        return (FileContent)this.create(project, file2);
    }

    @NotNull
    public DocumentContent createFragment(@Nullable Project project, @NotNull Document document, @NotNull TextRange range2) {
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(45);
        }
        if (range2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(46);
        }
        DocumentContent content = this.create(project, document);
        DocumentContent documentContent = this.createFragment(project, content, range2);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(47);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent createFragment(@Nullable Project project, @NotNull DocumentContent content, @NotNull TextRange range2) {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(48);
        }
        if (range2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(49);
        }
        DocumentFragmentContent documentFragmentContent = new DocumentFragmentContent(project, content, range2);
        if (documentFragmentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(50);
        }
        return documentFragmentContent;
    }

    @NotNull
    public DiffContent createClipboardContent() {
        DocumentContent documentContent = this.createClipboardContent(null, null);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(51);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent createClipboardContent(@Nullable DocumentContent referent) {
        DocumentContent documentContent = this.createClipboardContent(null, referent);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(52);
        }
        return documentContent;
    }

    @NotNull
    public DiffContent createClipboardContent(@Nullable Project project) {
        DocumentContent documentContent = this.createClipboardContent(project, null);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(53);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent createClipboardContent(@Nullable Project project, @Nullable DocumentContent referent) {
        String text = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        FileType type = referent != null ? referent.getContentType() : null;
        VirtualFile highlightFile = referent != null ? referent.getHighlightFile() : null;
        FilePath filePath = highlightFile != null ? VcsUtil.getFilePath((VirtualFile)highlightFile) : null;
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project, StringUtil.notNullize((String)text), type, filePath, "Clipboard.txt", highlightFile, false, false);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(54);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, @NotNull byte[] content, @NotNull FilePath filePath) throws IOException {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(55);
        }
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(56);
        }
        DiffContent diffContent = this.createFromBytes(project, content, filePath, null);
        if (diffContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(57);
        }
        return diffContent;
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, @NotNull byte[] content, @NotNull FilePath filePath, @Nullable Charset defaultCharset) throws IOException {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(58);
        }
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(59);
        }
        if (defaultCharset == null && DiffContentFactoryImpl.isBinaryContent(content, filePath.getFileType())) {
            DiffContent diffContent = DiffContentFactoryImpl.createBinaryImpl(project, content, filePath.getFileType(), filePath, filePath.getVirtualFile());
            if (diffContent == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(60);
            }
            return diffContent;
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createDocumentFromBytes(project, content, filePath, defaultCharset);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(61);
        }
        return documentContent;
    }

    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, @NotNull byte[] content, @NotNull FileType fileType, @NotNull String fileName) throws IOException {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(62);
        }
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(63);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(64);
        }
        if (DiffContentFactoryImpl.isBinaryContent(content, fileType)) {
            DiffContent diffContent = DiffContentFactoryImpl.createBinaryImpl(project, content, fileType, VcsUtil.getFilePath((String)fileName), null);
            if (diffContent == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(65);
            }
            return diffContent;
        }
        DocumentContent documentContent = this.createDocumentFromBytes(project, content, fileType, fileName);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(66);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, @NotNull byte[] content, @NotNull VirtualFile highlightFile) throws IOException {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(67);
        }
        if (highlightFile == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(68);
        }
        if (DiffContentFactoryImpl.isBinaryContent(content, highlightFile.getFileType())) {
            DiffContent diffContent = DiffContentFactoryImpl.createBinaryImpl(project, content, highlightFile.getFileType(), VcsUtil.getFilePath((VirtualFile)highlightFile), highlightFile);
            if (diffContent == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(69);
            }
            return diffContent;
        }
        DocumentContent documentContent = this.createDocumentFromBytes(project, content, highlightFile);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(70);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project, @NotNull byte[] content, @NotNull FileType fileType, @NotNull String fileName) {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(71);
        }
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(72);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(73);
        }
        Charset charset = DiffContentFactoryImpl.guessCharset(project, content, fileType);
        DocumentContent documentContent = DiffContentFactoryImpl.createFromBytesImpl(project, content, fileType, null, fileName, null, charset);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(74);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project, @NotNull byte[] content, @NotNull FilePath filePath) {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(75);
        }
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(76);
        }
        Charset charset = DiffContentFactoryImpl.guessCharset(content, filePath);
        DocumentContent documentContent = DiffContentFactoryImpl.createFromBytesImpl(project, content, filePath.getFileType(), filePath, filePath.getName(), filePath.getVirtualFile(), charset);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(77);
        }
        return documentContent;
    }

    @NotNull
    private static DocumentContent createDocumentFromBytes(@Nullable Project project, @NotNull byte[] content, @NotNull FilePath filePath, @Nullable Charset defaultCharset) {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(78);
        }
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(79);
        }
        Charset charset = DiffContentFactoryImpl.guessCharset(content, filePath.getFileType(), defaultCharset != null ? defaultCharset : filePath.getCharset());
        DocumentContent documentContent = DiffContentFactoryImpl.createFromBytesImpl(project, content, filePath.getFileType(), filePath, filePath.getName(), filePath.getVirtualFile(), charset);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(80);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project, @NotNull byte[] content, @NotNull VirtualFile highlightFile) {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(81);
        }
        if (highlightFile == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(82);
        }
        Charset charset = DiffContentFactoryImpl.guessCharset(content, highlightFile);
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)highlightFile);
        DocumentContent documentContent = DiffContentFactoryImpl.createFromBytesImpl(project, content, highlightFile.getFileType(), filePath, highlightFile.getName(), highlightFile, charset);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(83);
        }
        return documentContent;
    }

    @NotNull
    public DiffContent createBinary(@Nullable Project project, @NotNull byte[] content, @NotNull FileType type, @NotNull String fileName) throws IOException {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(84);
        }
        if (type == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(85);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(86);
        }
        DiffContent diffContent = DiffContentFactoryImpl.createBinaryImpl(project, content, type, VcsUtil.getFilePath((String)fileName), null);
        if (diffContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(87);
        }
        return diffContent;
    }

    @NotNull
    private static DiffContent createContentFromFile(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(88);
        }
        DiffContent diffContent = DiffContentFactoryImpl.createContentFromFile(project, file2, file2);
        if (diffContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(89);
        }
        return diffContent;
    }

    @NotNull
    private static DiffContent createContentFromFile(@Nullable Project project, @NotNull VirtualFile file2, @Nullable VirtualFile highlightFile) {
        if (file2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(90);
        }
        if (file2.isDirectory()) {
            DirectoryContentImpl directoryContentImpl = new DirectoryContentImpl(project, file2, highlightFile);
            if (directoryContentImpl == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(91);
            }
            return directoryContentImpl;
        }
        Document document = (Document)ReadAction.compute(() -> {
            if (file2 == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(140);
            }
            return FileDocumentManager.getInstance().getDocument(file2);
        });
        if (document != null) {
            FileDocumentContentImpl fileDocumentContentImpl = new FileDocumentContentImpl(project, document, file2, highlightFile);
            if (fileDocumentContentImpl == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(92);
            }
            return fileDocumentContentImpl;
        }
        FileContentImpl fileContentImpl = new FileContentImpl(project, file2, highlightFile);
        if (fileContentImpl == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(93);
        }
        return fileContentImpl;
    }

    @NotNull
    private static DiffContent createBinaryImpl(@Nullable Project project, @NotNull byte[] content, @NotNull FileType type, @NotNull FilePath path, @Nullable VirtualFile highlightFile) throws IOException {
        Object file2;
        boolean useTemporalFile;
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(94);
        }
        if (type == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(95);
        }
        if (path == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(96);
        }
        boolean bl = useTemporalFile = type instanceof ArchiveFileType || BinaryFileTypeDecompilers.INSTANCE.forFileType(type) != null;
        if (useTemporalFile) {
            file2 = DiffContentFactoryImpl.createTemporalFile(project, "tmp", path.getName(), content);
        } else {
            file2 = new MyBinaryLightVirtualFile(path, type, content);
            file2.setWritable(false);
        }
        file2.putUserData(DiffUtil.TEMP_FILE_KEY, (Object)Boolean.TRUE);
        DiffContent diffContent = DiffContentFactoryImpl.createContentFromFile(project, file2, highlightFile);
        if (diffContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(97);
        }
        return diffContent;
    }

    @NotNull
    private static DocumentContent createImpl(@Nullable Project project, @NotNull String text, @Nullable FileType fileType, @Nullable FilePath originalFilePath, @Nullable String fileName, @Nullable VirtualFile highlightFile, boolean respectLineSeparators, boolean readOnly) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(98);
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project, text, fileType, originalFilePath, fileName, highlightFile, null, null, respectLineSeparators, readOnly);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(99);
        }
        return documentContent;
    }

    @NotNull
    private static DocumentContent createImpl(@Nullable Project project, @NotNull String text, @Nullable FileType fileType, @Nullable FilePath originalFilePath, @Nullable String fileName, @Nullable VirtualFile highlightFile, @Nullable Charset charset, @Nullable Boolean bom, boolean respectLineSeparators, boolean readOnly) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(100);
        }
        if (FileTypes.UNKNOWN.equals(fileType)) {
            fileType = PlainTextFileType.INSTANCE;
        }
        LineSeparator separator = respectLineSeparators ? StringUtil.detectSeparators((CharSequence)text) : null;
        String correctedContent = StringUtil.convertLineSeparators((String)text);
        Document document = DiffContentFactoryImpl.createDocument(project, correctedContent, fileType, originalFilePath, fileName, readOnly);
        DocumentContentImpl content = new DocumentContentImpl(project, document, (FileType)fileType, highlightFile, separator, charset, bom);
        if (fileName != null) {
            content.putUserData(DiffUserDataKeysEx.FILE_NAME, fileName);
        }
        DocumentContentImpl documentContentImpl = content;
        if (documentContentImpl == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(101);
        }
        return documentContentImpl;
    }

    @NotNull
    private static DocumentContent createFromBytesImpl(@Nullable Project project, @NotNull byte[] content, @NotNull FileType fileType, @Nullable FilePath originalFilePath, @NotNull String fileName, @Nullable VirtualFile highlightFile, @NotNull Charset charset) {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(102);
        }
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(103);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(104);
        }
        if (charset == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(105);
        }
        if (fileType.isBinary()) {
            fileType = PlainTextFileType.INSTANCE;
        }
        boolean isBOM = CharsetToolkit.guessFromBOM((byte[])content) != null;
        boolean malformedContent = false;
        String text = CharsetToolkit.tryDecodeString((byte[])content, (Charset)charset);
        if (text == null) {
            text = CharsetToolkit.decodeString((byte[])content, (Charset)charset);
            malformedContent = true;
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project, text, fileType, originalFilePath, fileName, highlightFile, charset, isBOM, true, true);
        if (malformedContent) {
            String notificationText = "Content was decoded with errors (using '" + charset.name() + "' charset)";
            DiffUtil.addNotification(DiffNotifications.createNotification(notificationText, LightColors.RED), (UserDataHolder)documentContent);
        }
        DocumentContent documentContent2 = documentContent;
        if (documentContent2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(106);
        }
        return documentContent2;
    }

    @NotNull
    private static VirtualFile createTemporalFile(@Nullable Project project, @NotNull String prefix, @NotNull String suffix, @NotNull byte[] content) throws IOException {
        VirtualFile file2;
        if (prefix == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(107);
        }
        if (suffix == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(108);
        }
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(109);
        }
        File tempFile = FileUtil.createTempFile((String)PathUtil.suggestFileName((String)(prefix + "_"), (boolean)true, (boolean)false), (String)PathUtil.suggestFileName((String)("_" + suffix), (boolean)true, (boolean)false), (boolean)true);
        if (content.length != 0) {
            FileUtil.writeToFile((File)tempFile, (byte[])content);
        }
        if (!tempFile.setWritable(false, false)) {
            LOG.warn("Can't set writable attribute of temporal file");
        }
        if ((file2 = VfsUtil.findFileByIoFile((File)tempFile, (boolean)true)) == null) {
            throw new IOException("Can't create temp file for revision content");
        }
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{file2});
        VirtualFile virtualFile = file2;
        if (virtualFile == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(110);
        }
        return virtualFile;
    }

    @NotNull
    private static Document createDocument(@Nullable Project project, @NotNull String content, @Nullable FileType fileType, @Nullable FilePath originalFilePath, @Nullable String fileName, boolean readOnly) {
        Document document;
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(111);
        }
        if (project != null && !project.isDefault() && fileType != null && !fileType.isBinary() && Registry.is((String)"diff.enable.psi.highlighting")) {
            if (fileName == null) {
                fileName = "diff." + StringUtil.defaultIfEmpty((String)fileType.getDefaultExtension(), (String)"txt");
            }
            if ((document = DiffContentFactoryImpl.createPsiDocument(project, content, fileType, originalFilePath, fileName, readOnly)) != null) {
                Document document2 = document;
                if (document2 == null) {
                    DiffContentFactoryImpl.$$$reportNull$$$0(112);
                }
                return document2;
            }
        }
        document = EditorFactory.getInstance().createDocument((CharSequence)content);
        document.setReadOnly(readOnly);
        Document document3 = document;
        if (document3 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(113);
        }
        return document3;
    }

    @Nullable
    private static Document createPsiDocument(@NotNull Project project, @NotNull String content, @NotNull FileType fileType, @Nullable FilePath originalFilePath, @NotNull String fileName, boolean readOnly) {
        if (project == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(114);
        }
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(115);
        }
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(116);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(117);
        }
        return (Document)ReadAction.compute(() -> {
            if (fileName == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(136);
            }
            if (fileType == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(137);
            }
            if (content == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(138);
            }
            if (project == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(139);
            }
            LightVirtualFile file2 = new LightVirtualFile(fileName, fileType, (CharSequence)content);
            file2.setWritable(!readOnly);
            OutsidersPsiFileSupport.markFile((VirtualFile)file2, originalFilePath != null ? originalFilePath.getPath() : null);
            Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)file2);
            if (document == null) {
                return null;
            }
            PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            return document;
        });
    }

    private static boolean isBinaryContent(@NotNull byte[] content, @NotNull FileType fileType) {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(118);
        }
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(119);
        }
        if (UnknownFileType.INSTANCE.equals(fileType)) {
            return DiffContentFactoryImpl.guessCharsetFromContent(content) == null;
        }
        if (fileType instanceof UIBasedFileType) {
            return true;
        }
        return fileType.isBinary();
    }

    @NotNull
    public static Charset guessCharset(@NotNull byte[] content, @NotNull FilePath filePath) {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(120);
        }
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(121);
        }
        Charset charset = DiffContentFactoryImpl.guessCharset(content, filePath.getFileType(), filePath.getCharset());
        if (charset == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(122);
        }
        return charset;
    }

    @NotNull
    public static Charset guessCharset(@NotNull byte[] content, @NotNull VirtualFile highlightFile) {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(123);
        }
        if (highlightFile == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(124);
        }
        Charset charset = DiffContentFactoryImpl.guessCharset(content, highlightFile.getFileType(), highlightFile.getCharset());
        if (charset == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(125);
        }
        return charset;
    }

    @NotNull
    public static Charset guessCharset(@Nullable Project project, @NotNull byte[] content, @NotNull FileType fileType) {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(126);
        }
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(127);
        }
        EncodingManager e = project != null ? EncodingProjectManager.getInstance((Project)project) : EncodingManager.getInstance();
        Charset charset = DiffContentFactoryImpl.guessCharset(content, fileType, e.getDefaultCharset());
        if (charset == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(128);
        }
        return charset;
    }

    @NotNull
    private static Charset guessCharset(@NotNull byte[] content, @NotNull FileType fileType, @NotNull Charset defaultCharset) {
        Charset guessedCharset;
        Charset bomCharset;
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(129);
        }
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(130);
        }
        if (defaultCharset == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(131);
        }
        if ((bomCharset = CharsetToolkit.guessFromBOM((byte[])content)) != null) {
            Charset charset = bomCharset;
            if (charset == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(132);
            }
            return charset;
        }
        if (fileType.isBinary() && (guessedCharset = DiffContentFactoryImpl.guessCharsetFromContent(content)) != null) {
            Charset charset = guessedCharset;
            if (charset == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(133);
            }
            return charset;
        }
        Charset charset = defaultCharset;
        if (charset == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(134);
        }
        return charset;
    }

    @Nullable
    private static Charset guessCharsetFromContent(@NotNull byte[] content) {
        CharsetToolkit toolkit;
        Charset fromBOM;
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(135);
        }
        if ((fromBOM = (toolkit = new CharsetToolkit(content)).guessFromBOM()) != null) {
            return fromBOM;
        }
        CharsetToolkit.GuessedEncoding guessedEncoding = toolkit.guessFromContent(content.length);
        switch (guessedEncoding) {
            case SEVEN_BIT: {
                return Charset.forName("US-ASCII");
            }
            case VALID_UTF8: {
                return CharsetToolkit.UTF8_CHARSET;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 90: 
            case 94: 
            case 95: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 90: 
            case 94: 
            case 95: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/DiffContentFactoryImpl";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 98: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: 
            case 56: 
            case 59: 
            case 76: 
            case 79: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 38: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 41: 
            case 43: 
            case 44: 
            case 88: 
            case 90: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 48: 
            case 55: 
            case 58: 
            case 62: 
            case 67: 
            case 71: 
            case 75: 
            case 78: 
            case 81: 
            case 84: 
            case 94: 
            case 102: 
            case 109: 
            case 111: 
            case 115: 
            case 118: 
            case 120: 
            case 123: 
            case 126: 
            case 129: 
            case 135: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 63: 
            case 72: 
            case 103: 
            case 116: 
            case 119: 
            case 127: 
            case 130: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 64: 
            case 73: 
            case 86: 
            case 104: 
            case 117: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 68: 
            case 82: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightFile";
                break;
            }
            case 85: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 114: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmpty";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 90: 
            case 94: 
            case 95: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/DiffContentFactoryImpl";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditable";
                break;
            }
            case 47: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createFragment";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "createClipboardContent";
                break;
            }
            case 57: 
            case 60: 
            case 61: 
            case 65: 
            case 66: 
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromBytes";
                break;
            }
            case 74: 
            case 77: 
            case 80: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocumentFromBytes";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinary";
                break;
            }
            case 89: 
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "createContentFromFile";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinaryImpl";
                break;
            }
            case 99: 
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "createImpl";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromBytesImpl";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporalFile";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 122: 
            case 125: 
            case 128: 
            case 132: 
            case 133: 
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "guessCharset";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 38: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createEditable";
                break;
            }
            case 43: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createFragment";
                break;
            }
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createFromBytes";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "createDocumentFromBytes";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "createBinary";
                break;
            }
            case 88: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "createContentFromFile";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryImpl";
                break;
            }
            case 98: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "createImpl";
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "createFromBytesImpl";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "createTemporalFile";
                break;
            }
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "createPsiDocument";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryContent";
                break;
            }
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "guessCharset";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "guessCharsetFromContent";
                break;
            }
            case 136: 
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createPsiDocument$1";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createContentFromFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 90: 
            case 94: 
            case 95: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyBinaryLightVirtualFile
    extends BinaryLightVirtualFile {
        private final FilePath myPath;

        public MyBinaryLightVirtualFile(@NotNull FilePath path, FileType type, @NotNull byte[] content) {
            if (path == null) {
                MyBinaryLightVirtualFile.$$$reportNull$$$0(0);
            }
            if (content == null) {
                MyBinaryLightVirtualFile.$$$reportNull$$$0(1);
            }
            super(path.getName(), type, content);
            this.myPath = path;
        }

        @NotNull
        public String getPath() {
            String string = this.myPath.getPath();
            if (string == null) {
                MyBinaryLightVirtualFile.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/DiffContentFactoryImpl$MyBinaryLightVirtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/DiffContentFactoryImpl$MyBinaryLightVirtualFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

