/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.PasswordSafeConfigurableKt;
import com.intellij.credentialStore.PasswordSafeSettingsListener;
import com.intellij.credentialStore.ProviderType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="PasswordSafe", storages={@Storage(value="security.xml", roamingType=RoamingType.DISABLED)})
public class PasswordSafeSettings
implements PersistentStateComponent<State> {
    public static final Topic<PasswordSafeSettingsListener> TOPIC = Topic.create((String)"PasswordSafeSettingsListener", PasswordSafeSettingsListener.class);
    private State state = new State();

    @NotNull
    private static ProviderType getDefaultProviderType() {
        ProviderType providerType = SystemInfo.isWindows ? ProviderType.KEEPASS : ProviderType.KEYCHAIN;
        if (providerType == null) {
            PasswordSafeSettings.$$$reportNull$$$0(0);
        }
        return providerType;
    }

    @NotNull
    public ProviderType getProviderType() {
        ProviderType providerType = SystemInfo.isWindows && this.state.PROVIDER == ProviderType.KEYCHAIN ? ProviderType.KEEPASS : this.state.PROVIDER;
        if (providerType == null) {
            PasswordSafeSettings.$$$reportNull$$$0(1);
        }
        return providerType;
    }

    public void setProviderType(@NotNull ProviderType value) {
        ProviderType oldValue;
        if (value == null) {
            PasswordSafeSettings.$$$reportNull$$$0(2);
        }
        if (value == ProviderType.DO_NOT_STORE) {
            value = ProviderType.MEMORY_ONLY;
        }
        if (value != (oldValue = this.state.PROVIDER)) {
            this.state.PROVIDER = value;
            Application app = ApplicationManager.getApplication();
            if (app != null) {
                ((PasswordSafeSettingsListener)app.getMessageBus().syncPublisher(TOPIC)).typeChanged(oldValue, value);
            }
        }
    }

    @NotNull
    public State getState() {
        if (this.state.keepassDb != null && this.state.keepassDb.equals(PasswordSafeConfigurableKt.getDefaultKeePassDbFilePath())) {
            this.state.keepassDb = null;
        }
        State state = this.state;
        if (state == null) {
            PasswordSafeSettings.$$$reportNull$$$0(3);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            PasswordSafeSettings.$$$reportNull$$$0(4);
        }
        this.state = state;
        this.setProviderType((ProviderType)((Object)ObjectUtils.chooseNotNull((Object)((Object)state.PROVIDER), (Object)((Object)PasswordSafeSettings.getDefaultProviderType()))));
        state.keepassDb = StringUtil.nullize((String)state.keepassDb, (boolean)true);
    }

    static /* synthetic */ ProviderType access$000() {
        return PasswordSafeSettings.getDefaultProviderType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/credentialStore/PasswordSafeSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProviderType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderType";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/credentialStore/PasswordSafeSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setProviderType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State {
        public ProviderType PROVIDER = PasswordSafeSettings.access$000();
        public String keepassDb;
        public boolean isRememberPasswordByDefault = true;
    }
}

