/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.CredentialStoreWrapperKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.KeePassCredentialStore;
import com.intellij.credentialStore.kdbx.KdbxKt;
import com.intellij.credentialStore.kdbx.KdbxPassword;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.ide.passwordSafe.PasswordStorage;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.util.io.PathKt;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\b\b\u0002\u0010\b\u001a\u00020\u0006H\u0000\u001a$\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0014H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"DB_FILE_NAME", "", "GROUP_NAME", "copyFileDatabase", "Lcom/intellij/credentialStore/KeePassCredentialStore;", "path", "Ljava/nio/file/Path;", "masterPassword", "baseDirectory", "copyTo", "", "from", "", "Lcom/intellij/credentialStore/CredentialAttributes;", "Lcom/intellij/credentialStore/Credentials;", "store", "Lcom/intellij/ide/passwordSafe/PasswordStorage;", "loadOrNewOnError", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "dbFile", "", "intellij.platform.credentialStore"})
public final class KeePassCredentialStoreKt {
    private static final String GROUP_NAME = "IntelliJ Platform";
    @NotNull
    public static final String DB_FILE_NAME = "c.kdbx";

    private static final KeePassDatabase loadOrNewOnError(Path dbFile, byte[] masterPassword) {
        KeePassDatabase keePassDatabase;
        if (!PathKt.exists((Path)dbFile)) {
            return new KeePassDatabase(null, 1, null);
        }
        try {
            keePassDatabase = KdbxKt.loadKdbx(dbFile, new KdbxPassword(masterPassword));
        }
        catch (Throwable e) {
            CredentialStoreKt.getLOG().error(e);
            Logger $receiver$iv = CredentialStoreKt.getLOG();
            try {
                Path path = dbFile.getParent().resolve("corrupted.c.kdbx");
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"dbFile.parent.resolve(\"corrupted.c.kdbx\")");
                PathKt.move((Path)dbFile, (Path)path);
            }
            catch (ProcessCanceledException e$iv) {
            }
            catch (Throwable e$iv) {
                $receiver$iv.error(e$iv);
            }
            CredentialStoreWrapperKt.getNOTIFICATION_MANAGER().notify("KeePass database file is corrupted, new one is created", (Project)null);
            keePassDatabase = new KeePassDatabase(null, 1, null);
        }
        return keePassDatabase;
    }

    @NotNull
    public static final KeePassCredentialStore copyFileDatabase(@NotNull Path path, @NotNull String masterPassword, @NotNull Path baseDirectory) {
        KeePassCredentialStore keePassCredentialStore;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)masterPassword, (String)"masterPassword");
        Intrinsics.checkParameterIsNotNull((Object)baseDirectory, (String)"baseDirectory");
        Path dbFile = baseDirectory.resolve(DB_FILE_NAME);
        Files.copy(path, dbFile, StandardCopyOption.REPLACE_EXISTING);
        Path path2 = dbFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"dbFile");
        FileUtilKt.setOwnerPermissions(path2);
        String string = masterPassword;
        Path path3 = dbFile;
        boolean bl = false;
        Path path4 = baseDirectory;
        Map map = null;
        KeePassCredentialStore keePassCredentialStore2 = keePassCredentialStore;
        KeePassCredentialStore keePassCredentialStore3 = keePassCredentialStore;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        keePassCredentialStore2(map, path4, bl, path3, byArray2, 5, null);
        return keePassCredentialStore3;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KeePassCredentialStore copyFileDatabase$default(Path path, String string, Path path2, int n, Object object) {
        if ((n & 4) != 0) {
            Path path3 = Paths.get(PathManager.getConfigPath(), new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Paths.get(PathManager.getConfigPath())");
            path2 = path3;
        }
        return KeePassCredentialStoreKt.copyFileDatabase(path, string, path2);
    }

    public static final void copyTo(@NotNull Map<CredentialAttributes, Credentials> from, @NotNull PasswordStorage store) {
        Intrinsics.checkParameterIsNotNull(from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        Map<CredentialAttributes, Credentials> map = from;
        Iterator<Map.Entry<CredentialAttributes, Credentials>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<CredentialAttributes, Credentials> entry;
            Map.Entry<CredentialAttributes, Credentials> entry2 = entry = iterator.next();
            CredentialAttributes k = entry2.getKey();
            entry2 = entry;
            Credentials v = entry2.getValue();
            store.set(k, v);
        }
    }

    @NotNull
    public static final /* synthetic */ KeePassDatabase access$loadOrNewOnError(@NotNull Path dbFile, @NotNull byte[] masterPassword) {
        return KeePassCredentialStoreKt.loadOrNewOnError(dbFile, masterPassword);
    }
}

