/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ModuleStoreImpl;
import com.intellij.configurationStore.StateLoadPolicy;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.module.Module;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/configurationStore/TestModuleStore;", "Lcom/intellij/configurationStore/ModuleStoreImpl;", "module", "Lcom/intellij/openapi/module/Module;", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/components/PathMacroManager;)V", "loadPolicy", "Lcom/intellij/configurationStore/StateLoadPolicy;", "getLoadPolicy", "()Lcom/intellij/configurationStore/StateLoadPolicy;", "moduleComponentLoadPolicy", "setPath", "", "path", "", "isNew", "", "intellij.platform.configurationStore.impl"})
final class TestModuleStore
extends ModuleStoreImpl {
    private StateLoadPolicy moduleComponentLoadPolicy;

    @Override
    public void setPath(@NotNull String path, boolean isNew) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        super.setPath(path, isNew);
        if (!isNew) {
            Path path2 = Paths.get(path, new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(path)");
            if (PathKt.exists((Path)path2)) {
                this.moduleComponentLoadPolicy = StateLoadPolicy.LOAD;
            }
        }
    }

    @Override
    @NotNull
    public StateLoadPolicy getLoadPolicy() {
        StateLoadPolicy stateLoadPolicy = this.moduleComponentLoadPolicy;
        if (stateLoadPolicy == null) {
            IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)this.getProject$intellij_platform_configurationStore_impl());
            if (iComponentStore == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
            }
            stateLoadPolicy = ((ComponentStoreImpl)iComponentStore).getLoadPolicy();
        }
        return stateLoadPolicy;
    }

    public TestModuleStore(@NotNull Module module, @NotNull PathMacroManager pathMacroManager) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)pathMacroManager, (String)"pathMacroManager");
        super(module, pathMacroManager);
    }
}

