/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ExportSettingsActionKt;
import com.intellij.configurationStore.ExportableItem;
import com.intellij.configurationStore.SchemeManagerFactoryBase;
import com.intellij.configurationStore.SchemeManagerImpl;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceBean;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.ServiceManagerImpl;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.ZipUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a$\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a&\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u001aD\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\u0010\b\u0002\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0006\u001a \u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000bH\u0002\u00a8\u0006\""}, d2={"exportInstalledPlugins", "", "zipOut", "Ljava/util/zip/ZipOutputStream;", "exportSettings", "exportFiles", "", "Ljava/nio/file/Path;", "out", "Ljava/io/OutputStream;", "configPath", "", "getComponentPresentableName", "state", "Lcom/intellij/openapi/components/State;", "aClass", "Ljava/lang/Class;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "getExportableComponentsMap", "", "", "Lcom/intellij/configurationStore/ExportableItem;", "onlyExisting", "", "computePresentableNames", "storageManager", "Lcom/intellij/configurationStore/StateStorageManager;", "onlyPaths", "messageOrDefault", "classLoader", "Ljava/lang/ClassLoader;", "bundleName", "defaultName", "intellij.platform.configurationStore.impl"})
public final class ExportSettingsActionKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void exportSettings(@NotNull Set<? extends Path> exportFiles, @NotNull OutputStream out, @NotNull String configPath) {
        Intrinsics.checkParameterIsNotNull(exportFiles, (String)"exportFiles");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        Intrinsics.checkParameterIsNotNull((Object)configPath, (String)"configPath");
        Closeable closeable = new ZipOutputStream(out);
        Throwable throwable = null;
        try {
            ZipOutputStream it = (ZipOutputStream)closeable;
            THashSet writtenItemRelativePaths = new THashSet();
            for (Path path : exportFiles) {
                String relativePath;
                if (!PathKt.exists((Path)path)) continue;
                Path path2 = path.toAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file.toAbsolutePath()");
                if (FileUtilRt.getRelativePath((String)configPath, (String)PathKt.getSystemIndependentPath((Path)path2), (char)'/') == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)relativePath, (String)"FileUtilRt.getRelativePa\u2026emIndependentPath, '/')!!");
                ZipUtil.addFileOrDirRecursively((ZipOutputStream)it, null, (File)path.toFile(), (String)relativePath, null, (Set)((Set)writtenItemRelativePaths));
            }
            ExportSettingsActionKt.exportInstalledPlugins(it);
            it.putNextEntry(new ZipEntry("IntelliJ IDEA Global Settings"));
            it.closeEntry();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void exportInstalledPlugins(@NotNull ZipOutputStream zipOut) {
        Object $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)zipOut, (String)"zipOut");
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins();
        Intrinsics.checkExpressionValueIsNotNull((Object)ideaPluginDescriptorArray, (String)"PluginManagerCore.getPlugins()");
        Object $receiver$iv = ideaPluginDescriptorArray;
        IdeaPluginDescriptor[] ideaPluginDescriptorArray2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (IdeaPluginDescriptor element$iv$iv : $receiver$iv$iv) {
            void it;
            void v1 = it = element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            if (!(!v1.isBundled() && it.isEnabled())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            IdeaPluginDescriptor element$iv$iv;
            Object item$iv$iv = iterator.next();
            element$iv$iv = (IdeaPluginDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            PluginId pluginId = v2.getPluginId();
            Intrinsics.checkExpressionValueIsNotNull((Object)pluginId, (String)"it.pluginId");
            String string = pluginId.getIdString();
            collection.add(string);
        }
        List plugins2 = (List)destination$iv$iv;
        if (!plugins2.isEmpty()) {
            zipOut.putNextEntry(new ZipEntry("installed.txt"));
            try {
                PluginManagerCore.writePluginsList(plugins2, new OutputStreamWriter((OutputStream)zipOut, CharsetToolkit.UTF8_CHARSET));
            }
            finally {
                zipOut.closeEntry();
            }
        }
    }

    @NotNull
    public static final Map<Path, List<ExportableItem>> getExportableComponentsMap(boolean onlyExisting, boolean computePresentableNames, @NotNull StateStorageManager storageManager2, @Nullable Set<String> onlyPaths) {
        Intrinsics.checkParameterIsNotNull((Object)storageManager2, (String)"storageManager");
        LinkedHashMap result2 = new LinkedHashMap();
        Function1 processor2 = (Function1)new Function1<ExportableComponent, Unit>(result2){
            final /* synthetic */ LinkedHashMap $result;

            public final void invoke(@NotNull ExportableComponent component) {
                Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
                for (File file2 : component.getExportFiles()) {
                    Path path = file2.toPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file.toPath()");
                    String string = component.getPresentableName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"component.presentableName");
                    ExportableItem item = new ExportableItem(path, string, RoamingType.DEFAULT);
                    UtilKt.putValue((Map)this.$result, (Object)item.getFile(), (Object)item);
                }
            }
            {
                this.$result = linkedHashMap;
                super(1);
            }
        };
        Object[] objectArray = ApplicationManager.getApplication().getComponents(ExportableApplicationComponent.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ApplicationManager.getAp\u2026ionComponent::class.java)");
        for (Object element$iv : objectArray) {
            processor2.invoke(element$iv);
        }
        List list2 = ServiceBean.loadServicesFromBeans((ExtensionPointName)ExportableComponent.EXTENSION_POINT, ExportableComponent.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ServiceBean.loadServices\u2026bleComponent::class.java)");
        Iterable $receiver$iv = list2;
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            processor2.invoke(element$iv);
        }
        String configPath = storageManager2.expandMacros("$ROOT_CONFIG$");
        Function1<Path, Boolean> isSkipFile$ = new Function1<Path, Boolean>(onlyPaths, configPath, onlyExisting){
            final /* synthetic */ Set $onlyPaths;
            final /* synthetic */ String $configPath;
            final /* synthetic */ boolean $onlyExisting;

            public final boolean invoke(@NotNull Path file2) {
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                if (this.$onlyPaths != null) {
                    String string = FileUtilRt.getRelativePath((String)this.$configPath, (String)PathKt.getSystemIndependentPath((Path)file2), (char)'/');
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtilRt.getRelativePa\u2026emIndependentPath, '/')!!");
                    String relativePath = string;
                    if (!StringsKt.contains$default((CharSequence)((Object)file2.getFileName()).toString(), (char)'.', (boolean)false, (int)2, null) && !PathKt.isFile((Path)file2)) {
                        relativePath = relativePath + '/';
                    }
                    if (!this.$onlyPaths.contains(relativePath)) {
                        return true;
                    }
                }
                return this.$onlyExisting && !PathKt.exists((Path)file2);
            }
            {
                this.$onlyPaths = set2;
                this.$configPath = string;
                this.$onlyExisting = bl;
                super(1);
            }
        };
        if (onlyExisting || onlyPaths != null) {
            Set set2 = result2.keySet();
            Intrinsics.checkExpressionValueIsNotNull(set2, (String)"result.keys");
            CollectionsKt.removeAll((Iterable)set2, (Function1)((Function1)new Function1<Path, Boolean>(isSkipFile$){
                final /* synthetic */ getExportableComponentsMap.1 $isSkipFile$1;

                public final boolean invoke(@NotNull Path p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    return this.$isSkipFile$1.invoke(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return null;
                }

                public final String getName() {
                    return "isSkipFile";
                }

                public final String getSignature() {
                    return "invoke(Ljava/nio/file/Path;)Z";
                }
                {
                    this.$isSkipFile$1 = var1_1;
                    super(1);
                }
            }));
        }
        THashMap fileToContent = new THashMap();
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.application.impl.ApplicationImpl");
        }
        ServiceManagerImpl.processAllImplementationClasses((ApplicationImpl)application, new BiPredicate<Class<?>, PluginDescriptor>(storageManager2, isSkipFile$, computePresentableNames, onlyExisting, fileToContent, result2){
            final /* synthetic */ StateStorageManager $storageManager;
            final /* synthetic */ getExportableComponentsMap.1 $isSkipFile$1;
            final /* synthetic */ boolean $computePresentableNames;
            final /* synthetic */ boolean $onlyExisting;
            final /* synthetic */ THashMap $fileToContent;
            final /* synthetic */ LinkedHashMap $result;

            public final boolean test(Class<?> aClass, PluginDescriptor pluginDescriptor) {
                boolean isFileIncluded;
                Path file2;
                CharSequence charSequence;
                CharSequence charSequence2;
                State stateAnnotation = StoreUtil.getStateSpec(aClass);
                if (stateAnnotation == null || (charSequence2 = (CharSequence)stateAnnotation.name()).length() == 0 || ExportableComponent.class.isAssignableFrom(aClass)) {
                    return true;
                }
                Storage storage2 = (Storage)CollectionsKt.firstOrNull(ComponentStoreImplKt.sortByDeprecated(stateAnnotation.storages()));
                if (storage2 == null) {
                    return true;
                }
                Storage storage3 = storage2;
                if (storage3.roamingType() == RoamingType.DISABLED || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass((Class)storage3.storageClass()), (Object)Reflection.getOrCreateKotlinClass(StateStorage.class)) || (charSequence = (CharSequence)StateStorageManagerImplKt.getPath(storage3)).length() == 0) {
                    return true;
                }
                Path additionalExportFile = null;
                String additionalExportPath = stateAnnotation.additionalExportFile();
                CharSequence charSequence3 = additionalExportPath;
                if (charSequence3.length() > 0) {
                    additionalExportFile = additionalExportPath.charAt(0) == '$' ? Paths.get(this.$storageManager.expandMacros(additionalExportPath), new String[0]) : Paths.get(this.$storageManager.expandMacros("$ROOT_CONFIG$"), additionalExportPath);
                    Path path = additionalExportFile;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"additionalExportFile");
                    if (this.$isSkipFile$1.invoke(path)) {
                        additionalExportFile = null;
                    }
                }
                Path path = file2 = Paths.get(this.$storageManager.expandMacros(StateStorageManagerImplKt.getPath(storage3)), new String[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
                boolean bl = isFileIncluded = !this.$isSkipFile$1.invoke(path);
                if (isFileIncluded || additionalExportFile != null) {
                    String presentableName;
                    String string;
                    if (this.$computePresentableNames && this.$onlyExisting && additionalExportFile == null && StringsKt.endsWith$default((String)((Object)file2.getFileName()).toString(), (String)".xml", (boolean)false, (int)2, null)) {
                        String content;
                        Object object;
                        Map $receiver$iv = (Map)this.$fileToContent;
                        V value$iv = $receiver$iv.get(file2);
                        if (value$iv == null) {
                            String answer$iv = PathKt.readText((Path)file2);
                            $receiver$iv.put(file2, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        String string2 = content = (String)object;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"content");
                        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)("<component name=\"" + stateAnnotation.name() + '\"'), (boolean)false, (int)2, null)) {
                            return true;
                        }
                    }
                    if (this.$computePresentableNames) {
                        Class<?> clazz = aClass;
                        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"aClass");
                        string = ExportSettingsActionKt.access$getComponentPresentableName(stateAnnotation, clazz, pluginDescriptor);
                    } else {
                        string = presentableName = "";
                    }
                    if (isFileIncluded) {
                        UtilKt.putValue((Map)this.$result, (Object)file2, (Object)new ExportableItem(file2, presentableName, storage3.roamingType()));
                    }
                    if (additionalExportFile != null) {
                        UtilKt.putValue((Map)this.$result, (Object)additionalExportFile, (Object)new ExportableItem(additionalExportFile, presentableName + " (schemes)", RoamingType.DEFAULT));
                    }
                }
                return true;
            }
            {
                this.$storageManager = stateStorageManager;
                this.$isSkipFile$1 = var2_2;
                this.$computePresentableNames = bl;
                this.$onlyExisting = bl2;
                this.$fileToContent = tHashMap;
                this.$result = linkedHashMap;
            }
        });
        SchemeManagerFactory schemeManagerFactory = SchemeManagerFactory.Companion.getInstance();
        if (schemeManagerFactory == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.SchemeManagerFactoryBase");
        }
        ((SchemeManagerFactoryBase)schemeManagerFactory).process((Function1<? super SchemeManagerImpl<Scheme, Scheme>, Unit>)((Function1)new Function1<SchemeManagerImpl<Scheme, Scheme>, Unit>(storageManager2, result2, isSkipFile$){
            final /* synthetic */ StateStorageManager $storageManager;
            final /* synthetic */ LinkedHashMap $result;
            final /* synthetic */ getExportableComponentsMap.1 $isSkipFile$1;

            public final void invoke(@NotNull SchemeManagerImpl<Scheme, Scheme> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                if (it.getRoamingType() != RoamingType.DISABLED) {
                    Path file2;
                    Character c = StringsKt.getOrNull((CharSequence)it.getFileSpec(), (int)0);
                    if (!(c != null && c.charValue() == '$' || this.$result.containsKey(file2 = Paths.get(this.$storageManager.expandMacros("$ROOT_CONFIG$"), it.getFileSpec())))) {
                        Path path = file2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
                        if (!this.$isSkipFile$1.invoke(path)) {
                            Map map = this.$result;
                            String string = it.getPresentableName();
                            if (string == null) {
                                string = "";
                            }
                            UtilKt.putValue((Map)map, (Object)file2, (Object)new ExportableItem(file2, string, it.getRoamingType()));
                        }
                    }
                }
            }
            {
                this.$storageManager = stateStorageManager;
                this.$result = linkedHashMap;
                this.$isSkipFile$1 = var3_3;
                super(1);
            }
        }));
        return result2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Map getExportableComponentsMap$default(boolean bl, boolean bl2, StateStorageManager stateStorageManager, Set set2, int n, Object object) {
        if ((n & 4) != 0) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            stateStorageManager = ServiceKt.getStateStore((ComponentManager)application).getStorageManager();
        }
        if ((n & 8) != 0) {
            set2 = null;
        }
        return ExportSettingsActionKt.getExportableComponentsMap(bl, bl2, stateStorageManager, set2);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getComponentPresentableName(State state, Class<?> aClass, PluginDescriptor pluginDescriptor) {
        presentableName = state.presentableName();
        if (Intrinsics.areEqual((Object)presentableName, State.NameGetter.class) ^ true) {
            try {
                v0 = ((State.NameGetter)ReflectionUtil.newInstance((Class)presentableName)).get();
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"ReflectionUtil.newInstance(presentableName).get()");
                return (String)v0;
            }
            catch (Exception e) {
                ComponentStoreImplKt.getLOG().error((Throwable)e);
            }
        }
        defaultName = state.name();
        trimDefaultName$ = new Function0<String>(defaultName){
            final /* synthetic */ String $defaultName;

            @NotNull
            public final String invoke() {
                return StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)this.$defaultName, (CharSequence)".Settings"), (CharSequence)".Settings");
            }
            {
                this.$defaultName = string;
                super(0);
            }
        };
        if (!(pluginDescriptor instanceof IdeaPluginDescriptor)) ** GOTO lbl-1000
        v1 = ((IdeaPluginDescriptor)pluginDescriptor).getPluginId();
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"pluginDescriptor.pluginId");
        if (Intrinsics.areEqual((Object)"com.intellij", (Object)v1.getIdString()) ^ true) {
            resourceBundleName = ((IdeaPluginDescriptor)pluginDescriptor).getResourceBundleBaseName();
            if (resourceBundleName == null) {
                if (!Intrinsics.areEqual((Object)((IdeaPluginDescriptor)pluginDescriptor).getVendor(), (Object)"JetBrains")) return trimDefaultName$.invoke();
                resourceBundleName = "messages.OptionsBundle";
            }
        } else lbl-1000:
        // 2 sources

        {
            resourceBundleName = "messages.OptionsBundle";
        }
        if ((v2 /* !! */  = pluginDescriptor) == null || (v2 /* !! */  = v2 /* !! */ .getPluginClassLoader()) == null) {
            v2 /* !! */  = classLoader /* !! */  = aClass.getClassLoader();
        }
        if (classLoader /* !! */  == null) return trimDefaultName$.invoke();
        message = ExportSettingsActionKt.messageOrDefault((ClassLoader)classLoader /* !! */ , resourceBundleName, defaultName);
        if (message != defaultName) {
            return message;
        }
        if (!PlatformUtils.isRubyMine()) return trimDefaultName$.invoke();
        return ExportSettingsActionKt.messageOrDefault((ClassLoader)classLoader /* !! */ , "org.jetbrains.plugins.ruby.RBundle", defaultName);
    }

    private static final String messageOrDefault(ClassLoader classLoader, String bundleName, String defaultName) {
        ResourceBundle resourceBundle = AbstractBundle.getResourceBundle((String)bundleName, (ClassLoader)classLoader);
        if (resourceBundle == null) {
            return defaultName;
        }
        ResourceBundle bundle = resourceBundle;
        String string = CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)("exportable." + defaultName + ".presentable.name"), (String)defaultName, (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CommonBundle.messageOrDe\u2026table.name\", defaultName)");
        return string;
    }

    @NotNull
    public static final /* synthetic */ String access$getComponentPresentableName(@NotNull State state, @NotNull Class aClass, @Nullable PluginDescriptor pluginDescriptor) {
        return ExportSettingsActionKt.getComponentPresentableName(state, aClass, pluginDescriptor);
    }
}

