/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentInfo;
import com.intellij.configurationStore.ComponentInfoImpl;
import com.intellij.configurationStore.ComponentWithModificationTrackerInfo;
import com.intellij.configurationStore.ComponentWithStateModificationTrackerInfo;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.ThreeState;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"createComponentInfo", "Lcom/intellij/configurationStore/ComponentInfo;", "component", "", "stateSpec", "Lcom/intellij/openapi/components/State;", "isUseSaveThreshold", "", "storage", "Lcom/intellij/openapi/components/Storage;", "intellij.platform.configurationStore.impl"})
public final class ComponentInfoKt {
    @NotNull
    public static final ComponentInfo createComponentInfo(@NotNull Object component, @Nullable State stateSpec) {
        ComponentInfo componentInfo;
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        Object object = component;
        if (object instanceof ModificationTracker) {
            componentInfo = new ComponentWithModificationTrackerInfo((ModificationTracker)component, stateSpec);
        } else if (object instanceof PersistentStateComponentWithModificationTracker) {
            PersistentStateComponentWithModificationTracker persistentStateComponentWithModificationTracker = (PersistentStateComponentWithModificationTracker)component;
            State state = stateSpec;
            if (state == null) {
                Intrinsics.throwNpe();
            }
            componentInfo = new ComponentWithStateModificationTrackerInfo(persistentStateComponentWithModificationTracker, state);
        } else {
            Storage[] storageArray;
            ComponentInfoImpl componentInfo2 = new ComponentInfoImpl(component, stateSpec);
            if (stateSpec != null && !((storageArray = stateSpec.storages()).length == 0)) {
                boolean bl;
                block8: {
                    for (Storage element$iv : stateSpec.storages()) {
                        Storage p1 = element$iv;
                        if (ComponentInfoKt.isUseSaveThreshold(p1)) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
                if (bl) {
                    componentInfo2.setLastSaved((int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
                }
            }
            componentInfo = componentInfo2;
        }
        return componentInfo;
    }

    private static final boolean isUseSaveThreshold(Storage storage2) {
        return storage2.useSaveThreshold() != ThreeState.NO && StateStorageManagerImplKt.getEffectiveRoamingType(storage2.roamingType(), StateStorageManagerImplKt.getPath(storage2)) == RoamingType.DISABLED;
    }
}

