/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.InspectionViewSuppressActionHolder;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SuppressableInspectionTreeNode
extends InspectionTreeNode {
    @NotNull
    private final InspectionToolPresentation myPresentation;
    private volatile Set<SuppressIntentionAction> myAvailableSuppressActions;
    private volatile String myPresentableName;
    private volatile Boolean myValid;
    private volatile NodeState myPreviousState;

    SuppressableInspectionTreeNode(Object userObject, @NotNull InspectionToolPresentation presentation) {
        if (presentation == null) {
            SuppressableInspectionTreeNode.$$$reportNull$$$0(0);
        }
        super(userObject);
        this.myPresentation = presentation;
    }

    @Override
    protected boolean doesNeedInternProblemLevels() {
        return true;
    }

    @NotNull
    public InspectionToolPresentation getPresentation() {
        InspectionToolPresentation inspectionToolPresentation = this.myPresentation;
        if (inspectionToolPresentation == null) {
            SuppressableInspectionTreeNode.$$$reportNull$$$0(1);
        }
        return inspectionToolPresentation;
    }

    public boolean canSuppress() {
        return this.isLeaf();
    }

    public abstract boolean isAlreadySuppressedFromView();

    public abstract boolean isQuickFixAppliedFromView();

    @Override
    protected boolean isProblemCountCacheValid() {
        NodeState currentState = this.calculateState();
        if (!currentState.equals(this.myPreviousState)) {
            this.myPreviousState = currentState;
            return false;
        }
        return true;
    }

    @Override
    public int getProblemCount(boolean allowSuppressed) {
        return !this.isExcluded() && this.isValid() && !this.isQuickFixAppliedFromView() && (allowSuppressed || !this.isAlreadySuppressedFromView()) ? 1 : 0;
    }

    @NotNull
    public synchronized Set<SuppressIntentionAction> getAvailableSuppressActions() {
        Set<SuppressIntentionAction> actions = this.myAvailableSuppressActions;
        if (actions == null) {
            this.myAvailableSuppressActions = actions = this.calculateAvailableSuppressActions();
        }
        Set<SuppressIntentionAction> set2 = actions;
        if (set2 == null) {
            SuppressableInspectionTreeNode.$$$reportNull$$$0(2);
        }
        return set2;
    }

    public void removeSuppressActionFromAvailable(@NotNull SuppressIntentionAction action) {
        if (action == null) {
            SuppressableInspectionTreeNode.$$$reportNull$$$0(3);
        }
        this.myAvailableSuppressActions.remove(action);
    }

    @Nullable
    public abstract RefEntity getElement();

    @Nullable
    public abstract CommonProblemDescriptor getDescriptor();

    @Override
    public final synchronized boolean isValid() {
        Boolean valid = this.myValid;
        if (valid == null) {
            this.myValid = valid = Boolean.valueOf(this.calculateIsValid());
        }
        return valid;
    }

    @Override
    public final synchronized String toString() {
        String name = this.myPresentableName;
        if (name == null) {
            this.myPresentableName = name = this.calculatePresentableName();
        }
        return name;
    }

    @Override
    @Nullable
    public String getTailText() {
        if (this.isQuickFixAppliedFromView()) {
            return "";
        }
        if (this.isAlreadySuppressedFromView()) {
            return "Suppressed";
        }
        return !this.isValid() ? "No longer valid" : null;
    }

    @Override
    protected void nodeAddedToTree() {
        this.myPresentableName = this.calculatePresentableName();
        this.myValid = this.calculateIsValid();
        this.myAvailableSuppressActions = this.calculateAvailableSuppressActions();
    }

    @NotNull
    private Set<SuppressIntentionAction> calculateAvailableSuppressActions() {
        Set<SuppressIntentionAction> set2 = this.getElement() == null ? Collections.emptySet() : this.calculateAvailableSuppressActions(this.myPresentation.getContext().getProject());
        if (set2 == null) {
            SuppressableInspectionTreeNode.$$$reportNull$$$0(4);
        }
        return set2;
    }

    @NotNull
    public final Pair<PsiElement, CommonProblemDescriptor> getSuppressContent() {
        RefEntity refElement = this.getElement();
        CommonProblemDescriptor descriptor = this.getDescriptor();
        PsiElement element = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : (refElement instanceof RefElement ? ((RefElement)refElement).getElement() : null);
        Pair pair = Pair.create((Object)element, (Object)descriptor);
        if (pair == null) {
            SuppressableInspectionTreeNode.$$$reportNull$$$0(5);
        }
        return pair;
    }

    @NotNull
    private Set<SuppressIntentionAction> calculateAvailableSuppressActions(@NotNull Project project) {
        if (project == null) {
            SuppressableInspectionTreeNode.$$$reportNull$$$0(6);
        }
        if (this.myPresentation.isDummy()) {
            Set<SuppressIntentionAction> set2 = Collections.emptySet();
            if (set2 == null) {
                SuppressableInspectionTreeNode.$$$reportNull$$$0(7);
            }
            return set2;
        }
        Pair<PsiElement, CommonProblemDescriptor> suppressContent = this.getSuppressContent();
        PsiElement element = (PsiElement)suppressContent.getFirst();
        if (element == null) {
            Set<SuppressIntentionAction> set3 = Collections.emptySet();
            if (set3 == null) {
                SuppressableInspectionTreeNode.$$$reportNull$$$0(8);
            }
            return set3;
        }
        InspectionResultsView view = this.myPresentation.getContext().getView();
        if (view == null) {
            Set<SuppressIntentionAction> set4 = Collections.emptySet();
            if (set4 == null) {
                SuppressableInspectionTreeNode.$$$reportNull$$$0(9);
            }
            return set4;
        }
        InspectionViewSuppressActionHolder suppressActionHolder = view.getSuppressActionHolder();
        SuppressIntentionAction[] actions = suppressActionHolder.getSuppressActions(this.myPresentation.getToolWrapper(), element);
        if (actions.length == 0) {
            Set<SuppressIntentionAction> set5 = Collections.emptySet();
            if (set5 == null) {
                SuppressableInspectionTreeNode.$$$reportNull$$$0(10);
            }
            return set5;
        }
        Set<SuppressIntentionAction> set6 = suppressActionHolder.internSuppressActions(Arrays.stream(actions).filter(action -> {
            if (project == null) {
                SuppressableInspectionTreeNode.$$$reportNull$$$0(12);
            }
            return action.isAvailable(project, null, element);
        }).collect(Collectors.toCollection(() -> ConcurrentCollectionFactory.createConcurrentSet(ContainerUtil.identityStrategy()))));
        if (set6 == null) {
            SuppressableInspectionTreeNode.$$$reportNull$$$0(11);
        }
        return set6;
    }

    protected abstract String calculatePresentableName();

    protected abstract boolean calculateIsValid();

    protected void dropCache() {
        this.myProblemLevels.drop();
        if (this.isQuickFixAppliedFromView() || this.isAlreadySuppressedFromView()) {
            return;
        }
        this.myValid = this.calculateIsValid();
        this.myPresentableName = this.calculatePresentableName();
        for (int i = 0; i < this.getChildCount(); ++i) {
            TreeNode child = this.getChildAt(i);
            if (!(child instanceof SuppressableInspectionTreeNode)) continue;
            ((SuppressableInspectionTreeNode)child).dropCache();
        }
    }

    private NodeState calculateState() {
        return (NodeState)NodeState.INTERNER.intern((Object)new NodeState(this.isValid(), this.isAlreadySuppressedFromView(), this.isQuickFixAppliedFromView()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableSuppressActions";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateAvailableSuppressActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeSuppressActionFromAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calculateAvailableSuppressActions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calculateAvailableSuppressActions$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NodeState {
        private static final Interner<NodeState> INTERNER = new Interner();
        private final boolean isValid;
        private final boolean isSuppressed;
        private final boolean isFixApplied;

        private NodeState(boolean isValid, boolean isSuppressed, boolean isFixApplied) {
            this.isValid = isValid;
            this.isSuppressed = isSuppressed;
            this.isFixApplied = isFixApplied;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeState state = (NodeState)o;
            if (this.isValid != state.isValid) {
                return false;
            }
            if (this.isSuppressed != state.isSuppressed) {
                return false;
            }
            return this.isFixApplied == state.isFixApplied;
        }

        public int hashCode() {
            return (this.isValid ? 1 : 0) + (this.isFixApplied ? 2 : 0) + (this.isSuppressed ? 4 : 0);
        }
    }
}

