/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.lang.annotation.HighlightSeverity;
import gnu.trove.TObjectIntHashMap;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefElementNode
extends SuppressableInspectionTreeNode {
    private volatile boolean myHasDescriptorsUnder;
    private volatile CommonProblemDescriptor mySingleDescriptor;
    private final Icon myIcon;

    public RefElementNode(@Nullable RefEntity userObject, @NotNull InspectionToolPresentation presentation) {
        if (presentation == null) {
            RefElementNode.$$$reportNull$$$0(0);
        }
        super((Object)userObject, presentation);
        RefEntity refEntity = this.getElement();
        this.myIcon = refEntity == null ? null : refEntity.getIcon(false);
    }

    @Override
    public final boolean isAlreadySuppressedFromView() {
        return this.getElement() != null && this.getPresentation().isSuppressed(this.getElement());
    }

    public boolean hasDescriptorsUnder() {
        return this.myHasDescriptorsUnder;
    }

    @Override
    @Nullable
    public RefEntity getElement() {
        return (RefEntity)this.getUserObject();
    }

    @Override
    @Nullable
    public Icon getIcon(boolean expanded) {
        return this.myIcon;
    }

    @Override
    protected String calculatePresentableName() {
        RefEntity element = this.getElement();
        if (element == null) {
            return InspectionsBundle.message((String)"inspection.reference.invalid", (Object[])new Object[0]);
        }
        return element.getRefManager().getRefinedElement(element).getName();
    }

    @Override
    protected boolean calculateIsValid() {
        RefEntity refEntity = this.getElement();
        return refEntity != null && refEntity.isValid();
    }

    @Override
    public boolean isExcluded() {
        RefEntity element = this.getElement();
        if (this.isLeaf() && element != null) {
            return this.getPresentation().isExcluded(element);
        }
        return super.isExcluded();
    }

    @Override
    public void excludeElement() {
        RefEntity element = this.getElement();
        if (this.isLeaf() && element != null) {
            this.getPresentation().exclude(element);
            return;
        }
        super.excludeElement();
    }

    @Override
    public void amnestyElement() {
        RefEntity element = this.getElement();
        if (this.isLeaf() && element != null) {
            this.getPresentation().amnesty(element);
            return;
        }
        super.amnestyElement();
    }

    @Override
    public void add(MutableTreeNode newChild) {
        this.checkHasDescriptorUnder(newChild);
        super.add(newChild);
    }

    @Override
    public InspectionTreeNode insertByOrder(InspectionTreeNode child, boolean allowDuplication) {
        this.checkHasDescriptorUnder(child);
        return super.insertByOrder(child, allowDuplication);
    }

    public void setProblem(CommonProblemDescriptor descriptor) {
        this.mySingleDescriptor = descriptor;
    }

    @Override
    @Nullable
    public CommonProblemDescriptor getDescriptor() {
        return this.mySingleDescriptor;
    }

    @Override
    public RefEntity getContainingFileLocalEntity() {
        RefEntity element = this.getElement();
        return element instanceof RefElement && !(element instanceof RefDirectory) ? element : super.getContainingFileLocalEntity();
    }

    @Override
    protected void visitProblemSeverities(@NotNull TObjectIntHashMap<HighlightDisplayLevel> counter) {
        if (counter == null) {
            RefElementNode.$$$reportNull$$$0(1);
        }
        if (!this.isExcluded() && this.isLeaf() && !this.getPresentation().isProblemResolved(this.getElement()) && !this.getPresentation().isSuppressed(this.getElement())) {
            HighlightSeverity severity = InspectionToolPresentation.getSeverity(this.getElement(), null, this.getPresentation());
            HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
            if (!counter.adjustValue((Object)level, 1)) {
                counter.put((Object)level, 1);
            }
            return;
        }
        super.visitProblemSeverities(counter);
    }

    @Override
    public boolean isQuickFixAppliedFromView() {
        return this.isLeaf() && this.getPresentation().isProblemResolved(this.getElement());
    }

    @Override
    @Nullable
    public String getTailText() {
        if (this.getPresentation().isDummy()) {
            return "";
        }
        String customizedText = super.getTailText();
        if (customizedText != null) {
            return customizedText;
        }
        return this.isLeaf() ? "" : null;
    }

    private void checkHasDescriptorUnder(MutableTreeNode newChild) {
        if (this.myHasDescriptorsUnder) {
            return;
        }
        if (newChild instanceof ProblemDescriptionNode || newChild instanceof RefElementNode && ((RefElementNode)newChild).hasDescriptorsUnder()) {
            this.myHasDescriptorsUnder = true;
            TreeNode parent = this.getParent();
            while (parent instanceof RefElementNode) {
                ((RefElementNode)parent).myHasDescriptorsUnder = true;
                parent = parent.getParent();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "counter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/ui/RefElementNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitProblemSeverities";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

