/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.lang.RefManagerExtension;
import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefDirectoryImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefFileImpl;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefGraphAnnotatorEx;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefModuleImpl;
import com.intellij.codeInspection.reference.RefProject;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.SmartRefElementPointerImpl;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefManagerImpl
extends RefManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.reference.RefManager");
    private long myLastUsedMask;
    @NotNull
    private final Project myProject;
    private AnalysisScope myScope;
    private RefProject myRefProject;
    private final BitSet myUnprocessedFiles;
    private final boolean processExternalElements;
    private final ConcurrentMap<PsiAnchor, RefElement> myRefTable;
    private volatile List<RefElement> myCachedSortedRefs;
    private final ConcurrentMap<Module, RefModule> myModules;
    private final ProjectIterator myProjectIterator;
    private final AtomicBoolean myDeclarationsFound;
    private final PsiManager myPsiManager;
    private volatile boolean myIsInProcess;
    private volatile boolean myOfflineView;
    private final LinkedHashSet<RefGraphAnnotator> myGraphAnnotators;
    private GlobalInspectionContext myContext;
    private final Map<Key, RefManagerExtension> myExtensions;
    private final Map<Language, RefManagerExtension> myLanguageExtensions;
    private final StringInterner myNameInterner;

    public RefManagerImpl(@NotNull Project project, @Nullable AnalysisScope scope, @NotNull GlobalInspectionContext context) {
        if (project == null) {
            RefManagerImpl.$$$reportNull$$$0(0);
        }
        if (context == null) {
            RefManagerImpl.$$$reportNull$$$0(1);
        }
        this.myLastUsedMask = 0x8000000L;
        this.myUnprocessedFiles = new BitSet();
        this.processExternalElements = Registry.is((String)"batch.inspections.process.external.elements");
        this.myRefTable = ContainerUtil.newConcurrentMap();
        this.myModules = ContainerUtil.newConcurrentMap();
        this.myProjectIterator = new ProjectIterator();
        this.myDeclarationsFound = new AtomicBoolean(false);
        this.myGraphAnnotators = new LinkedHashSet();
        this.myExtensions = new THashMap();
        this.myLanguageExtensions = new HashMap<Language, RefManagerExtension>();
        this.myNameInterner = new StringInterner();
        this.myProject = project;
        this.myScope = scope;
        this.myContext = context;
        this.myPsiManager = PsiManager.getInstance((Project)project);
        this.myRefProject = new RefProjectImpl(this);
        for (InspectionExtensionsFactory inspectionExtensionsFactory : (InspectionExtensionsFactory[])Extensions.getExtensions((ExtensionPointName)InspectionExtensionsFactory.EP_NAME)) {
            RefManagerExtension extension = inspectionExtensionsFactory.createRefManagerExtension((RefManager)this);
            if (extension == null) continue;
            this.myExtensions.put(extension.getID(), extension);
            this.myLanguageExtensions.put(extension.getLanguage(), extension);
        }
        if (scope != null) {
            for (InspectionExtensionsFactory inspectionExtensionsFactory : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
                this.getRefModule((Module)inspectionExtensionsFactory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String internName(@NotNull String name) {
        if (name == null) {
            RefManagerImpl.$$$reportNull$$$0(2);
        }
        StringInterner stringInterner = this.myNameInterner;
        synchronized (stringInterner) {
            return (String)this.myNameInterner.intern((Object)name);
        }
    }

    @NotNull
    public GlobalInspectionContext getContext() {
        GlobalInspectionContext globalInspectionContext = this.myContext;
        if (globalInspectionContext == null) {
            RefManagerImpl.$$$reportNull$$$0(3);
        }
        return globalInspectionContext;
    }

    public void iterate(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            RefManagerImpl.$$$reportNull$$$0(4);
        }
        for (RefElement refElement : this.getSortedElements()) {
            refElement.accept(visitor);
        }
        if (this.myModules != null) {
            for (RefModule refModule : this.myModules.values()) {
                if (!this.myScope.containsModule(refModule.getModule())) continue;
                refModule.accept(visitor);
            }
        }
        for (RefManagerExtension extension : this.myExtensions.values()) {
            extension.iterate(visitor);
        }
    }

    public void cleanup() {
        this.myScope = null;
        this.myRefProject = null;
        this.myRefTable.clear();
        this.myCachedSortedRefs = null;
        this.myModules.clear();
        this.myContext = null;
        this.myGraphAnnotators.clear();
        for (RefManagerExtension extension : this.myExtensions.values()) {
            extension.cleanup();
        }
        this.myExtensions.clear();
        this.myLanguageExtensions.clear();
    }

    @Nullable
    public AnalysisScope getScope() {
        return this.myScope;
    }

    private void fireNodeInitialized(RefElement refElement) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onInitialize(refElement);
        }
    }

    void fireNodeMarkedReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer, boolean forReading, boolean forWriting) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onMarkReferenced(refWhat, refFrom, referencedFromClassInitializer, forReading, forWriting);
        }
    }

    void fireNodeMarkedReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer, boolean forReading, boolean forWriting, PsiElement element) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onMarkReferenced(refWhat, refFrom, referencedFromClassInitializer, forReading, forWriting, element);
        }
    }

    public void fireNodeMarkedReferenced(PsiElement what, PsiElement from) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onMarkReferenced(what, from, false);
        }
    }

    void fireBuildReferences(RefElement refElement) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onReferencesBuild(refElement);
        }
    }

    public void registerGraphAnnotator(@NotNull RefGraphAnnotator annotator) {
        if (annotator == null) {
            RefManagerImpl.$$$reportNull$$$0(5);
        }
        if (this.myGraphAnnotators.add(annotator) && annotator instanceof RefGraphAnnotatorEx) {
            ((RefGraphAnnotatorEx)annotator).initialize((RefManager)this);
        }
    }

    public synchronized long getLastUsedMask() {
        if (this.myLastUsedMask < 0L) {
            throw new IllegalStateException("We're out of 64 bits, sorry");
        }
        this.myLastUsedMask *= 2L;
        return this.myLastUsedMask;
    }

    public <T> T getExtension(@NotNull Key<T> key) {
        if (key == null) {
            RefManagerImpl.$$$reportNull$$$0(6);
        }
        return (T)this.myExtensions.get(key);
    }

    @Nullable
    public String getType(@NotNull RefEntity ref) {
        if (ref == null) {
            RefManagerImpl.$$$reportNull$$$0(7);
        }
        for (RefManagerExtension extension : this.myExtensions.values()) {
            String type = extension.getType(ref);
            if (type == null) continue;
            return type;
        }
        if (ref instanceof RefFile) {
            return "file";
        }
        if (ref instanceof RefModule) {
            return "module";
        }
        if (ref instanceof RefProject) {
            return "project";
        }
        if (ref instanceof RefDirectory) {
            return "dir";
        }
        return null;
    }

    @NotNull
    public RefEntity getRefinedElement(@NotNull RefEntity ref) {
        if (ref == null) {
            RefManagerImpl.$$$reportNull$$$0(8);
        }
        for (RefManagerExtension extension : this.myExtensions.values()) {
            ref = extension.getRefinedElement(ref);
        }
        RefEntity refEntity = ref;
        if (refEntity == null) {
            RefManagerImpl.$$$reportNull$$$0(9);
        }
        return refEntity;
    }

    public Element export(@NotNull RefEntity refEntity, @NotNull Element element, int actualLine) {
        if (refEntity == null) {
            RefManagerImpl.$$$reportNull$$$0(10);
        }
        if (element == null) {
            RefManagerImpl.$$$reportNull$$$0(11);
        }
        refEntity = this.getRefinedElement(refEntity);
        Element problem = new Element("problem");
        if (refEntity instanceof RefDirectory) {
            Element fileElement = new Element("file");
            VirtualFile virtualFile = ((PsiDirectory)((RefDirectory)refEntity).getElement()).getVirtualFile();
            fileElement.addContent(virtualFile.getUrl());
            problem.addContent(fileElement);
        } else if (refEntity instanceof RefElement) {
            RefElement refElement = (RefElement)refEntity;
            SmartPsiElementPointer pointer = refElement.getPointer();
            PsiFile psiFile = pointer.getContainingFile();
            if (psiFile == null) {
                return null;
            }
            Element fileElement = new Element("file");
            Element lineElement = new Element("line");
            VirtualFile virtualFile = psiFile.getVirtualFile();
            LOG.assertTrue(virtualFile != null);
            fileElement.addContent(virtualFile.getUrl());
            if (actualLine == -1) {
                Document document = PsiDocumentManager.getInstance((Project)pointer.getProject()).getDocument(psiFile);
                LOG.assertTrue(document != null);
                Segment range2 = pointer.getRange();
                lineElement.addContent(String.valueOf(range2 != null ? document.getLineNumber(range2.getStartOffset()) + 1 : -1));
            } else {
                lineElement.addContent(String.valueOf(actualLine + 1));
            }
            problem.addContent(fileElement);
            problem.addContent(lineElement);
            RefManagerImpl.appendModule(problem, refElement.getModule());
        } else if (refEntity instanceof RefModule) {
            RefModule refModule = (RefModule)refEntity;
            VirtualFile moduleFile = refModule.getModule().getModuleFile();
            Element fileElement = new Element("file");
            fileElement.addContent(moduleFile != null ? moduleFile.getUrl() : refEntity.getName());
            problem.addContent(fileElement);
            RefManagerImpl.appendModule(problem, refModule);
        }
        for (RefManagerExtension extension : this.myExtensions.values()) {
            extension.export(refEntity, problem);
        }
        new SmartRefElementPointerImpl(refEntity, true).writeExternal(problem);
        element.addContent(problem);
        return problem;
    }

    @Nullable
    public String getGroupName(@NotNull RefElement entity) {
        RefEntity parent;
        if (entity == null) {
            RefManagerImpl.$$$reportNull$$$0(12);
        }
        for (RefManagerExtension extension : this.myExtensions.values()) {
            String groupName = extension.getGroupName((RefEntity)entity);
            if (groupName == null) continue;
            return groupName;
        }
        for (parent = entity.getOwner(); parent != null && !(parent instanceof RefDirectory); parent = parent.getOwner()) {
        }
        LinkedList<String> containingDirs = new LinkedList<String>();
        while (parent instanceof RefDirectory) {
            containingDirs.addFirst(parent.getName());
            parent = parent.getOwner();
        }
        return containingDirs.isEmpty() ? null : StringUtil.join(containingDirs, (String)File.separator);
    }

    private static void appendModule(Element problem, RefModule refModule) {
        if (refModule != null) {
            Element moduleElement = new Element("module");
            moduleElement.addContent(refModule.getName());
            problem.addContent(moduleElement);
        }
    }

    public void findAllDeclarations() {
        if (!this.myDeclarationsFound.getAndSet(true)) {
            long before = System.currentTimeMillis();
            AnalysisScope scope = this.getScope();
            if (scope != null) {
                scope.accept((PsiElementVisitor)this.myProjectIterator);
            }
            LOG.info("Total duration of processing project usages:" + (System.currentTimeMillis() - before));
        }
    }

    public boolean isDeclarationsFound() {
        return this.myDeclarationsFound.get();
    }

    public void inspectionReadActionStarted() {
        this.myIsInProcess = true;
    }

    public void inspectionReadActionFinished() {
        this.myIsInProcess = false;
        if (this.myScope != null) {
            this.myScope.invalidate();
        }
        this.myCachedSortedRefs = null;
    }

    public void startOfflineView() {
        this.myOfflineView = true;
    }

    public boolean isOfflineView() {
        return this.myOfflineView;
    }

    public boolean isInProcess() {
        return this.myIsInProcess;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            RefManagerImpl.$$$reportNull$$$0(13);
        }
        return project;
    }

    @NotNull
    public RefProject getRefProject() {
        RefProject refProject = this.myRefProject;
        if (refProject == null) {
            RefManagerImpl.$$$reportNull$$$0(14);
        }
        return refProject;
    }

    @NotNull
    public List<RefElement> getSortedElements() {
        List<RefElement> answer = this.myCachedSortedRefs;
        if (answer != null) {
            List<RefElement> list2 = answer;
            if (list2 == null) {
                RefManagerImpl.$$$reportNull$$$0(15);
            }
            return list2;
        }
        List<RefElement> list3 = answer = new ArrayList(this.myRefTable.values());
        ReadAction.run(() -> ContainerUtil.quickSort((List)list3, (o1, o2) -> {
            VirtualFile v1 = ((RefElementImpl)o1).getVirtualFile();
            VirtualFile v2 = ((RefElementImpl)o2).getVirtualFile();
            return (v1 != null ? v1.hashCode() : 0) - (v2 != null ? v2.hashCode() : 0);
        }));
        this.myCachedSortedRefs = answer = Collections.unmodifiableList(answer);
        List<RefElement> list4 = answer;
        if (list4 == null) {
            RefManagerImpl.$$$reportNull$$$0(16);
        }
        return list4;
    }

    @NotNull
    public PsiManager getPsiManager() {
        PsiManager psiManager = this.myPsiManager;
        if (psiManager == null) {
            RefManagerImpl.$$$reportNull$$$0(17);
        }
        return psiManager;
    }

    public synchronized boolean isInGraph(VirtualFile file2) {
        return !this.myUnprocessedFiles.get(((VirtualFileWithId)file2).getId());
    }

    @Nullable
    public PsiNamedElement getContainerElement(@NotNull PsiElement element) {
        if (element == null) {
            RefManagerImpl.$$$reportNull$$$0(18);
        }
        Language language = element.getLanguage();
        return this.myExtensions.values().stream().filter(extension -> extension.getLanguage().equals(language)).map(extension -> {
            if (element == null) {
                RefManagerImpl.$$$reportNull$$$0(28);
            }
            return extension.getElementContainer(element);
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private synchronized void registerUnprocessed(VirtualFileWithId virtualFile) {
        this.myUnprocessedFiles.set(virtualFile.getId());
    }

    void removeReference(@NotNull RefElement refElem) {
        PsiElement element;
        RefManagerExtension extension;
        if (refElem == null) {
            RefManagerImpl.$$$reportNull$$$0(19);
        }
        RefManagerExtension refManagerExtension = extension = (element = refElem.getElement()) != null ? this.getExtension(element.getLanguage()) : null;
        if (extension != null) {
            extension.removeReference(refElem);
        }
        if (element != null && this.myRefTable.remove(RefManagerImpl.createAnchor(element)) != null) {
            return;
        }
        for (Map.Entry entry : this.myRefTable.entrySet()) {
            RefElement value = (RefElement)entry.getValue();
            PsiAnchor anchor2 = (PsiAnchor)entry.getKey();
            if (value != refElem) continue;
            this.myRefTable.remove(anchor2);
            break;
        }
        this.myCachedSortedRefs = null;
    }

    @NotNull
    private static PsiAnchor createAnchor(@NotNull PsiElement element) {
        if (element == null) {
            RefManagerImpl.$$$reportNull$$$0(20);
        }
        PsiAnchor psiAnchor = (PsiAnchor)ReadAction.compute(() -> {
            if (element == null) {
                RefManagerImpl.$$$reportNull$$$0(27);
            }
            return PsiAnchor.create(element);
        });
        if (psiAnchor == null) {
            RefManagerImpl.$$$reportNull$$$0(21);
        }
        return psiAnchor;
    }

    public void initializeAnnotators() {
        RefGraphAnnotator[] graphAnnotators;
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.refGraphAnnotator");
        for (RefGraphAnnotator annotator : graphAnnotators = (RefGraphAnnotator[])point.getExtensions()) {
            this.registerGraphAnnotator(annotator);
        }
    }

    @Nullable
    public RefElement getReference(@Nullable PsiElement elem) {
        return this.getReference(elem, false);
    }

    @Nullable
    public RefElement getReference(final PsiElement elem, boolean ignoreScope) {
        if (((Boolean)ReadAction.compute(() -> elem == null || !elem.isValid() || elem instanceof LightElement || !(elem instanceof PsiDirectory) && !this.belongsToScope(elem, ignoreScope))).booleanValue()) {
            return null;
        }
        return this.getFromRefTableOrCache(elem, () -> (RefElementImpl)ApplicationManager.getApplication().runReadAction((Computable)new Computable<RefElementImpl>(){

            @Nullable
            public RefElementImpl compute() {
                RefElement refElement;
                RefManagerExtension extension = RefManagerImpl.this.getExtension(elem.getLanguage());
                if (extension != null && (refElement = extension.createRefElement(elem)) != null) {
                    return (RefElementImpl)refElement;
                }
                if (elem instanceof PsiFile) {
                    return new RefFileImpl((PsiFile)elem, (RefManager)RefManagerImpl.this);
                }
                if (elem instanceof PsiDirectory) {
                    return new RefDirectoryImpl((PsiDirectory)elem, (RefManager)RefManagerImpl.this);
                }
                return null;
            }
        }), element -> ReadAction.run(() -> {
            element.initialize();
            for (RefManagerExtension each : this.myExtensions.values()) {
                each.onEntityInitialized((RefElement)element, elem);
            }
            this.fireNodeInitialized((RefElement)element);
        }));
    }

    private RefManagerExtension getExtension(Language language) {
        return this.myLanguageExtensions.get(language);
    }

    @Nullable
    public RefEntity getReference(String type, String fqName) {
        for (RefManagerExtension extension : this.myExtensions.values()) {
            RefEntity refEntity = extension.getReference(type, fqName);
            if (refEntity == null) continue;
            return refEntity;
        }
        if ("file".equals(type)) {
            return RefFileImpl.fileFromExternalName(this, fqName);
        }
        if ("module".equals(type)) {
            return RefModuleImpl.moduleFromName(this, fqName);
        }
        if ("project".equals(type)) {
            return this.getRefProject();
        }
        if ("dir".equals(type)) {
            String url = VfsUtilCore.pathToUrl((String)PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPath(fqName));
            VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(url);
            if (vFile != null) {
                PsiDirectory dir = PsiManager.getInstance((Project)this.getProject()).findDirectory(vFile);
                return this.getReference((PsiElement)dir);
            }
        }
        return null;
    }

    @Nullable
    <T extends RefElement> T getFromRefTableOrCache(PsiElement element, @NotNull NullableFactory<? extends T> factory) {
        if (factory == null) {
            RefManagerImpl.$$$reportNull$$$0(22);
        }
        return this.getFromRefTableOrCache(element, factory, null);
    }

    @Nullable
    private <T extends RefElement> T getFromRefTableOrCache(@NotNull PsiElement element, @NotNull NullableFactory<? extends T> factory, @Nullable Consumer<? super T> whenCached) {
        PsiAnchor psiAnchor;
        RefElement result2;
        if (element == null) {
            RefManagerImpl.$$$reportNull$$$0(23);
        }
        if (factory == null) {
            RefManagerImpl.$$$reportNull$$$0(24);
        }
        if ((result2 = (RefElement)this.myRefTable.get(psiAnchor = RefManagerImpl.createAnchor(element))) != null) {
            return (T)result2;
        }
        if (!this.isValidPointForReference()) {
            return null;
        }
        result2 = (RefElement)factory.create();
        if (result2 == null) {
            return null;
        }
        this.myCachedSortedRefs = null;
        RefElement prev2 = this.myRefTable.putIfAbsent(psiAnchor, result2);
        if (prev2 != null) {
            result2 = prev2;
        } else if (whenCached != null) {
            whenCached.consume((Object)result2);
        }
        return (T)result2;
    }

    public RefModule getRefModule(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        RefModule refModule = (RefModule)this.myModules.get(module);
        if (refModule == null) {
            refModule = (RefModule)ConcurrencyUtil.cacheOrGet(this.myModules, (Object)module, (Object)new RefModuleImpl(module, (RefManager)this));
        }
        return refModule;
    }

    public boolean belongsToScope(PsiElement psiElement) {
        return this.belongsToScope(psiElement, false);
    }

    private boolean belongsToScope(PsiElement psiElement, boolean ignoreScope) {
        if (psiElement == null || !psiElement.isValid()) {
            return false;
        }
        if (psiElement instanceof PsiCompiledElement) {
            return false;
        }
        PsiFile containingFile = (PsiFile)ReadAction.compute(() -> ((PsiElement)psiElement).getContainingFile());
        if (containingFile == null) {
            return false;
        }
        for (RefManagerExtension extension : this.myExtensions.values()) {
            if (extension.belongsToScope(psiElement)) continue;
            return false;
        }
        Boolean inProject = (Boolean)ReadAction.compute(() -> psiElement.getManager().isInProject(psiElement));
        return inProject != false && (ignoreScope || this.getScope() == null || this.getScope().contains(psiElement));
    }

    public String getQualifiedName(RefEntity refEntity) {
        if (refEntity == null || refEntity instanceof RefElementImpl && !refEntity.isValid()) {
            return InspectionsBundle.message((String)"inspection.reference.invalid", (Object[])new Object[0]);
        }
        return refEntity.getQualifiedName();
    }

    public void removeRefElement(@NotNull RefElement refElement, @NotNull List<RefElement> deletedRefs) {
        RefElement[] refElements;
        if (refElement == null) {
            RefManagerImpl.$$$reportNull$$$0(25);
        }
        if (deletedRefs == null) {
            RefManagerImpl.$$$reportNull$$$0(26);
        }
        List children2 = refElement.getChildren();
        for (RefElement refChild : refElements = children2.toArray(new RefElement[0])) {
            this.removeRefElement(refChild, deletedRefs);
        }
        ((RefManagerImpl)refElement.getRefManager()).removeReference(refElement);
        ((RefElementImpl)refElement).referenceRemoved();
        if (!deletedRefs.contains(refElement)) {
            deletedRefs.add(refElement);
        } else {
            LOG.error("deleted second time");
        }
    }

    boolean isValidPointForReference() {
        return this.myIsInProcess || this.myOfflineView || ApplicationManager.getApplication().isUnitTestMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 11: 
            case 18: 
            case 20: 
            case 23: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElem";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedRefs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefinedElement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefProject";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedElements";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiManager";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "internName";
                break;
            }
            case 3: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "iterate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerGraphAnnotator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRefinedElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getGroupName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getContainerElement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeReference";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createAnchor";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFromRefTableOrCache";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeRefElement";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createAnchor$4";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getContainerElement$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ProjectIterator
    extends PsiElementVisitor {
        private ProjectIterator() {
        }

        public void visitElement(PsiElement element) {
            PsiFile file2;
            ProgressManager.checkCanceled();
            RefManagerExtension extension = RefManagerImpl.this.getExtension(element.getLanguage());
            if (extension != null) {
                extension.visitElement(element);
            } else if (RefManagerImpl.this.processExternalElements && (file2 = element.getContainingFile()) != null) {
                VirtualFile virtualFile;
                boolean referencesProcessed = false;
                for (RefManagerExtension managerExtension : RefManagerImpl.this.myExtensions.values()) {
                    if (!managerExtension.shouldProcessExternalFile(file2)) continue;
                    RefElement refFile = RefManagerImpl.this.getReference((PsiElement)file2);
                    LOG.assertTrue(refFile != null, (Object)file2);
                    if (!referencesProcessed) {
                        referencesProcessed = true;
                        for (PsiReference reference : element.getReferences()) {
                            PsiElement resolve2 = reference.resolve();
                            if (resolve2 == null) continue;
                            RefManagerImpl.this.fireNodeMarkedReferenced(resolve2, (PsiElement)file2);
                            RefElement refWhat = RefManagerImpl.this.getReference(resolve2);
                            if (refWhat == null) {
                                PsiFile targetContainingFile = resolve2.getContainingFile();
                                if (file2 == targetContainingFile) continue;
                                refWhat = RefManagerImpl.this.getReference((PsiElement)targetContainingFile);
                            }
                            if (refWhat == null) continue;
                            ((RefElementImpl)refWhat).addInReference(refFile);
                            ((RefElementImpl)refFile).addOutReference(refWhat);
                        }
                    }
                    Stream implicitRefs = managerExtension.extractExternalFileImplicitReferences(file2);
                    implicitRefs.forEach(e -> {
                        RefElement superClassReference = RefManagerImpl.this.getReference((PsiElement)e);
                        if (superClassReference != null) {
                            ((RefElementImpl)refFile).addOutReference(superClassReference);
                        }
                    });
                }
                if (!referencesProcessed && element instanceof PsiFile && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element)) instanceof VirtualFileWithId) {
                    RefManagerImpl.this.registerUnprocessed((VirtualFileWithId)virtualFile);
                }
            }
            for (PsiElement aChildren : element.getChildren()) {
                aChildren.accept((PsiElementVisitor)this);
            }
        }

        public void visitFile(PsiFile file2) {
            VirtualFile virtualFile = file2.getVirtualFile();
            if (virtualFile != null) {
                String relative = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)virtualFile, (String)virtualFile.getPresentableUrl(), (Project)RefManagerImpl.this.myProject, (boolean)true, (boolean)false);
                RefManagerImpl.this.myContext.incrementJobDoneAmount(((RefManagerImpl)RefManagerImpl.this).myContext.getStdJobDescriptors().BUILD_GRAPH, relative);
            }
            FileViewProvider viewProvider = file2.getViewProvider();
            Set relevantLanguages = viewProvider.getLanguages();
            for (Language language : relevantLanguages) {
                try {
                    this.visitElement((PsiElement)viewProvider.getPsi(language));
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error((Throwable)new RuntimeExceptionWithAttachments(e, new Attachment[]{new Attachment("diagnostics.txt", file2.getName())}));
                }
            }
            RefManagerImpl.this.myPsiManager.dropResolveCaches();
            InjectedLanguageManager.getInstance((Project)RefManagerImpl.this.myProject).dropFileCaches(file2);
        }
    }
}

