/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.thoughtworks.xstream.io.xml.XppReader;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

public class OfflineViewParseUtil {
    @NonNls
    private static final String PACKAGE = "package";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String HINTS = "hints";
    @NonNls
    private static final String LINE = "line";
    @NonNls
    private static final String MODULE = "module";

    private OfflineViewParseUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Set<OfflineProblemDescriptor>> parse(String problems) {
        TObjectIntHashMap fqName2IdxMap = new TObjectIntHashMap();
        HashMap<String, Set<OfflineProblemDescriptor>> package2Result = new HashMap<String, Set<OfflineProblemDescriptor>>();
        try (XppReader reader = new XppReader((Reader)new StringReader(problems), (XmlPullParser)new MXParser());){
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                OfflineProblemDescriptor descriptor = new OfflineProblemDescriptor();
                boolean added = false;
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    if ("entry_point".equals(reader.getNodeName())) {
                        descriptor.setType(reader.getAttribute("TYPE"));
                        String fqName = reader.getAttribute("FQNAME");
                        descriptor.setFQName(fqName);
                        if (!fqName2IdxMap.containsKey((Object)fqName)) {
                            fqName2IdxMap.put((Object)fqName, 0);
                        }
                        int idx = fqName2IdxMap.get((Object)fqName);
                        descriptor.setProblemIndex(idx);
                        fqName2IdxMap.put((Object)fqName, idx + 1);
                    }
                    if (DESCRIPTION.equals(reader.getNodeName())) {
                        descriptor.setDescription(reader.getValue());
                    }
                    if (LINE.equals(reader.getNodeName())) {
                        descriptor.setLine(Integer.parseInt(reader.getValue()));
                    }
                    if (MODULE.equals(reader.getNodeName())) {
                        descriptor.setModule(reader.getValue());
                    }
                    if (HINTS.equals(reader.getNodeName())) {
                        while (reader.hasMoreChildren()) {
                            reader.moveDown();
                            ArrayList<String> hints = descriptor.getHints();
                            if (hints == null) {
                                hints = new ArrayList<String>();
                                descriptor.setHints(hints);
                            }
                            hints.add(reader.getAttribute("value"));
                            reader.moveUp();
                        }
                    }
                    if (PACKAGE.equals(reader.getNodeName())) {
                        OfflineViewParseUtil.appendDescriptor(package2Result, reader.getValue(), descriptor);
                        added = true;
                    }
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        if (PACKAGE.equals(reader.getNodeName())) {
                            OfflineViewParseUtil.appendDescriptor(package2Result, reader.getValue(), descriptor);
                            added = true;
                        }
                        reader.moveUp();
                    }
                    reader.moveUp();
                }
                if (!added) {
                    OfflineViewParseUtil.appendDescriptor(package2Result, null, descriptor);
                }
                reader.moveUp();
            }
        }
        return package2Result;
    }

    private static void appendDescriptor(Map<String, Set<OfflineProblemDescriptor>> package2Result, String packageName, OfflineProblemDescriptor descriptor) {
        THashSet descriptors = package2Result.get(packageName);
        if (descriptors == null) {
            descriptors = new THashSet();
            package2Result.put(packageName, (Set<OfflineProblemDescriptor>)descriptors);
        }
        descriptors.add((OfflineProblemDescriptor)descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String parseProfileName(String descriptors) {
        try (XppReader reader = new XppReader((Reader)new StringReader(descriptors), (XmlPullParser)new MXParser());){
            String string = reader.getAttribute("profile");
            return string;
        }
    }
}

