/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.actions.AbstractPerformFixesTask;
import com.intellij.codeInspection.actions.CleanupInspectionUtil;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CleanupInspectionIntention
implements IntentionAction,
HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(CleanupInspectionIntention.class);
    private final InspectionToolWrapper myToolWrapper;
    private final FileModifier myQuickfix;
    private final String myText;

    public CleanupInspectionIntention(@NotNull InspectionToolWrapper toolWrapper, @NotNull FileModifier quickFix, String text) {
        if (toolWrapper == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(0);
        }
        if (quickFix == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(1);
        }
        this.myToolWrapper = toolWrapper;
        this.myQuickfix = quickFix;
        this.myText = text;
    }

    @NotNull
    public String getText() {
        String string = InspectionsBundle.message((String)"fix.all.inspection.problems.in.file", (Object[])new Object[]{this.myToolWrapper.getDisplayName()});
        if (string == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        List descriptions;
        if (project == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(4);
        }
        if ((descriptions = (List)ProgressManager.getInstance().runProcess(() -> {
            if (project == null) {
                CleanupInspectionIntention.$$$reportNull$$$0(13);
            }
            InspectionManager inspectionManager = InspectionManager.getInstance((Project)project);
            return InspectionEngine.runInspectionOnFile(file2, this.myToolWrapper, inspectionManager.createNewGlobalContext(false));
        }, (ProgressIndicator)new EmptyProgressIndicator())).isEmpty() || !FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)file2)) {
            return;
        }
        AbstractPerformFixesTask fixesTask = CleanupInspectionUtil.getInstance().applyFixes(project, "Apply Fixes", descriptions, this.myQuickfix.getClass(), this.myQuickfix.startInWriteAction());
        if (!fixesTask.isApplicableFixFound()) {
            HintManager.getInstance().showErrorHint(editor, "Unfortunately '" + this.myText + "' is currently not available for batch mode\n User interaction is required for each problem found");
        }
    }

    @Deprecated
    public static AbstractPerformFixesTask applyFixes(@NotNull Project project, @NotNull String presentationText, @NotNull List<ProblemDescriptor> descriptions, @Nullable Class quickfixClass, boolean startInWriteAction) {
        if (project == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(5);
        }
        if (presentationText == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(6);
        }
        if (descriptions == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(7);
        }
        return CleanupInspectionUtil.getInstance().applyFixes(project, presentationText, descriptions, quickfixClass, startInWriteAction);
    }

    @Deprecated
    public static AbstractPerformFixesTask applyFixesNoSort(@NotNull Project project, @NotNull String presentationText, @NotNull List<ProblemDescriptor> descriptions, @Nullable Class quickfixClass, boolean startInWriteAction) {
        if (project == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(8);
        }
        if (presentationText == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(9);
        }
        if (descriptions == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(10);
        }
        return CleanupInspectionUtil.getInstance().applyFixesNoSort(project, presentationText, descriptions, quickfixClass, startInWriteAction);
    }

    @Deprecated
    public static void sortDescriptions(@NotNull List<ProblemDescriptor> descriptions) {
        if (descriptions == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(11);
        }
        Collections.sort(descriptions, CommonProblemDescriptor.DESCRIPTOR_COMPARATOR);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(12);
        }
        return this.myQuickfix.getClass() != EmptyIntentionAction.class && editor != null && (!(this.myToolWrapper instanceof LocalInspectionToolWrapper) || !((LocalInspectionToolWrapper)this.myToolWrapper).isUnfair());
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/actions/CleanupInspectionIntention";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationText";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/actions/CleanupInspectionIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFixes";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyFixesNoSort";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sortDescriptions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

