/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class InspectionDiff {
    private static HashMap<String, ArrayList<Element>> ourFileToProblem;
    @NonNls
    private static final String FILE_ELEMENT = "file";
    @NonNls
    private static final String CLASS_ELEMENT = "class";
    @NonNls
    private static final String FIELD_ELEMENT = "field";
    @NonNls
    private static final String METHOD_ELEMENT = "method";
    @NonNls
    private static final String CONSTRUCTOR_ELEMENT = "constructor";
    @NonNls
    private static final String INTERFACE_ELEMENT = "interface";
    @NonNls
    private static final String PROBLEM_CLASS_ELEMENT = "problem_class";
    @NonNls
    private static final String DESCRIPTION_ELEMENT = "description";

    public static void main(String[] args) {
        if (args.length != 3 && args.length != 2) {
            System.out.println(InspectionsBundle.message((String)"inspection.diff.format.error", (Object[])new Object[0]));
        }
        String oldPath = args[0];
        String newPath = args[1];
        String outPath = args.length == 3 ? args[2] : null;
        File oldResults = new File(oldPath);
        File newResults = new File(newPath);
        if (oldResults.isDirectory() && newResults.isDirectory()) {
            File[] results;
            File[] old = oldResults.listFiles();
            for (File result2 : results = newResults.listFiles()) {
                String inspectionName = result2.getName();
                boolean found = false;
                for (File oldFile : old) {
                    if (!oldFile.getName().equals(inspectionName)) continue;
                    InspectionDiff.writeInspectionDiff(oldFile.getPath(), result2.getPath(), outPath);
                    found = true;
                    break;
                }
                if (found) continue;
                InspectionDiff.writeInspectionDiff(null, result2.getPath(), outPath);
            }
        }
    }

    private static void writeInspectionDiff(String oldPath, String newPath, String outPath) {
        try {
            BufferedInputStream oldStream = oldPath != null ? new BufferedInputStream(new FileInputStream(oldPath)) : null;
            BufferedInputStream newStream = new BufferedInputStream(new FileInputStream(newPath));
            Document oldDoc = oldStream != null ? JDOMUtil.loadDocument((InputStream)oldStream) : null;
            Document newDoc = JDOMUtil.loadDocument((InputStream)newStream);
            FilterOutputStream outStream = System.out;
            if (outPath != null) {
                outStream = new BufferedOutputStream(new FileOutputStream(outPath + File.separator + new File(newPath).getName()));
            }
            Document delta = InspectionDiff.createDelta(oldDoc, newDoc);
            JDOMUtil.writeDocument((Document)delta, (OutputStream)outStream, (String)"\n");
            if (outStream != System.out) {
                ((OutputStream)outStream).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Document createDelta(@Nullable Document oldDoc, Document newDoc) {
        Element newRoot = newDoc.getRootElement();
        ourFileToProblem = new HashMap();
        List newProblems = newRoot.getChildren("problem");
        for (Object o : newProblems) {
            Element newProblem = (Element)o;
            InspectionDiff.addProblem(newProblem);
        }
        if (oldDoc != null) {
            List oldProblems = oldDoc.getRootElement().getChildren("problem");
            for (Object o : oldProblems) {
                Element oldProblem = (Element)o;
                if (InspectionDiff.removeIfEquals(oldProblem)) continue;
                InspectionDiff.addProblem(oldProblem);
            }
        }
        Element root = new Element("problems");
        Document delta = new Document(root);
        for (ArrayList<Element> fileList : ourFileToProblem.values()) {
            if (fileList == null) continue;
            for (Element element : fileList) {
                root.addContent(element.clone());
            }
        }
        return delta;
    }

    private static boolean removeIfEquals(Element problem) {
        String fileName = problem.getChildText(FILE_ELEMENT);
        ArrayList<Element> problemList = ourFileToProblem.get(fileName);
        if (problemList != null) {
            Element[] problems;
            for (Element toCheck : problems = problemList.toArray(new Element[0])) {
                if (!InspectionDiff.equals(problem, toCheck)) continue;
                return problemList.remove(toCheck);
            }
        }
        return false;
    }

    private static void addProblem(Element problem) {
        String fileName = problem.getChildText(FILE_ELEMENT);
        ArrayList<Object> problemList = ourFileToProblem.get(fileName);
        if (problemList == null) {
            problemList = new ArrayList();
            ourFileToProblem.put(fileName, problemList);
        }
        problemList.add(problem);
    }

    private static boolean equals(Element oldProblem, Element newProblem) {
        if (!Comparing.equal((String)oldProblem.getChildText(CLASS_ELEMENT), (String)newProblem.getChildText(CLASS_ELEMENT))) {
            return false;
        }
        if (!Comparing.equal((String)oldProblem.getChildText(FIELD_ELEMENT), (String)newProblem.getChildText(FIELD_ELEMENT))) {
            return false;
        }
        if (!Comparing.equal((String)oldProblem.getChildText(METHOD_ELEMENT), (String)newProblem.getChildText(METHOD_ELEMENT))) {
            return false;
        }
        if (!Comparing.equal((String)oldProblem.getChildText(CONSTRUCTOR_ELEMENT), (String)newProblem.getChildText(CONSTRUCTOR_ELEMENT))) {
            return false;
        }
        if (!Comparing.equal((String)oldProblem.getChildText(INTERFACE_ELEMENT), (String)newProblem.getChildText(INTERFACE_ELEMENT))) {
            return false;
        }
        if (!Comparing.equal((String)oldProblem.getChildText(PROBLEM_CLASS_ELEMENT), (String)newProblem.getChildText(PROBLEM_CLASS_ELEMENT))) {
            return false;
        }
        return Comparing.equal((String)oldProblem.getChildText(DESCRIPTION_ELEMENT), (String)newProblem.getChildText(DESCRIPTION_ELEMENT));
    }
}

