/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.HintInfoFilter;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.MethodInfoBlacklistFilter;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.codeInsight.hints.ParameterHintsUpdater;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.CaretVisualPositionKeeper;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ParameterHintsPass
extends EditorBoundHighlightingPass {
    private final TIntObjectHashMap<List<HintData>> myHints;
    private final TIntObjectHashMap<String> myShowOnlyIfExistedBeforeHints;
    private final SyntaxTraverser<PsiElement> myTraverser;
    private final PsiElement myRootElement;
    private final HintInfoFilter myHintInfoFilter;
    private final boolean myForceImmediateUpdate;

    public static void syncUpdate(@NotNull PsiElement element, @NotNull Editor editor) {
        if (element == null) {
            ParameterHintsPass.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ParameterHintsPass.$$$reportNull$$$0(1);
        }
        MethodInfoBlacklistFilter filter = MethodInfoBlacklistFilter.forLanguage(element.getLanguage());
        ParameterHintsPass pass = new ParameterHintsPass(element, editor, filter, true);
        pass.doCollectInformation(new ProgressIndicatorBase());
        pass.applyInformationToEditor();
    }

    public ParameterHintsPass(@NotNull PsiElement element, @NotNull Editor editor, @NotNull HintInfoFilter hintsFilter, boolean forceImmediateUpdate) {
        if (element == null) {
            ParameterHintsPass.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            ParameterHintsPass.$$$reportNull$$$0(3);
        }
        if (hintsFilter == null) {
            ParameterHintsPass.$$$reportNull$$$0(4);
        }
        super(editor, element.getContainingFile(), true);
        this.myHints = new TIntObjectHashMap();
        this.myShowOnlyIfExistedBeforeHints = new TIntObjectHashMap();
        this.myRootElement = element;
        this.myTraverser = SyntaxTraverser.psiTraverser((PsiElement)element);
        this.myHintInfoFilter = hintsFilter;
        this.myForceImmediateUpdate = forceImmediateUpdate;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            ParameterHintsPass.$$$reportNull$$$0(5);
        }
        assert (this.myDocument != null);
        this.myHints.clear();
        Language language = this.myFile.getLanguage();
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (provider == null || !provider.canShowHintsWhenDisabled() && !ParameterHintsPass.isEnabled()) {
            return;
        }
        this.myTraverser.forEach(element -> this.process((PsiElement)element, provider));
    }

    private static boolean isEnabled() {
        return EditorSettingsExternalizable.getInstance().isShowParameterNameHints();
    }

    private void process(PsiElement element, InlayParameterHintsProvider provider) {
        List hints = provider.getParameterHints(element);
        if (hints.isEmpty()) {
            return;
        }
        HintInfo info = provider.getHintInfo(element);
        boolean showHints = info == null || info instanceof HintInfo.OptionInfo || this.myHintInfoFilter.showHint(info);
        Stream<Object> inlays = hints.stream();
        if (!showHints) {
            inlays = inlays.filter(inlayInfo -> !inlayInfo.isFilterByBlacklist());
        }
        inlays.forEach(hint -> {
            int offset = hint.getOffset();
            if (!this.canShowHintsAtOffset(offset)) {
                return;
            }
            String presentation = provider.getInlayPresentation(hint.getText());
            if (hint.isShowOnlyIfExistedBefore()) {
                this.myShowOnlyIfExistedBeforeHints.put(offset, (Object)presentation);
            } else {
                ArrayList<HintData> hintList = (ArrayList<HintData>)this.myHints.get(offset);
                if (hintList == null) {
                    hintList = new ArrayList<HintData>();
                    this.myHints.put(offset, hintList);
                }
                hintList.add(new HintData(presentation, hint.getRelatesToPrecedingText()));
            }
        });
    }

    @Override
    public void doApplyInformationToEditor() {
        CaretVisualPositionKeeper keeper = new CaretVisualPositionKeeper(this.myEditor);
        ParameterHintsPresentationManager manager = ParameterHintsPresentationManager.getInstance();
        List<Inlay> hints = this.hintsInRootElementArea(manager);
        ParameterHintsUpdater updater = new ParameterHintsUpdater(this.myEditor, hints, this.myHints, this.myShowOnlyIfExistedBeforeHints, this.myForceImmediateUpdate);
        updater.update();
        keeper.restoreOriginalLocation(false);
        if (ParameterHintsUpdater.hintRemovalDelayed(this.myEditor)) {
            ParameterHintsPassFactory.forceHintsUpdateOnNextPass(this.myEditor);
        } else if (this.myRootElement == this.myFile) {
            ParameterHintsPassFactory.putCurrentPsiModificationStamp(this.myEditor, this.myFile);
        }
    }

    @NotNull
    private List<Inlay> hintsInRootElementArea(ParameterHintsPresentationManager manager) {
        assert (this.myDocument != null);
        TextRange range2 = this.myRootElement.getTextRange();
        int elementStart = range2.getStartOffset();
        int elementEnd = range2.getEndOffset();
        List inlays = this.myEditor.getInlayModel().getInlineElementsInRange(elementStart + 1, elementEnd - 1);
        List list2 = ContainerUtil.filter((Collection)inlays, hint -> manager.isParameterHint((Inlay)hint));
        if (list2 == null) {
            ParameterHintsPass.$$$reportNull$$$0(6);
        }
        return list2;
    }

    private boolean canShowHintsAtOffset(int offset) {
        TextRange rootRange = this.myRootElement.getTextRange();
        if (!rootRange.containsOffset(offset)) {
            return false;
        }
        if (offset > rootRange.getStartOffset() && offset < rootRange.getEndOffset()) {
            return true;
        }
        return this.myDocument != null && this.myDocument.getTextLength() == rootRange.getLength();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintsFilter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hints/ParameterHintsPass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hints/ParameterHintsPass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "hintsInRootElementArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "syncUpdate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class HintData {
        public final String presentationText;
        public final boolean relatesToPrecedingText;

        public HintData(String text, boolean relatesToPrecedingText) {
            this.presentationText = text;
            this.relatesToPrecedingText = relatesToPrecedingText;
        }
    }
}

