/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.ColoredSideBorder;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HintUtil {
    @Deprecated
    public static final Color INFORMATION_COLOR = new JBColor(new Color(253, 254, 226), new Color(5066577));
    @Deprecated
    public static final Color QUESTION_COLOR = new JBColor(new Color(181, 208, 251), new Color(55, 108, 137));
    @Deprecated
    public static final Color ERROR_COLOR = new JBColor(new Color(255, 220, 220), new Color(7870258));
    public static final ColorKey INFORMATION_COLOR_KEY = ColorKey.createColorKey((String)"INFORMATION_HINT", (Color)INFORMATION_COLOR);
    public static final ColorKey QUESTION_COLOR_KEY = ColorKey.createColorKey((String)"QUESTION_HINT", (Color)QUESTION_COLOR);
    public static final ColorKey ERROR_COLOR_KEY = ColorKey.createColorKey((String)"ERROR_HINT", (Color)ERROR_COLOR);
    public static final Color QUESTION_UNDERSCORE_COLOR = JBColor.foreground();

    private HintUtil() {
    }

    @NotNull
    public static Color getInformationColor() {
        Color color = (Color)ObjectUtils.notNull((Object)EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)INFORMATION_COLOR_KEY), (Object)INFORMATION_COLOR_KEY.getDefaultColor());
        if (color == null) {
            HintUtil.$$$reportNull$$$0(0);
        }
        return color;
    }

    @NotNull
    public static Color getQuestionColor() {
        Color color = (Color)ObjectUtils.notNull((Object)EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)QUESTION_COLOR_KEY), (Object)QUESTION_COLOR_KEY.getDefaultColor());
        if (color == null) {
            HintUtil.$$$reportNull$$$0(1);
        }
        return color;
    }

    @NotNull
    public static Color getErrorColor() {
        Color color = (Color)ObjectUtils.notNull((Object)EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)ERROR_COLOR_KEY), (Object)ERROR_COLOR_KEY.getDefaultColor());
        if (color == null) {
            HintUtil.$$$reportNull$$$0(2);
        }
        return color;
    }

    public static JComponent createInformationLabel(@NotNull String text) {
        if (text == null) {
            HintUtil.$$$reportNull$$$0(3);
        }
        return HintUtil.createInformationLabel(text, null, null, null);
    }

    public static JComponent createInformationLabel(@NotNull String text, @Nullable HyperlinkListener hyperlinkListener, @Nullable MouseListener mouseListener, @Nullable Ref<Consumer<String>> updatedTextConsumer) {
        if (text == null) {
            HintUtil.$$$reportNull$$$0(4);
        }
        HintHint hintHint = HintUtil.getInformationHint();
        HintLabel label2 = HintUtil.createLabel(text, null, hintHint.getTextBackground(), hintHint);
        HintUtil.configureLabel(label2, hyperlinkListener, mouseListener, updatedTextConsumer);
        return label2;
    }

    @NotNull
    public static HintHint getInformationHint() {
        HintHint hintHint = new HintHint().setTextBg(HintUtil.getInformationColor()).setTextFg(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : Color.black).setFont(HintUtil.getBoldFont()).setAwtTooltip(true);
        if (hintHint == null) {
            HintUtil.$$$reportNull$$$0(5);
        }
        return hintHint;
    }

    public static CompoundBorder createHintBorder() {
        return BorderFactory.createCompoundBorder(new ColoredSideBorder(Color.white, Color.white, Color.gray, Color.gray, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    @NotNull
    public static JComponent createInformationLabel(SimpleColoredText text) {
        JComponent jComponent = HintUtil.createInformationLabel(text, null);
        if (jComponent == null) {
            HintUtil.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    public static JComponent createQuestionLabel(String text) {
        Icon icon = AllIcons.General.Help_small;
        return HintUtil.createQuestionLabel(text, icon);
    }

    public static JComponent createQuestionLabel(String text, Icon icon) {
        Color bg = HintUtil.getQuestionColor();
        HintHint hintHint = new HintHint().setTextBg(bg).setTextFg(JBColor.foreground()).setFont(HintUtil.getBoldFont()).setAwtTooltip(true);
        return HintUtil.createLabel(text, icon, bg, hintHint);
    }

    @NotNull
    public static SimpleColoredComponent createInformationComponent() {
        SimpleColoredComponent component = new SimpleColoredComponent();
        component.setBackground(HintUtil.getInformationColor());
        component.setForeground(JBColor.foreground());
        component.setFont(HintUtil.getBoldFont());
        SimpleColoredComponent simpleColoredComponent = component;
        if (simpleColoredComponent == null) {
            HintUtil.$$$reportNull$$$0(7);
        }
        return simpleColoredComponent;
    }

    @NotNull
    public static JComponent createInformationLabel(@NotNull SimpleColoredText text, @Nullable Icon icon) {
        if (text == null) {
            HintUtil.$$$reportNull$$$0(8);
        }
        SimpleColoredComponent component = HintUtil.createInformationComponent();
        component.setIcon(icon);
        text.appendToComponent((ColoredTextContainer)component);
        HintLabel hintLabel = new HintLabel(component);
        if (hintLabel == null) {
            HintUtil.$$$reportNull$$$0(9);
        }
        return hintLabel;
    }

    public static JComponent createErrorLabel(@NotNull String text, @Nullable HyperlinkListener hyperlinkListener, @Nullable MouseListener mouseListener, @Nullable Ref<Consumer<String>> updatedTextConsumer) {
        if (text == null) {
            HintUtil.$$$reportNull$$$0(10);
        }
        Color bg = HintUtil.getErrorColor();
        HintHint hintHint = new HintHint().setTextBg(bg).setTextFg(JBColor.foreground()).setFont(HintUtil.getBoldFont()).setAwtTooltip(true);
        HintLabel label2 = HintUtil.createLabel(text, null, bg, hintHint);
        HintUtil.configureLabel(label2, hyperlinkListener, mouseListener, updatedTextConsumer);
        return label2;
    }

    @NotNull
    public static JComponent createErrorLabel(@NotNull String text) {
        if (text == null) {
            HintUtil.$$$reportNull$$$0(11);
        }
        JComponent jComponent = HintUtil.createErrorLabel(text, null, null, null);
        if (jComponent == null) {
            HintUtil.$$$reportNull$$$0(12);
        }
        return jComponent;
    }

    @NotNull
    private static HintLabel createLabel(String text, @Nullable Icon icon, @NotNull Color color, @NotNull HintHint hintHint) {
        if (color == null) {
            HintUtil.$$$reportNull$$$0(13);
        }
        if (hintHint == null) {
            HintUtil.$$$reportNull$$$0(14);
        }
        HintLabel label2 = new HintLabel();
        label2.setText(text, hintHint);
        label2.setIcon(icon);
        if (!hintHint.isAwtTooltip()) {
            label2.setBorder(HintUtil.createHintBorder());
            label2.setForeground(JBColor.foreground());
            label2.setFont(HintUtil.getBoldFont());
            label2.setBackground(color);
            label2.setOpaque(true);
        }
        HintLabel hintLabel = label2;
        if (hintLabel == null) {
            HintUtil.$$$reportNull$$$0(15);
        }
        return hintLabel;
    }

    private static Font getBoldFont() {
        return UIUtil.getLabelFont().deriveFont(1);
    }

    public static JLabel createAdComponent(String bottomText, Border border, @JdkConstants.HorizontalAlignment int alignment) {
        JLabel label2 = new JLabel();
        label2.setText(bottomText);
        label2.setHorizontalAlignment(alignment);
        label2.setFont(label2.getFont().deriveFont((float)(label2.getFont().getSize() - 2)));
        if (bottomText != null) {
            label2.setBorder(border);
        }
        return label2;
    }

    @NotNull
    public static String prepareHintText(@NotNull String text, @NotNull HintHint hintHint) {
        if (text == null) {
            HintUtil.$$$reportNull$$$0(16);
        }
        if (hintHint == null) {
            HintUtil.$$$reportNull$$$0(17);
        }
        String string = HintUtil.prepareHintText(new Html(text), hintHint);
        if (string == null) {
            HintUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    public static String prepareHintText(@NotNull Html text, @NotNull HintHint hintHint) {
        if (text == null) {
            HintUtil.$$$reportNull$$$0(19);
        }
        if (hintHint == null) {
            HintUtil.$$$reportNull$$$0(20);
        }
        String htmlBody = UIUtil.getHtmlBody((Html)text);
        return String.format("<html><head>%s</head><body>%s</body></html>", UIUtil.getCssFontDeclaration((Font)hintHint.getTextFont(), (Color)hintHint.getTextForeground(), (Color)hintHint.getLinkForeground(), (String)hintHint.getUlImg()), htmlBody);
    }

    private static void configureLabel(@NotNull HintLabel label2, @Nullable HyperlinkListener hyperlinkListener, @Nullable MouseListener mouseListener, @Nullable Ref<Consumer<String>> updatedTextConsumer) {
        if (label2 == null) {
            HintUtil.$$$reportNull$$$0(21);
        }
        if (hyperlinkListener != null) {
            label2.myPane.addHyperlinkListener(hyperlinkListener);
        }
        if (mouseListener != null) {
            label2.myPane.addMouseListener(mouseListener);
        }
        if (updatedTextConsumer != null) {
            updatedTextConsumer.set(s -> {
                if (label2 == null) {
                    HintUtil.$$$reportNull$$$0(22);
                }
                label2.myPane.setText((String)s);
                label2.setPreferredSize(null);
                label2.myPane.setPreferredSize(null);
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/HintUtil";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintHint";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationColor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuestionColor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorColor";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/HintUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationHint";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createInformationLabel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createInformationComponent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorLabel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabel";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareHintText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createInformationLabel";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createErrorLabel";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "prepareHintText";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "configureLabel";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$configureLabel$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HintLabel
    extends JPanel {
        private JEditorPane myPane;
        private SimpleColoredComponent myColored;
        private JLabel myIcon;

        private HintLabel() {
            this.setLayout(new BorderLayout());
        }

        private HintLabel(@NotNull SimpleColoredComponent component) {
            if (component == null) {
                HintLabel.$$$reportNull$$$0(0);
            }
            this();
            this.setText(component);
        }

        @Override
        public boolean requestFocusInWindow() {
            if (this.myPane != null) {
                return this.myPane.requestFocusInWindow();
            }
            if (this.myColored != null) {
                return this.myColored.requestFocusInWindow();
            }
            if (this.myIcon != null) {
                return this.myIcon.requestFocusInWindow();
            }
            return super.requestFocusInWindow();
        }

        public void setText(@NotNull SimpleColoredComponent colored) {
            if (colored == null) {
                HintLabel.$$$reportNull$$$0(1);
            }
            this.clearText();
            this.myColored = colored;
            this.add((Component)this.myColored, "Center");
            this.setOpaque(true);
            this.setBackground(colored.getBackground());
            this.revalidate();
            this.repaint();
        }

        public void setText(String s, HintHint hintHint) {
            this.clearText();
            if (s != null) {
                this.myPane = IdeTooltipManager.initPane(s, hintHint, null);
                this.add((Component)this.myPane, "Center");
            }
            this.setOpaque(true);
            this.setBackground(hintHint.getTextBackground());
            this.revalidate();
            this.repaint();
        }

        private void clearText() {
            if (this.myPane != null) {
                this.remove(this.myPane);
                this.myPane = null;
            }
            if (this.myColored != null) {
                this.remove((Component)this.myColored);
                this.myColored = null;
            }
        }

        public void setIcon(Icon icon) {
            if (this.myIcon != null) {
                this.remove(this.myIcon);
            }
            this.myIcon = new JLabel(icon, 0);
            this.myIcon.setVerticalAlignment(1);
            this.add((Component)this.myIcon, "West");
            this.revalidate();
            this.repaint();
        }

        @Override
        public String toString() {
            return "Hint: text='" + (this.myPane != null ? this.myPane.getText() : "") + "'";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colored";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/hint/HintUtil$HintLabel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

