/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import javax.swing.JLabel;

public class ElementLocationUtil {
    private ElementLocationUtil() {
    }

    public static void customizeElementLabel(PsiElement element, JLabel label2) {
        if (element != null) {
            VirtualFile vfile;
            PsiFile file2 = element.getContainingFile();
            VirtualFile virtualFile = vfile = file2 == null ? null : file2.getVirtualFile();
            if (vfile == null) {
                label2.setText("");
                label2.setIcon(null);
                return;
            }
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
            Module module = fileIndex.getModuleForFile(vfile);
            if (module != null) {
                label2.setText(module.getName());
                label2.setIcon(ModuleType.get((Module)module).getIcon());
            } else {
                List entries = fileIndex.getOrderEntriesForFile(vfile);
                OrderEntry entry = null;
                for (OrderEntry order : entries) {
                    if (!(order instanceof LibraryOrderEntry) && !(order instanceof JdkOrderEntry)) continue;
                    entry = order;
                    break;
                }
                if (entry != null) {
                    label2.setText(entry.getPresentableName());
                    label2.setIcon(AllIcons.Nodes.PpLibFolder);
                }
            }
        }
    }
}

