/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandler;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExtendWordSelectionHandlerBase
implements ExtendWordSelectionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase");

    public abstract boolean canSelect(@NotNull PsiElement var1);

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        TextRange originalRange;
        if (e == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(0);
        }
        if (editorText == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(2);
        }
        if ((originalRange = e.getTextRange()).getEndOffset() > editorText.length()) {
            throw new RuntimeExceptionWithAttachments("Invalid element range in " + this.getClass(), "element=" + e + "; range=" + originalRange + "; text length=" + editorText.length() + "; editor=" + editor + "; committed=" + PsiDocumentManager.getInstance((Project)e.getProject()).isCommitted(editor.getDocument()), new Attachment[]{new Attachment("editor_text.txt", editorText.toString()), new Attachment("psi_text.txt", e.getText())});
        }
        List<TextRange> ranges = ExtendWordSelectionHandlerBase.expandToWholeLine(editorText, originalRange, true);
        if (ranges.size() == 1 && ranges.contains(originalRange)) {
            return ExtendWordSelectionHandlerBase.expandToWholeLine(editorText, originalRange, false);
        }
        return ranges;
    }

    public int getMinimalTextRangeLength(@NotNull PsiElement element, @NotNull CharSequence text, int cursorOffset) {
        if (element == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(3);
        }
        if (text == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(4);
        }
        return 0;
    }

    public static List<TextRange> expandToWholeLine(CharSequence text, @Nullable TextRange range2, boolean isSymmetric) {
        TextRange expanded;
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        if (range2 == null) {
            return result2;
        }
        LOG.assertTrue(range2.getEndOffset() <= text.length());
        if (!StringUtil.contains((CharSequence)text, (int)range2.getStartOffset(), (int)range2.getEndOffset(), (char)'\n')) {
            result2.add(range2);
        }
        if ((expanded = ExtendWordSelectionHandlerBase.getExpandedRange(text, range2, isSymmetric)) != null) {
            result2.add(expanded);
        } else {
            result2.add(range2);
        }
        return result2;
    }

    @Nullable
    private static TextRange getExpandedRange(CharSequence text, TextRange range2, boolean isSymmetric) {
        int startOffset = range2.getStartOffset();
        int endOffset = range2.getEndOffset();
        int index1 = CharArrayUtil.shiftBackward((CharSequence)text, (int)(startOffset - 1), (String)" \t");
        if (endOffset > startOffset && text.charAt(endOffset - 1) == '\n') {
            --endOffset;
        }
        int textLength = text.length();
        int index2 = Math.min(textLength, CharArrayUtil.shiftForward((CharSequence)text, (int)endOffset, (String)" \t"));
        if (index1 < 0 || text.charAt(index1) == '\n' || index2 == textLength || text.charAt(index2) == '\n') {
            if (!isSymmetric) {
                if (index1 < 0 || text.charAt(index1) == '\n') {
                    startOffset = index1 + 1;
                }
                if ((index2 == textLength || text.charAt(index2) == '\n') && (endOffset = index2) < textLength) {
                    ++endOffset;
                }
                return new TextRange(startOffset, endOffset);
            }
            if (!(index1 >= 0 && text.charAt(index1) != '\n' || index2 != textLength && text.charAt(index2) != '\n')) {
                startOffset = index1 + 1;
                endOffset = index2;
                if (endOffset < textLength) {
                    ++endOffset;
                }
                return new TextRange(startOffset, endOffset);
            }
        }
        return null;
    }

    public static List<TextRange> expandToWholeLinesWithBlanks(CharSequence text, TextRange range2) {
        int blankLineEnd;
        ArrayList result2 = ContainerUtil.newArrayList();
        result2.addAll(ExtendWordSelectionHandlerBase.expandToWholeLine(text, range2, true));
        TextRange last = result2.isEmpty() ? range2 : (TextRange)result2.get(result2.size() - 1);
        int start = last.getStartOffset();
        int end = last.getEndOffset();
        while ((blankLineEnd = CharArrayUtil.shiftForward((CharSequence)text, (int)end, (String)" \t")) < text.length() && text.charAt(blankLineEnd) == '\n') {
            end = blankLineEnd + 1;
        }
        if (end == last.getEndOffset()) {
            int blankLineStart;
            while (start > 0 && text.charAt(start - 1) == '\n' && (blankLineStart = CharArrayUtil.shiftBackward((CharSequence)text, (int)(start - 2), (String)" \t")) > 0 && text.charAt(blankLineStart) == '\n') {
                start = blankLineStart + 1;
            }
        }
        if (start != last.getStartOffset() || end != last.getEndOffset()) {
            result2.add(new TextRange(start, end));
        }
        return result2;
    }

    public static List<TextRange> expandToWholeLine(CharSequence text, TextRange range2) {
        return ExtendWordSelectionHandlerBase.expandToWholeLine(text, range2, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/ExtendWordSelectionHandlerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getMinimalTextRangeLength";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

